/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.events;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.blocks.MineralBlock;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryBlocks;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryFeatures;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryStructures;
import io.github.flemmli97.runecraftory.common.world.features.BiomeFilteredRandomFeature;
import io.github.flemmli97.runecraftory.common.world.features.MineralFeature;
import io.github.flemmli97.runecraftory.common.world.features.config.BiomeFilteredConfig;
import io.github.flemmli97.runecraftory.common.world.features.config.ChancedBlockClusterConfig;
import io.github.flemmli97.runecraftory.mixinhelper.StructureTemplateModifier;
import io.github.flemmli97.tenshilib.loader.registry.RegistryEntrySupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.LakeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountOnEveryLayerPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.jetbrains.annotations.Nullable;

public class WorldRegistrationCalls {
    public static final String[] VANILLA_VILLAGES = new String[]{"plains", "desert", "savanna", "snowy", "taiga"};

    public static List<HerbFeatureEntry> defaultHerbEntries() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.WEEDS, 100));
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.MUSHROOM, 40));
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.MONARCH_MUSHROOM, 10));
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.WITHERED_GRASS, 50));
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.WHITE_GRASS, 30));
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.INDIGO_GRASS, 30));
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.PURPLE_GRASS, 30));
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.GREEN_GRASS, 30));
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.BLUE_GRASS, 30));
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.YELLOW_GRASS, 30));
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.RED_GRASS, 30));
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.ORANGE_GRASS, 30));
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.BLACK_GRASS, 75));
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.ELLI_LEAVES, 10));
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.ANTIDOTE_GRASS, 75));
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.MEDICINAL_HERB, 75));
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.BAMBOO_SPROUT, 66));
        return builder.build();
    }

    public static void createFeatures(@Nullable FeatureRegister register, Consumer<FeatureBiomeModifier> placedFeatureHandler) {
        if (register != null) {
            List<HerbFeatureEntry> herbEntries = WorldRegistrationCalls.defaultHerbEntries();
            herbEntries.forEach(entry -> register.registerConfigured(entry.configuredId(), provider -> new ConfiguredFeature(Feature.RANDOM_PATCH, (FeatureConfiguration)new RandomPatchConfiguration(64, 8, 8, Holder.direct((Object)new PlacedFeature(Holder.direct((Object)new ConfiguredFeature(Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)entry.block().get()))))), List.of(BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesTag((TagKey)BlockTags.AIR)))))))));
            register.registerConfigured(RuneCraftoryFeatures.CONFIGRED_HERB_FEATURE, provider -> {
                List<BiomeFilteredConfig.BiomeFilteredEntry> filtered = herbEntries.stream().map(entry -> new BiomeFilteredConfig.BiomeFilteredEntry((Holder<PlacedFeature>)Holder.direct((Object)new PlacedFeature(provider.get(entry.configuredId()), List.of())), RunecraftoryTags.Biomes.getBlockBasedGenerationTag(entry.block(), true), RunecraftoryTags.Biomes.getBlockBasedGenerationTag(entry.block(), false), entry.weight())).toList();
                return new ConfiguredFeature((Feature)((BiomeFilteredRandomFeature)((Object)((Object)RuneCraftoryFeatures.BIOME_FILTERED_RANDOM_FEATURES.get()))), (FeatureConfiguration)new BiomeFilteredConfig(filtered));
            });
            register.registerPlaced(RuneCraftoryFeatures.HERB_FEATURE, provider -> new PlacedFeature(provider.get(RuneCraftoryFeatures.CONFIGRED_HERB_FEATURE), List.of(RarityFilter.onAverageOnceEvery((int)4), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP)));
        }
        placedFeatureHandler.accept(FeatureBiomeModifier.of(RuneCraftoryFeatures.HERB_FEATURE));
        ArrayList<FeatureBiomeModifier> placedFeatures = new ArrayList<FeatureBiomeModifier>();
        placedFeatures.addAll(WorldRegistrationCalls.registerMineralFeatures(register, RuneCraftoryBlocks.MINERAL_IRON, 15, 2, 5));
        placedFeatures.addAll(WorldRegistrationCalls.registerMineralFeatures(register, RuneCraftoryBlocks.MINERAL_TIN, 20, 2, 4));
        placedFeatures.addAll(WorldRegistrationCalls.registerMineralFeatures(register, RuneCraftoryBlocks.MINERAL_SILVER, 40, 2, 3));
        placedFeatures.addAll(WorldRegistrationCalls.registerMineralFeatures(register, RuneCraftoryBlocks.MINERAL_GOLD, 60, 2, 3));
        placedFeatures.addAll(WorldRegistrationCalls.registerMineralFeatures(register, RuneCraftoryBlocks.MINERAL_PLATINUM, 100, 1, 3));
        placedFeatures.addAll(WorldRegistrationCalls.registerMineralFeatures(register, RuneCraftoryBlocks.MINERAL_ORICHALCUM, 175, 1, 3));
        placedFeatures.addAll(WorldRegistrationCalls.registerMineralFeatures(register, RuneCraftoryBlocks.MINERAL_DIAMOND, 133, 1, 3));
        placedFeatures.addAll(WorldRegistrationCalls.registerMineralFeatures(register, RuneCraftoryBlocks.MINERAL_DRAGONIC, 25, 1, 2));
        placedFeatures.addAll(WorldRegistrationCalls.registerMineralFeatures(register, RuneCraftoryBlocks.MINERAL_AQUAMARINE, 25, 2, 3));
        placedFeatures.addAll(WorldRegistrationCalls.registerMineralFeatures(register, RuneCraftoryBlocks.MINERAL_AMETHYST, 66, 2, 3));
        placedFeatures.addAll(WorldRegistrationCalls.registerMineralFeatures(register, RuneCraftoryBlocks.MINERAL_RUBY, 50, 2, 3));
        placedFeatures.addAll(WorldRegistrationCalls.registerMineralFeatures(register, RuneCraftoryBlocks.MINERAL_EMERALD, 66, 1, 3));
        placedFeatures.addAll(WorldRegistrationCalls.registerMineralFeatures(register, RuneCraftoryBlocks.MINERAL_SAPPHIRE, 66, 2, 3));
        placedFeatures.forEach(placedFeatureHandler);
        if (register != null) {
            register.registerConfigured(RuneCraftoryFeatures.HOT_SPRING_LAKE, p -> new ConfiguredFeature(Feature.LAKE, (FeatureConfiguration)new LakeFeature.Configuration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)RuneCraftoryBlocks.HOT_SPRING_WATER.get())), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.STONE))));
            register.registerPlaced(RuneCraftoryFeatures.PLACED_HOT_SPRING_LAKE, provider -> new PlacedFeature(provider.get(RuneCraftoryFeatures.HOT_SPRING_LAKE), List.of(RarityFilter.onAverageOnceEvery((int)4), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE)));
        }
        placedFeatureHandler.accept(new FeatureBiomeModifier(RunecraftoryTags.Biomes.HAS_HOT_SPRINGS, GenerationStep.Decoration.LAKES, RuneCraftoryFeatures.PLACED_HOT_SPRING_LAKE));
    }

    private static List<FeatureBiomeModifier> registerMineralFeatures(@Nullable FeatureRegister register, RegistryEntrySupplier<Block, ? extends MineralBlock> block, int chance, int min, int max) {
        ResourceKey id = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)RuneCraftory.modRes("mineral_" + block.getID().getPath().replace("ore_", "")));
        ResourceKey idPlaced = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)id.location());
        ResourceKey netherIDPlaced = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)id.location().getNamespace(), (String)(id.location().getPath() + "_nether")));
        if (register != null) {
            register.registerConfigured(id, provider -> {
                MineralBlock mineral = (MineralBlock)block.get();
                return new ConfiguredFeature((Feature)((MineralFeature)((Object)((Object)RuneCraftoryFeatures.MINERAL_FEATURE.get()))), (FeatureConfiguration)new ChancedBlockClusterConfig(mineral, RunecraftoryTags.Biomes.getMineralGenTag(mineral.tier, true), RunecraftoryTags.Biomes.getMineralGenTag(mineral.tier, false), (IntProvider)UniformInt.of((int)min, (int)max), 4, 32));
            });
            register.registerPlaced((ResourceKey<PlacedFeature>)idPlaced, provider -> new PlacedFeature(provider.get(id), List.of(RarityFilter.onAverageOnceEvery((int)chance), InSquarePlacement.spread(), PlacementUtils.RANGE_4_4)));
            register.registerPlaced((ResourceKey<PlacedFeature>)netherIDPlaced, provider -> new PlacedFeature(provider.get(id), List.of(CountOnEveryLayerPlacement.of((int)5), RarityFilter.onAverageOnceEvery((int)chance), InSquarePlacement.spread())));
        }
        return List.of(FeatureBiomeModifier.of((ResourceKey<PlacedFeature>)idPlaced), new FeatureBiomeModifier((TagKey<Biome>)BiomeTags.IS_NETHER, GenerationStep.Decoration.VEGETAL_DECORATION, (ResourceKey<PlacedFeature>)netherIDPlaced));
    }

    public static MobSpawnSettings.SpawnerData gateSetting() {
        return new MobSpawnSettings.SpawnerData((EntityType)RuneCraftoryEntities.GATE.get(), 100, 1, 1);
    }

    public static void addVillageStructures(MinecraftServer server) {
        Registry pools = (Registry)server.registryAccess().registry(Registries.TEMPLATE_POOL).orElseThrow();
        for (String s : VANILLA_VILLAGES) {
            if (!s.equals("savanna") && !s.equals("desert")) {
                StructureTemplatePool streetsPool = (StructureTemplatePool)pools.get(ResourceLocation.withDefaultNamespace((String)("village/" + s + "/streets")));
                StructureTemplatePool bigStreet = (StructureTemplatePool)pools.get(RuneCraftory.modRes("npc/streets/big_street_" + s));
                if (bigStreet != null) {
                    WorldRegistrationCalls.addToPool(streetsPool, ((StructureTemplateModifier)bigStreet).runecraftory$getRawTemplates());
                }
            }
            StructureTemplatePool housePool = (StructureTemplatePool)pools.get(ResourceLocation.withDefaultNamespace((String)("village/" + s + "/houses")));
            StructureTemplatePool npcHouses = (StructureTemplatePool)pools.get(RuneCraftoryStructures.NPC_HOUSES);
            if (npcHouses == null) continue;
            WorldRegistrationCalls.addToPool(housePool, ((StructureTemplateModifier)npcHouses).runecraftory$getRawTemplates());
        }
    }

    private static void addToPool(StructureTemplatePool pool, List<Pair<StructurePoolElement, Integer>> houses) {
        if (pool == null) {
            return;
        }
        for (Pair<StructurePoolElement, Integer> pair : houses) {
            ((StructureTemplateModifier)pool).runecraftory$addPoolElement(pair);
        }
    }

    public record HerbFeatureEntry(RegistryEntrySupplier<Block, ?> block, int weight) {
        public ResourceKey<ConfiguredFeature<?, ?>> configuredId() {
            return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)RuneCraftory.modRes(this.block.getID().getPath()));
        }

        public ResourceKey<PlacedFeature> placedId() {
            return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)RuneCraftory.modRes(this.block.getID().getPath()));
        }
    }

    public static interface FeatureRegister {
        public void registerConfigured(ResourceKey<ConfiguredFeature<?, ?>> var1, Function<HolderGetterLookup, ConfiguredFeature<?, ?>> var2);

        public void registerPlaced(ResourceKey<PlacedFeature> var1, Function<HolderGetterLookup, PlacedFeature> var2);
    }

    public record FeatureBiomeModifier(TagKey<Biome> tag, GenerationStep.Decoration decoration, ResourceKey<PlacedFeature> placedFeature) {
        public static FeatureBiomeModifier of(ResourceKey<PlacedFeature> id) {
            return new FeatureBiomeModifier(RunecraftoryTags.Biomes.VANILLA_DIMENSIONS, GenerationStep.Decoration.VEGETAL_DECORATION, id);
        }
    }

    public static interface HolderGetterLookup {
        default public <S> Holder<S> get(ResourceKey<S> key) {
            return this.lookup(key.registryKey()).getOrThrow(key);
        }

        public <S> HolderGetter<S> lookup(ResourceKey<? extends Registry<? extends S>> var1);
    }
}

