/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.inventory.container;

import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.entities.npc.profession.ShopResult;
import io.github.flemmli97.runecraftory.common.inventory.InventoryShop;
import io.github.flemmli97.runecraftory.common.network.S2CShopResponses;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryMenuTypes;
import io.github.flemmli97.runecraftory.common.utils.ItemUtils;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ContainerShop
extends AbstractContainerMenu {
    public static final StreamCodec<RegistryFriendlyByteBuf, Data> DATA_STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, Data>(){

        public Data decode(RegistryFriendlyByteBuf buf) {
            int entity = buf.readInt();
            int size = buf.readInt();
            NonNullList list = NonNullList.create();
            for (int i = 0; i < size; ++i) {
                list.add((Object)((ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf)));
            }
            return new Data(entity, (NonNullList<ItemStack>)list);
        }

        public void encode(RegistryFriendlyByteBuf buf, Data data) {
            buf.writeInt(data.entity());
            buf.writeInt(data.list().size());
            data.list().forEach(stack -> ItemStack.STREAM_CODEC.encode((Object)buf, stack));
        }
    };
    private final InventoryShop invShop;
    private final DataSlot price;
    private final DataSlot next;
    private final DataSlot prev;

    public ContainerShop(int windowID, Inventory playerInv, Data data) {
        this(windowID, playerInv, ContainerShop.read(playerInv.player.level(), data));
    }

    public ContainerShop(int windowID, Inventory playerInv, InventoryShop invShop) {
        super((MenuType)RuneCraftoryMenuTypes.SHOP_CONTAINER.get(), windowID);
        this.invShop = invShop;
        if (this.invShop == null) {
            throw new IllegalStateException("Tried creating a shop container but shop inventory was null");
        }
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 6; ++x) {
                this.addSlot(new Slot(this, this.invShop, x + y * 5, 13 + x * 21, 28 + y * 21){

                    public boolean mayPlace(ItemStack stack) {
                        return false;
                    }

                    public boolean mayPickup(Player player) {
                        return false;
                    }
                });
            }
        }
        this.addSlot(new Slot(this, this.invShop, 30, 200, 144){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            public boolean mayPickup(Player player) {
                return false;
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInv, j + i * 9 + 9, 13 + j * 18, 135 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInv, k, 13 + k * 18, 193));
        }
        this.price = DataSlot.standalone();
        this.addDataSlot(this.price);
        this.next = DataSlot.standalone();
        this.addDataSlot(this.next);
        this.prev = DataSlot.standalone();
        this.addDataSlot(this.prev);
        this.next.set(this.invShop.hasNext() ? 1 : 0);
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        if (index <= 30) {
            return ItemStack.EMPTY;
        }
        Slot slot = (Slot)this.slots.get(index);
        ItemStack slotItem = slot.getItem();
        ItemStack slotCopy = slotItem.copy();
        if (index < 58 ? !this.moveItemStackTo(slotItem, 58, 67, false) : !this.moveItemStackTo(slotItem, 31, 58, false)) {
            return ItemStack.EMPTY;
        }
        if (slotItem.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (slotItem.getCount() == slotCopy.getCount()) {
            return ItemStack.EMPTY;
        }
        return slotCopy;
    }

    public void clicked(int slot, int mouse, ClickType clickType, Player player) {
        if (slot > 30 || slot < 0) {
            super.clicked(slot, mouse, clickType, player);
            return;
        }
        if (slot == 30) {
            Slot shopOutput = this.getSlot(30);
            if (shopOutput.hasItem() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ShopResult res = ItemUtils.buyItem(player, this.invShop.npc, shopOutput.getItem().copy());
                MutableComponent txt = switch (res) {
                    default -> throw new MatchException(null, null);
                    case ShopResult.NOMONEY -> Component.translatable((String)"runecraftory.npc.shop.money.no");
                    case ShopResult.NOSPACE -> Component.translatable((String)"runecraftory.npc.shop.inventory.full");
                    case ShopResult.SUCCESS -> Component.translatable((String)"runecraftory.npc.shop.success");
                };
                LoaderNetwork.INSTANCE.sendToPlayer((CustomPacketPayload)new S2CShopResponses((Component)txt), serverPlayer);
                if (res == ShopResult.SUCCESS) {
                    shopOutput.set(ItemStack.EMPTY);
                }
            }
            return;
        }
        if (clickType == ClickType.QUICK_MOVE || clickType == ClickType.PICKUP || clickType == ClickType.PICKUP_ALL) {
            int count;
            ItemStack clickedStack = this.getSlot(slot).getItem();
            if (clickedStack.isEmpty()) {
                return;
            }
            Slot shopOutput = this.getSlot(30);
            int n = count = clickType == ClickType.QUICK_MOVE ? 10 : 1;
            if (mouse == 1) {
                count = -count;
            }
            boolean changed = false;
            if (!shopOutput.hasItem() || !ItemStack.isSameItemSameComponents((ItemStack)clickedStack, (ItemStack)shopOutput.getItem())) {
                if (count > 0) {
                    ItemStack copy = clickedStack.copy();
                    copy.setCount(count);
                    shopOutput.set(copy);
                    changed = true;
                }
            } else {
                shopOutput.getItem().setCount(Math.min(shopOutput.getItem().getMaxStackSize() * 36, shopOutput.getItem().getCount() + count));
                changed = true;
            }
            if (changed) {
                if (shopOutput.hasItem()) {
                    this.price.set(ItemUtils.getBuyPrice(shopOutput.getItem()) * shopOutput.getItem().getCount());
                } else {
                    this.price.set(0);
                }
            }
            this.broadcastChanges();
        }
    }

    public int getCurrentCost() {
        return this.price.get();
    }

    public NPCEntity getShopOwner() {
        return this.invShop.npc;
    }

    private static InventoryShop read(Level level, Data data) {
        Entity entity = level.getEntity(data.entity());
        if (entity instanceof NPCEntity) {
            NPCEntity npc = (NPCEntity)entity;
            return new InventoryShop(npc, data.list());
        }
        return null;
    }

    public void prev() {
        this.invShop.prev();
        this.broadcastChanges();
        this.next.set(this.invShop.hasPrev() ? 1 : 0);
    }

    public void next() {
        this.invShop.next();
        this.broadcastChanges();
        this.next.set(this.invShop.hasNext() ? 1 : 0);
    }

    public boolean hasNext() {
        return this.next.get() == 1;
    }

    public boolean hasPrev() {
        return this.prev.get() == 1;
    }

    public record Data(int entity, NonNullList<ItemStack> list) {
    }
}

