/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items;

import io.github.flemmli97.runecraftory.common.components.BabyData;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryDataComponentTypes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class BabySpawnEgg
extends Item {
    public BabySpawnEgg(Item.Properties props) {
        super(props);
    }

    public static ItemStack createBabyFrom(NPCEntity baby, Component playerName, UUID father, UUID mother) {
        CompoundTag tag = baby.saveWithoutId(new CompoundTag());
        tag.remove("Pos");
        tag.remove("UUID");
        tag.remove("Motion");
        tag.remove("Rotation");
        ItemStack stack = new ItemStack((ItemLike)RuneCraftoryItems.NPC_BABY.get());
        stack.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)tag));
        stack.set((DataComponentType)RuneCraftoryDataComponentTypes.BABY_DATA.get(), (Object)new BabyData(baby.isMale(), baby.getDataName(), father, mother, Optional.of(playerName)));
        return stack;
    }

    public static boolean isBoy(ItemStack stack) {
        return ((BabyData)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.BABY_DATA.get(), (Object)BabyData.DEFAULT)).male();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, list, tooltipFlag);
        list.add((Component)(BabySpawnEgg.isBoy(stack) ? Component.translatable((String)"runecraftory.tooltip.baby.boy").withStyle(ChatFormatting.BLUE) : Component.translatable((String)"runecraftory.tooltip.baby.girl").withStyle(ChatFormatting.RED)));
        this.getPlayerName(stack).ifPresent(name -> list.add((Component)Component.translatable((String)"runecraftory.tooltip.baby.owner", (Object[])new Object[]{name}).withStyle(ChatFormatting.GOLD)));
    }

    public Optional<Component> getPlayerName(ItemStack stack) {
        return ((BabyData)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.BABY_DATA.get(), (Object)BabyData.DEFAULT)).player();
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Level level = ctx.getLevel();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = ctx.getItemInHand();
        BlockPos blockpos = ctx.getClickedPos();
        Direction direction = ctx.getClickedFace();
        BlockState blockstate = level.getBlockState(blockpos);
        BlockPos blockpos1 = blockstate.getCollisionShape((BlockGetter)level, blockpos).isEmpty() ? blockpos : blockpos.relative(direction);
        Entity e = this.spawnEntity((ServerLevel)level, ctx.getPlayer(), stack, blockpos1, MobSpawnType.SPAWN_EGG, true, true, !Objects.equals(blockpos, blockpos1) && direction == Direction.UP);
        if (e != null) {
            stack.shrink(1);
        }
        return InteractionResult.CONSUME;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        BlockHitResult raytraceresult = BabySpawnEgg.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (raytraceresult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (!(level instanceof ServerLevel)) {
            return InteractionResultHolder.success((Object)stack);
        }
        BlockPos blockpos = raytraceresult.getBlockPos();
        if (!(level.getBlockState(blockpos).getBlock() instanceof LiquidBlock)) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (level.mayInteract(player, blockpos) && player.mayUseItemAt(blockpos, raytraceresult.getDirection(), stack)) {
            Entity e = this.spawnEntity((ServerLevel)level, player, stack, blockpos, MobSpawnType.SPAWN_EGG, true, true, false);
            if (e != null) {
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                return InteractionResultHolder.consume((Object)stack);
            }
            return InteractionResultHolder.pass((Object)stack);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    private Entity spawnEntity(ServerLevel level, Player player, ItemStack stack, BlockPos pos, MobSpawnType spawnType, boolean forgeCheck, boolean updateLocation, boolean doCollisionOffset) {
        BabyData data = (BabyData)stack.get((DataComponentType)RuneCraftoryDataComponentTypes.BABY_DATA.get());
        if (data == null) {
            return null;
        }
        EntityType type = (EntityType)RuneCraftoryEntities.NPC.get();
        if (data.name().isEmpty()) {
            if (player != null) {
                player.displayClientMessage((Component)Component.translatable((String)"runecraftory.npc.spawn.name.missing").withStyle(ChatFormatting.RED), false);
            }
            return null;
        }
        Entity e = type.create(level, EntityType.createDefaultStackConfig((ServerLevel)level, (ItemStack)stack, (Player)player), pos, spawnType, updateLocation, doCollisionOffset);
        if (e instanceof NPCEntity) {
            NPCEntity npc = (NPCEntity)e;
            npc.tryUpdateName((Component)Component.literal((String)data.name().get()));
            npc.getFamily().setFather(data.father());
            npc.getFamily().setMother(data.mother());
            level.addFreshEntityWithPassengers(e);
            return e;
        }
        return null;
    }
}

