/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.creative;

import io.github.flemmli97.runecraftory.api.datapack.npc.NPCData;
import io.github.flemmli97.runecraftory.api.registry.NPCProfession;
import io.github.flemmli97.runecraftory.common.components.NPCSpawnData;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.datapack.ReloadableHolder;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.items.creative.RuneCraftoryEggItem;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryDataComponentTypes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryNPCProfessions;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class NPCSpawnEgg
extends RuneCraftoryEggItem {
    public NPCSpawnEgg(Supplier<? extends EntityType<? extends Mob>> type, Item.Properties props) {
        super(type, 4532232, 8211477, props);
    }

    public boolean addToDefaultSpawneggs() {
        return false;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, list, tooltipFlag);
        NPCSpawnData itemData = (NPCSpawnData)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.NPC_SPAWN_DATA.get(), (Object)NPCSpawnData.DEFAULT);
        String key = itemData.profession().map(h -> ((NPCProfession)h.value()).getTranslationKey()).orElse(((NPCProfession)RuneCraftoryNPCProfessions.NONE.get()).getTranslationKey());
        list.add((Component)Component.translatable((String)key).withStyle(ChatFormatting.AQUA));
    }

    @Override
    public boolean onEntitySpawned(Entity e, ItemStack stack, Player player) {
        if (e instanceof NPCEntity) {
            ReloadableHolder<NPCData> data;
            NPCEntity npc = (NPCEntity)e;
            NPCSpawnData itemData = (NPCSpawnData)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.NPC_SPAWN_DATA.get(), (Object)NPCSpawnData.DEFAULT);
            boolean profession = true;
            if (itemData.npcDataId().isPresent() && (data = DataPackHandler.INSTANCE.npcDataManager().get(itemData.npcDataId().get())) != null) {
                npc.setNPCData(data, false);
                profession = data.value().profession().isEmpty();
            }
            if (profession) {
                itemData.profession().ifPresent(prof -> npc.randomizeData((NPCProfession)prof.value(), true));
            }
        }
        return super.onEntitySpawned(e, stack, player);
    }
}

