/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.creative;

import io.github.flemmli97.runecraftory.common.entities.misc.TreasureChestEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryDataComponentTypes;
import io.github.flemmli97.tenshilib.common.item.SpawnEgg;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class TreasureChestSpawnegg
extends SpawnEgg {
    public TreasureChestSpawnegg(Supplier<? extends EntityType<?>> type, Item.Properties props) {
        super(type, 11309918, 4599568, props);
    }

    public boolean addToDefaultSpawneggs() {
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)Component.translatable((String)"runecraftory.tooltip.item.treasure_chest").withStyle(ChatFormatting.GOLD));
        list.add((Component)Component.translatable((String)"runecraftory.tooltip.item.treasure_level", (Object[])new Object[]{this.getTier(stack).ordinal() + 1}).withStyle(ChatFormatting.AQUA));
        super.appendHoverText(stack, context, list, tooltipFlag);
    }

    public boolean onEntitySpawned(Entity e, ItemStack stack, Player player) {
        if (e instanceof TreasureChestEntity) {
            TreasureChestEntity chest = (TreasureChestEntity)e;
            chest.setTier(this.getTier(stack));
        }
        if ((double)e.getBbWidth() > 0.7 && e.getBbWidth() < 1.0f) {
            e.setPos(e.getX() + 0.05, e.getY(), e.getZ());
        }
        return super.onEntitySpawned(e, stack, player);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (player.isShiftKeyDown()) {
            ItemStack stack = player.getItemInHand(hand);
            if (!level.isClientSide) {
                ChestTier tier = this.getTier(stack);
                stack.set((DataComponentType)RuneCraftoryDataComponentTypes.SPAWN_EGG_CHEST_TIER.get(), (Object)tier.cycle());
            }
            return InteractionResultHolder.consume((Object)stack);
        }
        return super.use(level, player, hand);
    }

    public int getColor(ItemStack stack, int i) {
        ChestTier tier = this.getTier(stack);
        if (tier == ChestTier.RARE || tier == ChestTier.EPIC) {
            return i == 0 ? 9411780 : 0x343843;
        }
        return super.getColor(stack, i);
    }

    protected ChestTier getTier(ItemStack stack) {
        return (ChestTier)((Object)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.SPAWN_EGG_CHEST_TIER.get(), (Object)ChestTier.COMMON));
    }

    public static enum ChestTier {
        COMMON,
        UNCOMMON,
        RARE,
        EPIC,
        QUEST;


        public ChestTier cycle() {
            int next = (this.ordinal() + 1) % ChestTier.values().length;
            return ChestTier.values()[next];
        }
    }
}

