/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.loot;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.MapCodec;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryLootRegistries;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class FirstKillCondition
implements LootItemCondition {
    public static final FirstKillCondition INSTANCE = new FirstKillCondition();
    public static final MapCodec<FirstKillCondition> CODEC = MapCodec.unit((Object)INSTANCE);

    private FirstKillCondition() {
    }

    public static LootItemCondition.Builder get() {
        return () -> INSTANCE;
    }

    public LootItemConditionType getType() {
        return (LootItemConditionType)RuneCraftoryLootRegistries.FIRST_KILL.get();
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of((Object)LootContextParams.ATTACKING_ENTITY);
    }

    public boolean test(LootContext ctx) {
        Entity entity = (Entity)ctx.getParamOrNull(LootContextParams.ATTACKING_ENTITY);
        ServerPlayer player = null;
        if (entity instanceof LivingEntity) {
            OwnableEntity ownable;
            LivingEntity livingEntity;
            LivingEntity living = (LivingEntity)entity;
            if (living instanceof ServerPlayer) {
                ServerPlayer serverPlayer;
                player = serverPlayer = (ServerPlayer)living;
            } else if (living instanceof OwnableEntity && (livingEntity = (ownable = (OwnableEntity)living).getOwner()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer;
                player = serverPlayer = (ServerPlayer)livingEntity;
            }
            return player != null && player.getStats().getValue(Stats.ENTITY_KILLED.get((Object)entity.getType())) <= 0;
        }
        return false;
    }
}

