/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.loot;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.MapCodec;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.loot.LootCtxParameters;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryLootRegistries;
import java.util.Set;
import java.util.UUID;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public record TalkCountCondition(int count) implements LootItemCondition
{
    public static final MapCodec<TalkCountCondition> CODEC = ExtraCodecs.NON_NEGATIVE_INT.fieldOf("count").xmap(TalkCountCondition::new, TalkCountCondition::count);

    public static LootItemCondition.Builder of(int count) {
        return () -> new TalkCountCondition(count);
    }

    public LootItemConditionType getType() {
        return (LootItemConditionType)RuneCraftoryLootRegistries.TALKCOUNT.get();
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of((Object)LootContextParams.THIS_ENTITY);
    }

    public boolean test(LootContext ctx) {
        Object object = ctx.getParamOrNull(LootContextParams.THIS_ENTITY);
        if (object instanceof NPCEntity) {
            NPCEntity npc = (NPCEntity)object;
            UUID uuid = (UUID)ctx.getParamOrNull(LootCtxParameters.UUID_CONTEXT);
            if (uuid != null) {
                return npc.talkCount(uuid) >= this.count;
            }
        }
        return false;
    }
}

