/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.quests.tasks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.simplequests_api.SimpleQuestsAPI;
import io.github.flemmli97.simplequests_api.player.PlayerQuestData;
import io.github.flemmli97.simplequests_api.player.QuestProgress;
import io.github.flemmli97.simplequests_api.quest.QuestBase;
import io.github.flemmli97.simplequests_api.quest.entry.QuestEntryKey;
import io.github.flemmli97.simplequests_api.quest.entry.QuestTask;
import io.github.flemmli97.simplequests_api.quest.entry.ResolvedQuestTask;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class SkillLevelTask
implements QuestTask<SkillLevelTaskResolved> {
    public static final QuestEntryKey<SkillLevelTask> ID = new QuestEntryKey(RuneCraftory.modRes("skill_level"));
    public static final MapCodec<SkillLevelTask> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("description").forGetter(d -> d.description), (App)ExtraCodecs.nonEmptyList((Codec)CodecUtils.stringEnumCodec(Skills.class, null).listOf()).fieldOf("skill").forGetter(d -> d.skills), (App)NumberProviders.CODEC.fieldOf("level").forGetter(d -> d.range)).apply((Applicative)instance, SkillLevelTask::new));
    private final String description;
    private final List<Skills> skills;
    private final NumberProvider range;

    public SkillLevelTask(String description, List<Skills> skills, NumberProvider range) {
        this.description = description;
        this.skills = skills;
        this.range = range;
        if (this.description.isEmpty() && !this.simple()) {
            throw new IllegalStateException("Description is required");
        }
    }

    private boolean simple() {
        return this.skills.size() == 1 && this.range instanceof ConstantValue;
    }

    public MutableComponent translation(ServerPlayer player) {
        if (this.description.isEmpty() && this.simple()) {
            Skills skill = this.skills.getFirst();
            return Component.translatable((String)this.getId().toString(), (Object[])new Object[]{skill, this.range.getInt(null)});
        }
        return Component.translatable((String)this.description);
    }

    public QuestEntryKey<?> getId() {
        return ID;
    }

    public SkillLevelTaskResolved resolve(PlayerQuestData data, QuestProgress progress, QuestBase base) {
        LootContext ctx = SimpleQuestsAPI.createContext((PlayerQuestData)data, (ResourceLocation)base.id);
        Skills skills = this.skills.get(ctx.getRandom().nextInt(this.skills.size()));
        return new SkillLevelTaskResolved(skills, this.range.getInt(ctx));
    }

    public record SkillLevelTaskResolved(Skills skill, int level) implements ResolvedQuestTask
    {
        public static final MapCodec<SkillLevelTaskResolved> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CodecUtils.stringEnumCodec(Skills.class, null).fieldOf("skill").forGetter(d -> d.skill), (App)ExtraCodecs.POSITIVE_INT.fieldOf("level").forGetter(d -> d.level)).apply((Applicative)instance, SkillLevelTaskResolved::new));

        public boolean submit(ServerPlayer player) {
            return Platform.INSTANCE.getPlayerData((Player)player).getPlayerLevel().getLevel() >= this.level;
        }

        public QuestEntryKey<SkillLevelTask> getId() {
            return ID;
        }

        public MutableComponent translation(ServerPlayer player) {
            return Component.translatable((String)this.getId().toString(), (Object[])new Object[]{this.skill, this.level});
        }
    }
}

