/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.ElementalBallEntity;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ProjectileUtils;
import io.github.flemmli97.tenshilib.common.utils.HitResultUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class IceBallDropSpell
extends Spell {
    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        ElementalBallEntity ball = new ElementalBallEntity((Level)level, entity, ItemElement.WATER);
        ball.setVariant(1);
        Vec3 target = ProjectileUtils.getAimTarget(entity);
        if (target == null) {
            Vec3 vec3;
            HitResult res = HitResultUtils.entityRayTrace((Entity)entity, (double)10.0, (ClipContext.Block)ClipContext.Block.COLLIDER, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY, (boolean)true, (boolean)true, null);
            if (res instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)res;
                vec3 = entityHitResult.getEntity().getEyePosition();
            } else {
                vec3 = res.getLocation();
            }
            target = vec3;
        }
        ball.setPos(target.x(), target.y() + 5.0, target.z());
        ball.withMaxLivingTicks(25);
        ball.setDeltaMovement(new Vec3(0.0, -1.0, 0.0).scale(0.3));
        ball.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, this));
        level.addFreshEntity((Entity)ball);
        IceBallDropSpell.playSound(entity, (SoundEvent)RuneCraftorySounds.SPELL_GENERIC_FIRE_BALL.get(), 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
        return true;
    }
}

