/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.SmallRaccoonLeafEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.MathsHelper;
import io.github.flemmli97.runecraftory.common.utils.ProjectileUtils;
import io.github.flemmli97.tenshilib.common.utils.math.MathUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;

public class SmallLeafSpell
extends Spell {
    private final int amount;

    public SmallLeafSpell(int amount) {
        this.amount = amount;
    }

    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        Vec3 pos = new SmallRaccoonLeafEntity((Level)level, entity).position();
        Vec3 target = ProjectileUtils.getAimTarget(entity, pos);
        Vec3 dir = target != null ? target.subtract(pos) : entity.getViewVector(1.0f);
        float degs = this.amount < 5 ? 25.0f : 35.0f;
        Vec3 up = MathsHelper.getUp(dir);
        for (Vector3d vec : MathUtils.rotatedVecs((Vector3d)new Vector3d(dir.x(), dir.y(), dir.z()), (Vector3d)new Vector3d(up.x(), up.y(), up.z()), (float)(-degs), (float)degs, (float)(degs * 2.0f / (float)this.amount))) {
            SmallRaccoonLeafEntity leaf = new SmallRaccoonLeafEntity((Level)level, entity);
            leaf.setPos(leaf.getX() + vec.x() * 0.1, leaf.getY() + vec.y() * 0.1, leaf.getZ() + vec.z() * 0.1);
            leaf.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, this));
            leaf.shoot(vec.x(), vec.y(), vec.z(), 0.75f, 0.0f);
            level.addFreshEntity((Entity)leaf);
        }
        SmallLeafSpell.playSound(entity, (SoundEvent)RuneCraftorySounds.ENTITY_FLOWER_LILY_STEP.get(), 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.2f);
        return true;
    }
}

