/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.calendar.Season;
import io.github.flemmli97.runecraftory.common.world.data.RunecraftorySavedData;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityInLevelCallback;

public class WorldUtils {
    public static final TicketType<ChunkPos> ENTITY_LOADER = TicketType.create((String)"runecraftory_entity_loader", Comparator.comparingLong(ChunkPos::toLong), (int)10);
    public static final Codec<Pair<Season, Integer>> DATE = RecordCodecBuilder.create(inst -> inst.group((App)CodecUtils.stringEnumCodec(Season.class, null).fieldOf("season").forGetter(Pair::getFirst), (App)WorldUtils.dayRange().fieldOf("day").forGetter(Pair::getSecond)).apply((Applicative)inst, Pair::of));

    private static Codec<Integer> dayRange() {
        Function<Integer, DataResult> function = i -> {
            if (i >= 1 && i <= 30) {
                return DataResult.success((Object)i);
            }
            return DataResult.error(() -> "Date must be between 1 - 30 but is " + i);
        };
        return Codec.INT.flatXmap(function, function);
    }

    public static boolean canUpdateDaily(Level level, int lastUpdate) {
        return ((GameRules.BooleanValue)level.getGameRules().getRule(GameRules.RULE_DAYLIGHT)).get() && WorldUtils.day(level) != lastUpdate;
    }

    public static int dayTime(Level level) {
        return (int)(level.getDayTime() % 24000L);
    }

    public static int dayTimeTotal(Level level) {
        return (int)level.getDayTime();
    }

    public static long totalTime(Level level) {
        return level.getGameTime();
    }

    public static int day(Level level) {
        return WorldUtils.day(level, 0);
    }

    public static int day(Level level, int tickOffset) {
        return (int)((level.getDayTime() + (long)tickOffset) / 24000L % Integer.MAX_VALUE);
    }

    public static <T extends Mob> EntityInLevelCallback wrappedCallbackFor(final T member, final Supplier<Player> partyOwner, final EntityInLevelCallback callback) {
        return new EntityInLevelCallback(){

            public void onMove() {
                callback.onMove();
            }

            public void onRemove(Entity.RemovalReason reason) {
                Level level = member.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (reason == Entity.RemovalReason.UNLOADED_TO_CHUNK) {
                        RunecraftorySavedData.get(serverLevel.getServer()).safeUnloadedPartyMembers((LivingEntity)member);
                    } else if (reason == Entity.RemovalReason.DISCARDED || reason == Entity.RemovalReason.KILLED) {
                        Player owner = (Player)partyOwner.get();
                        if (owner instanceof ServerPlayer) {
                            ServerPlayer player = (ServerPlayer)owner;
                            Platform.INSTANCE.getPlayerData((Player)player).party.removePartyMember((Entity)member);
                        } else {
                            RunecraftorySavedData.get(serverLevel.getServer()).toRemovePartyMember((LivingEntity)member);
                        }
                    }
                }
                callback.onRemove(reason);
            }
        };
    }
}

