/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world.features.trees;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryFeatures;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class FruitLeaveDecorator
extends TreeDecorator {
    public static final MapCodec<FruitLeaveDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockStateProvider.CODEC.fieldOf("fruit").forGetter(d -> d.fruit), (App)IntProvider.NON_NEGATIVE_CODEC.fieldOf("amount").forGetter(d -> d.amount)).apply((Applicative)instance, FruitLeaveDecorator::new));
    public final BlockStateProvider fruit;
    public final IntProvider amount;

    public FruitLeaveDecorator(BlockStateProvider fruit, IntProvider amount) {
        this.fruit = fruit;
        this.amount = amount;
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)RuneCraftoryFeatures.FRUIT_DECORATOR.get();
    }

    public void place(TreeDecorator.Context context) {
        ArrayList<BlockPos> potentialFruits = new ArrayList<BlockPos>(context.leaves().stream().filter(p -> context.isAir(p.below())).toList());
        int fruits = this.amount.sample(context.random());
        for (int i = 0; i < fruits; ++i) {
            if (potentialFruits.isEmpty()) {
                return;
            }
            BlockPos pos = (BlockPos)potentialFruits.remove(context.random().nextInt(potentialFruits.size()));
            context.setBlock(pos, this.fruit.getState(context.random(), pos));
        }
    }
}

