/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world.features.trees;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.blocks.TreeBaseBlock;
import io.github.flemmli97.runecraftory.common.blocks.TreeRootBlock;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryBlocks;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryFeatures;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class FruitTreeTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<FruitTreeTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("base_height").forGetter(d -> d.baseHeight), (App)Codec.INT.fieldOf("height_rand_a").forGetter(d -> d.heightRandA), (App)Codec.INT.fieldOf("min_branches").forGetter(d -> d.minBranches), (App)Codec.INT.fieldOf("max_branches").forGetter(d -> d.maxBranches)).apply((Applicative)instance, FruitTreeTrunkPlacer::new));
    private final int minBranches;
    private final int maxBranches;

    public FruitTreeTrunkPlacer(int baseHeight, int heightRandA, int minBranches, int maxBranches) {
        super(baseHeight, heightRandA, 0);
        this.minBranches = minBranches;
        this.maxBranches = maxBranches;
    }

    protected static boolean placeIfFree(LevelSimulatedReader level, Map<BlockPos, BlockState> blockSetter, BlockPos pos, BlockState state) {
        if (level.isStateAtPosition(pos, TreeBaseBlock::isAirOrReplaceable)) {
            blockSetter.put(pos, state);
            return true;
        }
        return false;
    }

    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)RuneCraftoryFeatures.FRUIT_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int freeTreeHeight, BlockPos pos, TreeConfiguration config) {
        BlockPos soil = pos.below();
        HashMap<BlockPos, BlockState> placements = new HashMap<BlockPos, BlockState>();
        if (level.isStateAtPosition(soil, s -> !s.is((Block)RuneCraftoryBlocks.TREE_SOIL.get()))) {
            placements.put(soil, ((TreeRootBlock)((Object)RuneCraftoryBlocks.TREE_SOIL.get())).defaultBlockState());
        }
        ArrayList<FoliagePlacer.FoliageAttachment> foliagePos = new ArrayList<FoliagePlacer.FoliageAttachment>();
        for (int i = 1; i <= freeTreeHeight; ++i) {
            BlockPos log = pos.above(i);
            if (!FruitTreeTrunkPlacer.placeIfFree(level, placements, log, config.trunkProvider.getState(random, log))) {
                return List.of();
            }
            if (i != freeTreeHeight || freeTreeHeight > 3) continue;
            foliagePos.add(new FoliagePlacer.FoliageAttachment(log.above(), -1, false));
        }
        ArrayList dirs = new ArrayList(Direction.Plane.HORIZONTAL.stream().toList());
        float chance = 1.0f;
        for (int i = 0; i < dirs.size(); ++i) {
            int offset;
            Direction dir = (Direction)dirs.remove(random.nextInt(dirs.size()));
            if (!(random.nextFloat() < chance)) continue;
            int n = offset = freeTreeHeight <= 3 || random.nextInt(3) == 0 ? 1 : 0;
            if (!this.growBranch(pos.above(freeTreeHeight + offset), dir, config, level, placements, random, random.nextInt(this.minBranches, this.maxBranches + 1), foliagePos)) {
                return List.of();
            }
            chance = (float)((double)chance - 0.3);
        }
        placements.forEach(blockSetter);
        return foliagePos;
    }

    public int getTreeHeight(RandomSource random) {
        return random.nextInt(1 + this.heightRandA) + this.baseHeight;
    }

    private boolean growBranch(BlockPos pos, Direction dir, TreeConfiguration config, LevelSimulatedReader level, Map<BlockPos, BlockState> blockSetter, RandomSource rand, int amount, List<FoliagePlacer.FoliageAttachment> logs) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0 || dir.getStepX() != 0 && i == -dir.getStepX() || dir.getStepZ() != 0 && j == -dir.getStepZ()) continue;
                list.add(new BlockPos(i, 0, j));
            }
        }
        BlockPos.MutableBlockPos mut = pos.mutable();
        for (int i = 0; i < amount; ++i) {
            BlockPos d = (BlockPos)list.get(rand.nextInt(list.size()));
            Direction direction = d.getX() == 0 || d.getZ() == 0 ? Direction.fromDelta((int)d.getX(), (int)d.getY(), (int)d.getZ()) : (dir = rand.nextBoolean() ? dir.getClockWise() : dir);
            if (i != 0 && (mut.getY() == pos.getY() ? rand.nextInt(2) == 0 : rand.nextInt(3) == 0)) {
                d = d.above();
            }
            mut.move((Vec3i)d);
            BlockPos newPos = mut.immutable();
            if (!FruitTreeTrunkPlacer.placeIfFree(level, blockSetter, newPos, (BlockState)config.trunkProvider.getState(rand, newPos).setValue((Property)RotatedPillarBlock.AXIS, (Comparable)dir.getAxis()))) {
                return false;
            }
            logs.add(new FoliagePlacer.FoliageAttachment(newPos.above(), 0, false));
        }
        return true;
    }
}

