/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.integration.jei;

import io.github.flemmli97.runecraftory.common.recipes.CraftingType;
import io.github.flemmli97.runecraftory.common.recipes.SextupleRecipe;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryCrafting;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;

public final class CraftingIdentifier
extends Record {
    private final RecipeType<RecipeHolder<SextupleRecipe>> identifier;
    private final CraftingType craftingType;
    private final Supplier<net.minecraft.world.item.crafting.RecipeType<SextupleRecipe>> recipeType;
    private static final Map<CraftingType, CraftingIdentifier> IDENTIFIERS = new HashMap<CraftingType, CraftingIdentifier>();
    public static final CraftingIdentifier FORGING = new CraftingIdentifier(CraftingType.FORGE);
    public static final CraftingIdentifier CHEMISTRY = new CraftingIdentifier(CraftingType.CHEMISTRY_SET);
    public static final CraftingIdentifier COOKING = new CraftingIdentifier(CraftingType.COOKING_TABLE);
    public static final CraftingIdentifier ARMOR = new CraftingIdentifier(CraftingType.ACCESSORY_WORKBENCH);

    private CraftingIdentifier(CraftingType craftingType) {
        RecipeType recipeType = CraftingIdentifier.createHolder("runecraftory", craftingType.getId() + "_category");
        this((RecipeType<RecipeHolder<SextupleRecipe>>)recipeType, craftingType, (Supplier<net.minecraft.world.item.crafting.RecipeType<SextupleRecipe>>)(switch (craftingType) {
            default -> throw new MatchException(null, null);
            case CraftingType.FORGE -> RuneCraftoryCrafting.FORGE;
            case CraftingType.ACCESSORY_WORKBENCH -> RuneCraftoryCrafting.ARMOR;
            case CraftingType.CHEMISTRY_SET -> RuneCraftoryCrafting.CHEMISTRY;
            case CraftingType.COOKING_TABLE -> RuneCraftoryCrafting.COOKING;
        }));
        IDENTIFIERS.put(craftingType, this);
    }

    public CraftingIdentifier(RecipeType<RecipeHolder<SextupleRecipe>> identifier, CraftingType craftingType, Supplier<net.minecraft.world.item.crafting.RecipeType<SextupleRecipe>> recipeType) {
        this.identifier = identifier;
        this.craftingType = craftingType;
        this.recipeType = recipeType;
    }

    public static CraftingIdentifier get(CraftingType craftingType) {
        return IDENTIFIERS.get((Object)craftingType);
    }

    public static boolean has(RecipeType<?> recipeType) {
        return IDENTIFIERS.values().stream().anyMatch(id -> id.identifier().equals((Object)recipeType));
    }

    private static <R extends Recipe<?>> RecipeType<RecipeHolder<R>> createHolder(String nameSpace, String path) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)nameSpace, (String)path);
        Class<RecipeHolder> holderClass = RecipeHolder.class;
        return new RecipeType(id, holderClass);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{CraftingIdentifier.class, "identifier;craftingType;recipeType", "identifier", "craftingType", "recipeType"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CraftingIdentifier.class, "identifier;craftingType;recipeType", "identifier", "craftingType", "recipeType"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CraftingIdentifier.class, "identifier;craftingType;recipeType", "identifier", "craftingType", "recipeType"}, this, o);
    }

    public RecipeType<RecipeHolder<SextupleRecipe>> identifier() {
        return this.identifier;
    }

    public CraftingType craftingType() {
        return this.craftingType;
    }

    public Supplier<net.minecraft.world.item.crafting.RecipeType<SextupleRecipe>> recipeType() {
        return this.recipeType;
    }
}

