/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.integration.rei;

import io.github.flemmli97.runecraftory.client.gui.CraftingGui;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.runecraftory.integration.rei.CraftingIdentifier;
import io.github.flemmli97.runecraftory.integration.rei.SextupleCategory;
import io.github.flemmli97.runecraftory.integration.rei.SextupleDisplayGenerator;
import io.github.flemmli97.runecraftory.mixinhelper.CreativeScreenSubTab;
import io.github.flemmli97.tenshilib.client.gui.widget.list.SelectableListWidget;
import java.util.List;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.display.DynamicDisplayGenerator;
import me.shedaniel.rei.api.client.registry.screen.ClickArea;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZonesProvider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.client.exclusionzones.DefaultRecipeBookExclusionZones;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.world.level.ItemLike;

public class ReiClientPlugin
implements REIClientPlugin {
    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new SextupleCategory(CraftingIdentifier.FORGING));
        registry.addWorkstations(CraftingIdentifier.FORGING.identifier(), new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)RuneCraftoryItems.FORGE.get()))});
        registry.add((DisplayCategory)new SextupleCategory(CraftingIdentifier.CHEMISTRY));
        registry.addWorkstations(CraftingIdentifier.CHEMISTRY.identifier(), new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)RuneCraftoryItems.CHEMISTRY_SET.get()))});
        registry.add((DisplayCategory)new SextupleCategory(CraftingIdentifier.COOKING));
        registry.addWorkstations(CraftingIdentifier.COOKING.identifier(), new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)RuneCraftoryItems.COOKING_TABLE.get()))});
        registry.add((DisplayCategory)new SextupleCategory(CraftingIdentifier.ARMOR));
        registry.addWorkstations(CraftingIdentifier.ARMOR.identifier(), new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)RuneCraftoryItems.ACCESSORY_WORKBENCH.get()))});
    }

    public void registerDisplays(DisplayRegistry registry) {
        registry.registerDisplayGenerator(CraftingIdentifier.FORGING.identifier(), (DynamicDisplayGenerator)new SextupleDisplayGenerator(CraftingIdentifier.FORGING));
        registry.registerDisplayGenerator(CraftingIdentifier.ARMOR.identifier(), (DynamicDisplayGenerator)new SextupleDisplayGenerator(CraftingIdentifier.ARMOR));
        registry.registerDisplayGenerator(CraftingIdentifier.CHEMISTRY.identifier(), (DynamicDisplayGenerator)new SextupleDisplayGenerator(CraftingIdentifier.CHEMISTRY));
        registry.registerDisplayGenerator(CraftingIdentifier.COOKING.identifier(), (DynamicDisplayGenerator)new SextupleDisplayGenerator(CraftingIdentifier.COOKING));
    }

    public void registerExclusionZones(ExclusionZones zones) {
        zones.register(CreativeModeInventoryScreen.class, screen -> {
            SelectableListWidget widget = ((CreativeScreenSubTab)screen).runecraftory$subTabWidget();
            if (widget != null) {
                return List.of(new Rectangle(widget.getX(), widget.getY(), widget.getWidth(), widget.getHeight()));
            }
            return List.of();
        });
        zones.register(RecipeUpdateListener.class, (ExclusionZonesProvider)new DefaultRecipeBookExclusionZones());
    }

    public void registerScreens(ScreenRegistry registry) {
        registry.registerClickArea(CraftingGui.class, ReiClientPlugin.clickAreaFor(CraftingIdentifier.FORGING, new Rectangle(80, 30, 26, 26)));
        registry.registerClickArea(CraftingGui.class, ReiClientPlugin.clickAreaFor(CraftingIdentifier.COOKING, new Rectangle(80, 30, 26, 26)));
        registry.registerClickArea(CraftingGui.class, ReiClientPlugin.clickAreaFor(CraftingIdentifier.ARMOR, new Rectangle(80, 30, 26, 26)));
        registry.registerClickArea(CraftingGui.class, ReiClientPlugin.clickAreaFor(CraftingIdentifier.CHEMISTRY, new Rectangle(80, 30, 26, 26)));
    }

    private static ClickArea<CraftingGui> clickAreaFor(CraftingIdentifier identifier, Rectangle rect) {
        return ctx -> {
            CraftingGui screen = (CraftingGui)ctx.getScreen();
            Rectangle rectangle = rect.clone();
            rectangle.translate(screen.getRectangle().left(), screen.getRectangle().top());
            if (((CraftingGui)ctx.getScreen()).type() == identifier.craftingType() && rectangle.contains(ctx.getMousePosition())) {
                return ClickArea.Result.success().categories(List.of(identifier.identifier()));
            }
            return ClickArea.Result.fail();
        };
    }
}

