/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import io.github.flemmli97.runecraftory.common.events.EntityCalls;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEffects;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Inject(method={"setSprinting(Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSprint(boolean sprinting, CallbackInfo info) {
        if (sprinting && ((LivingEntity)this).hasEffect(RuneCraftoryEffects.PARALYSIS.asHolder())) {
            info.cancel();
        }
    }

    @Inject(method={"dropAllDeathLoot(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;dropEquipment()V", shift=At.Shift.AFTER)})
    private void doDeathLootDrop(ServerLevel level, DamageSource damageSource, CallbackInfo info) {
        EntityCalls.dropInventoryDeath((LivingEntity)this);
    }

    @Inject(method={"collectEquipmentChanges()Ljava/util/Map;"}, at={@At(value="RETURN")})
    private void onChange(CallbackInfoReturnable<Map<EquipmentSlot, ItemStack>> info, @Local Map<EquipmentSlot, ItemStack> map) {
        if (map != null) {
            EntityCalls.updateEquipment((LivingEntity)this, map, this.getLastHandItem(EquipmentSlot.MAINHAND), this::getLastArmorItem);
        }
    }

    @Shadow
    protected abstract ItemStack getLastHandItem(EquipmentSlot var1);

    @Shadow
    protected abstract ItemStack getLastArmorItem(EquipmentSlot var1);
}

