/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.mixin;

import com.mojang.authlib.GameProfile;
import io.github.flemmli97.runecraftory.common.quests.QuestData;
import io.github.flemmli97.runecraftory.common.quests.QuestHandler;
import io.github.flemmli97.runecraftory.mixinhelper.QuestDataGet;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends Player
implements QuestDataGet {
    @Unique
    private QuestData runecraftory_questData;

    private ServerPlayerMixin(Level level, BlockPos blockPos, float f, GameProfile gameProfile) {
        super(level, blockPos, f, gameProfile);
    }

    @Inject(method={"<init>*"}, at={@At(value="RETURN")})
    private void initData(CallbackInfo info) {
        this.runecraftory_questData = new QuestData((ServerPlayer)this);
    }

    @Inject(method={"restoreFrom(Lnet/minecraft/server/level/ServerPlayer;Z)V"}, at={@At(value="RETURN")})
    private void copyOld(ServerPlayer oldPlayer, boolean alive, CallbackInfo info) {
        this.runecraftory_questData.clone(QuestHandler.getData(oldPlayer));
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="RETURN")})
    private void save(CompoundTag compound, CallbackInfo info) {
        this.runecraftory_questData.load(compound.getCompound("RunecraftoryQuestData"));
    }

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    private void onTick(CallbackInfo info) {
        this.runecraftory_questData.tick();
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="RETURN")})
    private void read(CompoundTag compound, CallbackInfo info) {
        compound.put("RunecraftoryQuestData", (Tag)this.runecraftory_questData.save());
    }

    @Override
    public QuestData runecraftory$getQuestData() {
        return this.runecraftory_questData;
    }
}

