/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.mixinhelper;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.flemmli97.runecraftory.api.calendar.Season;
import io.github.flemmli97.runecraftory.client.ClientCalendarHolder;
import io.github.flemmli97.runecraftory.client.ClientCalls;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.armor.ArmorModels;
import io.github.flemmli97.runecraftory.common.attachment.EntityData;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerWeaponHandler;
import io.github.flemmli97.runecraftory.common.config.ClientConfig;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttackActions;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryDataComponentTypes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.runecraftory.common.world.data.Calendar;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.client.model.ModelPartsContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;

public class ClientMixinUtils {
    public static final int LEAVE_SPRING = 870913;
    public static final int LEAVE_FALL = 0xFF4646;
    private static final Map<SeasonedTint, Integer> LEAVE_TINTS = new ConcurrentHashMap<SeasonedTint, Integer>();
    private static final Map<SeasonedTint, Integer> GRASS_TINTS = new ConcurrentHashMap<SeasonedTint, Integer>();
    private static boolean AnimatedItemHandRendering;

    public static int modifyColoredTint(BlockAndTintGetter getter, int old) {
        Calendar calendar = ClientCalendarHolder.CLIENT_CALENDAR;
        if (calendar.currentSeason() == Season.SUMMER) {
            return old;
        }
        return LEAVE_TINTS.computeIfAbsent(new SeasonedTint(old, calendar.currentSeason()), ClientMixinUtils::getLeaveTint);
    }

    public static int modifyColoredTintGrass(BlockAndTintGetter getter, int old) {
        Calendar calendar = ClientCalendarHolder.CLIENT_CALENDAR;
        if (calendar.currentSeason() == Season.SUMMER) {
            return old;
        }
        return GRASS_TINTS.computeIfAbsent(new SeasonedTint(old, calendar.currentSeason()), ClientMixinUtils::getGrassTint);
    }

    private static int getLeaveTint(SeasonedTint tint) {
        return switch (tint.season) {
            default -> throw new MatchException(null, null);
            case Season.SPRING -> ClientMixinUtils.desaturate(ClientMixinUtils.add(tint.origin, 870913), 0.1f);
            case Season.SUMMER -> tint.origin;
            case Season.AUTUMN -> ClientMixinUtils.desaturate(ClientMixinUtils.add(FastColor.ARGB32.multiply((int)tint.origin, (int)0xFF4646), 3939840), 0.2f);
            case Season.WINTER -> ClientMixinUtils.desaturate(ClientMixinUtils.add(FastColor.ARGB32.multiply((int)tint.origin, (int)0xFF4646), 3939840), 0.6f);
        };
    }

    private static int getGrassTint(SeasonedTint tint) {
        return switch (tint.season) {
            default -> throw new MatchException(null, null);
            case Season.SPRING -> ClientMixinUtils.desaturate(ClientMixinUtils.add(tint.origin, 870913), 0.1f);
            case Season.SUMMER -> tint.origin;
            case Season.AUTUMN -> ClientMixinUtils.desaturate(tint.origin, 0.25f);
            case Season.WINTER -> ClientMixinUtils.desaturate(tint.origin, 0.7f);
        };
    }

    private static int desaturate(int color, float perc) {
        int r = FastColor.ARGB32.red((int)color);
        int g = FastColor.ARGB32.green((int)color);
        int b = FastColor.ARGB32.blue((int)color);
        int gray = Math.max(b, Math.max(r, g));
        return FastColor.ARGB32.color((int)FastColor.ARGB32.alpha((int)color), (int)((int)((float)r + (float)(gray - r) * perc)), (int)((int)((float)g + (float)(gray - g) * perc)), (int)((int)((float)b + (float)(gray - b) * perc)));
    }

    private static int add(int packedColourOne, int packedColorTwo) {
        return FastColor.ARGB32.color((int)Math.min(255, FastColor.ARGB32.alpha((int)packedColourOne) + FastColor.ARGB32.alpha((int)packedColorTwo)), (int)Math.min(255, FastColor.ARGB32.red((int)packedColourOne) + FastColor.ARGB32.red((int)packedColorTwo)), (int)Math.min(255, FastColor.ARGB32.green((int)packedColourOne) + FastColor.ARGB32.green((int)packedColorTwo)), (int)Math.min(255, FastColor.ARGB32.blue((int)packedColourOne) + FastColor.ARGB32.blue((int)packedColorTwo)));
    }

    public static void translateSleepingEntity(LivingEntity entity, PoseStack poseStack, float flipDegrees) {
        if (EntityData.getSleepStateFrom(entity) == EntityData.SleepState.VANILLA && flipDegrees != 0.0f) {
            ClientCalls.SLEEP_ROTATED_TYPES.add(entity.getType());
            poseStack.translate(0.0, (double)entity.getBbWidth() * 0.15, 0.0);
            if (entity.getPose() == Pose.SLEEPING) {
                poseStack.mulPose(Axis.ZP.rotationDegrees(entity.getYHeadRot() + 90.0f));
            } else {
                poseStack.mulPose(Axis.YP.rotationDegrees(entity.yBodyRot - entity.getYHeadRot()));
                poseStack.mulPose(Axis.XP.rotationDegrees(flipDegrees));
            }
            float standOffset = entity.getEyeHeight(Pose.STANDING) * 0.6f;
            poseStack.translate(0.0f, -standOffset, 0.0f);
        }
    }

    public static boolean shouldAnimate(LivingEntity entity) {
        return entity instanceof Player || entity instanceof AnimatedEntity;
    }

    public static void transformHumanoidModel(LivingEntity entity, HumanoidModel<?> model) {
        PlayerWeaponHandler weaponHandler;
        InteractionHand off;
        InteractionHand main = entity.getMainArm() == HumanoidArm.RIGHT ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        InteractionHand interactionHand = off = entity.getMainArm() == HumanoidArm.RIGHT ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        if (model.rightArmPose == HumanoidModel.ArmPose.ITEM && entity.getItemInHand(main).is((Item)RuneCraftoryItems.UMBRELLA.get())) {
            model.rightArm.xRot -= 1.2217305f;
        }
        if (model.leftArmPose == HumanoidModel.ArmPose.ITEM && entity.getItemInHand(off).is((Item)RuneCraftoryItems.UMBRELLA.get())) {
            model.leftArm.xRot -= 1.2217305f;
        }
        float partialTicks = ClientHandlers.getPartialTicks();
        if (entity instanceof AnimatedEntity) {
            boolean result = ClientHandlers.getAnimatedPlayerModel().setUpModel(entity, model, null, partialTicks);
            if (result) {
                ClientHandlers.getAnimatedPlayerModel().copyTo(model);
            }
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            v1 = Platform.INSTANCE.getPlayerData(player).getWeaponHandler();
        } else {
            v1 = weaponHandler = null;
        }
        if (weaponHandler == null) {
            return;
        }
        boolean ignoreRiding = weaponHandler.getCurrentAction() == RuneCraftoryAttackActions.DUAL_USE.get();
        boolean result = ClientHandlers.getAnimatedPlayerModel().setUpModel(entity, model, weaponHandler, partialTicks);
        if (result) {
            ClientHandlers.getAnimatedPlayerModel().copyTo(model);
        }
    }

    public static void onRenderHand(PoseStack poseStack, AbstractClientPlayer player, boolean rightArm, PlayerModel<AbstractClientPlayer> arm, MultiBufferSource buffer, int combinedLight) {
        for (ItemStack stack : player.getArmorSlots()) {
            ArmorModels.FirstPersonArmorRenderer r;
            if (stack.isEmpty() || (r = ArmorModels.getFirstPersonRenderer(stack)) == null) continue;
            r.render(player, stack, rightArm, arm, poseStack, buffer, combinedLight);
        }
    }

    public static boolean onRenderHeldItem(LivingEntity livingEntity, ItemStack stack, ItemDisplayContext transformType, boolean leftHand, MultiBufferSource buffer, int combinedLight) {
        if (livingEntity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)livingEntity;
            if (transformType.firstPerson()) {
                if (leftHand == (livingEntity.getMainArm() == HumanoidArm.RIGHT) && AnimatedItemHandRendering) {
                    return true;
                }
                PlayerData data = Platform.INSTANCE.getPlayerData((Player)player);
                if (data != null) {
                    PlayerRenderer renderer = (PlayerRenderer)Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)player);
                    float partialTicks = ClientHandlers.getPartialTicks();
                    AnimatedItemHandRendering = ClientHandlers.getAnimatedPlayerModel().setUpModel((LivingEntity)player, null, data.getWeaponHandler(), partialTicks);
                    if (!AnimatedItemHandRendering) {
                        return false;
                    }
                    player.resetAttackStrengthTicker();
                    PoseStack poseStack = new PoseStack();
                    poseStack.pushPose();
                    poseStack.scale(-0.5f, -0.5f, 0.5f);
                    poseStack.translate(0.0, 0.1, 0.0);
                    poseStack.mulPose(Axis.YP.rotationDegrees(Minecraft.getInstance().gameRenderer.getMainCamera().getYRot() - 180.0f));
                    ClientHandlers.getAnimatedPlayerModel().copyTo((HumanoidModel)renderer.getModel());
                    if (ClientConfig.renderHand) {
                        ((PlayerModel)renderer.getModel()).leftArm.render(poseStack, buffer.getBuffer(RenderType.entitySolid((ResourceLocation)player.getSkin().texture())), combinedLight, OverlayTexture.NO_OVERLAY);
                        ((PlayerModel)renderer.getModel()).leftSleeve.render(poseStack, buffer.getBuffer(RenderType.entitySolid((ResourceLocation)player.getSkin().texture())), combinedLight, OverlayTexture.NO_OVERLAY);
                        ((PlayerModel)renderer.getModel()).rightArm.render(poseStack, buffer.getBuffer(RenderType.entitySolid((ResourceLocation)player.getSkin().texture())), combinedLight, OverlayTexture.NO_OVERLAY);
                        ((PlayerModel)renderer.getModel()).rightSleeve.render(poseStack, buffer.getBuffer(RenderType.entitySolid((ResourceLocation)player.getSkin().texture())), combinedLight, OverlayTexture.NO_OVERLAY);
                    }
                    if (!stack.has((DataComponentType)RuneCraftoryDataComponentTypes.INVISIBLE.get())) {
                        poseStack.pushPose();
                        ((PlayerModel)renderer.getModel()).translateToHand(leftHand ? HumanoidArm.LEFT : HumanoidArm.RIGHT, poseStack);
                        poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                        poseStack.translate(0.0625, 0.125, -0.625);
                        Minecraft.getInstance().getItemRenderer().renderStatic(livingEntity, stack, transformType, leftHand, poseStack, buffer, livingEntity.level(), combinedLight, OverlayTexture.NO_OVERLAY, livingEntity.getId() + transformType.ordinal());
                        poseStack.popPose();
                    }
                    if (!(stack = player.getOffhandItem()).isEmpty() && !stack.has((DataComponentType)RuneCraftoryDataComponentTypes.INVISIBLE.get())) {
                        poseStack.pushPose();
                        ((PlayerModel)renderer.getModel()).translateToHand(leftHand ? HumanoidArm.RIGHT : HumanoidArm.LEFT, poseStack);
                        poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                        poseStack.translate(-0.0625, 0.125, -0.625);
                        Minecraft.getInstance().getItemRenderer().renderStatic(livingEntity, stack, transformType, leftHand, poseStack, buffer, livingEntity.level(), combinedLight, OverlayTexture.NO_OVERLAY, livingEntity.getId() + transformType.ordinal());
                        poseStack.popPose();
                    }
                    poseStack.popPose();
                    return true;
                }
            }
        }
        AnimatedItemHandRendering = false;
        return stack.has((DataComponentType)RuneCraftoryDataComponentTypes.INVISIBLE.get());
    }

    public static ModelPartsContainer.ModelPartExtended createPlayerItemPart(boolean left) {
        ModelPart item = new ModelPart(List.of(), Map.of());
        item.loadPose(PartPose.offset((float)(left ? -1.0f : 1.0f), (float)-8.0f, (float)0.0f));
        ModelPart root = new ModelPart(List.of(), Map.of(left ? "LeftItem" : "RightItem", item));
        root.loadPose(PartPose.offset((float)(left ? 1.0f : -1.0f), (float)8.0f, (float)0.0f));
        return new ModelPartsContainer.ModelPartExtended("root", null, root);
    }

    record SeasonedTint(int origin, Season season) {
    }
}

