/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.neoforge.data;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.blocks.CraftingBlock;
import io.github.flemmli97.runecraftory.common.blocks.ExtendedCropBlock;
import io.github.flemmli97.runecraftory.common.blocks.GiantCropBlock;
import io.github.flemmli97.runecraftory.common.blocks.HerbBlock;
import io.github.flemmli97.runecraftory.common.blocks.QuestboardBlock;
import io.github.flemmli97.runecraftory.common.blocks.TreeFruitLeavesBlock;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryBlocks;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.tenshilib.loader.registry.RegistryEntrySupplier;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class BlockStatesGen
extends BlockStateProvider {
    private static final ResourceLocation CROP_TINTED = RuneCraftory.modRes("block/crop_tinted");
    private static final ResourceLocation CROP_BIG = RuneCraftory.modRes("block/big_crop");
    private static final ResourceLocation CROP_GIANT_1 = RuneCraftory.modRes("block/giant_crop_1");
    private static final ResourceLocation CROP_GIANT_2 = RuneCraftory.modRes("block/giant_crop_2");
    private static final ResourceLocation FLOWER_BIG = RuneCraftory.modRes("block/big_flower");
    private static final ResourceLocation FLOWER_GIANT = RuneCraftory.modRes("block/giant_flower");
    private static final ResourceLocation CROSS_TINTED = RuneCraftory.modRes("block/cross_tinted");

    public BlockStatesGen(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "runecraftory", exFileHelper);
    }

    protected void registerStatesAndModels() {
        RuneCraftoryBlocks.HERBS.forEach(reg -> {
            Block block = (Block)reg.get();
            if (block == RuneCraftoryBlocks.MEDICINAL_HERB.get()) {
                this.simpleBlock(block, (ModelFile)this.models().withExistingParent(reg.getID().toString(), RuneCraftory.modRes("item/medicinal_herb")));
            } else if (block instanceof HerbBlock) {
                ResourceLocation texture = this.itemTexture(block);
                this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cross(reg.getID().toString(), texture)).texture("particle", texture));
            }
        });
        for (RegistryEntrySupplier<Block, ?> reg2 : RuneCraftoryBlocks.FLOWERS) {
            Block block = (Block)reg2.get();
            if (reg2 == RuneCraftoryBlocks.SWORD_CROP || reg2 == RuneCraftoryBlocks.SHIELD_CROP) {
                this.getVariantBuilder(block).forAllStatesExcept(state -> {
                    int stage = (Integer)state.getValue((Property)ExtendedCropBlock.AGE);
                    ResourceLocation text = stage == 3 || stage == 4 ? this.blockTexture("runecraftory", reg2.getID().getPath()) : this.blockTexture("runecraftory", "plant_gear_" + stage);
                    return ConfiguredModel.builder().modelFile((ModelFile)this.models().singleTexture(text.toString(), CROSS_TINTED, "cross", text)).build();
                }, new Property[]{ExtendedCropBlock.WILTED});
                continue;
            }
            if (block instanceof GiantCropBlock) {
                GiantCropBlock giant = (GiantCropBlock)block;
                this.getVariantBuilder(block).forAllStatesExcept(state -> {
                    ResourceLocation texture = this.itemTexture(giant.getCrop((HolderLookup<Item>)BuiltInRegistries.ITEM.asLookup()));
                    return ConfiguredModel.builder().modelFile((ModelFile)this.models().singleTexture(reg2.getID().toString(), FLOWER_GIANT, "0", texture)).rotationY(((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + 180) % 360).build();
                }, new Property[]{ExtendedCropBlock.WILTED, GiantCropBlock.AGE});
                continue;
            }
            if (!(block instanceof ExtendedCropBlock)) continue;
            this.getVariantBuilder(block).forAllStatesExcept(state -> {
                String name;
                int stage = (Integer)state.getValue((Property)ExtendedCropBlock.AGE);
                boolean defaultFlowerState = stage == 0 && reg2 != RuneCraftoryBlocks.EMERY_FLOWER && reg2 != RuneCraftoryBlocks.IRONLEAF && reg2 != RuneCraftoryBlocks.NOEL_GRASS && reg2 != RuneCraftoryBlocks.LAMP_GRASS;
                String string = name = defaultFlowerState ? "runecraftory:flower_stage_0" : reg2.getID().toString() + "_" + stage;
                ResourceLocation texture = defaultFlowerState ? this.blockTexture("runecraftory", "flower_stage_0") : (stage == 3 ? this.itemCropTexture(block) : this.blockTexture("runecraftory", reg2.getID().getPath() + "_" + stage));
                ResourceLocation parent = CROSS_TINTED;
                if (stage == 4) {
                    Object patt0$temp;
                    parent = FLOWER_BIG;
                    RegistryEntrySupplier<Block, ?> giant = RuneCraftoryBlocks.GIANT_CROP_MAP.get(reg2);
                    if (giant != null && (patt0$temp = giant.get()) instanceof GiantCropBlock) {
                        GiantCropBlock giantCrop = (GiantCropBlock)patt0$temp;
                        texture = this.itemTexture(giantCrop.getCrop((HolderLookup<Item>)BuiltInRegistries.ITEM.asLookup()));
                    }
                }
                return ConfiguredModel.builder().modelFile((ModelFile)this.models().singleTexture(name, parent, "cross", texture)).build();
            }, new Property[]{ExtendedCropBlock.WILTED});
        }
        RuneCraftoryBlocks.CROPS.forEach(reg -> {
            Block block = (Block)reg.get();
            if (block instanceof GiantCropBlock) {
                this.getVariantBuilder(block).forAllStatesExcept(state -> {
                    ResourceLocation texture = this.blockTexture("runecraftory", reg.getID().getPath());
                    ResourceLocation parent = CROP_GIANT_1;
                    int rot = 0;
                    Object file = reg.getID().toString();
                    switch ((Direction)state.getValue(GiantCropBlock.DIRECTION)) {
                        case EAST: {
                            parent = CROP_GIANT_2;
                            file = (String)file + "_2";
                            break;
                        }
                        case SOUTH: {
                            rot = 180;
                            break;
                        }
                        case WEST: {
                            parent = CROP_GIANT_2;
                            file = (String)file + "_2";
                            rot = 180;
                        }
                    }
                    return ConfiguredModel.builder().modelFile((ModelFile)this.models().singleTexture((String)file, parent, "crop", texture)).rotationY(rot).build();
                }, new Property[]{ExtendedCropBlock.WILTED, GiantCropBlock.AGE});
            } else if (block instanceof ExtendedCropBlock) {
                this.getVariantBuilder(block).forAllStatesExcept(state -> {
                    int stage = (Integer)state.getValue((Property)ExtendedCropBlock.AGE);
                    String name = reg.getID().toString() + "_" + stage;
                    ResourceLocation texture = this.blockTexture("runecraftory", reg.getID().getPath() + "_" + stage);
                    ResourceLocation parent = CROP_TINTED;
                    if (stage == 4) {
                        parent = CROP_BIG;
                        RegistryEntrySupplier<Block, ?> giant = RuneCraftoryBlocks.GIANT_CROP_MAP.get(reg);
                        if (giant != null) {
                            texture = this.blockTexture((Block)giant.get());
                        }
                    }
                    return ConfiguredModel.builder().modelFile((ModelFile)this.models().singleTexture(name, parent, "crop", texture)).build();
                }, new Property[]{ExtendedCropBlock.WILTED});
            }
        });
        RuneCraftoryBlocks.MINERAL_MAP.values().forEach(reg -> {
            Block block = (Block)reg.get();
            this.getVariantBuilder(block).forAllStatesExcept(state -> {
                BlockModelBuilder file = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(reg.getID().toString(), "runecraftory:block/ore")).texture("ore", this.blockTexture(block));
                if (block == RuneCraftoryBlocks.MINERAL_DRAGONIC.get()) {
                    file = (BlockModelBuilder)file.texture("0", ResourceLocation.withDefaultNamespace((String)"block/end_stone"));
                }
                return ConfiguredModel.builder().modelFile((ModelFile)file).rotationY((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() % 360).build();
            }, new Property[]{BlockStateProperties.WATERLOGGED});
        });
        RuneCraftoryBlocks.BROKEN_MINERAL_MAP.values().forEach(reg -> {
            Block block = (Block)reg.get();
            this.getVariantBuilder(block).forAllStatesExcept(state -> {
                BlockModelBuilder file = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(reg.getID().toString(), "runecraftory:block/ore_broken")).texture("ore", this.mineralTexture((RegistryEntrySupplier<Block, ?>)reg));
                if (block == RuneCraftoryBlocks.BROKEN_MINERAL_DRAGONIC.get()) {
                    file = (BlockModelBuilder)file.texture("0", ResourceLocation.withDefaultNamespace((String)"block/end_stone"));
                }
                return ConfiguredModel.builder().modelFile((ModelFile)file).rotationY((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() % 360).build();
            }, new Property[]{BlockStateProperties.WATERLOGGED});
        });
        this.craftingModel(RuneCraftoryBlocks.FORGE);
        this.craftingModel(RuneCraftoryBlocks.ACCESSORY_WORKBENCH);
        this.craftingModel(RuneCraftoryBlocks.COOKING_TABLE);
        this.craftingModel(RuneCraftoryBlocks.CHEMISTRY_SET);
        this.simpleBlock((Block)RuneCraftoryBlocks.BOSS_SPAWNER.get(), (ModelFile)this.models().getExistingFile(ResourceLocation.withDefaultNamespace((String)("block/" + this.key(Blocks.SPAWNER).getPath()))));
        this.simpleBlock((Block)RuneCraftoryBlocks.SINGLE_SPAWN_BLOCK.get(), (ModelFile)this.models().getExistingFile(ResourceLocation.withDefaultNamespace((String)("block/" + this.key(Blocks.SPAWNER).getPath()))));
        this.simpleBlock((Block)RuneCraftoryBlocks.MONSTER_BARN.get(), (ModelFile)this.models().getExistingFile(RuneCraftory.modRes("block/" + RuneCraftoryBlocks.MONSTER_BARN.getID().getPath())));
        this.simpleBlock((Block)RuneCraftoryBlocks.HOT_SPRING_WATER.get(), (ModelFile)this.models().getExistingFile(this.blockTexture(Blocks.WATER)));
        this.getVariantBuilder((Block)RuneCraftoryBlocks.SHIPPING.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().orientableVertical(RuneCraftoryBlocks.SHIPPING.getID().getPath(), this.modLoc("block/shipping_bin"), this.modLoc("block/shipping_bin_top"))).rotationY((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() % 360).build());
        this.getVariantBuilder((Block)RuneCraftoryBlocks.CASH_REGISTER.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(RuneCraftory.modRes("block/" + RuneCraftoryBlocks.CASH_REGISTER.getID().getPath()))).rotationY((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() % 360).build());
        this.getVariantBuilder((Block)RuneCraftoryBlocks.QUEST_BOARD.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(RuneCraftory.modRes("block/" + RuneCraftoryBlocks.QUEST_BOARD.getID().getPath() + "_" + ((QuestboardBlock.Part)((Object)((Object)state.getValue(QuestboardBlock.PART)))).getSerializedName()))).rotationY((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() % 360).build());
        this.simpleBlock((Block)RuneCraftoryBlocks.TREE_SOIL.get(), (ModelFile)this.models().getExistingFile(ResourceLocation.withDefaultNamespace((String)("block/" + this.key(Blocks.DIRT).getPath()))));
        this.axisBlock((RotatedPillarBlock)RuneCraftoryBlocks.APPLE_TREE.get(), (ModelFile)this.models().getExistingFile(ResourceLocation.withDefaultNamespace((String)("block/" + this.key(Blocks.OAK_LOG).getPath()))), (ModelFile)this.models().getExistingFile(ResourceLocation.withDefaultNamespace((String)("block/" + this.key(Blocks.OAK_LOG).getPath() + "_horizontal"))));
        this.simpleBlock((Block)RuneCraftoryBlocks.APPLE_SAPLING.get(), (ModelFile)this.models().cross(RuneCraftoryBlocks.APPLE_SAPLING.getID().toString(), this.itemTexture((Item)RuneCraftoryItems.APPLE_SAPLING.get())));
        this.axisBlock((RotatedPillarBlock)RuneCraftoryBlocks.APPLE_WOOD.get(), (ModelFile)this.models().getExistingFile(ResourceLocation.withDefaultNamespace((String)("block/" + this.key(Blocks.OAK_LOG).getPath()))), (ModelFile)this.models().getExistingFile(ResourceLocation.withDefaultNamespace((String)("block/" + this.key(Blocks.OAK_LOG).getPath() + "_horizontal"))));
        this.simpleBlock((Block)RuneCraftoryBlocks.APPLE_LEAVES.get(), (ModelFile)this.models().getExistingFile(ResourceLocation.withDefaultNamespace((String)("block/" + this.key(Blocks.OAK_LEAVES).getPath()))));
        ((VariantBlockStateBuilder)this.getVariantBuilder((Block)RuneCraftoryBlocks.APPLE.get()).partialState().with((Property)TreeFruitLeavesBlock.HAS_FRUIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(RuneCraftoryBlocks.APPLE.getID().toString(), this.modLoc("fruit_leaves"))).texture("base", this.blockTexture(Blocks.OAK_LEAVES))).texture("particle", this.blockTexture(Blocks.OAK_LEAVES))).texture("overlay", this.blockTexture((Block)RuneCraftoryBlocks.APPLE.get()))).addModel()).partialState().with((Property)TreeFruitLeavesBlock.HAS_FRUIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(RuneCraftoryBlocks.APPLE.getID().toString() + "_fruitless", "block/leaves")).texture("all", this.blockTexture(Blocks.OAK_LEAVES))).addModel();
        this.axisBlock((RotatedPillarBlock)RuneCraftoryBlocks.ORANGE_TREE.get(), (ModelFile)this.models().getExistingFile(ResourceLocation.withDefaultNamespace((String)("block/" + this.key(Blocks.BIRCH_LOG).getPath()))), (ModelFile)this.models().getExistingFile(ResourceLocation.withDefaultNamespace((String)("block/" + this.key(Blocks.BIRCH_LOG).getPath() + "_horizontal"))));
        this.simpleBlock((Block)RuneCraftoryBlocks.ORANGE_SAPLING.get(), (ModelFile)this.models().cross(RuneCraftoryBlocks.ORANGE_SAPLING.getID().toString(), this.itemTexture((Item)RuneCraftoryItems.ORANGE_SAPLING.get())));
        this.axisBlock((RotatedPillarBlock)RuneCraftoryBlocks.ORANGE_WOOD.get(), (ModelFile)this.models().getExistingFile(ResourceLocation.withDefaultNamespace((String)("block/" + this.key(Blocks.BIRCH_LOG).getPath()))), (ModelFile)this.models().getExistingFile(ResourceLocation.withDefaultNamespace((String)("block/" + this.key(Blocks.BIRCH_LOG).getPath() + "_horizontal"))));
        this.simpleBlock((Block)RuneCraftoryBlocks.ORANGE_LEAVES.get(), (ModelFile)this.models().getExistingFile(ResourceLocation.withDefaultNamespace((String)("block/" + this.key(Blocks.BIRCH_LEAVES).getPath()))));
        ((VariantBlockStateBuilder)this.getVariantBuilder((Block)RuneCraftoryBlocks.ORANGE.get()).partialState().with((Property)TreeFruitLeavesBlock.HAS_FRUIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(RuneCraftoryBlocks.ORANGE.getID().toString(), this.modLoc("fruit_leaves"))).texture("base", this.blockTexture(Blocks.BIRCH_LEAVES))).texture("particle", this.blockTexture(Blocks.BIRCH_LEAVES))).texture("overlay", this.blockTexture((Block)RuneCraftoryBlocks.ORANGE.get()))).addModel()).partialState().with((Property)TreeFruitLeavesBlock.HAS_FRUIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(RuneCraftoryBlocks.ORANGE.getID().toString() + "_fruitless", "block/leaves")).texture("all", this.blockTexture(Blocks.BIRCH_LEAVES))).addModel();
        this.axisBlock((RotatedPillarBlock)RuneCraftoryBlocks.GRAPE_TREE.get(), (ModelFile)this.models().getExistingFile(ResourceLocation.withDefaultNamespace((String)("block/" + this.key(Blocks.SPRUCE_LOG).getPath()))), (ModelFile)this.models().getExistingFile(ResourceLocation.withDefaultNamespace((String)("block/" + this.key(Blocks.SPRUCE_LOG).getPath() + "_horizontal"))));
        this.simpleBlock((Block)RuneCraftoryBlocks.GRAPE_SAPLING.get(), (ModelFile)this.models().cross(RuneCraftoryBlocks.GRAPE_SAPLING.getID().toString(), this.itemTexture((Item)RuneCraftoryItems.GRAPE_SAPLING.get())));
        this.axisBlock((RotatedPillarBlock)RuneCraftoryBlocks.GRAPE_WOOD.get(), (ModelFile)this.models().getExistingFile(ResourceLocation.withDefaultNamespace((String)("block/" + this.key(Blocks.SPRUCE_LOG).getPath()))), (ModelFile)this.models().getExistingFile(ResourceLocation.withDefaultNamespace((String)("block/" + this.key(Blocks.SPRUCE_LOG).getPath() + "_horizontal"))));
        this.simpleBlock((Block)RuneCraftoryBlocks.GRAPE_LEAVES.get(), (ModelFile)this.models().getExistingFile(ResourceLocation.withDefaultNamespace((String)("block/" + this.key(Blocks.DARK_OAK_LEAVES).getPath()))));
        ((VariantBlockStateBuilder)this.getVariantBuilder((Block)RuneCraftoryBlocks.GRAPE.get()).partialState().with((Property)TreeFruitLeavesBlock.HAS_FRUIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(RuneCraftoryBlocks.GRAPE.getID().toString(), this.modLoc("fruit_leaves"))).texture("base", this.blockTexture(Blocks.DARK_OAK_LEAVES))).texture("particle", this.blockTexture(Blocks.DARK_OAK_LEAVES))).texture("overlay", this.blockTexture((Block)RuneCraftoryBlocks.GRAPE.get()))).addModel()).partialState().with((Property)TreeFruitLeavesBlock.HAS_FRUIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(RuneCraftoryBlocks.GRAPE.getID().toString() + "_fruitless", "block/leaves")).texture("all", this.blockTexture(Blocks.DARK_OAK_LEAVES))).addModel();
    }

    public ResourceLocation mineralTexture(RegistryEntrySupplier<Block, ?> block) {
        ResourceLocation name = block.getID();
        return ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)("block/" + name.getPath().replace("broken_", "")));
    }

    private void craftingModel(RegistryEntrySupplier<Block, ?> block) {
        this.getVariantBuilder((Block)block.get()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(ResourceLocation.fromNamespaceAndPath((String)block.getID().getNamespace(), (String)("block/" + block.getID().getPath() + "_" + ((CraftingBlock.EnumPart)((Object)((Object)state.getValue(CraftingBlock.PART)))).getSerializedName())))).rotationY(((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + 180) % 360).build(), new Property[0]);
    }

    public ResourceLocation blockTexture(String nameSpace, String block) {
        return ResourceLocation.fromNamespaceAndPath((String)nameSpace, (String)("block/" + block));
    }

    public ResourceLocation itemTexture(Block block) {
        ResourceLocation name = this.key(block);
        return ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)("item/" + name.getPath()));
    }

    public ResourceLocation itemTexture(Item item) {
        ResourceLocation name = BuiltInRegistries.ITEM.getKey((Object)item);
        return ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)("item/" + name.getPath()));
    }

    public ResourceLocation itemCropTexture(Block block) {
        ResourceLocation name = this.key(block);
        return ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)("item/" + name.getPath().replace("plant", "crop")));
    }

    private ResourceLocation key(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }
}

