/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.neoforge.data;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.ConversationContext;
import io.github.flemmli97.runecraftory.api.datapack.npc.ConversationSet;
import io.github.flemmli97.runecraftory.api.datapack.npc.GiftData;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCData;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCLook;
import io.github.flemmli97.runecraftory.api.datapack.provider.FileVerifier;
import io.github.flemmli97.runecraftory.api.datapack.provider.NPCDataProvider;
import io.github.flemmli97.runecraftory.api.registry.NPCFeature;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.api.registry.NPCProfession;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc.NPCAttackActions;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc.SerializableBehaviour;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc.SerializableBehaviours;
import io.github.flemmli97.runecraftory.common.entities.npc.features.BlushFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.ColorSetting;
import io.github.flemmli97.runecraftory.common.entities.npc.features.FaceFeaturesType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.HairFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.IndexRange;
import io.github.flemmli97.runecraftory.common.entities.npc.features.IndexedColorSetting;
import io.github.flemmli97.runecraftory.common.entities.npc.features.IndexedColorSettingType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.OutfitFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.SimpleHatFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.SizeFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.SlimLookFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.TypedIndexRange;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryNPCBehaviour;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryNPCLooks;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryNPCProfessions;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.neoforge.data.QuestGen;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.TimeCheck;
import net.minecraft.world.level.storage.loot.predicates.WeatherCheck;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class NPCDataGen
extends NPCDataProvider {
    private final QuestGen questGen;

    public NPCDataGen(PackOutput packOutput, FileVerifier verifier, CompletableFuture<HolderLookup.Provider> provider, QuestGen questGen) {
        super(packOutput, verifier, "runecraftory", provider);
        this.questGen = questGen;
    }

    @Override
    protected void add(HolderLookup.Provider provider) {
        ResourceLocation genericAttack = this.addAttackActions(RuneCraftory.modRes("generic_melee_attack"), new NPCAttackActions.Builder().addSequence(1).add(((SerializableBehaviour)RuneCraftoryNPCBehaviour.WALK_TO.get()).of(new SerializableBehaviours.WalkToData(1.0f, 1))).add(((SerializableBehaviour)RuneCraftoryNPCBehaviour.ATTACK_WITH_WEAPON.get()).of(Unit.INSTANCE)).timeout((NumberProvider)UniformGenerator.between((float)30.0f, (float)80.0f)).end());
        ResourceLocation meleeAndFireball = this.addAttackActions(RuneCraftory.modRes("melee_fireball_attack"), new NPCAttackActions.Builder().addSequence(5).add(((SerializableBehaviour)RuneCraftoryNPCBehaviour.WALK_TO.get()).of(new SerializableBehaviours.WalkToData(1.0f, 1))).add(((SerializableBehaviour)RuneCraftoryNPCBehaviour.ATTACK_WITH_WEAPON.get()).of(Unit.INSTANCE)).timeout((NumberProvider)UniformGenerator.between((float)30.0f, (float)80.0f)).end().addSequence(1).add(((SerializableBehaviour)RuneCraftoryNPCBehaviour.KEEP_DISTANCE.get()).of(new SerializableBehaviours.KeepDistanceData(1.1f, 5.0f, 9.0f))).add(((SerializableBehaviour)RuneCraftoryNPCBehaviour.ATTACK_WITH_SPELL.get()).of(new SerializableBehaviours.SpellAttackData((Spell)RuneCraftorySpells.FIREBALL.get()))).timeout((NumberProvider)UniformGenerator.between((float)50.0f, (float)100.0f)).end());
        ResourceLocation meleeAndHeal = this.addAttackActions(RuneCraftory.modRes("melee_heal_attack"), new NPCAttackActions.Builder().addSequence(5).add(((SerializableBehaviour)RuneCraftoryNPCBehaviour.WALK_TO.get()).of(new SerializableBehaviours.WalkToData(1.0f, 1))).add(((SerializableBehaviour)RuneCraftoryNPCBehaviour.ATTACK_WITH_WEAPON.get()).of(Unit.INSTANCE)).timeout((NumberProvider)UniformGenerator.between((float)30.0f, (float)80.0f)).end().addSequence(1).add(((SerializableBehaviour)RuneCraftoryNPCBehaviour.KEEP_DISTANCE.get()).of(new SerializableBehaviours.KeepDistanceData(1.1f, 4.0f, 7.0f))).add(((SerializableBehaviour)RuneCraftoryNPCBehaviour.ATTACK_WITH_SPELL.get()).of(new SerializableBehaviours.SpellAttackData((Spell)RuneCraftorySpells.CURE_ALL.get()))).timeout((NumberProvider)UniformGenerator.between((float)40.0f, (float)80.0f)).end());
        ResourceLocation meleeAndWater = this.addAttackActions(RuneCraftory.modRes("melee_water_attack"), new NPCAttackActions.Builder().addSequence(5).add(((SerializableBehaviour)RuneCraftoryNPCBehaviour.WALK_TO.get()).of(new SerializableBehaviours.WalkToData(1.0f, 1))).add(((SerializableBehaviour)RuneCraftoryNPCBehaviour.ATTACK_WITH_WEAPON.get()).of(Unit.INSTANCE)).timeout((NumberProvider)UniformGenerator.between((float)30.0f, (float)80.0f)).end().addSequence(1).add(((SerializableBehaviour)RuneCraftoryNPCBehaviour.KEEP_DISTANCE.get()).of(new SerializableBehaviours.KeepDistanceData(1.1f, 5.0f, 9.0f))).add(((SerializableBehaviour)RuneCraftoryNPCBehaviour.ATTACK_WITH_SPELL.get()).of(new SerializableBehaviours.SpellAttackData((Spell)RuneCraftorySpells.WATER_LASER.get()))).timeout((NumberProvider)UniformGenerator.between((float)50.0f, (float)100.0f)).end());
        ResourceLocation trashGift = this.addGiftData(RuneCraftory.modRes("trash"), GiftData.builder(RunecraftoryTags.Items.GENERIC_TRASH, "runecraftory.gift.trash", "Trash"));
        ResourceLocation smithTrashGift = this.addGiftData(RuneCraftory.modRes("smithing_trash"), GiftData.builder(RunecraftoryTags.Items.GENERIC_TRASH, "runecraftory.gift.trash.smith", "Trash").add((Item)RuneCraftoryItems.SCRAP.get(), (Item)RuneCraftoryItems.SCRAP_PLUS.get()));
        ResourceLocation mineralGift = this.addGiftData(RuneCraftory.modRes("minerals"), GiftData.builder(RunecraftoryTags.Items.MINERALS, "runecraftory.gift.minerals", "minerals").max(7));
        ResourceLocation flowers = this.addGiftData(RuneCraftory.modRes("flowers"), GiftData.builder(RunecraftoryTags.Items.FLOWERS, "runecraftory.gift.flowers", "flowers").max(7));
        ResourceLocation fruits = this.addGiftData(RuneCraftory.modRes("fruits"), GiftData.builder(RunecraftoryTags.Items.FOODS_FRUIT, "runecraftory.gift.fruits", "fruits").max(7));
        ResourceLocation veggies = this.addGiftData(RuneCraftory.modRes("vegetables"), GiftData.builder(RunecraftoryTags.Items.FOODS_VEGGETABLE, "runecraftory.gift.vegetables", "vegetables").max(7));
        ResourceLocation turnip = this.addGiftData(RuneCraftory.modRes("turnip"), GiftData.builder(RunecraftoryTags.Items.TURNIP, "runecraftory.gift.turnip", "turnip").max(7));
        ResourceLocation metals = this.addGiftData(RuneCraftory.modRes("ingots"), GiftData.builder(RunecraftoryTags.Items.IRON, "runecraftory.gift.ingots", "metals").add(RunecraftoryTags.Items.GOLD).add(RunecraftoryTags.Items.RAW_MATERIALS_TIN).add(RunecraftoryTags.Items.COPPER).add(RunecraftoryTags.Items.DUSTS_BRONZE).add(RunecraftoryTags.Items.RAW_MATERIALS_SILVER).add(RunecraftoryTags.Items.RAW_MATERIALS_PLATINUM).max(7));
        ResourceLocation gems = this.addGiftData(RuneCraftory.modRes("gems"), GiftData.builder(Items.DIAMOND, "runecraftory.gift.gems", "gems").add(RunecraftoryTags.Items.GEMS_EMERALD).add(RunecraftoryTags.Items.GEMS_AMETHYST).add(RunecraftoryTags.Items.GEMS_AQUAMARINE).add(RunecraftoryTags.Items.GEMS_RUBY).add(RunecraftoryTags.Items.GEMS_SAPPHIRE).max(7));
        ResourceLocation onigiri = this.addGiftData(RuneCraftory.modRes("onigiri"), GiftData.builder(RunecraftoryTags.Items.ONIGIRI, "runecraftory.gift.onigiri", "onigiri").selectable());
        ResourceLocation pie = this.addGiftData(RuneCraftory.modRes("pie"), GiftData.builder(RunecraftoryTags.Items.PIE, "runecraftory.gift.pie", "cake and pies").selectable());
        ResourceLocation juice = this.addGiftData(RuneCraftory.modRes("juice"), GiftData.builder(RunecraftoryTags.Items.JUICE, "runecraftory.gift.juice", "juice").selectable());
        ResourceLocation toast = this.addGiftData(RuneCraftory.modRes("toast"), GiftData.builder(RunecraftoryTags.Items.TOAST, "runecraftory.gift.toast", "toasts").selectable());
        ResourceLocation udon = this.addGiftData(RuneCraftory.modRes("udon"), GiftData.builder(RunecraftoryTags.Items.UDON, "runecraftory.gift.udon", "udon").selectable());
        ResourceLocation jam = this.addGiftData(RuneCraftory.modRes("jam"), GiftData.builder(RunecraftoryTags.Items.JAM, "runecraftory.gift.jam", "jam").selectable());
        this.addLook(RuneCraftory.modRes("generic/male_1"), new NPCLook(NPCData.Gender.MALE, null, 50, NPCDataGen.defaultNPCFeatures(false, m -> m.put((NPCFeatureType)RuneCraftoryNPCLooks.OUTFIT.get(), new OutfitFeatureType(new TypedIndexRange(List.of(WeightedEntry.wrap((Object)Pair.of((Object)"generic", (Object)new IndexRange.FirstNIndices(3)), (int)1))))))));
        this.addLook(RuneCraftory.modRes("generic/female_1"), new NPCLook(NPCData.Gender.FEMALE, null, 50, NPCDataGen.defaultNPCFeatures(true, m -> m.put((NPCFeatureType)RuneCraftoryNPCLooks.OUTFIT.get(), new OutfitFeatureType(new TypedIndexRange(List.of(WeightedEntry.wrap((Object)Pair.of((Object)"generic", (Object)new IndexRange.FirstNIndices(3)), (int)1))))))));
        this.addNPCData("random_npc_1", new NPCData.Builder(50).addGiftResponse("hate", new NPCData.Gift(trashGift, "npc.generic.1.hate", -15), "What... why would you give me this?").addGiftResponse("dislike", new NPCData.Gift(null, "npc.generic.1.dislike", -7), "Uh, thanks... but I\u2019m not really into this.").addGiftResponse("like", new NPCData.Gift(null, "npc.generic.1.like", 10), "Thanks %player% for the gift. I really like this.").setNeutralGiftResponse("npc.generic.1.gift.default", "Not bad, thanks. I\u2019ll find a use for it.").withCombatActions(genericAttack, meleeAndHeal, meleeAndHeal), NPCDataGen.of(m -> {
            m.put(ConversationContext.FIRST_TALK, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.first.1"), "Hello there! Haven't seen you around before. Are you new here?").addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.first.2"), "Greetings, adventurer. What brings you to this place?").addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.first.3"), "Ah, a new face! Welcome, stranger."));
            m.put(ConversationContext.GREETING, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.greeting.1").addCondition((LootItemCondition)TimeCheck.time((IntRange)IntRange.range((int)0, (int)12000)).build()), "Good day %player%. What can I do for you today?").addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.greeting.2").addCondition((LootItemCondition)TimeCheck.time((IntRange)IntRange.range((int)12000, (int)14000)).build()), "Good evening %player%. How was your day?").addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.greeting.3"), "Hi. How are you today %player%?").addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.greeting.4"), "Hello %player%, always a pleasure to see you."));
            m.put(ConversationContext.TALK, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.talk.1").addCondition((LootItemCondition)WeatherCheck.weather().setRaining(false).build()).addAction(new ConversationSet.ConversationActionHolder("npc.generic.1.talk.1.answer.same", ConversationSet.ConversationAction.ANSWER, "npc.generic.1.talk.1.response.same", 0), "Same").addAction(new ConversationSet.ConversationActionHolder("npc.generic.1.talk.1.answer.ok", ConversationSet.ConversationAction.ANSWER, "npc.generic.1.talk.1.response.ok", 0), "Ok..."), "On sunny days I like to go out and walk a lot.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.talk.1.response.same").setAnswer(), "It's nice right?").addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.talk.1.response.ok").setAnswer(), "You don't?").addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.talk.2"), "I\u2019ve been hearing some strange tales from the travelers passing through. Stories of a distant land where the sky is always dark and tall people appear there. Wonder what's that about.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.talk.rain.1").addCondition((LootItemCondition)WeatherCheck.weather().setRaining(true).build()), "Rainy days like this always make me reflective. What\u2019s on your mind?").addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.talk.rain.2").addCondition((LootItemCondition)WeatherCheck.weather().setRaining(true).build()), "Quite the downpour, isn\u2019t it? What can I do for you while we wait it out?"));
            m.put(ConversationContext.FOLLOW_YES, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.follow.yes.1"), "Lead the way, I'm right behind you.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.follow.yes.2"), "Ready when you are. Let's move.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.follow.yes.3"), "You can count on me. Let's go!"));
            m.put(ConversationContext.FOLLOW_NO, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.follow.no.1"), "I'm afraid I can't right now. Perhaps another time?").addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.follow.no.2"), "Now's not a good time. Maybe later?").addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.follow.no.3"), "Sorry but I am busy right now."));
            m.put(ConversationContext.FOLLOW_STOP, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.follow.stop.1"), "Got it. See you then.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.follow.stop.2"), "Ok. See you again."));
            m.put(ConversationContext.DATING_ACCEPT, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.dating.yes.1"), "I would love that. Let's enjoy our time together.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.dating.yes.2"), "Yes, I think this could be the start of something special.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.dating.yes.3"), "I... didn't think that day would come but yes!"));
            m.put(ConversationContext.DATING_DENY, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.dating.no.1"), "I don't think that's the best idea. Let's keep things as they are.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.dating.no.2"), "I appreciate the offer, but I don't feel that way.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.dating.no.3"), "Sorry but i don't feel that way"));
            m.put(ConversationContext.MARRIAGE_ACCEPT, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.marry.yes.1"), "This is the happiest day of my life! Of course, I'll marry you.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.marry.yes.2"), "Yes, I can't imagine spending my life with anyone else.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.marry.yes.3"), "Yes of course! You can't imagine how happy I am!"));
            m.put(ConversationContext.MARRIAGE_DENY, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.marry.no.1"), "Wait, what? Marriage? I didn\u2019t think we were even at that stage...").addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.marry.no.2"), "Uh, did I miss something? We were talking about something else, right?").addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.marry.no.3"), "I'm sorry, but I don\u2019t see us taking that step together."));
            m.put(ConversationContext.DIVORCE, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.divorce.success.1"), "You\u2019re really doing this? After everything we\u2019ve been through?").addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.divorce.success.2"), "I can\u2019t believe you! Just like that, you want to throw it all away?").addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.divorce.success.3"), "After everything... I see... Goodbye then..."));
            m.put(ConversationContext.DIVORCE_ERROR, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.divorce.fail.1"), "Are you feeling alright? We've never been married.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.divorce.fail.2"), "I think you\u2019re a bit confused. We\u2019re not married, remember?").addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.divorce.fail.3"), "Huh? Why are you giving me that?"));
            m.put(ConversationContext.PROCREATION_COOLDOWN, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.procreation.fail.1"), "I understand, but I\u2019m not sure I want that right now.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.procreation.fail.2"), "It's a big decision, and I\u2019m not comfortable with it at this time.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.1.procreation.fail.3"), "I don't feel like we're in the right place for that yet."));
        }));
        this.addNPCData("random_npc_2", new NPCData.Builder(50).addGiftResponse("hate", new NPCData.Gift(trashGift, "npc.generic.2.hate", -15), "Oh... I\u2019m sorry, but I really don\u2019t like this.").addGiftResponse("dislike", new NPCData.Gift(null, "npc.generic.2.dislike", -7), "I... I appreciate it, but I\u2019m not sure what to do with this.").addGiftResponse("like", new NPCData.Gift(null, "npc.generic.2.like", 10), "Oh, this is... really nice. Thank you %player%.").setNeutralGiftResponse("npc.generic.2.gift.default", "This is okay... Thanks for thinking of me.").withCombatActions(genericAttack, meleeAndHeal, meleeAndWater), NPCDataGen.of(m -> {
            m.put(ConversationContext.FIRST_TALK, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.first.1"), "Um, welcome. I'm ... %npc%. I hope you\u2019ll like it here.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.first.2"), "Hi... I\u2019m not used to seeing new faces around here. I'm %npc%... nice to meet you.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.first.3"), "Oh, um, hello... I didn\u2019t expect to meet someone new today..."));
            m.put(ConversationContext.GREETING, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.greeting.1"), "Hi %player%... Um, did you need something??").addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.greeting.2"), "Oh, it\u2019s you... I\u2019m glad you\u2019re back.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.greeting.3"), "Oh, hi %player% again... It\u2019s nice to see you..."));
            m.put(ConversationContext.TALK, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.talk.1"), "Life here is... quiet. I like it, but sometimes I wish for more.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.talk.2"), "I... um, I saw some bunnies the other day. They were... very cute").addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.talk.3"), "Um, I was thinking... Do you ever wonder what\u2019s out there beyond the village?"));
            m.put(ConversationContext.FOLLOW_YES, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.follow.yes.1"), "Alright... I\u2019ll be right behind you.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.follow.yes.2"), "Sure... I\u2019ll go with you. Just... stay close, okay?"));
            m.put(ConversationContext.FOLLOW_NO, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.follow.no.1"), "I appreciate the offer, but... I should stay here for now.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.follow.no.2"), "I\u2019m sorry... I can\u2019t, not right now."));
            m.put(ConversationContext.FOLLOW_STOP, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.follow.stop.1"), "Ok... see you then. Be careful, okay?").addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.follow.stop.2"), "Alright... I\u2019ll stay here until you need me."));
            m.put(ConversationContext.DATING_ACCEPT, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.dating.yes.1"), "I... I never thought you\u2019d ask. Yes, let\u2019s give it a try.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.dating.yes.2"), "Oh... I didn\u2019t expect that. But, yes, I\u2019d love to.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.dating.yes.3"), "R-really? Um, yes, I\u2019d like that..."));
            m.put(ConversationContext.DATING_DENY, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.dating.no.1"), "I\u2019m not sure I can do that... I\u2019m sorry.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.dating.no.2"), "Oh... I\u2019m sorry, but I can\u2019t. I hope you\u2019re not upset.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.dating.no.3"), "I\u2019m... I\u2019m really sorry, but I don\u2019t think I\u2019m ready for that."));
            m.put(ConversationContext.MARRIAGE_ACCEPT, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.marry.yes.1"), "Oh my... Yes, of course! I\u2019ve dreamed of this...").addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.marry.yes.2"), "I... I can\u2019t believe you asked. Yes, I\u2019ll be with you forever.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.marry.yes.3"), "Y-yes... I can\u2019t believe this is happening. I\u2019d love to marry you."));
            m.put(ConversationContext.MARRIAGE_DENY, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.marry.no.1"), "Oh... I wish I could, but I don\u2019t think I can.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.marry.no.2"), "This is hard to say, but... no, I\u2019m not ready for that.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.marry.no.3"), "I\u2019m sorry... I can\u2019t. I\u2019m not ready for something so big."));
            m.put(ConversationContext.DIVORCE, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.divorce.success.1"), "This is really hard, but... I\u2019ll let you go if that\u2019s what you need.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.divorce.success.2"), "It\u2019s... it\u2019s over then. I\u2019ll always remember what we had.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.divorce.success.3"), "Oh... I didn\u2019t think this would happen. I guess... this is goodbye."));
            m.put(ConversationContext.DIVORCE_ERROR, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.divorce.fail.1"), "I... I\u2019m not sure what you mean. We were never together.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.divorce.fail.2"), "I think there\u2019s a misunderstanding... We were never married.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.divorce.fail.3"), "Wait... What? We were never married..."));
            m.put(ConversationContext.PROCREATION_COOLDOWN, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.procreation.fail.1"), "I... I don\u2019t think having a child is right for me, not now.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.procreation.fail.2"), "I\u2019ve thought about it, but... I don't think now is the right time.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.2.procreation.fail.3"), "I... I\u2019m not ready for that kind of responsibility. I\u2019m sorry."));
        }));
        this.addNPCData("random_npc_3", new NPCData.Builder(50).addGiftResponse("hate", new NPCData.Gift(trashGift, "npc.generic.3.hate", -15), "Uhh... what should I do with this?").addGiftResponse("dislike", new NPCData.Gift(null, "npc.generic.3.dislike", -7), "Sorry... but this isn't really my thing.").addGiftResponse("like", new NPCData.Gift(null, "npc.generic.3.like", 10), "Oh, nice... this is something I can appreciate.").setNeutralGiftResponse("npc.generic.3.gift.default", "Oh... thanks... it\u2019s... alright.").withCombatActions(genericAttack, meleeAndHeal, meleeAndWater), NPCDataGen.of(m -> {
            m.put(ConversationContext.FIRST_TALK, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.first.1"), "Zzzz... huh? Oh a new face! I... wasn't sleeping no. Anyway Im' %npc%. Nice to meet you").addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.first.2"), "Oh welcome. I'm %npc%. Nice to ... yawn... meet you").addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.first.3"), "Yawn... oh. Haven't seen you around here before. Hello... I'm  %npc%."));
            m.put(ConversationContext.GREETING, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.greeting.1"), "Zzzzz... ! Oh hi. How are you today %player%?").addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.greeting.2"), "Hey there %player%... I wish the day was over already?"));
            m.put(ConversationContext.TALK, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.talk.1"), "Those sheep look so fluffy... I bet you can fall asleep instantly if you lie on them").addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.talk.2"), "Some people have so much energy during the day. I wonder where they get all of it from...").addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.talk.3").addAction(new ConversationSet.ConversationActionHolder("npc.generic.3.talk.3.answer.nice", ConversationSet.ConversationAction.ANSWER, "npc.generic.3.talk.3.response.nice", 0), "Sounds great!").addAction(new ConversationSet.ConversationActionHolder("npc.generic.3.talk.3.answer.uhh", ConversationSet.ConversationAction.ANSWER, "npc.generic.3.talk.3.response.uhh", 0), "..."), "If I bring a pillow with me i could nap everywhere I want. What do you think?").addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.talk.3.response.nice"), "Yeah I know right?").addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.talk.3.response.uhh"), "Come on... You don't think so?"));
            m.put(ConversationContext.FOLLOW_YES, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.follow.yes.1"), "Mmm... alright, I\u2019ll follow... just don\u2019t expect me to keep up if we\u2019re running.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.follow.yes.2"), "I\u2019m in... as long as we can stop for naps along the way.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.follow.yes.3"), "Sure. But can we take it slowly?"));
            m.put(ConversationContext.FOLLOW_NO, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.follow.no.1"), "I would, but... this spot is so comfy, I might just stay put.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.follow.no.2"), "Sorry, but my bed is calling... maybe another time?").addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.follow.no.3"), "Mmm... maybe later... I think I\u2019ll just rest here for now."));
            m.put(ConversationContext.FOLLOW_STOP, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.follow.stop.1"), "Oh... stopping already? I was just getting used to the pace...").addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.follow.stop.2"), "Mmm... okay, I\u2019ll stay here... don\u2019t worry, I\u2019ll find a good spot to nap."));
            m.put(ConversationContext.DATING_ACCEPT, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.dating.yes.1"), "Yeah... let\u2019s see where this goes... maybe we can nap together sometime.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.dating.yes.2"), "I\u2019d like that... as long as we can keep it low-key and relaxed.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.dating.yes.3"), "Mmm... dating sounds nice... as long as our dates are cozy."));
            m.put(ConversationContext.DATING_DENY, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.dating.no.1"), "Dating sounds... like a lot of work... and I\u2019m just so sleepy.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.dating.no.2"), "Mmm... I\u2019m flattered, but... I don\u2019t think I\u2019m up for that kind of energy.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.dating.no.3"), "Thanks, but... I\u2019m not sure I can keep up with all that."));
            m.put(ConversationContext.MARRIAGE_ACCEPT, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.marry.yes.1"), "Marriage? Mmm... yeah, I think I\u2019d like that... as long as we keep it chill.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.marry.yes.2"), "Sure... as long as we can take naps together... I\u2019m in.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.marry.yes.3"), "Marriage sounds nice... as long as we can keep things laid-back."));
            m.put(ConversationContext.MARRIAGE_DENY, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.marry.no.1"), "Marriage is... a bit too much for me right now.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.marry.no.2"), "I appreciate it, but... I\u2019m not really ready for that step.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.marry.no.3"), "Mmm... I don\u2019t think marriage is in the cards for me... too much commitment."));
            m.put(ConversationContext.DIVORCE, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.divorce.success.1"), "Mmm... so that\u2019s it? I guess I shouldn\u2019t have expected more...").addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.divorce.success.2"), "What? Divorce? Mmm... that\u2019s... really frustrating, you know.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.divorce.success.3"), "Divorce? Just like that? That\u2019s... really disappointing."));
            m.put(ConversationContext.DIVORCE_ERROR, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.divorce.fail.1"), "Mmm... divorce? Wait, did I sleep through the wedding?").addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.divorce.fail.2"), "I think you\u2019re confused... we\u2019re not even married, remember?").addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.divorce.fail.3"), "You want to divorce me? But... I\u2019m pretty sure we\u2019re not married."));
            m.put(ConversationContext.PROCREATION_COOLDOWN, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.procreation.fail.1"), "A kid? I\u2019m too tired just thinking about it...").addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.procreation.fail.2"), "I\u2019m sorry, but... I don\u2019t think I can handle that right now.").addConversation(new ConversationSet.Conversation.Builder("npc.generic.3.procreation.fail.3"), "Mmm... a child? I don\u2019t think I have the energy for that right now."));
        }));
        ResourceLocation shopMale = this.addLook(RuneCraftory.modRes("shop_owner/male_1"), new NPCLook(NPCData.Gender.MALE, null, 0, NPCDataGen.defaultNPCFeatures(false, m -> m.put((NPCFeatureType)RuneCraftoryNPCLooks.OUTFIT.get(), new OutfitFeatureType(new TypedIndexRange(List.of(WeightedEntry.wrap((Object)Pair.of((Object)"shop", (Object)new IndexRange.FirstNIndices(3)), (int)1))))))));
        ResourceLocation shopFemale = this.addLook(RuneCraftory.modRes("shop_owner/female_1"), new NPCLook(NPCData.Gender.FEMALE, null, 0, NPCDataGen.defaultNPCFeatures(true, m -> m.put((NPCFeatureType)RuneCraftoryNPCLooks.OUTFIT.get(), new OutfitFeatureType(new TypedIndexRange(List.of(WeightedEntry.wrap((Object)Pair.of((Object)"shop", (Object)new IndexRange.FirstNIndices(3)), (int)1))))))));
        this.addNPCData("shop_owner/1", new NPCData.Builder(50).withLook(new NPCData.NPCLookId(shopMale, NPCData.Gender.MALE), new NPCData.NPCLookId(shopFemale, NPCData.Gender.FEMALE)).withProfession((NPCProfession)RuneCraftoryNPCProfessions.GENERAL_STORE.get(), (NPCProfession)RuneCraftoryNPCProfessions.FLORIST.get()).addGiftResponse("hate", new NPCData.Gift(trashGift, "npc.shop_owner.1.hate", -15), "Uhh... what should I do with this?").addGiftResponse("dislike", new NPCData.Gift(null, "npc.shop_owner.1.dislike", -7), "Sorry... but this isn't really my thing.").addGiftResponse("like", new NPCData.Gift(null, "npc.shop_owner.1.like", 10), "Oh, nice... this is something I can appreciate.").setNeutralGiftResponse("npc.shop_owner.1.gift.default", "Oh... thanks... it\u2019s... alright.").withCombatActions(genericAttack), NPCDataGen.of(m -> {
            m.put(ConversationContext.FIRST_TALK, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.shop_owner.1.first.1"), "Ah, someone new! Let me know if you need any help finding something. I manage a general store so you should find something useful there. I'm %npc% by the way.").addConversation(new ConversationSet.Conversation.Builder("npc.shop_owner.1.first.2"), "Hello there, traveler! You seem to be new here. Whats your name? ... %player% I see. I'm %npc% and I have a general store where i sell various goods there.").addConversation(new ConversationSet.Conversation.Builder("npc.shop_owner.1.first.3"), "Ah, a new face in town! Welcome. I'm %npc% and I manage a general store. You should come by if you have some time"));
            m.put(ConversationContext.GREETING, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.shop_owner.1.greeting.1").addCondition((LootItemCondition)TimeCheck.time((IntRange)IntRange.range((int)6000, (int)12000)).build()), "Goood morning %player%! How are you today").addConversation(new ConversationSet.Conversation.Builder("npc.shop_owner.1.greeting.2"), "Good day to you %player%! How are you today"));
            m.put(ConversationContext.TALK, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.shop_owner.1.talk.1"), "Running this store keeps me busy, but I wouldn\u2019t trade it for anything. Seeing so many people needing this store makes me happy.").addConversation(new ConversationSet.Conversation.Builder("npc.shop_owner.1.talk.2"), "").addConversation(new ConversationSet.Conversation.Builder("npc.shop_owner.1.talk.3"), ""));
            m.put(ConversationContext.FOLLOW_YES, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.shop_owner.1.follow.yes.1"), "Sure. Where are we going?"));
            m.put(ConversationContext.FOLLOW_NO, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.shop_owner.1.follow.no.1"), "Ah sorry but this is not possible right now."));
            m.put(ConversationContext.FOLLOW_STOP, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.shop_owner.1.follow.stop.1"), "Got it. See ya then!"));
            m.put(ConversationContext.DATING_ACCEPT, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.shop_owner.1.dating.yes.1"), "I didn\u2019t see that coming, but yes, I\u2019d love to.").addConversation(new ConversationSet.Conversation.Builder("npc.shop_owner.1.dating.yes.2"), "I\u2019ve been hoping you\u2019d ask. Yes, I\u2019d love to."));
            m.put(ConversationContext.DATING_DENY, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.shop_owner.1.dating.no.1"), "Sorry. But I don't see you that way.").addConversation(new ConversationSet.Conversation.Builder("npc.shop_owner.1.dating.no.2"), "I appreciate your feelings, but I don\u2019t think it\u2019s a good idea."));
            m.put(ConversationContext.MARRIAGE_ACCEPT, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.shop_owner.1.marry.yes.1"), "This is the happiest moment of my life. Yes, I\u2019ll marry you!").addConversation(new ConversationSet.Conversation.Builder("npc.shop_owner.1.marry.yes.2"), "This is everything I hoped for. Yes, let\u2019s get married!"));
            m.put(ConversationContext.MARRIAGE_DENY, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.shop_owner.1.marry.no.1"), "I\u2019m sorry, but I\u2019m not ready for that kind of commitment.").addConversation(new ConversationSet.Conversation.Builder("npc.shop_owner.1.marry.no.2"), "I care about you deeply, but I\u2019m not ready for marriage yet."));
            m.put(ConversationContext.DIVORCE, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.shop_owner.1.divorce.success.1"), "You\u2019re just going to walk away like that? After everything?").addConversation(new ConversationSet.Conversation.Builder("npc.shop_owner.1.divorce.success.2"), "I can\u2019t believe this. You\u2019re just going to throw it all away?"));
            m.put(ConversationContext.DIVORCE_ERROR, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.shop_owner.1.divorce.fail.1"), "Wait, what? We\u2019re not even married!").addConversation(new ConversationSet.Conversation.Builder("npc.shop_owner.1.divorce.fail.2"), "You can\u2019t divorce someone you were never married to, you know."));
            m.put(ConversationContext.PROCREATION_COOLDOWN, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.shop_owner.1.procreation.fail.1"), "Now is not the time for that. Sorry.").addConversation(new ConversationSet.Conversation.Builder("npc.shop_owner.1.procreation.fail.2"), "I think we shoul wait a bit more before that step."));
        }));
        ResourceLocation smithMale = this.addLook(RuneCraftory.modRes("smith/male_1"), new NPCLook(NPCData.Gender.MALE, null, 0, NPCDataGen.defaultNPCFeatures(false, m -> m.put((NPCFeatureType)RuneCraftoryNPCLooks.OUTFIT.get(), new OutfitFeatureType(new TypedIndexRange(List.of(WeightedEntry.wrap((Object)Pair.of((Object)"smith", (Object)new IndexRange.FirstNIndices(3)), (int)1))))))));
        ResourceLocation smithFemale = this.addLook(RuneCraftory.modRes("smith/female_1"), new NPCLook(NPCData.Gender.FEMALE, null, 0, NPCDataGen.defaultNPCFeatures(true, m -> m.put((NPCFeatureType)RuneCraftoryNPCLooks.OUTFIT.get(), new OutfitFeatureType(new TypedIndexRange(List.of(WeightedEntry.wrap((Object)Pair.of((Object)"smith", (Object)new IndexRange.FirstNIndices(3)), (int)1))))))));
        this.addNPCData("smith/1", new NPCData.Builder(50).withLook(new NPCData.NPCLookId(smithMale, NPCData.Gender.MALE), new NPCData.NPCLookId(smithFemale, NPCData.Gender.FEMALE)).withProfession((NPCProfession)RuneCraftoryNPCProfessions.GENERAL_STORE.get(), (NPCProfession)RuneCraftoryNPCProfessions.BLACKSMITH.get()).addGiftResponse("dislike", new NPCData.Gift(smithTrashGift, "npc.smith.2.dislike", -7), "Hey! I'm not your trashcan!").addGiftResponse("like", new NPCData.Gift(mineralGift, "npc.smith.2.like", 10), "Wow thanks! I can make something great using this").setNeutralGiftResponse("npc.smith.2.gift.default", "Thanks. Btw did you know that I really like %like%?").withCombatActions(meleeAndFireball), NPCDataGen.of(m -> {
            m.put(ConversationContext.FIRST_TALK, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.smith.1.first.1"), "Are you new here? I see. My name is %npc% and operate a forge here. Swing by if you want to have a good weapon."));
            m.put(ConversationContext.GREETING, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.smith.1.greeting.1"), "Hello %player%. Let's do our best again today!"));
            m.put(ConversationContext.TALK, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.smith.1.talk.1"), "Nothing beats the clanging sound of a working forge.").addConversation(new ConversationSet.Conversation.Builder("npc.smith.1.talk.2"), "There are multiple different weapon types. You should try them all out to find the one that suits you the best.").addConversation(new ConversationSet.Conversation.Builder("npc.smith.1.talk.3"), "Working as a blacksmith is hard but very fun.").addConversation(new ConversationSet.Conversation.Builder("npc.smith.1.talk.4"), "Someday I would like to make some kind of legendary weapon."));
            m.put(ConversationContext.FOLLOW_YES, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.smith.1.follow.yes.1"), "Ok. Let's go then!"));
            m.put(ConversationContext.FOLLOW_NO, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.smith.1.follow.no.1"), "Hmm sorry but the forge calls for me."));
            m.put(ConversationContext.FOLLOW_STOP, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.smith.1.follow.stop.1"), "Okay, bye then. Let me know if you need me again."));
            m.put(ConversationContext.DATING_ACCEPT, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.smith.1.dating.yes.1"), "You know what? Yes, I\u2019d like to get to know you better.").addConversation(new ConversationSet.Conversation.Builder("npc.smith.1.dating.yes.2"), "I think we\u2019d have a great time. Yes, I\u2019m in."));
            m.put(ConversationContext.DATING_DENY, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.smith.1.dating.no.1"), "Thank you for asking, but I\u2019m not looking for that kind of relationship.").addConversation(new ConversationSet.Conversation.Builder("npc.smith.1.dating.no.2"), "I\u2019m sorry, but I don\u2019t think I\u2019m ready for a relationship."));
            m.put(ConversationContext.MARRIAGE_ACCEPT, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.smith.1.marry.yes.1"), "Yes! Let us walk the path of the forge together.").addConversation(new ConversationSet.Conversation.Builder("npc.smith.1.marry.yes.2"), "I never imagined something like this would happen, but yes, I\u2019ll marry you."));
            m.put(ConversationContext.MARRIAGE_DENY, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.smith.1.marry.no.1"), "This is difficult for me, but I have to say no.").addConversation(new ConversationSet.Conversation.Builder("npc.smith.1.marry.no.2"), "I\u2019ve thought about it, but I don\u2019t think I can say yes for now."));
            m.put(ConversationContext.DIVORCE, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.smith.1.divorce.success.1"), "Fine. If this is what you want, just don\u2019t expect me to forget.").addConversation(new ConversationSet.Conversation.Builder("npc.smith.1.divorce.success.2"), "If this is what you want, so be it. But don\u2019t think I\u2019ll forgive easily."));
            m.put(ConversationContext.DIVORCE_ERROR, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.smith.1.divorce.fail.1"), "Huh what is this? I don't think i have any use for this?").addConversation(new ConversationSet.Conversation.Builder("npc.smith.1.divorce.fail.2"), "Uhh are you ok? We are not married or anything you know..."));
            m.put(ConversationContext.PROCREATION_COOLDOWN, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.smith.1.procreation.fail.1"), "This is a huge step, and i feel like now is not the right time for that"));
        }));
        ResourceLocation doctorMale = this.addLook(RuneCraftory.modRes("doctor/male_1"), new NPCLook(NPCData.Gender.MALE, null, 0, NPCDataGen.defaultNPCFeatures(false, m -> m.put((NPCFeatureType)RuneCraftoryNPCLooks.OUTFIT.get(), new OutfitFeatureType(new TypedIndexRange(List.of(WeightedEntry.wrap((Object)Pair.of((Object)"doctor", (Object)new IndexRange.FirstNIndices(1)), (int)1))))))));
        ResourceLocation doctorFemale = this.addLook(RuneCraftory.modRes("doctor/female_1"), new NPCLook(NPCData.Gender.FEMALE, null, 0, NPCDataGen.defaultNPCFeatures(true, m -> m.put((NPCFeatureType)RuneCraftoryNPCLooks.OUTFIT.get(), new OutfitFeatureType(new TypedIndexRange(List.of(WeightedEntry.wrap((Object)Pair.of((Object)"doctor", (Object)new IndexRange.FirstNIndices(1)), (int)1))))))));
        this.addNPCData("doctor/1", new NPCData.Builder(50).withLook(new NPCData.NPCLookId(doctorMale, NPCData.Gender.MALE), new NPCData.NPCLookId(doctorFemale, NPCData.Gender.FEMALE)).withProfession((NPCProfession)RuneCraftoryNPCProfessions.DOCTOR.get()).addGiftResponse("dislike", new NPCData.Gift(null, "npc.doctor.2.dislike", -7), "I can't use this...").addGiftResponse("like", new NPCData.Gift(null, "npc.doctor.2.like", 10), "Thanks! I really like this!").setNeutralGiftResponse("npc.doctor.2.gift.default", "Oh? this might be useful. Thanks").withCombatActions(meleeAndFireball), NPCDataGen.of(m -> {
            m.put(ConversationContext.FIRST_TALK, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.doctor.1.first.1"), "Hello! Who are you?\n...\nI see. I'm %npc% and I run a clinic here. If you ever need help feel free to drop by there."));
            m.put(ConversationContext.GREETING, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.doctor.1.greeting.1"), "Good day %player%. How are you today?"));
            m.put(ConversationContext.TALK, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.doctor.1.talk.1"), "Medicine isn\u2019t just a job to me; it\u2019s a passion. Every patient has a story, and sometimes, understanding that story is the key to their treatment.").addConversation(new ConversationSet.Conversation.Builder("npc.doctor.1.talk.2"), "Whenever you have a status condition you let me check that out. They can be quite detrimental. Though i heard a good night's rest also helps with that.").addConversation(new ConversationSet.Conversation.Builder("npc.doctor.1.talk.3"), "Various herbs and grass are very useful in medicine").addConversation(new ConversationSet.Conversation.Builder("npc.doctor.1.talk.4"), "Being a doctor lots of people come to me for a variety of problems. Helping them with it is my duty."));
            m.put(ConversationContext.FOLLOW_YES, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.doctor.1.follow.yes.1"), "Sure. But don't overexert yourself!"));
            m.put(ConversationContext.FOLLOW_NO, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.doctor.1.follow.no.1"), "Ah sorry but I'm quite busy right now."));
            m.put(ConversationContext.FOLLOW_STOP, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.doctor.1.follow.stop.1"), "Ok. Take care of yourself!"));
            m.put(ConversationContext.DATING_ACCEPT, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.doctor.1.dating.yes.1"), "That sounds wonderful. I\u2019d love to.").addConversation(new ConversationSet.Conversation.Builder("npc.doctor.1.dating.yes.2"), "I\u2019d like that. Let\u2019s see where this goes."));
            m.put(ConversationContext.DATING_DENY, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.doctor.1.dating.no.1"), "I\u2019m flattered, but I don't see us in that way."));
            m.put(ConversationContext.MARRIAGE_ACCEPT, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.doctor.1.marry.yes.1"), "Wow. I would've never expected that I would walk down this path. Yes lets do it!"));
            m.put(ConversationContext.MARRIAGE_DENY, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.doctor.1.marry.no.1"), "That\u2019s a big step, and I don\u2019t think I\u2019m ready to take it."));
            m.put(ConversationContext.DIVORCE, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.doctor.1.divorce.success.1"), "I... was never expecting this. Especially from you..."));
            m.put(ConversationContext.DIVORCE_ERROR, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.doctor.1.divorce.fail.1"), "Hmm... why are you giving me this?"));
            m.put(ConversationContext.PROCREATION_COOLDOWN, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.doctor.1.procreation.fail.1"), "We should take this more slowly and not rush things."));
        }));
        ResourceLocation cookMale = this.addLook(RuneCraftory.modRes("cook/male_1"), new NPCLook(NPCData.Gender.MALE, null, 0, NPCDataGen.defaultNPCFeatures(false, m -> {
            m.put((NPCFeatureType)RuneCraftoryNPCLooks.HAT.get(), new SimpleHatFeatureType(List.of("chef_hat")));
            m.put((NPCFeatureType)RuneCraftoryNPCLooks.OUTFIT.get(), new OutfitFeatureType(new TypedIndexRange(List.of(WeightedEntry.wrap((Object)Pair.of((Object)"doctor", (Object)new IndexRange.FirstNIndices(1)), (int)1)))));
        })));
        ResourceLocation cookFemale = this.addLook(RuneCraftory.modRes("cook/female_1"), new NPCLook(NPCData.Gender.FEMALE, null, 0, NPCDataGen.defaultNPCFeatures(true, m -> {
            m.put((NPCFeatureType)RuneCraftoryNPCLooks.HAT.get(), new SimpleHatFeatureType(List.of("chef_hat")));
            m.put((NPCFeatureType)RuneCraftoryNPCLooks.OUTFIT.get(), new OutfitFeatureType(new TypedIndexRange(List.of(WeightedEntry.wrap((Object)Pair.of((Object)"doctor", (Object)new IndexRange.FirstNIndices(1)), (int)1)))));
        })));
        this.addNPCData("cook/1", new NPCData.Builder(50).withLook(new NPCData.NPCLookId(cookMale, NPCData.Gender.MALE), new NPCData.NPCLookId(cookFemale, NPCData.Gender.FEMALE)).withProfession((NPCProfession)RuneCraftoryNPCProfessions.CHEF.get()).addGiftResponse("dislike", new NPCData.Gift(null, "npc.cook.2.dislike", -7), "This can't even be used in my dishes...").addGiftResponse("like", new NPCData.Gift(null, "npc.cook.2.like", 10), "Wow thanks! I really like this!").setNeutralGiftResponse("npc.cook.2.gift.default", "It\u2019s nice of you to think of me. I\u2019ll find a use for this.").withCombatActions(meleeAndFireball), NPCDataGen.of(m -> {
            m.put(ConversationContext.FIRST_TALK, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.cook.1.first.1"), "I don\u2019t think we\u2019ve met. I\u2019m %npc%, the chef around here. Making sure folks are well-fed is what I do.").addConversation(new ConversationSet.Conversation.Builder("npc.cook.1.first.2"), "Ah, a new face! I\u2019m the cook here. If you are hungry you should swing by. I run a restaurant here serving various delicous dishes."));
            m.put(ConversationContext.GREETING, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.cook.1.greeting.1"), "Good to see you %player%! What can I cook up for you today?"));
            m.put(ConversationContext.TALK, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.cook.1.talk.1"), "You know, people say cooking is just a job, but for me, it\u2019s a passion. There's something magical about turning simple ingredients into something that brings folks together.").addConversation(new ConversationSet.Conversation.Builder("npc.cook.1.talk.2"), "You should try out cooking too. Sometimes a homecooked meal can beat any other dishes. And who knows? Maybe it will awaken the culinary flame in you too.").addConversation(new ConversationSet.Conversation.Builder("npc.cook.1.talk.3"), "Seeing people eat the food I cook gives me an indescribable feeling of satisfaction."));
            m.put(ConversationContext.FOLLOW_YES, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.cook.1.follow.yes.1"), "Sure. Where are we going?"));
            m.put(ConversationContext.FOLLOW_NO, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.cook.1.follow.no.1"), "Sorry but I have a lot on my plate right now."));
            m.put(ConversationContext.FOLLOW_STOP, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.cook.1.follow.stop.1"), "Stopping here? Alright, I\u2019ll head back to the kitchen then."));
            m.put(ConversationContext.DATING_ACCEPT, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.cook.1.dating.yes.1"), "You know, I\u2019ve always had a soft spot for someone who appreciates good food. Let\u2019s give it a shot!"));
            m.put(ConversationContext.DATING_DENY, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.cook.1.dating.no.1"), "I\u2019m honored you\u2019d ask, but my passion for cooking leaves little room for romance."));
            m.put(ConversationContext.MARRIAGE_ACCEPT, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.cook.1.marry.yes.1"), "Marriage? Wow... I never thought I\u2019d find someone who loves my cooking and me! Yes, let\u2019s get married.").addConversation(new ConversationSet.Conversation.Builder("npc.cook.1.marry.yes.2"), "This is the sweetest proposal I\u2019ve ever had\u2014yes, I\u2019ll marry you, and I promise to keep your plate full of love."));
            m.put(ConversationContext.MARRIAGE_DENY, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.cook.1.marry.no.1"), "You\u2019re wonderful, but I\u2019m not ready to commit to marriage yet. Let\u2019s just keep enjoying each other\u2019s company\u2014and my cooking.").addConversation(new ConversationSet.Conversation.Builder("npc.cook.1.marry.no.2"), "Marriage is a big step, and I\u2019m not sure I\u2019m ready to share my kitchen\u2014or my life\u2014that way."));
            m.put(ConversationContext.DIVORCE, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.cook.1.divorce.success.1"), "You want to divorce me? After everything we\u2019ve shared\u2014meals, memories, and more? I can\u2019t believe this!").addConversation(new ConversationSet.Conversation.Builder("npc.cook.1.divorce.success.2"), "So you\u2019ve had your fill and now you\u2019re done with me? I never thought it would come to this."));
            m.put(ConversationContext.DIVORCE_ERROR, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.cook.1.divorce.fail.1"), "Divorce? You must have eaten something that\u2019s gone bad\u2014we\u2019re not even married!").addConversation(new ConversationSet.Conversation.Builder("npc.cook.1.divorce.fail.2"), "Wait, divorce? But we never got married! Maybe you need to spend more time in the kitchen clearing your head."));
            m.put(ConversationContext.PROCREATION_COOLDOWN, new ConversationSet.Builder().addConversation(new ConversationSet.Conversation.Builder("npc.cook.1.procreation.fail.1"), "I\u2019ve thought about it, but I don\u2019t think kids are in the cards for me right now."));
        }));
    }

    private static <T extends NPCFeature> Map<NPCFeatureType<?>, NPCFeature.NPCFeatureHolder<?>> defaultNPCFeatures(boolean female, Consumer<FeatureBuilderHelper> cons) {
        LinkedHashMap map = new LinkedHashMap();
        FeatureBuilderHelper builder = map::put;
        builder.put((NPCFeatureType)RuneCraftoryNPCLooks.SKIN.get(), new IndexedColorSettingType((Supplier<NPCFeatureType<IndexedColorSettingType.IndexedColorFeature>>)RuneCraftoryNPCLooks.SKIN, List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2)), ColorSetting.SKIN_COLOR_RANGE));
        if (female) {
            builder.put((NPCFeatureType)RuneCraftoryNPCLooks.SLIM.get(), SlimLookFeatureType.TYPE_INSTANCE);
            builder.put((NPCFeatureType)RuneCraftoryNPCLooks.SIZE.get(), new SizeFeatureType((NumberProvider)UniformGenerator.between((float)0.9f, (float)1.05f)));
            builder.put((NPCFeatureType)RuneCraftoryNPCLooks.BLUSH.get(), new BlushFeatureType(0.5f, ColorSetting.BLUSH_COLOR_RANGE));
            builder.put((NPCFeatureType)RuneCraftoryNPCLooks.HAIR.get(), new HairFeatureType(new TypedIndexRange(List.of(WeightedEntry.wrap((Object)Pair.of((Object)"long", (Object)new IndexRange.FirstNIndices(5)), (int)1))), ColorSetting.HAIR_COLOR_RANGE));
            builder.put((NPCFeatureType)RuneCraftoryNPCLooks.FACE.get(), new FaceFeaturesType(new IndexedColorSetting(List.of(Integer.valueOf(0), Integer.valueOf(1)), ColorSetting.EYE_COLOR_RANGE), new IndexedColorSetting(List.of(Integer.valueOf(0), Integer.valueOf(1)), ColorSetting.DEFAULT), new IndexedColorSetting(List.of(Integer.valueOf(1), Integer.valueOf(2)), ColorSetting.EYEBROW_COLOR_RANGE), FaceFeaturesType.DEFAULT_EXPRESSIONS));
        } else {
            builder.put((NPCFeatureType)RuneCraftoryNPCLooks.SIZE.get(), new SizeFeatureType((NumberProvider)UniformGenerator.between((float)0.95f, (float)1.1f)));
            builder.put((NPCFeatureType)RuneCraftoryNPCLooks.HAIR.get(), new HairFeatureType(new TypedIndexRange(List.of(WeightedEntry.wrap((Object)Pair.of((Object)"short", (Object)new IndexRange.FirstNIndices(5)), (int)1))), ColorSetting.HAIR_COLOR_RANGE));
            builder.put((NPCFeatureType)RuneCraftoryNPCLooks.FACE.get(), new FaceFeaturesType(new IndexedColorSetting(List.of(Integer.valueOf(0), Integer.valueOf(1)), ColorSetting.EYE_COLOR_RANGE), new IndexedColorSetting(List.of(Integer.valueOf(0), Integer.valueOf(1)), ColorSetting.DEFAULT), new IndexedColorSetting(List.of(Integer.valueOf(0), Integer.valueOf(1)), ColorSetting.EYEBROW_COLOR_RANGE), FaceFeaturesType.DEFAULT_EXPRESSIONS));
        }
        cons.accept(builder);
        return map;
    }

    public void addNPCData(String id, NPCData.Builder data, Map<ConversationContext, ConversationSet.Builder> conversations) {
        this.addNPCData(id, data, conversations, this.questGen.questResponses.getOrDefault(ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)id), Map.of()));
    }

    private static <K, V> Map<K, V> of(Consumer<Map<K, V>> cons) {
        LinkedHashMap map = new LinkedHashMap();
        cons.accept(map);
        return map;
    }

    private static interface FeatureBuilderHelper {
        public <T extends NPCFeature> void put(NPCFeatureType<T> var1, NPCFeature.NPCFeatureHolder<T> var2);
    }
}

