/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.datapack.SimpleEffect;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import io.github.flemmli97.runecraftory.common.utils.StreamCodecUtils;
import it.unimi.dsi.fastutil.objects.Object2DoubleAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleSortedMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleSortedMaps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1320;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_5134;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class FoodProperties {
    public static final Codec<FoodProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("duration").forGetter(d -> d.duration), (App)Codec.unboundedMap((Codec)class_7923.field_41190.method_40294(), (Codec)Codec.DOUBLE).fieldOf("effects").forGetter(d -> d.effects), (App)Codec.unboundedMap((Codec)class_7923.field_41190.method_40294(), (Codec)Codec.DOUBLE).fieldOf("effects_percentage").forGetter(d -> d.effectsPercentage), (App)Codec.unboundedMap((Codec)class_7923.field_41190.method_40294(), (Codec)Codec.DOUBLE).fieldOf("cooking_bonus").forGetter(d -> d.cookingBonus), (App)Codec.unboundedMap((Codec)class_7923.field_41190.method_40294(), (Codec)Codec.DOUBLE).fieldOf("cooking_bonus_percent").forGetter(d -> d.cookingBonusPercent), (App)SimpleEffect.CODEC.listOf().fieldOf("potion_apply").forGetter(d -> d.potionApply), (App)class_7923.field_41174.method_40294().listOf().fieldOf("potion_remove").forGetter(d -> d.potionRemove)).apply((Applicative)instance, FoodProperties::new));
    public static final class_9139<class_9129, FoodProperties> STREAM_CODEC = new class_9139<class_9129, FoodProperties>(){

        public FoodProperties decode(class_9129 buf) {
            return new FoodProperties(buf.readInt(), (Map)StreamCodecUtils.ATTRIBUTE_CODEC.decode((Object)buf), (Map)StreamCodecUtils.ATTRIBUTE_CODEC.decode((Object)buf), (Map)StreamCodecUtils.ATTRIBUTE_CODEC.decode((Object)buf), (Map)StreamCodecUtils.ATTRIBUTE_CODEC.decode((Object)buf), buf.method_34066(b -> (SimpleEffect)SimpleEffect.STREAM_CODEC.decode((Object)buf)), buf.method_34066(b -> (class_6880)class_9135.method_56383((class_5321)class_7924.field_41208).decode((Object)buf)));
        }

        public void encode(class_9129 buf, FoodProperties props) {
            buf.method_53002(props.duration);
            StreamCodecUtils.ATTRIBUTE_CODEC.encode((Object)buf, props.effects);
            StreamCodecUtils.ATTRIBUTE_CODEC.encode((Object)buf, props.effectsPercentage);
            StreamCodecUtils.ATTRIBUTE_CODEC.encode((Object)buf, props.cookingBonus);
            StreamCodecUtils.ATTRIBUTE_CODEC.encode((Object)buf, props.cookingBonusPercent);
            buf.method_34062(props.potionApply, (b, val) -> SimpleEffect.STREAM_CODEC.encode((Object)buf, val));
            buf.method_34062(props.potionRemove, (b, val) -> class_9135.method_56383((class_5321)class_7924.field_41208).encode((Object)buf, val));
        }
    };
    private final Map<class_6880<class_1320>, Double> effects;
    private final Map<class_6880<class_1320>, Double> effectsPercentage;
    private final Map<class_6880<class_1320>, Double> cookingBonus;
    private final Map<class_6880<class_1320>, Double> cookingBonusPercent;
    private final int duration;
    private final List<SimpleEffect> potionApply;
    private final List<class_6880<class_1291>> potionRemove;

    public FoodProperties(int duration, Map<class_6880<class_1320>, Double> effects, Map<class_6880<class_1320>, Double> effectsPercentage, Map<class_6880<class_1320>, Double> cookingBonus, Map<class_6880<class_1320>, Double> cookingBonusPercent, List<SimpleEffect> potionApply, List<class_6880<class_1291>> potionRemove) {
        this.effects = FoodProperties.createFor(effects);
        this.effectsPercentage = FoodProperties.createFor(effectsPercentage);
        this.cookingBonus = FoodProperties.createFor(cookingBonus);
        this.cookingBonusPercent = FoodProperties.createFor(cookingBonusPercent);
        this.duration = duration;
        this.potionApply = potionApply;
        this.potionRemove = potionRemove;
    }

    private static Map<class_6880<class_1320>, Double> createFor(Map<class_6880<class_1320>, Double> map) {
        Object2DoubleAVLTreeMap sorted = new Object2DoubleAVLTreeMap(RuneCraftoryAttributes.SORTED);
        sorted.putAll(map);
        return Object2DoubleSortedMaps.unmodifiable((Object2DoubleSortedMap)sorted);
    }

    public int getHPGain() {
        return this.effects.getOrDefault(RuneCraftoryAttributes.HEALTH_GAIN.asHolder(), 0.0).intValue();
    }

    public int getHpPercentGain() {
        return this.effects.getOrDefault(RuneCraftoryAttributes.HEALTH_GAIN.asHolder(), 0.0).intValue();
    }

    public int getRPRegen() {
        return this.effects.getOrDefault(RuneCraftoryAttributes.RUNE_POINTS_GAIN.asHolder(), 0.0).intValue();
    }

    public int getRpPercentRegen() {
        return this.effectsPercentage.getOrDefault(RuneCraftoryAttributes.RUNE_POINTS_GAIN.asHolder(), 0.0).intValue();
    }

    public int duration() {
        return this.duration;
    }

    public Map<class_6880<class_1320>, Double> effects() {
        return this.effects;
    }

    public Map<class_6880<class_1320>, Double> effectsMultiplier() {
        return this.effectsPercentage;
    }

    public Map<class_6880<class_1320>, Double> cookingBonus() {
        return this.cookingBonus;
    }

    public Map<class_6880<class_1320>, Double> cookingBonusPercent() {
        return this.cookingBonusPercent;
    }

    public List<class_6880<class_1291>> potionHeals() {
        return this.potionRemove;
    }

    public List<SimpleEffect> potionApply() {
        return this.potionApply;
    }

    public List<class_2561> texts(class_1799 stack) {
        class_5250 comp;
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        list.add((class_2561)class_2561.method_43471((String)"runecraftory.tooltip.item.eaten").method_27692(class_124.field_1080));
        Pair<Map<class_6880<class_1320>, Double>, Map<class_6880<class_1320>, Double>> foodStats = ItemComponentUtils.foodStats(stack);
        Map effects = (Map)foodStats.getFirst();
        Map effectsPercent = (Map)foodStats.getSecond();
        ArrayList<class_5250> hpRpGain = new ArrayList<class_5250>();
        ArrayList<class_5250> hpRpIncrease = new ArrayList<class_5250>();
        ArrayList<class_5250> attributes = new ArrayList<class_5250>();
        for (Map.Entry entry : effects.entrySet()) {
            if ((Double)entry.getValue() == 0.0) continue;
            comp = class_2561.method_43469((String)"runecraftory.tooltip.item.attribute", (Object[])new Object[]{class_2561.method_43471((String)((class_1320)((class_6880)entry.getKey()).comp_349()).method_26830()), this.format((Double)entry.getValue())}).method_27692(class_124.field_1075);
            if (((class_6880)entry.getKey()).method_40225(RuneCraftoryAttributes.HEALTH_GAIN.getKey()) || ((class_6880)entry.getKey()).method_40225(RuneCraftoryAttributes.RUNE_POINTS_GAIN.getKey())) {
                hpRpGain.add(comp);
                continue;
            }
            if (((class_6880)entry.getKey()).comp_349() == class_5134.field_23716.comp_349() || ((class_6880)entry.getKey()).method_40225(RuneCraftoryAttributes.MAX_RUNEPOINTS.getKey())) {
                hpRpIncrease.add(comp);
                continue;
            }
            attributes.add(class_5244.method_48320().method_10852((class_2561)comp));
        }
        for (Map.Entry entry : effectsPercent.entrySet()) {
            if ((Double)entry.getValue() == 0.0) continue;
            comp = class_2561.method_43469((String)"runecraftory.tooltip.item.attribute.percentage", (Object[])new Object[]{class_2561.method_43471((String)((class_1320)((class_6880)entry.getKey()).comp_349()).method_26830()), this.format((Double)entry.getValue())}).method_27692(class_124.field_1075);
            if (((class_6880)entry.getKey()).method_40225(RuneCraftoryAttributes.HEALTH_GAIN.getKey()) || ((class_6880)entry.getKey()).method_40225(RuneCraftoryAttributes.RUNE_POINTS_GAIN.getKey())) {
                hpRpGain.add(comp);
                continue;
            }
            if (((class_6880)entry.getKey()).comp_349() == class_5134.field_23716.comp_349() || ((class_6880)entry.getKey()).method_40225(RuneCraftoryAttributes.MAX_RUNEPOINTS.getKey())) {
                hpRpIncrease.add(comp);
                continue;
            }
            attributes.add(class_5244.method_48320().method_10852((class_2561)comp));
        }
        if (!hpRpGain.isEmpty()) {
            list.add((class_2561)class_5244.method_48320().method_10852(class_2564.method_37112(hpRpGain, (class_2561)class_5244.method_48320())));
        }
        if (!hpRpIncrease.isEmpty()) {
            list.add((class_2561)class_5244.method_48320().method_10852(class_2564.method_37112(hpRpIncrease, (class_2561)class_5244.method_48320())));
        }
        list.addAll(attributes);
        return list;
    }

    private String format(double n) {
        return n >= 0.0 ? "+" + (int)n : "" + (int)n;
    }

    public String toString() {
        return "[Duration:" + this.duration + "]{effects:[" + String.valueOf(this.effects) + "], potions:[" + String.valueOf(this.potionRemove) + "]";
    }

    public static class Builder {
        private final Map<class_6880<class_1320>, Double> effects = new HashMap<class_6880<class_1320>, Double>();
        private final Map<class_6880<class_1320>, Double> effectsPercentage = new HashMap<class_6880<class_1320>, Double>();
        private final Map<class_6880<class_1320>, Double> cookingBonus = new HashMap<class_6880<class_1320>, Double>();
        private final Map<class_6880<class_1320>, Double> cookingBonusPercent = new HashMap<class_6880<class_1320>, Double>();
        private final List<SimpleEffect> potionApply = new ArrayList<SimpleEffect>();
        private final List<class_6880<class_1291>> potionRemove = new ArrayList<class_6880<class_1291>>();
        private final int duration;

        public Builder(int duration) {
            this.duration = duration;
        }

        public Builder setHPRegen(int hpRegen, int hpRegenPercent) {
            if (hpRegen != 0) {
                this.effects.put((class_6880<class_1320>)RuneCraftoryAttributes.HEALTH_GAIN.asHolder(), Double.valueOf(hpRegen));
            }
            if (hpRegenPercent != 0) {
                this.effectsPercentage.put((class_6880<class_1320>)RuneCraftoryAttributes.HEALTH_GAIN.asHolder(), Double.valueOf(hpRegenPercent));
            }
            return this;
        }

        public Builder setRPRegen(int rpRegen, int rpRegenPercent) {
            if (rpRegen != 0) {
                this.effects.put((class_6880<class_1320>)RuneCraftoryAttributes.RUNE_POINTS_GAIN.asHolder(), Double.valueOf(rpRegen));
            }
            if (rpRegenPercent != 0) {
                this.effectsPercentage.put((class_6880<class_1320>)RuneCraftoryAttributes.RUNE_POINTS_GAIN.asHolder(), Double.valueOf(rpRegenPercent));
            }
            return this;
        }

        public Builder setRPIncrease(int increase, int percentIncrease) {
            if (increase != 0) {
                this.effects.put((class_6880<class_1320>)RuneCraftoryAttributes.MAX_RUNEPOINTS.asHolder(), Double.valueOf(increase));
            }
            if (percentIncrease != 0) {
                this.effectsPercentage.put((class_6880<class_1320>)RuneCraftoryAttributes.MAX_RUNEPOINTS.asHolder(), Double.valueOf(percentIncrease));
            }
            return this;
        }

        public Builder addEffect(class_6880<class_1320> att, double value) {
            this.effects.put(att, value);
            return this;
        }

        public Builder addEffectPercentage(class_6880<class_1320> att, double value) {
            this.effectsPercentage.put(att, value);
            return this;
        }

        public Builder addCookingBonus(class_6880<class_1320> att, double value) {
            this.cookingBonus.put(att, value);
            return this;
        }

        public Builder addCookingBonusPercent(class_6880<class_1320> att, double value) {
            this.cookingBonusPercent.put(att, value);
            return this;
        }

        public Builder addPotion(class_6880<class_1291> effect, int duration, int amplifier) {
            this.potionApply.add(new SimpleEffect(effect, duration, amplifier));
            return this;
        }

        public Builder curePotion(class_6880<class_1291> effect) {
            this.potionRemove.add(effect);
            return this;
        }

        public FoodProperties build() {
            return new FoodProperties(this.duration, this.effects, this.effectsPercentage, this.cookingBonus, this.cookingBonusPercent, this.potionApply, this.potionRemove);
        }
    }
}

