/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.client.gui.GuiUtils;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.inventory.container.ContainerCrafting;
import io.github.flemmli97.runecraftory.common.network.C2SSelectRecipeCrafting;
import io.github.flemmli97.runecraftory.common.recipes.CraftingType;
import io.github.flemmli97.runecraftory.mixinhelper.GuiGraphicsExtension;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.client.gui.widget.list.SelectableEntry;
import io.github.flemmli97.tenshilib.client.gui.widget.list.SelectableListWidget;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_8710;

public class CraftingGui
extends class_465<ContainerCrafting> {
    private static final class_2960 FORGING = RuneCraftory.modRes("textures/gui/container/forging.png");
    private static final class_2960 CRAFTING = RuneCraftory.modRes("textures/gui/container/crafting.png");
    private static final class_2960 COOKING = RuneCraftory.modRes("textures/gui/container/cooking.png");
    private static final class_2960 CHEMISTRY = RuneCraftory.modRes("textures/gui/container/chemistry.png");
    public static final class_2960 RUNEPOINTS = RuneCraftory.modRes("widget/runepoints_bar");
    public static final class_2960 RUNEPOINTS_BORDER = RuneCraftory.modRes("widget/runepoints_bar_border");
    public static final class_2960 SCROLLBAR = RuneCraftory.modRes("widget/scrollbar");
    public static final class_2960 SCROLLBAR_DISABLED = RuneCraftory.modRes("widget/scrollbar_disabled");
    protected final PlayerData data;
    private final Skills skill;
    private SelectableListWidget recipes;
    private long lastChange;

    public CraftingGui(ContainerCrafting container, class_1661 inv, class_2561 name) {
        super((class_1703)container, inv, name);
        this.field_2792 = 209;
        this.field_2779 = 166;
        this.data = Platform.INSTANCE.getPlayerData(inv.field_7546);
        this.skill = ((ContainerCrafting)this.field_2797).craftingType().skill;
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37067();
        this.setupRecipes();
    }

    protected void setupRecipes() {
        if (this.recipes != null) {
            this.method_37066((class_364)this.recipes);
        }
        ArrayList<RecipeOutputEntry> entries = new ArrayList<RecipeOutputEntry>();
        for (int i = 0; i < ((ContainerCrafting)this.field_2797).getMatchingRecipesClient().result().size(); ++i) {
            entries.add(new RecipeOutputEntry(i));
        }
        this.recipes = new SelectableListWidget(this.field_2776 + 173, this.field_2800 + 13, 29, 140, this.field_22793, entries).setEntryHeight(20, 0).scrollbar(new SelectableListWidget.Scrollbar(SCROLLBAR, SCROLLBAR_DISABLED, 6, 27, 1, 0));
        this.method_37063((class_364)this.recipes);
        this.lastChange = ((ContainerCrafting)this.field_2797).getMatchingRecipesClient().lastChange();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (((ContainerCrafting)this.field_2797).getMatchingRecipesClient().lastChange() != this.lastChange) {
            this.setupRecipes();
        }
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        this.method_2380(graphics, mouseX, mouseY);
    }

    protected void method_2389(class_332 graphics, float partialTick, int mouseX, int mouseY) {
        class_2960 texture = switch (((ContainerCrafting)this.field_2797).craftingType()) {
            default -> throw new MatchException(null, null);
            case CraftingType.FORGE -> FORGING;
            case CraftingType.ACCESSORY_WORKBENCH -> CRAFTING;
            case CraftingType.CHEMISTRY_SET -> CHEMISTRY;
            case CraftingType.COOKING_TABLE -> COOKING;
        };
        graphics.method_25302(texture, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
        if (((ContainerCrafting)this.field_2797).runepointCost() >= 0) {
            int rpMax = this.data.getMaxRunePoints();
            class_5250 cost = class_2561.method_43470((String)("" + ((ContainerCrafting)this.field_2797).runepointCost()));
            if (rpMax < ((ContainerCrafting)this.field_2797).runepointCost() && !this.field_22787.field_1724.method_7337()) {
                cost = class_2561.method_43471((String)"runecraftory.gui.crafting.rpMax.missing").method_27692(class_124.field_1079);
            }
            GuiGraphicsExtension.drawCenteredString(graphics, this.field_22793, (class_2561)cost, (float)(this.field_2776 + 123), (float)(this.field_2800 + 20), 0, false);
        }
        int xPos = this.field_2776;
        int yPos = this.field_2800 - 13;
        int barWidth = 102;
        int runeWidth = Math.min(100, (int)((float)this.data.getRunePoints() / (float)this.data.getMaxRunePoints() * 100.0f));
        graphics.method_52706(RUNEPOINTS_BORDER, xPos, yPos, barWidth, 11);
        GuiUtils.drawBorderedBar(graphics, RUNEPOINTS, xPos, yPos, barWidth, 11, runeWidth, 1, 1);
        GuiGraphicsExtension.drawCenteredString(graphics, this.field_22793, this.data.getRunePoints() + "/" + this.data.getMaxRunePoints(), (float)xPos + (float)(barWidth + 1) * 0.5f, (float)(yPos + 2), 0xFFFFFF, false);
        graphics.method_51439(this.field_22793, (class_2561)class_2561.method_43469((String)"runecraftory.gui.display.level", (Object[])new Object[]{this.data.getSkillLevel(this.skill).getLevel()}), this.field_2776 + this.field_25267 + this.field_22793.method_27525((class_5348)this.field_22785) + 6, this.field_2800 + this.field_25268, 0x404040, false);
    }

    public CraftingType type() {
        return ((ContainerCrafting)this.field_2797).craftingType();
    }

    public void setSelectedRecipe(int index) {
        this.recipes.select(index, false);
    }

    private class RecipeOutputEntry
    implements SelectableEntry {
        private static final class_2960 BUTTON = class_2960.method_60656((String)"widget/button");
        private static final class_2960 HIGHLIGHTED = class_2960.method_60656((String)"widget/button_highlighted");
        private final int index;

        private RecipeOutputEntry(int index) {
            this.index = index;
        }

        public void updateDimensions(int width, int height) {
        }

        public void render(SelectableListWidget widget, class_332 graphics, int mouseX, int mouseY, float partialTick, int x, int y, boolean selected, boolean hovered) {
            if (this.index < ((ContainerCrafting)CraftingGui.this.field_2797).getMatchingRecipesClient().result().size()) {
                graphics.method_52706(hovered || selected ? HIGHLIGHTED : BUTTON, x, y, 22, 20);
                class_1799 stack = ((ContainerCrafting)CraftingGui.this.field_2797).getMatchingRecipesClient().result().get(this.index);
                graphics.method_51427(stack, x + 3, y + 2);
                if (((ContainerCrafting)CraftingGui.this.field_2797).method_34255().method_7960() && hovered) {
                    graphics.method_51437(widget.getFont(), CraftingGui.this.method_51454(stack), stack.method_32347(), mouseX, mouseY);
                }
            }
        }

        public boolean onClick(double relativeMouseX, double relativeMouseY, boolean selected) {
            LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2SSelectRecipeCrafting(this.index));
            return true;
        }
    }
}

