/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.client.render.npc.NPCRender;
import io.github.flemmli97.runecraftory.client.render.npc.NPCTextureLayer;
import io.github.flemmli97.runecraftory.common.network.C2SQuestSelect;
import io.github.flemmli97.runecraftory.common.network.C2SSubmitQuestBoard;
import io.github.flemmli97.runecraftory.common.quests.ClientSideQuestDisplay;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryNPCLooks;
import io.github.flemmli97.runecraftory.mixinhelper.GuiGraphicsExtension;
import io.github.flemmli97.tenshilib.client.gui.widget.TexturedButton;
import io.github.flemmli97.tenshilib.client.gui.widget.list.SelectableEntry;
import io.github.flemmli97.tenshilib.client.gui.widget.list.SelectableListWidget;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_8666;
import net.minecraft.class_8710;

public class QuestGui
extends class_437 {
    protected static final class_2960 BACKGROUND = RuneCraftory.modRes("textures/gui/misc/quest_gui.png");
    protected static final class_2960 POPUP_BACKGROUND = RuneCraftory.modRes("widget/quest_confirmation_popup");
    protected static final class_2960 SCROLLBAR = RuneCraftory.modRes("widget/quest_scrollbar");
    protected static final class_8666 ACCEPT = new class_8666(RuneCraftory.modRes("widget/quest_confirm"), RuneCraftory.modRes("widget/quest_confirm_highlighted"));
    protected static final class_8666 DENY = new class_8666(RuneCraftory.modRes("widget/quest_deny"), RuneCraftory.modRes("widget/quest_deny_highlighted"));
    protected static final class_8666 SUBMIT = new class_8666(RuneCraftory.modRes("widget/quest_submit"), RuneCraftory.modRes("widget/quest_submit_disabled"), RuneCraftory.modRes("widget/quest_submit_highlighted"));
    private final int textureX = 238;
    private final int textureY = 175;
    protected int leftPos;
    protected int topPos;
    protected final List<ClientSideQuestDisplay> quests;
    protected final List<Pair<String, List<Pair<Integer, class_2960>>>> heads;
    private SelectPopup popup;
    private ClientSideQuestDisplay selectedQuest;
    private final boolean hasActive;

    public QuestGui(boolean hasActive, List<ClientSideQuestDisplay> quests) {
        super((class_2561)class_2561.method_43470((String)""));
        this.hasActive = hasActive;
        this.quests = quests;
        this.heads = this.quests.stream().map(display -> {
            ArrayList<Pair> textures = new ArrayList<Pair>();
            if (display.features() != null) {
                for (NPCTextureLayer.LayerType layerType : NPCTextureLayer.LayerType.values()) {
                    class_2960 text = NPCRender.getTextureFromLook(display.features(), display.features().view.containsKey(RuneCraftoryNPCLooks.SLIM.get()), layerType, null);
                    if (text.equals((Object)NPCRender.EMPTY)) continue;
                    textures.add(Pair.of((Object)NPCTextureLayer.setColor(display.features(), layerType), (Object)text));
                }
            }
            return Pair.of((Object)display.npcSkin(), textures);
        }).toList();
    }

    protected void method_25426() {
        super.method_25426();
        this.leftPos = (this.field_22789 - this.textureX) / 2;
        this.topPos = (this.field_22790 - this.textureY) / 2;
        ((SubmitButton)this.method_37063((class_364)new SubmitButton((int)(this.leftPos + 238), (int)(this.topPos + 153), (int)20, (int)22))).field_22763 = this.hasActive;
        ArrayList<QuestEntry> entries = new ArrayList<QuestEntry>();
        for (int i = 0; i < this.quests.size(); ++i) {
            entries.add(new QuestEntry(i));
        }
        this.method_37063((class_364)new SelectableListWidget(this.leftPos + 14, this.topPos + 14, 210, 147, this.field_22793, entries).withPadding(21).scrollbar(new SelectableListWidget.Scrollbar(SCROLLBAR, SCROLLBAR, 12, 21, 2, 0)));
        this.popup = new SelectPopup(this.leftPos, this.topPos, () -> {
            LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2SQuestSelect(this.selectedQuest.id(), this.selectedQuest.active()));
            class_310.method_1551().method_1507(null);
        }, () -> {
            this.selectedQuest = null;
        });
        this.method_37060(this.popup);
    }

    public void method_25420(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        super.method_25420(graphics, mouseX, mouseY, partialTick);
        graphics.method_25302(BACKGROUND, this.leftPos, this.topPos, 0, 0, this.textureX, this.textureY);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.popup.active = this.selectedQuest != null;
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.popup.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.selectedQuest != null) {
            return false;
        }
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        return true;
    }

    public void method_25432() {
        super.method_25432();
        LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2SQuestSelect());
    }

    protected void selectQuest(int index) {
        this.selectedQuest = this.quests.get(index);
    }

    private static class SubmitButton
    extends TexturedButton {
        public SubmitButton(int x, int y, int width, int height) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), b -> {
                LoaderNetwork.INSTANCE.sendToServer((class_8710)C2SSubmitQuestBoard.INSTANCE);
                class_310.method_1551().method_1507(null);
            });
            this.withSprite(SUBMIT);
        }

        protected void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
            super.method_48579(graphics, mouseX, mouseY, partialTick);
            if (this.method_49606() && this.method_37303()) {
                graphics.method_51438(class_310.method_1551().field_1772, (class_2561)class_2561.method_43471((String)"runecraftory.gui.quest.submit.button"), mouseX, mouseY);
            }
        }
    }

    private class QuestEntry
    implements SelectableEntry {
        private final int index;

        private QuestEntry(int index) {
            this.index = index;
        }

        public void updateDimensions(int width, int height) {
        }

        public void render(SelectableListWidget widget, class_332 graphics, int mouseX, int mouseY, float partialTick, int x, int y, boolean selected, boolean hovered) {
            if (this.index < QuestGui.this.quests.size()) {
                boolean shouldHighlight;
                boolean bl = shouldHighlight = hovered && QuestGui.this.selectedQuest == null;
                if (shouldHighlight) {
                    graphics.method_52706(RuneCraftory.modRes("widget/quest_entry_background"), x, y, 198, 21);
                }
                ClientSideQuestDisplay display = QuestGui.this.quests.get(this.index);
                Pair<String, List<Pair<Integer, class_2960>>> head = QuestGui.this.heads.get(this.index);
                int offset = NPCRender.renderForTooltip(graphics, x + 2, y + 2, (String)head.getFirst(), (List)head.getSecond()) ? 18 : 0;
                graphics.method_51439(widget.getFont(), display.task(), x + 2 + offset, y + 6, display.active() ? 5341699 : 0, false);
                if (shouldHighlight && !display.description().isEmpty()) {
                    graphics.method_51437(widget.getFont(), display.description(), Optional.empty(), mouseX, mouseY);
                }
            }
        }

        public boolean onClick(double relativeMouseX, double relativeMouseY, boolean selected) {
            QuestGui.this.selectQuest(this.index);
            return true;
        }
    }

    private class SelectPopup
    implements class_4068 {
        private final int leftPos;
        private final int topPos;
        private final class_339 yesButton;
        private final class_339 noButton;
        private boolean active;

        public SelectPopup(int leftPos, int topPos, Runnable acceptCallback, Runnable denyCallback) {
            this.leftPos = leftPos;
            this.topPos = topPos;
            this.yesButton = new TexturedButton(this.leftPos + 57, this.topPos + 92, 44, 22, (class_2561)class_2561.method_43471((String)"runecraftory.generic.yes"), b -> acceptCallback.run()).withSprite(ACCEPT);
            this.noButton = new TexturedButton(this.leftPos + 137, this.topPos + 92, 44, 22, (class_2561)class_2561.method_43471((String)"runecraftory.generic.no"), b -> denyCallback.run()).withSprite(DENY);
        }

        public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
            if (!this.active) {
                return;
            }
            graphics.method_52706(RuneCraftory.modRes("widget/quest_confirmation_popup"), this.leftPos + 52, this.topPos + 56, 134, 63);
            GuiGraphicsExtension.drawCenteredString(graphics, QuestGui.this.field_22793, (class_2561)(QuestGui.this.selectedQuest.active() ? class_2561.method_43471((String)"runecraftory.gui.quests.reset").method_27692(class_124.field_1061) : class_2561.method_43471((String)"runecraftory.gui.quests.accept")), (float)(this.leftPos + 52) + 67.0f, (float)(this.topPos + 56 + 8), 0, false);
            this.yesButton.method_25394(graphics, mouseX, mouseY, partialTick);
            this.noButton.method_25394(graphics, mouseX, mouseY, partialTick);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (!this.active) {
                return false;
            }
            return this.yesButton.method_25402(mouseX, mouseY, button) || this.noButton.method_25402(mouseX, mouseY, button);
        }
    }
}

