/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.client.TransformationHelper;
import io.github.flemmli97.runecraftory.common.attachment.AttackActionHandler;
import io.github.flemmli97.runecraftory.mixinhelper.HumanoidMainHand;
import io.github.flemmli97.tenshilib.client.data.GeoAnimationManager;
import io.github.flemmli97.tenshilib.client.data.GeoModelManager;
import io.github.flemmli97.tenshilib.client.data.ReloadableCache;
import io.github.flemmli97.tenshilib.client.model.BedrockAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartsContainer;
import io.github.flemmli97.tenshilib.client.model.PoseExtended;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5603;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_630;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3fc;
import org.joml.Vector3f;

public class AnimatedPlayerModel<T extends class_1309>
extends class_583<T>
implements ExtendedModel {
    public static final class_2960 LOCATION = RuneCraftory.modRes("player");
    protected final ReloadableCache<ModelPartsContainer> model = GeoModelManager.getInstance().getModel(LOCATION, model -> {
        this.head = model.getPart("Head");
        this.body = model.getPart("Body");
        this.rightArm = model.getPart("RightArm");
        this.rightArmItem = model.getPart("RightItemRoot");
        this.leftArm = model.getPart("LeftArm");
        this.leftArmItem = model.getPart("LeftItemRoot");
        this.rightLeg = model.getPart("RightLeg");
        this.leftLeg = model.getPart("LeftLeg");
    });
    protected final ReloadableCache<BedrockAnimations> anim = GeoAnimationManager.getInstance().getAnimation(LOCATION);
    protected ModelPartsContainer.ModelPartExtended head;
    protected ModelPartsContainer.ModelPartExtended body;
    protected ModelPartsContainer.ModelPartExtended rightArm;
    protected ModelPartsContainer.ModelPartExtended rightArmItem;
    protected ModelPartsContainer.ModelPartExtended leftArm;
    protected ModelPartsContainer.ModelPartExtended leftArmItem;
    protected ModelPartsContainer.ModelPartExtended rightLeg;
    protected ModelPartsContainer.ModelPartExtended leftLeg;

    public void method_2828(class_4587 poseStack, class_4588 buffer, int packedLight, int packedOverlay, int color) {
        this.leftArmItem.visible = false;
        this.rightArmItem.visible = false;
        this.getModel().getRoot().render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public boolean setUpModel(class_1309 entity, @Nullable class_572<?> model, @Nullable AttackActionHandler handler, float partialTicks) {
        if (model != null) {
            HumanoidMainHand hands = (HumanoidMainHand)model;
            hands.runecraftory$getLeftHandItem().resetAll();
            hands.runecraftory$getRightHandItem().resetAll();
        }
        if (entity instanceof AnimatedEntity) {
            AnimatedEntity animated = (AnimatedEntity)entity;
            this.setup(model);
            return ((BedrockAnimations)this.anim.get()).doAnimation((ExtendedModel)this, animated.getAnimationHandler(), partialTicks, entity.method_6068() == class_1306.field_6182);
        }
        if (handler == null) {
            return false;
        }
        this.setup(model);
        return this.doAnimation(handler, partialTicks, entity.method_6068() == class_1306.field_6182);
    }

    private void setup(@Nullable class_572<?> model) {
        if (model == null) {
            this.body.resetAll();
            return;
        }
        class_5603 body = model.field_3391.method_32084();
        this.getModel().resetPoses();
        this.body.loadPose(body);
        this.leftArm.loadPose(TransformationHelper.withoutParent(body, model.field_27433.method_32084()));
        this.rightArm.loadPose(TransformationHelper.withoutParent(body, model.field_3401.method_32084()));
        this.leftLeg.loadPose(TransformationHelper.withoutParent(body, model.field_3397.method_32084()));
        this.rightLeg.loadPose(TransformationHelper.withoutParent(body, model.field_3392.method_32084()));
        this.head.loadPose(TransformationHelper.withoutParent(body, model.field_3398.method_32084()));
    }

    private boolean doAnimation(AttackActionHandler handler, float partialTicks, boolean mirror) {
        AnimationState current = handler.getAnimation();
        AnimationState last = handler.getLastAnimation();
        float interpolationLast = handler.getLastTransitionProgress(partialTicks);
        float interpolation = handler.getCurrentTransitionProgress(partialTicks);
        boolean changed = false;
        if (last != null && interpolationLast > 0.0f) {
            changed = ((BedrockAnimations)this.anim.get()).doAnimation((ExtendedModel)this, last.getAnimation(), last.getTick(partialTicks), interpolationLast, mirror, false);
        }
        if (current != null && ((BedrockAnimations)this.anim.get()).doAnimation((ExtendedModel)this, current.getAnimation(), current.getTick(partialTicks), interpolation, mirror, false) && !changed) {
            changed = true;
        }
        return changed;
    }

    public void copyTo(class_572<?> model) {
        HumanoidMainHand hands = (HumanoidMainHand)model;
        if (model.field_3449) {
            this.body.x = this.body.getDefaultPose().x;
            this.body.y = this.body.getDefaultPose().y;
            this.body.z = this.body.getDefaultPose().z;
            class_4587 stack = new class_4587();
            this.body.translateAndRotate(stack);
            float bodyLength = -12.0f;
            Vector3f v = new Vector3f(0.0f, bodyLength, 0.0f);
            v.mulTranspose((Matrix3fc)stack.method_23760().method_23762());
            this.body.x += v.x();
            this.body.y += v.y() - bodyLength;
            this.body.z += v.z();
        }
        PoseExtended body = this.body.extendedPose();
        model.field_3391.method_32085(body.asPartPose());
        this.apply(model.field_3398, body, this.head);
        this.apply(model.field_27433, body, this.leftArm);
        hands.runecraftory$getLeftHandItem().loadPose(this.leftArmItem.storePose());
        this.apply(model.field_3401, body, this.rightArm);
        hands.runecraftory$getRightHandItem().loadPose(this.rightArmItem.storePose());
        if (!model.field_3449) {
            this.apply(model.field_3397, body, this.leftLeg);
            this.apply(model.field_3392, body, this.rightLeg);
        }
        model.field_3394.method_17138(model.field_3398);
    }

    public ModelPartsContainer getModel() {
        return (ModelPartsContainer)this.model.get();
    }

    private void apply(class_630 model, PoseExtended body, ModelPartsContainer.ModelPartExtended first) {
        model.method_32085(TransformationHelper.withParent(body, first.storePose()));
    }
}

