/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render;

import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.tenshilib.client.render.RenderUtils;
import io.github.flemmli97.tenshilib.client.render.layer.RiderEntityLayer;
import java.util.Random;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_7833;
import net.minecraft.class_922;
import net.minecraft.class_927;

public class RenderMonster<T extends BaseMonster, M extends class_583<T>>
extends class_927<T, M> {
    private final class_2960 tex;
    private final Random random = new Random();
    private final RenderUtils.BeamBuilder builder = RenderMonster.create();

    public RenderMonster(class_5617.class_5618 ctx, M model, class_2960 texture, float shadow) {
        this(ctx, model, texture, shadow, true);
    }

    public RenderMonster(class_5617.class_5618 ctx, M model, class_2960 texture, float shadow, boolean withDefaultRiderLayer) {
        super(ctx, model, shadow);
        this.tex = texture;
        if (withDefaultRiderLayer) {
            this.field_4738.add(new RiderEntityLayer((class_922)this));
        }
    }

    private static RenderUtils.BeamBuilder create() {
        RenderUtils.BeamBuilder beam = new RenderUtils.BeamBuilder();
        beam.setEndColor(5293552);
        return beam;
    }

    public void render(T entity, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight) {
        super.method_4054(entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        if (((BaseMonster)entity).deathRays() > 0) {
            poseStack.method_22903();
            poseStack.method_22904(0.0, ((BaseMonster)entity).deathRayOffset(), 0.0);
            this.random.setSeed(entity.method_5667().getLeastSignificantBits());
            for (int i = 0; i < ((BaseMonster)entity).deathRays(); ++i) {
                poseStack.method_22907(class_7833.field_40714.rotationDegrees(this.random.nextFloat() * 360.0f));
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(this.random.nextFloat() * 360.0f));
                poseStack.method_22907(class_7833.field_40718.rotationDegrees(this.random.nextFloat() * 360.0f));
                RenderUtils.renderGradientBeam3d((class_4587)poseStack, (class_4597)buffer, (float)(entity.method_17681() + 3.0f), (float)1.0f, (RenderUtils.BeamBuilder)this.builder);
            }
            poseStack.method_22909();
        }
    }

    protected void setupRotations(T entity, class_4587 stack, float ageInTicks, float rotationYaw, float partialTicks, float scale) {
        super.method_4058(entity, stack, ageInTicks, rotationYaw, partialTicks, scale);
        if (((BaseMonster)entity).getPlayDeathTick() > 0 && ((BaseMonster)entity).getDeathAnimation() == null) {
            float f;
            float f2 = ((float)((BaseMonster)entity).getPlayDeathTick() + (((BaseMonster)entity).playDeath() ? partialTicks : -partialTicks)) / 20.0f * 1.6f;
            f2 = class_3532.method_15355((float)f2);
            if (f > 1.0f) {
                f2 = 1.0f;
            }
            stack.method_22904(0.0, (double)f2 * 0.1, (double)(-f2 * entity.method_17682()) * 0.5);
            stack.method_22907(class_7833.field_40714.rotationDegrees(f2 * this.getFlipDegrees(entity)));
        }
    }

    protected float getFlipDegrees(T entity) {
        return ((BaseMonster)entity).getDeathAnimation() != null ? 0.0f : super.method_4039(entity);
    }

    public boolean shouldRender(T entity, class_4604 camera, double camX, double camY, double camZ) {
        if (((BaseMonster)entity).getPlayDeathTick() > 0 && !((BaseMonster)entity).playDeath()) {
            if (((BaseMonster)entity).getPlayDeathTick() > 8 && ((BaseMonster)entity).getPlayDeathTick() % 2 == 0) {
                return false;
            }
            if (((BaseMonster)entity).getPlayDeathTick() % 3 == 0) {
                return false;
            }
        }
        return super.method_3933(entity, camera, camX, camY, camZ);
    }

    public class_2960 getTextureLocation(T entity) {
        return this.tex;
    }
}

