/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render.npc;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.client.render.npc.NPCRender;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.entities.npc.features.BlushFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.FaceFeaturesType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.HairFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.IndexedColorSettingType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.NPCFeatureContainer;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryNPCLooks;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import net.minecraft.class_5601;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_922;
import org.jetbrains.annotations.Nullable;

public class NPCTextureLayer<T extends NPCEntity, M extends class_572<T>, A extends class_591<T>>
extends class_3887<T, M> {
    private final A model;
    private final A slimModel;
    protected LayerType layer;

    public NPCTextureLayer(class_3883<T, M> renderer, A model, A slimModel, LayerType layer) {
        super(renderer);
        this.model = model;
        this.slimModel = slimModel;
        this.layer = layer;
    }

    public static int setColor(NPCFeatureContainer features, LayerType layer) {
        int color = switch (layer.ordinal()) {
            case 0 -> {
                Record feat = (IndexedColorSettingType.IndexedColorFeature)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.SKIN.get());
                if (feat == null) {
                    yield 14008231;
                }
                yield ((IndexedColorSettingType.IndexedColorFeature)feat).color();
            }
            case 2 -> {
                Record feat = (FaceFeaturesType.FaceFeatures)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.FACE.get());
                if (feat == null || ((FaceFeaturesType.FaceFeatures)feat).iris() == null) {
                    yield 0;
                }
                yield ((FaceFeaturesType.FaceFeatures)feat).iris().color();
            }
            case 3 -> {
                Record feat = (FaceFeaturesType.FaceFeatures)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.FACE.get());
                if (feat == null || ((FaceFeaturesType.FaceFeatures)feat).sclera() == null) {
                    yield 0;
                }
                yield ((FaceFeaturesType.FaceFeatures)feat).sclera().color();
            }
            case 4 -> {
                Record feat = (FaceFeaturesType.FaceFeatures)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.FACE.get());
                if (feat == null || ((FaceFeaturesType.FaceFeatures)feat).eyebrow() == null) {
                    yield 0;
                }
                yield ((FaceFeaturesType.FaceFeatures)feat).eyebrow().color();
            }
            case 5 -> {
                Record feat = (BlushFeatureType.BlushFeature)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.BLUSH.get());
                if (feat == null) {
                    yield 0xFFFFFF;
                }
                yield ((BlushFeatureType.BlushFeature)feat).color();
            }
            case 6 -> {
                Record feat = (HairFeatureType.HairFeature)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.HAIR.get());
                if (feat == null) {
                    yield 0xFFFFFF;
                }
                yield ((HairFeatureType.HairFeature)feat).color();
            }
            default -> 0xFFFFFF;
        };
        int a = 255;
        if (layer == LayerType.BLUSH_LAYER) {
            a = 88;
        }
        return a << 24 | color;
    }

    public void render(class_4587 poseStack, class_4597 buffer, int packedLight, T npc, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        A layerModel = this.getModel(npc);
        this.setup(layerModel);
        this.actualRender(poseStack, buffer, packedLight, npc, layerModel);
    }

    protected A getModel(T npc) {
        return NPCRender.isSlim(npc) ? this.slimModel : this.model;
    }

    protected void setup(A layerModel) {
        ((class_572)this.method_17165()).method_2818(layerModel);
        ((class_591)layerModel).field_3482.method_17138(((class_572)this.method_17165()).field_3397);
        ((class_591)layerModel).field_3479.method_17138(((class_572)this.method_17165()).field_3392);
        ((class_591)layerModel).field_3484.method_17138(((class_572)this.method_17165()).field_27433);
        ((class_591)layerModel).field_3486.method_17138(((class_572)this.method_17165()).field_3401);
        ((class_591)layerModel).field_3483.method_17138(((class_572)this.method_17165()).field_3391);
        this.setPartVisibility(layerModel);
    }

    protected void actualRender(class_4587 poseStack, class_4597 buffer, int packedLight, T npc, A layerModel) {
        boolean bl3;
        boolean bl2;
        class_310 mc = class_310.method_1551();
        boolean bl = !npc.method_5767();
        class_1921 renderType = this.getRenderType(npc, layerModel, bl, bl2 = !bl && !npc.method_5756((class_1657)mc.field_1724), bl3 = mc.method_27022(npc));
        if (renderType != null) {
            class_4588 vertexConsumer = buffer.getBuffer(renderType);
            int m = class_922.method_23622(npc, (float)0.0f);
            int color = this.setColor(npc);
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            layerModel.method_2828(poseStack, vertexConsumer, packedLight, m, class_5253.class_5254.method_59554((float)(a * (bl2 ? 0.15f : 1.0f)), (float)r, (float)g, (float)b));
        }
    }

    @Nullable
    protected class_1921 getRenderType(T entity, A model, boolean bodyVisible, boolean translucent, boolean glowing) {
        class_2960 resourceLocation;
        if (((NPCEntity)entity).getPlayDeathTick() > 0 && !((NPCEntity)entity).playDeath()) {
            if (((NPCEntity)entity).getPlayDeathTick() > 8 && ((NPCEntity)entity).getPlayDeathTick() % 2 == 0) {
                return null;
            }
            if (((NPCEntity)entity).getPlayDeathTick() % 3 == 0) {
                return null;
            }
        }
        if ((resourceLocation = this.getTexture(entity)).equals((Object)NPCRender.EMPTY)) {
            return null;
        }
        if (translucent) {
            return class_1921.method_29379((class_2960)resourceLocation);
        }
        if (bodyVisible) {
            return model.method_23500(resourceLocation);
        }
        if (glowing) {
            return class_1921.method_23287((class_2960)resourceLocation);
        }
        return null;
    }

    protected int setColor(T entity) {
        return NPCTextureLayer.setColor(((NPCEntity)entity).lookFeatures, this.layer);
    }

    protected class_2960 getTexture(T entity) {
        return NPCRender.getTextureFromLook(entity, this.layer, null);
    }

    protected void setPartVisibility(A model) {
        model.method_2805(false);
        ((class_591)model).field_3398.field_3665 = true;
        ((class_591)model).field_3394.field_3665 = true;
        switch (this.layer.ordinal()) {
            case 0: 
            case 1: {
                model.method_2805(true);
            }
            case 6: {
                ((class_591)model).field_3391.field_3665 = true;
                ((class_591)model).field_3483.field_3665 = true;
                ((class_591)model).field_3401.field_3665 = true;
                ((class_591)model).field_3486.field_3665 = true;
                ((class_591)model).field_27433.field_3665 = true;
                ((class_591)model).field_3484.field_3665 = true;
            }
        }
    }

    public static enum LayerType {
        SKIN_LAYER("skin", 0.0f),
        OUTFIT_LAYER("outft", 0.005f),
        IRIS_LAYER("eyes", 0.006f),
        SCLERA_LAYER(null, 0.007f),
        EYEBROWS_LAYER(null, 0.008f),
        BLUSH_LAYER("blush", 0.009f),
        HAIR_LAYER("hair", 0.5f),
        HAT_LAYER("hats", 0.8f);

        public final class_5601 location;
        public final class_5601 slimLocation;
        public final float expand;

        private LayerType(String name, float expand) {
            this.location = name == null ? null : new class_5601(RuneCraftory.modRes("npc_" + name), "main");
            this.slimLocation = name == null ? null : new class_5601(RuneCraftory.modRes("npc_slim_" + name), "main");
            this.expand = expand;
        }
    }
}

