/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attachment.player;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.api.datapack.FoodProperties;
import io.github.flemmli97.runecraftory.api.datapack.ShopItemProperties;
import io.github.flemmli97.runecraftory.api.datapack.SkillProperties;
import io.github.flemmli97.runecraftory.api.registry.NPCProfession;
import io.github.flemmli97.runecraftory.common.advancements.LevelTrigger;
import io.github.flemmli97.runecraftory.common.advancements.MoneyTrigger;
import io.github.flemmli97.runecraftory.common.advancements.SkillLevelTrigger;
import io.github.flemmli97.runecraftory.common.attachment.player.DailyPlayerUpdater;
import io.github.flemmli97.runecraftory.common.attachment.player.EntitySelector;
import io.github.flemmli97.runecraftory.common.attachment.player.EntityStatsTracker;
import io.github.flemmli97.runecraftory.common.attachment.player.Party;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerWeaponHandler;
import io.github.flemmli97.runecraftory.common.attachment.player.RecipeKeeper;
import io.github.flemmli97.runecraftory.common.attachment.player.WalkingTracker;
import io.github.flemmli97.runecraftory.common.attachment.player.XpLevelHolder;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.inventory.InventoryShippingBin;
import io.github.flemmli97.runecraftory.common.inventory.InventorySpells;
import io.github.flemmli97.runecraftory.common.items.tools.ItemStatIncrease;
import io.github.flemmli97.runecraftory.common.lib.LibConstants;
import io.github.flemmli97.runecraftory.common.network.S2CFoodPkt;
import io.github.flemmli97.runecraftory.common.network.S2CLevelPkt;
import io.github.flemmli97.runecraftory.common.network.S2CMoney;
import io.github.flemmli97.runecraftory.common.network.S2CRunePoints;
import io.github.flemmli97.runecraftory.common.network.S2CSkillLevelPkt;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryCriteria;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEffects;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryNPCProfessions;
import io.github.flemmli97.runecraftory.common.utils.DamageSourceUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.mixin.AttributeMapAccessor;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3738;
import net.minecraft.class_5134;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8710;

public class PlayerData {
    private final class_1657 player;
    private boolean starting;
    private double runePoints;
    private final XpLevelHolder level = new XpLevelHolder();
    private final EnumMap<Skills, XpLevelHolder> skillLevels = new EnumMap(Skills.class);
    private int money = GeneralConfig.startingMoney;
    private final RecipeKeeper keeper = new RecipeKeeper();
    private final InventoryShippingBin shippingBin = new InventoryShippingBin();
    private final Map<class_1792, ShippedItemData> shippedItems = new HashMap<class_1792, ShippedItemData>();
    private final Map<NPCProfession, class_2371<class_1799>> shopItems = new HashMap<NPCProfession, class_2371<class_1799>>();
    private final InventorySpells spells = new InventorySpells();
    private final DailyPlayerUpdater updater = new DailyPlayerUpdater(this);
    private class_6880<class_1792> lastEaten;
    private int foodDuration;
    private final WalkingTracker walkingTracker = new WalkingTracker();
    public final EntityStatsTracker entityStatsTracker = new EntityStatsTracker();
    public final Party party = new Party();
    private int craftingSeed;
    private int boughtBarns;
    private int mobLevelIncrease;
    private final PlayerWeaponHandler weaponHandler;
    public final EntitySelector entitySelector = new EntitySelector();
    private class_2338 blockBreakPosForMsg;
    private int breakTick;
    private int rpStillRegen;

    public PlayerData(class_1657 player) {
        this.player = player;
        for (Skills skill : Skills.values()) {
            this.skillLevels.put(skill, new XpLevelHolder());
        }
        this.weaponHandler = new PlayerWeaponHandler(player);
    }

    public class_1657 player() {
        return this.player;
    }

    public void onJoin() {
        this.recalculateStats(false);
        this.updateConfigAttributes();
        if (!this.starting) {
            this.starting = true;
            this.player.method_6033(this.player.method_6063());
            this.setRunePoints((int)this.player.method_45325(RuneCraftoryAttributes.MAX_RUNEPOINTS.asHolder()));
        }
    }

    private void setForVitality(class_2960 modifier, double value, AttributeUpdate update) {
        this.setAttributeValue((class_6880<class_1320>)RuneCraftoryAttributes.DEFENCE.asHolder(), modifier, value * 0.5, update);
        this.setAttributeValue((class_6880<class_1320>)RuneCraftoryAttributes.MAGIC_DEFENCE.asHolder(), modifier, value * 0.5, update);
    }

    private void setFoodBonus(Pair<Map<class_6880<class_1320>, Double>, Map<class_6880<class_1320>, Double>> bonus) {
        ((Map)bonus.getFirst()).forEach((att, val) -> this.setAttributeValue((class_6880<class_1320>)att, LibConstants.FOOD_MODIFIER, (double)val, AttributeUpdate.REPLACE));
        ((Map)bonus.getSecond()).forEach((att, val) -> {
            class_1324 instance = this.player.method_5996(att);
            AttributeUpdate.REPLACE.modify(instance, LibConstants.FOOD_MODIFIER_MULTI, (double)val, class_1322.class_1323.field_6331);
        });
    }

    private void setAttributeValue(class_6880<class_1320> attribute, class_2960 modifier, double value, AttributeUpdate update) {
        class_1324 instance = this.player.method_5996(attribute);
        if (instance == null) {
            return;
        }
        update.modify(instance, modifier, value);
    }

    private void updateConfigAttributes() {
        this.setAttributeValue((class_6880<class_1320>)class_5134.field_23716, LibConstants.PLAYER_CONFIG_MODIFIER, GeneralConfig.startingHealth, AttributeUpdate.ABSOLUTE);
        this.setAttributeValue((class_6880<class_1320>)RuneCraftoryAttributes.MAX_RUNEPOINTS.asHolder(), LibConstants.PLAYER_CONFIG_MODIFIER, GeneralConfig.startingRp, AttributeUpdate.ABSOLUTE);
        this.setAttributeValue((class_6880<class_1320>)class_5134.field_23721, LibConstants.PLAYER_CONFIG_MODIFIER, GeneralConfig.startingStr, AttributeUpdate.ABSOLUTE);
        this.setForVitality(LibConstants.PLAYER_CONFIG_MODIFIER, GeneralConfig.startingVit, AttributeUpdate.ABSOLUTE);
        this.setAttributeValue((class_6880<class_1320>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder(), LibConstants.PLAYER_CONFIG_MODIFIER, GeneralConfig.startingIntel, AttributeUpdate.ABSOLUTE);
    }

    private void updateLevelAttributes() {
        int lvl = this.level.getLevel() - 1;
        this.setAttributeValue((class_6880<class_1320>)class_5134.field_23716, LibConstants.PLAYER_LEVEL_MODIFIER, GeneralConfig.hpPerLevel * (float)lvl, AttributeUpdate.REPLACE);
        this.setAttributeValue((class_6880<class_1320>)RuneCraftoryAttributes.MAX_RUNEPOINTS.asHolder(), LibConstants.PLAYER_LEVEL_MODIFIER, GeneralConfig.rpPerLevel * (float)lvl, AttributeUpdate.REPLACE);
        this.setAttributeValue((class_6880<class_1320>)class_5134.field_23721, LibConstants.PLAYER_LEVEL_MODIFIER, GeneralConfig.strPerLevel * (float)lvl, AttributeUpdate.REPLACE);
        this.setForVitality(LibConstants.PLAYER_LEVEL_MODIFIER, GeneralConfig.vitPerLevel * (float)lvl, AttributeUpdate.REPLACE);
        this.setAttributeValue((class_6880<class_1320>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder(), LibConstants.PLAYER_LEVEL_MODIFIER, GeneralConfig.intPerLevel * (float)lvl, AttributeUpdate.REPLACE);
    }

    private void updateSkillLevelAttributes() {
        this.setAttributeValue((class_6880<class_1320>)class_5134.field_23716, LibConstants.PLAYER_SKILL_LEVEL_MODIFIER, this.skillVal(SkillProperties::healthIncrease), AttributeUpdate.REPLACE);
        this.setAttributeValue((class_6880<class_1320>)RuneCraftoryAttributes.MAX_RUNEPOINTS.asHolder(), LibConstants.PLAYER_SKILL_LEVEL_MODIFIER, this.skillVal(SkillProperties::rpIncrease), AttributeUpdate.REPLACE);
        this.setAttributeValue((class_6880<class_1320>)class_5134.field_23721, LibConstants.PLAYER_SKILL_LEVEL_MODIFIER, this.skillVal(SkillProperties::strIncrease), AttributeUpdate.REPLACE);
        this.setForVitality(LibConstants.PLAYER_SKILL_LEVEL_MODIFIER, this.skillVal(SkillProperties::vitIncrease), AttributeUpdate.REPLACE);
        this.setAttributeValue((class_6880<class_1320>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder(), LibConstants.PLAYER_SKILL_LEVEL_MODIFIER, this.skillVal(SkillProperties::intelIncrease), AttributeUpdate.REPLACE);
    }

    private void clearAtributeModifier(class_6880<class_1320> attribute, class_2960 modifier) {
        class_1324 instance = this.player.method_5996(attribute);
        if (instance == null) {
            return;
        }
        instance.method_6200(modifier);
    }

    private void clearAllAtributeModifier(class_2960 modifier) {
        ((AttributeMapAccessor)this.player.method_6127()).getAttributes().forEach((att, inst) -> inst.method_6200(modifier));
    }

    public int getRunePoints() {
        return (int)this.runePoints;
    }

    public int getMaxRunePoints() {
        return (int)this.player.method_45325(RuneCraftoryAttributes.MAX_RUNEPOINTS.asHolder());
    }

    public boolean useRunePoints(int amount, boolean damage) {
        if (!GeneralConfig.useRp && !this.player.method_37908().field_9236) {
            return true;
        }
        if (!this.player.method_7337()) {
            if (this.player.method_6059(RuneCraftoryEffects.FATIGUE.asHolder())) {
                amount *= 2;
            }
            if (this.runePoints >= (double)amount) {
                this.runePoints -= (double)amount;
            } else if (damage) {
                int diff = amount - this.getRunePoints();
                this.runePoints = 0.0;
                if (!this.player.method_37908().field_9236) {
                    int invul = this.player.field_6008;
                    this.player.field_6008 = 10;
                    boolean res = this.player.method_5643(DamageSourceUtils.exhaust(this.player.method_37908()), Math.min(this.player.method_6063() * 0.25f, (float)(diff * 2)));
                    this.player.field_6008 = res ? 10 : invul;
                }
            } else {
                return false;
            }
            this.rpStillRegen = 200;
            class_1657 class_16572 = this.player;
            if (class_16572 instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_16572;
                LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2CRunePoints(this), serverPlayer);
            }
            return true;
        }
        return true;
    }

    public void regenRunePoints(int amount) {
        if (amount <= 0) {
            return;
        }
        this.runePoints = class_3532.method_15350((double)(this.runePoints + (double)amount), (double)0.0, (double)this.getMaxRunePoints());
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2CRunePoints(this), serverPlayer);
        }
    }

    public void setRunePoints(int amount) {
        this.runePoints = amount;
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2CRunePoints(this), serverPlayer);
        }
    }

    public int getMoney() {
        return this.money;
    }

    public boolean useMoney(int amount) {
        if (this.money >= amount) {
            this.money -= amount;
            class_1657 class_16572 = this.player;
            if (class_16572 instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_16572;
                LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2CMoney(this), serverPlayer);
            }
            return true;
        }
        return false;
    }

    public void giveMoney(int amount) {
        this.setMoney(this.getMoney() + amount);
    }

    public void setMoney(int amount) {
        this.money = amount;
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            ((MoneyTrigger)((Object)RuneCraftoryCriteria.MONEY_TRIGGER.get())).trigger(serverPlayer);
            LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2CMoney(this), serverPlayer);
        }
    }

    public XpLevelHolder getPlayerLevel() {
        return this.level;
    }

    public void setPlayerLevel(int level, float xpAmount, boolean recalc) {
        this.level.setLevel(class_3532.method_15340((int)level, (int)1, (int)GeneralConfig.maxLevel), LevelCalc::xpAmountForLevelUp);
        this.level.setXp(class_3532.method_15363((float)xpAmount, (float)0.0f, (float)LevelCalc.xpAmountForLevelUp(level)));
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            if (recalc) {
                this.recalculateStats(true);
            } else {
                LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2CLevelPkt(this), serverPlayer);
            }
        }
    }

    public void addXp(float amount) {
        class_1657 class_16572;
        if (this.level.getLevel() >= GeneralConfig.maxLevel) {
            return;
        }
        boolean levelUp = this.level.addXP(amount, GeneralConfig.maxLevel, LevelCalc::xpAmountForLevelUp, this::handleLevelStatUpdate);
        if (levelUp) {
            this.player.method_37908().method_8396(null, this.player.method_24515(), class_3417.field_14709, class_3419.field_15248, 1.0f, 0.5f);
        }
        if ((class_16572 = this.player) instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            if (levelUp) {
                ((LevelTrigger)((Object)RuneCraftoryCriteria.LEVEL_TRIGGER.get())).trigger(serverPlayer);
            }
            LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2CLevelPkt(this), serverPlayer);
        }
    }

    private void handleLevelStatUpdate() {
        float health = this.player.method_6063();
        int runePoints = this.getRunePoints();
        this.updateLevelAttributes();
        this.player.method_6025(this.player.method_6063() - health);
        this.regenRunePoints(this.getMaxRunePoints() - runePoints);
    }

    public void recalculateStats(boolean regen) {
        class_1657 class_16572 = this.player;
        if (!(class_16572 instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)class_16572;
        this.updateConfigAttributes();
        this.updateLevelAttributes();
        this.updateSkillLevelAttributes();
        if (regen) {
            this.player.method_6033(this.player.method_6063());
            this.runePoints = this.getMaxRunePoints();
        }
        LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2CLevelPkt(this), serverPlayer);
    }

    private double skillVal(Function<SkillProperties, Number> func) {
        return this.skillLevels.entrySet().stream().mapToDouble(e -> (double)(((XpLevelHolder)e.getValue()).getLevel() - 1) * ((Number)func.apply(DataPackHandler.INSTANCE.skillPropertiesManager().getPropertiesFor((Skills)((Object)((Object)e.getKey()))))).doubleValue()).sum();
    }

    public XpLevelHolder getSkillLevel(Skills skill) {
        return this.skillLevels.get((Object)skill);
    }

    public void setSkillLevel(Skills skill, int level, float xpAmount, boolean recalc) {
        this.skillLevels.get((Object)skill).setLevel(this.player.method_37908().field_9236 ? level : class_3532.method_15340((int)level, (int)1, (int)DataPackHandler.INSTANCE.skillPropertiesManager().getPropertiesFor(skill).maxLevel()), l -> LevelCalc.xpAmountForSkillLevelUp(skill, l));
        this.skillLevels.get((Object)skill).setXp(this.player.method_37908().field_9236 ? xpAmount : class_3532.method_15363((float)xpAmount, (float)0.0f, (float)LevelCalc.xpAmountForSkillLevelUp(skill, level)));
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            if (recalc) {
                this.recalculateStats(true);
                this.player.method_6033(this.player.method_6063());
            }
            LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2CSkillLevelPkt(this, skill), serverPlayer);
        }
    }

    public void increaseSkill(Skills skill, float amount) {
        class_1657 class_16572;
        if (this.skillLevels.get((Object)skill).getLevel() >= DataPackHandler.INSTANCE.skillPropertiesManager().getPropertiesFor(skill).maxLevel()) {
            return;
        }
        boolean levelUp = this.skillLevels.get((Object)skill).addXP(amount, DataPackHandler.INSTANCE.skillPropertiesManager().getPropertiesFor(skill).maxLevel(), lvl -> LevelCalc.xpAmountForSkillLevelUp(skill, lvl), this::onSkillLevelUp);
        if (levelUp) {
            this.player.method_37908().method_8396(null, this.player.method_24515(), class_3417.field_14709, class_3419.field_15248, 1.0f, 0.5f);
        }
        if ((class_16572 = this.player) instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            if (levelUp) {
                ((SkillLevelTrigger)((Object)RuneCraftoryCriteria.SKILL_LEVEL_TRIGGER.get())).trigger(serverPlayer, skill);
            }
            LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2CSkillLevelPkt(this, skill), serverPlayer);
        }
    }

    private void onSkillLevelUp() {
        float health = this.player.method_6063();
        int runePoints = this.getRunePoints();
        this.updateSkillLevelAttributes();
        this.player.method_6025(this.player.method_6063() - health);
        this.regenRunePoints(this.getMaxRunePoints() - runePoints);
    }

    public void increaseStatBonus(ItemStatIncrease.Stat type) {
        switch (type) {
            case STR: {
                this.setAttributeValue((class_6880<class_1320>)class_5134.field_23721, LibConstants.PLAYER_STAT_BOOST_ITEM_INCREASE, 1.0, AttributeUpdate.ADD);
                break;
            }
            case INT: {
                this.setAttributeValue((class_6880<class_1320>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder(), LibConstants.PLAYER_STAT_BOOST_ITEM_INCREASE, 1.0, AttributeUpdate.ADD);
                break;
            }
            case VIT: {
                this.setForVitality(LibConstants.PLAYER_STAT_BOOST_ITEM_INCREASE, 1.0, AttributeUpdate.ADD);
                break;
            }
            case HP: {
                this.setAttributeValue((class_6880<class_1320>)class_5134.field_23716, LibConstants.PLAYER_STAT_BOOST_ITEM_INCREASE, 10.0, AttributeUpdate.ADD);
            }
        }
    }

    public void resetAllStatBoost(ItemStatIncrease.Stat type) {
        switch (type) {
            case STR: {
                this.clearAtributeModifier((class_6880<class_1320>)class_5134.field_23721, LibConstants.PLAYER_STAT_BOOST_ITEM_INCREASE);
                break;
            }
            case INT: {
                this.clearAtributeModifier((class_6880<class_1320>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder(), LibConstants.PLAYER_STAT_BOOST_ITEM_INCREASE);
                break;
            }
            case VIT: {
                this.clearAtributeModifier((class_6880<class_1320>)RuneCraftoryAttributes.DEFENCE.asHolder(), LibConstants.PLAYER_STAT_BOOST_ITEM_INCREASE);
                this.clearAtributeModifier((class_6880<class_1320>)RuneCraftoryAttributes.MAGIC_DEFENCE.asHolder(), LibConstants.PLAYER_STAT_BOOST_ITEM_INCREASE);
                break;
            }
            case HP: {
                this.clearAtributeModifier((class_6880<class_1320>)class_5134.field_23716, LibConstants.PLAYER_STAT_BOOST_ITEM_INCREASE);
            }
        }
    }

    public InventorySpells getInv() {
        return this.spells;
    }

    public InventoryShippingBin getShippingInv() {
        return this.shippingBin;
    }

    public void refreshShop() {
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            for (NPCProfession profession : RuneCraftoryNPCProfessions.PROFESSIONS.registry()) {
                Collection<ShopItemProperties> datapack = DataPackHandler.INSTANCE.shopItemsManager().get(profession);
                ArrayList shopItems = new ArrayList();
                datapack.forEach(shopProps -> {
                    boolean canAdd;
                    block7: {
                        boolean bl;
                        block6: {
                            if (!shopProps.predicate().isEmpty() && !shopProps.predicate().get().method_8914(serverPlayer, (class_1297)serverPlayer)) break block6;
                            switch (shopProps.unlockType()) {
                                default: {
                                    throw new MatchException(null, null);
                                }
                                case DEFAULT: {
                                    break block6;
                                }
                                case ALWAYS: {
                                    break;
                                }
                                case NEEDS_SHIPPING: {
                                    if (!this.shippedItems.containsKey(shopProps.stack().method_7909())) break block6;
                                }
                            }
                            bl = true;
                            break block7;
                        }
                        bl = canAdd = false;
                    }
                    if (canAdd) {
                        shopItems.add(shopProps.stack().method_7972());
                    }
                });
                class_2371 shop = class_2371.method_10211();
                if (!shopItems.isEmpty()) {
                    for (float chance = 1.5f + (float)shopItems.size() * 0.002f; this.player.method_37908().field_9229.method_43057() < chance; chance -= 0.1f) {
                        class_1799 stack = (class_1799)shopItems.remove(this.player.method_37908().field_9229.method_43048(shopItems.size()));
                        shop.add((Object)stack);
                        if (shopItems.isEmpty() || profession == RuneCraftoryNPCProfessions.TRAVELLING_MERCHANT.get() && shop.size() >= 30) break;
                    }
                }
                DataPackHandler.INSTANCE.shopItemsManager().getDefaultItems(profession).forEach(props -> shop.add((Object)props.stack()));
                this.shopItems.put(profession, (class_2371<class_1799>)shop);
            }
        }
    }

    public class_2371<class_1799> getShop(NPCProfession shop) {
        class_2371 list = class_2371.method_10211();
        list.addAll((Collection)this.shopItems.getOrDefault(shop, (class_2371<class_1799>)class_2371.method_10213((int)0, (Object)class_1799.field_8037)));
        return list;
    }

    public void addShippingItem(class_1799 stack) {
        int level = ItemComponentUtils.itemLevel(stack);
        this.shippedItems.compute(stack.method_7909(), (k, v) -> v == null ? new ShippedItemData(stack.method_7947(), level) : new ShippedItemData(v.amount + stack.method_7947(), Math.max(v.maxLevel, level)));
    }

    public ShippedItemData shippedItemData(class_1799 stack) {
        return this.shippedItems.get(stack.method_7909());
    }

    public int getShippedTypesAmount() {
        return this.shippedItems.size();
    }

    public RecipeKeeper getRecipeKeeper() {
        return this.keeper;
    }

    public void applyFoodEffect(class_1799 stack) {
        class_1657 class_16572;
        FoodProperties food = DataPackHandler.INSTANCE.foodManager().get(stack.method_7909());
        if (food == null) {
            return;
        }
        Pair<Map<class_6880<class_1320>, Double>, Map<class_6880<class_1320>, Double>> foodStats = ItemComponentUtils.foodStats(stack);
        if (!((Map)foodStats.getFirst()).isEmpty() || !((Map)foodStats.getSecond()).isEmpty()) {
            this.removeFoodEffect(this.player);
            this.setFoodBonus(foodStats);
            this.foodDuration = food.duration();
            this.lastEaten = stack.method_41409();
        }
        if ((class_16572 = this.player) instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2CFoodPkt(stack), serverPlayer);
        }
    }

    public void removeFoodEffect(class_1657 player) {
        this.foodDuration = -1;
        this.lastEaten = null;
        this.clearAllAtributeModifier(LibConstants.FOOD_MODIFIER);
        this.clearAllAtributeModifier(LibConstants.FOOD_MODIFIER_MULTI);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2CFoodPkt(null), serverPlayer);
        }
    }

    public FoodData foodBuff() {
        return new FoodData(Optional.ofNullable(this.lastEaten), this.foodDuration);
    }

    public void updateFoodBuff(FoodData data) {
        this.lastEaten = data.food().orElse(null);
        this.foodDuration = data.duration();
    }

    public PlayerWeaponHandler getWeaponHandler() {
        return this.weaponHandler;
    }

    public void tick() {
        this.weaponHandler.tick();
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            this.updater.tick(serverPlayer);
            if (serverPlayer.field_6012 % 10 == 0 && this.walkingTracker.tickWalkingTracker(serverPlayer)) {
                this.rpStillRegen = 200;
            }
            if (--this.rpStillRegen < 0 && serverPlayer.field_6012 % 20 == 0) {
                this.regenRunePoints(1);
            }
            if (--this.breakTick <= 0) {
                this.blockBreakPosForMsg = null;
            }
            class_1799 main = this.player.method_6047();
            class_1799 off = this.player.method_6079();
            if (main.method_31574((class_1792)RuneCraftoryItems.MOB_STAFF.get()) || off.method_31574((class_1792)RuneCraftoryItems.MOB_STAFF.get())) {
                if (this.entitySelector.poi != null) {
                    serverPlayer.method_51469().method_14166(serverPlayer, (class_2394)class_2398.field_11240, true, (double)this.entitySelector.poi.method_10263() + 0.5, (double)this.entitySelector.poi.method_10264() + 1.5, (double)this.entitySelector.poi.method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                    serverPlayer.method_51469().method_14166(serverPlayer, (class_2394)class_2398.field_11240, true, (double)this.entitySelector.poi.method_10263() + 0.5, (double)this.entitySelector.poi.method_10264() + 1.5, (double)this.entitySelector.poi.method_10260() + 0.5, 3, 0.0, 0.0, 0.0, 0.01);
                }
            } else {
                this.entitySelector.reset();
            }
        }
        this.foodDuration = Math.max(--this.foodDuration, -1);
        if (this.foodDuration == 0) {
            this.removeFoodEffect(this.player);
        }
    }

    public DailyPlayerUpdater getDailyUpdater() {
        return this.updater;
    }

    public int getCraftingSeed(class_1657 player) {
        if (this.craftingSeed == 0) {
            this.craftingSeed = player.method_59922().method_43054();
        }
        return this.craftingSeed;
    }

    public void onCrafted(class_1657 player) {
        this.craftingSeed = player.method_59922().method_43054();
    }

    public int getBoughtBarns() {
        return this.boughtBarns;
    }

    public void onBuyBarn() {
        ++this.boughtBarns;
    }

    public boolean onBarnFailMine(class_2338 pos) {
        boolean start = !pos.equals((Object)this.blockBreakPosForMsg);
        this.blockBreakPosForMsg = pos;
        this.breakTick = 20;
        return start;
    }

    public void increaseMobFrom(BaseMonster monster) {
        class_1657 class_16572 = this.player;
        if (!(class_16572 instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)class_16572;
        this.entityStatsTracker.killEntity((class_1297)monster);
        this.increaseMobLevel(monster.getProp().levelIncreaseFromKill(this.entityStatsTracker.getKillCount(monster.method_5864()), serverPlayer));
    }

    public void increaseMobLevel(int increase) {
        this.mobLevelIncrease += increase;
    }

    public int getMobLevelIncrease() {
        return this.mobLevelIncrease;
    }

    public void readFromNBT(class_2487 nbt) {
        class_1657 class_16572;
        class_5455 provider = this.player.method_56673();
        class_6903 ops = provider.method_57093((DynamicOps)class_2509.field_11560);
        this.starting = nbt.method_10577("Starting");
        if (nbt.method_10545("RestoreHP") && (class_16572 = this.player) instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            float f = nbt.method_10583("RestoreHP");
            serverPlayer.method_5682().method_18858((Runnable)new class_3738(1, () -> this.player.method_6033(f)));
        }
        this.runePoints = nbt.method_10574("RunePoints");
        this.level.read(nbt.method_10580("XpLevel"));
        class_2487 skillCompound = nbt.method_10562("Skills");
        for (Skills skill : Skills.values()) {
            this.skillLevels.get((Object)skill).read(skillCompound.method_10580(skill.toString()));
        }
        this.money = nbt.method_10550("Money");
        this.keeper.read(nbt.method_10562("Recipes"));
        this.shippingBin.load(nbt.method_10562("Shippingbin"), (class_7225.class_7874)provider);
        class_2499 ship = nbt.method_10554("ShippedItems", 10);
        ship.forEach(arg_0 -> this.lambda$readFromNBT$10((DynamicOps)ops, arg_0));
        class_2499 shop = nbt.method_10554("ShopItems", 10);
        shop.forEach(arg_0 -> this.lambda$readFromNBT$12((class_7225.class_7874)provider, (DynamicOps)ops, arg_0));
        this.spells.load(nbt.method_10562("Inventory"), (class_7225.class_7874)provider);
        this.updater.read(nbt.method_10562("DailyUpdater"));
        this.lastEaten = nbt.method_10545("LastFood") ? (class_6880)class_7923.field_41178.method_40294().parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580("LastFood")).getOrThrow() : null;
        this.foodDuration = nbt.method_10550("FoodBuffDuration");
        this.walkingTracker.read(nbt.method_10562("WalkingTracker"));
        this.entityStatsTracker.read(nbt.method_10562("TamedEntityTracker"));
        this.party.load(nbt.method_10562("PartyTag"));
        this.craftingSeed = nbt.method_10550("CraftingSeed");
        this.boughtBarns = nbt.method_10550("BoughtBarns");
        this.mobLevelIncrease = nbt.method_10550("MobLevelIncrease");
    }

    public class_2487 writeToNBTPlain(class_2487 nbt) {
        return this.writeToNBT(nbt, false);
    }

    public class_2487 writeToNBT(class_2487 tag, boolean wasDead) {
        class_5455 provider = this.player.method_56673();
        class_6903 ops = provider.method_57093((DynamicOps)class_2509.field_11560);
        tag.method_10556("Starting", this.starting);
        if (wasDead) {
            tag.method_10548("RestoreHP", this.player.method_6063() * GeneralConfig.deathHpPercent);
            tag.method_10549("RunePoints", this.runePoints * (double)GeneralConfig.deathRpPercent);
        } else {
            tag.method_10549("RunePoints", this.runePoints);
        }
        tag.method_10566("XpLevel", (class_2520)this.level.save());
        class_2487 skillCompound = new class_2487();
        for (Skills skill : Skills.values()) {
            skillCompound.method_10566(skill.toString(), (class_2520)this.skillLevels.get((Object)skill).save());
        }
        tag.method_10566("Skills", (class_2520)skillCompound);
        tag.method_10569("Money", this.money);
        tag.method_10566("Recipes", (class_2520)this.keeper.save());
        tag.method_10566("ShippingBin", (class_2520)this.shippingBin.save((class_7225.class_7874)provider));
        class_2499 ship = new class_2499();
        this.shippedItems.forEach((arg_0, arg_1) -> PlayerData.lambda$writeToNBT$13((DynamicOps)ops, ship, arg_0, arg_1));
        tag.method_10566("ShippedItems", (class_2520)ship);
        class_2499 shop = new class_2499();
        for (Map.Entry<NPCProfession, class_2371<class_1799>> entry : this.shopItems.entrySet()) {
            class_2487 data = new class_2487();
            data.method_10566("Shop", (class_2520)RuneCraftoryNPCProfessions.PROFESSIONS.registry().method_39673().encodeStart((DynamicOps)ops, (Object)entry.getKey()).getOrThrow());
            class_2499 items = new class_2499();
            for (class_1799 stack : entry.getValue()) {
                items.add((Object)stack.method_57376((class_7225.class_7874)provider, (class_2520)new class_2487()));
            }
            data.method_10566("Items", (class_2520)items);
        }
        tag.method_10566("ShopItems", (class_2520)shop);
        tag.method_10566("Inventory", (class_2520)this.spells.save((class_7225.class_7874)provider));
        tag.method_10566("DailyUpdater", (class_2520)this.updater.save());
        if (this.lastEaten != null) {
            tag.method_10566("LastFood", (class_2520)class_7923.field_41178.method_40294().encodeStart((DynamicOps)class_2509.field_11560, this.lastEaten).getOrThrow());
        }
        tag.method_10569("FoodBuffDuration", this.foodDuration);
        tag.method_10566("WalkingTracker", (class_2520)this.walkingTracker.save());
        tag.method_10566("TamedEntityTracker", (class_2520)this.entityStatsTracker.save());
        tag.method_10566("PartyTag", (class_2520)this.party.save());
        tag.method_10569("CraftingSeed", this.craftingSeed);
        tag.method_10569("BoughtBarns", this.boughtBarns);
        tag.method_10569("MobLevelIncrease", this.mobLevelIncrease);
        return tag;
    }

    public void resetAll() {
        PlayerData newData = new PlayerData(this.player);
        newData.spells.load(this.spells.save((class_7225.class_7874)this.player.method_56673()), (class_7225.class_7874)this.player.method_56673());
        newData.shippingBin.load(this.shippingBin.save((class_7225.class_7874)this.player.method_56673()), (class_7225.class_7874)this.player.method_56673());
        this.readFromNBT(newData.writeToNBTPlain(new class_2487()));
        this.recalculateStats(false);
        this.refreshShop();
        this.starting = false;
        this.entityStatsTracker.reset();
        this.mobLevelIncrease = 0;
    }

    private static /* synthetic */ void lambda$writeToNBT$13(DynamicOps ops, class_2499 ship, class_1792 key, ShippedItemData value) {
        class_2487 data = new class_2487();
        data.method_10569("Amount", value.amount);
        data.method_10569("Level", value.maxLevel);
        data.method_10566("Item", (class_2520)class_7923.field_41178.method_39673().encodeStart(ops, (Object)key).getOrThrow());
        ship.add((Object)data);
    }

    private /* synthetic */ void lambda$readFromNBT$12(class_7225.class_7874 provider, DynamicOps ops, class_2520 t) {
        class_2487 data = (class_2487)t;
        class_2371 list = class_2371.method_10211();
        class_2499 items = data.method_10554("Items", 10);
        items.forEach(lt -> class_1799.method_57360((class_7225.class_7874)provider, (class_2520)lt).ifPresent(arg_0 -> list.add(arg_0)));
        this.shopItems.put((NPCProfession)RuneCraftoryNPCProfessions.PROFESSIONS.registry().method_39673().parse(ops, (Object)data.method_10580("Shop")).getOrThrow(), (class_2371<class_1799>)list);
    }

    private /* synthetic */ void lambda$readFromNBT$10(DynamicOps ops, class_2520 t) {
        class_2487 data = (class_2487)t;
        this.shippedItems.put((class_1792)class_7923.field_41178.method_39673().parse(ops, (Object)data.method_10580("Item")).getOrThrow(), new ShippedItemData(data.method_10550("Amount"), data.method_10550("Level")));
    }

    public static enum AttributeUpdate {
        ABSOLUTE,
        REPLACE,
        ADD;


        public void modify(class_1324 instance, class_2960 modifier, double from) {
            this.modify(instance, modifier, from, class_1322.class_1323.field_6328);
        }

        public void modify(class_1324 instance, class_2960 modifier, double from, class_1322.class_1323 operation) {
            double value = switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> from - instance.method_6201();
                case 1 -> from;
                case 2 -> {
                    class_1322 mod = instance.method_6199(modifier);
                    if (mod == null) {
                        yield from;
                    }
                    yield mod.comp_2449() + from;
                }
            };
            instance.method_6200(modifier);
            if (this == REPLACE && value <= 0.0) {
                return;
            }
            instance.method_26837(new class_1322(modifier, value, operation));
        }
    }

    public record ShippedItemData(int amount, int maxLevel) {
    }

    public record FoodData(Optional<class_6880<class_1792>> food, int duration) {
    }
}

