/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attachment.player;

import java.util.function.IntUnaryOperator;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

public class XpLevelHolder {
    private int level = 1;
    private float xp;
    private float required;

    public XpLevelHolder() {
    }

    public XpLevelHolder(class_2540 buf) {
        this.fromPacket(buf);
    }

    public void setLevel(int level, IntUnaryOperator xpForNext) {
        this.level = level;
        this.required = xpForNext.applyAsInt(this.level);
    }

    public void setXp(float xp) {
        this.xp = xp;
    }

    public int getLevel() {
        return this.level;
    }

    public float getXp() {
        return this.xp;
    }

    public float getProgress() {
        if (this.required == -1.0f) {
            return 1.0f;
        }
        if (this.required <= 0.0f) {
            return 0.0f;
        }
        return Math.min(1.0f, this.xp / this.required);
    }

    public boolean addXP(float amount, int maxLevel, IntUnaryOperator xpForNext, Runnable onLevelUp) {
        if (amount < 0.0f) {
            int neededXP = xpForNext.applyAsInt(this.level - 1);
            this.required = neededXP;
            if (this.xp < -amount) {
                --this.level;
                float current = this.xp;
                this.xp = neededXP;
                return this.addXP(amount + current, maxLevel, xpForNext, onLevelUp);
            }
            this.xp -= amount;
            return false;
        }
        int neededXP = xpForNext.applyAsInt(this.level);
        this.required = neededXP;
        if (neededXP <= 0) {
            return false;
        }
        float xpToNextLevel = (float)neededXP - this.xp;
        if (amount >= xpToNextLevel) {
            float diff = amount - xpToNextLevel;
            ++this.level;
            this.xp = 0.0f;
            onLevelUp.run();
            this.addXP(diff, maxLevel, xpForNext, onLevelUp);
            return true;
        }
        if (this.level >= maxLevel) {
            amount = 0.0f;
            this.required = -1.0f;
        }
        this.xp += amount;
        return false;
    }

    public class_2487 save() {
        class_2487 tag = new class_2487();
        tag.method_10569("Level", this.level);
        tag.method_10548("XP", this.xp);
        tag.method_10548("Required", this.required);
        return tag;
    }

    public void read(class_2520 tag) {
        if (tag instanceof class_2495) {
            class_2495 arrayTag = (class_2495)tag;
            this.level = arrayTag.method_10588()[0];
            this.xp = arrayTag.method_10588()[1];
        } else if (tag instanceof class_2487) {
            class_2487 compoundTag = (class_2487)tag;
            this.level = compoundTag.method_10550("Level");
            this.xp = compoundTag.method_10583("XP");
            this.required = compoundTag.method_10583("Required");
        }
    }

    public void toPacket(class_2540 buf) {
        buf.method_53002(this.level);
        buf.method_52941(this.xp);
        buf.method_52941(this.required);
    }

    public void from(XpLevelHolder pair) {
        this.level = pair.getLevel();
        this.xp = pair.getXp();
        this.required = pair.required;
    }

    public void fromPacket(class_2540 buf) {
        this.level = buf.readInt();
        this.xp = buf.readFloat();
        this.required = buf.readFloat();
    }

    public String toString() {
        return String.format("Level: %s, XP: %s", this.level, Float.valueOf(this.xp));
    }
}

