/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.registry.action.DataKey;
import io.github.flemmli97.runecraftory.api.registry.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.common.attachment.AttackActionHandler;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.item.AOEWeapon;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4050;

public class GloveAttack
extends AttackAction {
    private final ComboContainer combo = ComboContainer.Builder.builder().addCombo(ComboContainer.past("done"), 2).addCombo(ComboContainer.past("done"), 2).addCombo(ComboContainer.past("done"), 2).addCombo(handler -> handler.isCurrentAnimationDone() && CombatUtils.canPerform(handler.getEntity(), Skills.FIST, 20), 0).build();

    @Override
    public AnimationState getAnimation(class_1309 entity, int comboIdx) {
        float speed = (float)EntityUtils.attackSpeedModifier(entity);
        return AttackAction.create(PlayerModelAnimations.GLOVES.get(comboIdx), speed);
    }

    @Override
    public void run(class_1309 entity, class_1799 stack, AttackActionHandler handler, AnimationState anim) {
        if (anim.isAt("attack") && handler.getComboCount() != 5) {
            if (!entity.method_37908().field_9236) {
                if (handler.getComboCount() != 4) {
                    CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.obbTargets(AOEWeapon.createOBB((class_1309)entity, (double)CombatUtils.getRange(entity, 0.0), (double)CombatUtils.getWidth(entity, 0.0), (double)0.5))).executeAttack();
                } else {
                    CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.aabbTargets(new class_238(-1.0, -1.0, -1.0, 1.0, 1.5, 1.5).method_997(entity.method_19538().method_1031(0.0, 0.2, 0.0).method_1019(entity.method_18798().method_1029().method_1021(0.4))))).executeAttack();
                }
            }
            entity.method_5783(class_3417.field_14840, 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 1.0f);
        }
        switch (handler.getComboCount()) {
            case 1: {
                if (!anim.isAt("step")) break;
                class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                entity.method_18799(dir.method_1021(0.2));
                break;
            }
            case 2: 
            case 3: {
                if (!anim.isAt("step")) break;
                class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                entity.method_18799(dir.method_1021(0.3));
                break;
            }
            case 4: {
                class_243 dir;
                if (anim.isAt("jump")) {
                    dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                    entity.method_18799(dir.method_1021(1.2).method_1031(0.0, 0.9, 0.0));
                }
                if (anim.isAt("down")) {
                    dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                    entity.method_18799(dir.method_1021(0.9).method_1031(0.0, -0.5, 0.0));
                }
                entity.method_38785();
                break;
            }
            case 5: {
                if (anim.isAt("leap")) {
                    handler.store(DataKey.SPIN_ROTATION, Float.valueOf(entity.method_36454()));
                    handler.resetHitEntityTracker();
                    class_243 dir = CombatUtils.fromRelativeVector(handler.get(DataKey.SPIN_ROTATION).floatValue(), new class_243(0.0, 0.0, 1.0));
                    entity.method_18799(dir.method_1021(2.7).method_1031(0.0, 0.6, 0.0));
                }
                entity.method_38785();
                if (anim.isAt("attack_start")) {
                    entity.method_5783((class_3414)RuneCraftorySounds.SPELL_GENERIC_WIND_LONG.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 1.3f);
                }
                if (entity.method_37908().field_9236 || !anim.isPast("attack_start") || anim.isPast("attack_end")) break;
                handler.addHitEntityTracker(CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.aabbTargets(entity.method_5829().method_1014(0.5))).withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).executeAttack());
            }
        }
        if (handler.getComboCount() == 5) {
            handler.store(DataKey.FIXED_LOOK, anim.isPast("move_start") && !anim.isPast("move_end"));
        }
    }

    @Override
    public void onStart(class_1309 entity, AttackActionHandler handler) {
        if (handler.getComboCount() == 5 && entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            LevelCalc.useRP(Platform.INSTANCE.getPlayerData((class_1657)player), GeneralConfig.gloveUltimate, true, 0.0f, false, new Skills[0]);
        }
    }

    @Override
    public boolean isInvulnerable(class_1309 entity, AttackActionHandler handler) {
        return handler.getComboCount() == 5;
    }

    @Override
    public float movementReduction(AnimationState current) {
        return GeneralConfig.MOVE_SPEED_ATTACK.get().floatValue();
    }

    @Override
    public class_4050 getPose(class_1309 entity, AttackActionHandler handler) {
        if (handler.getAnimation() == null) {
            return null;
        }
        if (handler.getComboCount() == 5 && handler.getAnimation().isPast("attack_start") && !handler.getAnimation().isPast("attack_end")) {
            return class_4050.field_18080;
        }
        return null;
    }

    @Override
    public ComboContainer combos() {
        return this.combo;
    }

    @Override
    public boolean usableOnMounts(int targetCombo) {
        return targetCombo < 4;
    }
}

