/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.registry.action.DataKey;
import io.github.flemmli97.runecraftory.api.registry.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.common.attachment.AttackActionHandler;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinition;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import java.util.function.Predicate;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1799;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import net.minecraft.class_6880;

public class TornadoSwingAttack
extends AttackAction {
    private final ComboContainer combo;

    public TornadoSwingAttack() {
        Predicate<AttackActionHandler> MAIN = handler -> handler.getAnimation().isAt("attack_end_1");
        this.combo = ComboContainer.Builder.builder().addCombo(MAIN).addCombo(MAIN).addCombo(MAIN).build();
    }

    @Override
    public AnimationState getAnimation(class_1309 entity, int comboIdx) {
        float speed = (float)EntityUtils.attackSpeedModifier(entity);
        if (comboIdx > 0) {
            AnimationDefinition definition = PlayerModelAnimations.ANIMS.get(PlayerModelAnimations.TORNADO_SWING);
            double offset = definition.marker("chain_offset", 0) * 20.0;
            return AnimationState.create((AnimationDefinition)definition, (int)0, (int)-1, (double)offset, (double)speed);
        }
        return AttackAction.create(PlayerModelAnimations.TORNADO_SWING, speed);
    }

    @Override
    public void run(class_1309 entity, class_1799 stack, AttackActionHandler handler, AnimationState anim) {
        CombatUtils.EntityAttack attack;
        if (anim.isAt("attack_start_1")) {
            entity.method_5783((class_3414)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH_HEAVY.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 0.8f);
        }
        if (anim.isAt("attack_start_2")) {
            handler.resetHitEntityTracker();
            entity.method_5783((class_3414)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH_HEAVY.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 0.8f);
        }
        if ((attack = TornadoSwingAttack.spinAttack(entity, anim, anim.getMarker("attack_start_1", 0), anim.getMarker("attack_end_1", 0), handler.get(DataKey.SPIN_ROTATION).floatValue() + 110.0f, handler.get(DataKey.SPIN_ROTATION).floatValue() - 285.0f, 0.5f)) != null) {
            handler.addHitEntityTracker(attack.withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).withBonusAttributesMultiplier((class_6880<class_1320>)class_5134.field_23721, CombatUtils.getAbilityDamageBonus(stack, RuneCraftorySpells.TORNADO_SWING)).executeAttack());
        }
        if ((attack = TornadoSwingAttack.spinAttack(entity, anim, anim.getMarker("attack_start_2", 0), anim.getMarker("attack_end_2", 0), handler.get(DataKey.SPIN_ROTATION).floatValue() + 75.0f, handler.get(DataKey.SPIN_ROTATION).floatValue() - 35.0f, 0.5f)) != null) {
            handler.addHitEntityTracker(attack.withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).withBonusAttributesMultiplier((class_6880<class_1320>)class_5134.field_23721, CombatUtils.getAbilityDamageBonus(stack, RuneCraftorySpells.TORNADO_SWING)).executeAttack());
        }
    }

    @Override
    public void onStart(class_1309 entity, AttackActionHandler handler) {
        super.onStart(entity, handler);
        handler.store(DataKey.SPIN_ROTATION, Float.valueOf(entity.method_36454()));
        if (handler.getComboCount() != 1) {
            entity.method_5783((class_3414)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH_HEAVY.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 0.8f);
        }
    }

    @Override
    public float movementReduction(AnimationState current) {
        return 0.6f;
    }

    @Override
    public ComboContainer combos() {
        return this.combo;
    }

    @Override
    public boolean usableOnMounts(int targetCombo) {
        return false;
    }
}

