/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.blocks.HerbBlock;
import io.github.flemmli97.runecraftory.common.blocks.TreeRootBlock;
import io.github.flemmli97.runecraftory.common.blocks.entity.TreeBlockEntity;
import io.github.flemmli97.runecraftory.common.blocks.util.Growable;
import io.github.flemmli97.runecraftory.common.blocks.util.GrowableCrop;
import io.github.flemmli97.runecraftory.common.blocks.util.LazyResolvedRegistryEntry;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryBlocks;
import io.github.flemmli97.runecraftory.common.world.data.farming.FarmlandHandler;
import io.github.flemmli97.runecraftory.mixinhelper.LevelSnapshotHandler;
import io.github.flemmli97.runecraftory.platform.ExtendedBlock;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2465;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2626;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2975;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class TreeBaseBlock
extends class_2465
implements class_2343,
Growable,
ExtendedBlock,
GrowableCrop {
    public static final MapCodec<TreeBaseBlock> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)TreeBaseBlock.method_54096(), (App)class_5321.method_39154((class_5321)class_7924.field_41239).fieldOf("stump").forGetter(d -> d.stump), (App)class_5321.method_39154((class_5321)class_7924.field_41239).fieldOf("stage_1").forGetter(d -> d.stage1), (App)class_5321.method_39154((class_5321)class_7924.field_41239).fieldOf("stage_2").forGetter(d -> d.stage2), (App)LazyResolvedRegistryEntry.codec(class_7924.field_41197).fieldOf("seed").forGetter(d -> d.sapling)).apply((Applicative)inst, TreeBaseBlock::new));
    public static final int MAX_AGE = 4;
    public static final class_2758 AGE = class_2741.field_12497;
    private final class_5321<class_2975<?, ?>> stump;
    private final class_5321<class_2975<?, ?>> stage1;
    private final class_5321<class_2975<?, ?>> stage2;
    protected final LazyResolvedRegistryEntry<class_1792> sapling;

    public TreeBaseBlock(class_4970.class_2251 properties, class_5321<class_2975<?, ?>> stump, class_5321<class_2975<?, ?>> stage1, class_5321<class_2975<?, ?>> stage2, class_5321<class_1792> seed) {
        this(properties, stump, stage1, stage2, new LazyResolvedRegistryEntry<class_1792>(seed));
    }

    private TreeBaseBlock(class_4970.class_2251 prop, class_5321<class_2975<?, ?>> stump, class_5321<class_2975<?, ?>> stage1, class_5321<class_2975<?, ?>> stage2, LazyResolvedRegistryEntry<class_1792> seed) {
        super(prop);
        this.stump = stump;
        this.stage1 = stage1;
        this.stage2 = stage2;
        this.sapling = seed;
    }

    public MapCodec<TreeBaseBlock> method_53969() {
        return CODEC;
    }

    public static boolean isAirOrReplaceable(class_2680 state) {
        return state.method_26215() || state.method_26164(class_3481.field_44470) || state.method_26164(class_3481.field_15503);
    }

    public boolean growTree(class_3218 level, class_2338 pos, class_2680 state, class_5819 rand) {
        class_2586 class_25862 = level.method_8321(pos);
        if (!(class_25862 instanceof TreeBlockEntity)) {
            return false;
        }
        TreeBlockEntity tree = (TreeBlockEntity)class_25862;
        if (!tree.isTreeValid((class_1922)level)) {
            return false;
        }
        return switch ((Integer)state.method_11654((class_2769)AGE)) {
            case 2 -> {
                ((LevelSnapshotHandler)level).runecraftory$getSnapshotHandler().takeSnapshot(null);
                tree.onRemove((class_1937)level, pos, false);
                boolean result = ((class_2975)level.method_30349().method_46762(class_7924.field_41239).method_46747(this.stage2).comp_349()).method_12862((class_5281)level, level.method_14178().method_12129(), rand, pos);
                ((LevelSnapshotHandler)level).runecraftory$getSnapshotHandler().popSnapshots(result);
                if (!result) {
                    tree.invalidateUpdate();
                }
                yield result;
            }
            case 1 -> {
                ((LevelSnapshotHandler)level).runecraftory$getSnapshotHandler().takeSnapshot(null);
                tree.onRemove((class_1937)level, pos, false);
                boolean result = ((class_2975)level.method_30349().method_46762(class_7924.field_41239).method_46747(this.stage1).comp_349()).method_12862((class_5281)level, level.method_14178().method_12129(), rand, pos);
                ((LevelSnapshotHandler)level).runecraftory$getSnapshotHandler().popSnapshots(result);
                if (!result) {
                    tree.invalidateUpdate();
                }
                yield result;
            }
            case 0 -> ((class_2975)level.method_30349().method_46762(class_7924.field_41239).method_46747(this.stump).comp_349()).method_12862((class_5281)level, level.method_14178().method_12129(), rand, pos);
            default -> {
                tree.update(level);
                yield false;
            }
        };
    }

    @Override
    public boolean onDestroyedByPlayer(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, boolean willHarvest, class_3610 fluid) {
        if (!(player instanceof class_3222)) {
            return false;
        }
        class_3222 serverPlayer = (class_3222)player;
        TreeBlockEntity tree = this.resolveTreeForBreak(state, level, pos, player);
        if (tree == null || tree.getHealth() <= 0) {
            this.method_9576(level, pos, state, player);
            return level.method_8652(pos, fluid.method_15759(), 3);
        }
        tree.onBreak(10);
        TreeBaseBlock.method_9511((class_2680)state, (class_1937)level, (class_2338)pos, null, (class_1297)player, (class_1799)player.method_6047());
        serverPlayer.field_13987.method_14364((class_2596)new class_2626(pos, state));
        return false;
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean isMoving) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            if (!newState.method_27852(state.method_26204())) {
                FarmlandHandler.get(serverLevel.method_8503()).getData(serverLevel, pos.method_10074()).ifPresent(d -> d.onCropRemove(serverLevel, pos, newState));
                class_2586 class_25862 = serverLevel.method_8321(pos);
                if (class_25862 instanceof TreeBlockEntity) {
                    TreeBlockEntity tree = (TreeBlockEntity)class_25862;
                    tree.onRemove(level, pos, true);
                }
            }
        }
        super.method_9536(state, level, pos, newState, isMoving);
    }

    protected TreeBlockEntity resolveTreeForBreak(class_2680 state, class_1937 level, class_2338 pos, class_1657 player) {
        if (player.method_7337() || player.method_5715()) {
            return null;
        }
        class_2586 class_25862 = level.method_8321(pos);
        if (!(class_25862 instanceof TreeBlockEntity)) {
            return null;
        }
        TreeBlockEntity tree = (TreeBlockEntity)class_25862;
        return this.runecraftory$isAtMaxAge(state) ? tree : null;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{AGE});
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new TreeBlockEntity(pos, state);
    }

    public class_1799 method_9574(class_4538 level, class_2338 pos, class_2680 state) {
        return new class_1799(this.sapling.get((class_7225.class_7874)level.method_30349()));
    }

    @Override
    public int runecraftory$getGrowableMaxAge() {
        return 4;
    }

    @Override
    public boolean canGrow(class_3218 level, class_2338 pos, class_2680 state) {
        return true;
    }

    @Override
    public class_2680 runecraftory$getGrowableStateForAge(class_2680 current, int age) {
        int newAge = current.method_28500((class_2769)AGE).map(i -> class_3532.method_15340((int)(age - 1), (int)0, (int)(i + 1))).orElse(age - 1);
        return (class_2680)this.method_9564().method_11657((class_2769)AGE, (Comparable)Integer.valueOf(newAge));
    }

    @Override
    public boolean runecraftory$isAtMaxAge(class_2680 state) {
        return (Integer)state.method_11654((class_2769)AGE) == 3;
    }

    @Override
    public void onGrow(class_3218 level, class_2338 pos, class_2680 state, class_2680 old) {
        int age = (Integer)state.method_11654((class_2769)AGE);
        if (!old.method_27852((class_2248)this) || !Objects.equals(old.method_11654((class_2769)AGE), age) || this.runecraftory$isAtMaxAge(state)) {
            if (age == 0 || old.method_28500((class_2769)AGE).orElse(0) == 2) {
                Growable.super.onGrow(level, pos, state, old);
            }
            if (this.growTree(level, pos, state, level.method_8409())) {
                Growable.super.onGrow(level, pos, state, old);
                level.method_8652(pos.method_10074(), ((TreeRootBlock)((Object)RuneCraftoryBlocks.TREE_SOIL.get())).method_9564(), 3);
            }
        }
    }

    @Override
    public void onWater(class_1937 level, class_2338 pos, class_2680 crop) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof TreeBlockEntity) {
            TreeBlockEntity tree = (TreeBlockEntity)class_25862;
            tree.witherTree((class_1936)level, false);
        }
    }

    @Override
    public void onWither(int amount, class_1937 level, class_2680 state, class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof TreeBlockEntity) {
            TreeBlockEntity tree = (TreeBlockEntity)class_25862;
            if (amount > 1 || tree.withered()) {
                level.method_8652(pos, ((HerbBlock)((Object)RuneCraftoryBlocks.WITHERED_GRASS.get())).method_9564(), 3);
            } else {
                tree.witherTree((class_1936)level, true);
            }
        }
    }
}

