/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.utils.StreamCodecUtils;
import it.unimi.dsi.fastutil.objects.Object2DoubleAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleSortedMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleSortedMaps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1320;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class ItemAttributeData {
    public static final ItemAttributeData DEFAULT = new ItemAttributeData(Map.of(), Map.of());
    public static final Codec<ItemAttributeData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)class_7923.field_41190.method_40294(), (Codec)Codec.DOUBLE).fieldOf("base_stats").forGetter(d -> d.baseStats), (App)Codec.unboundedMap((Codec)class_7923.field_41190.method_40294(), (Codec)Codec.DOUBLE).fieldOf("stats").forGetter(d -> d.stats)).apply((Applicative)instance, ItemAttributeData::new));
    public static final class_9139<class_9129, ItemAttributeData> STREAM_CODEC = new class_9139<class_9129, ItemAttributeData>(){

        public ItemAttributeData decode(class_9129 buf) {
            return new ItemAttributeData((Map)StreamCodecUtils.ATTRIBUTE_CODEC.decode((Object)buf), (Map)StreamCodecUtils.ATTRIBUTE_CODEC.decode((Object)buf));
        }

        public void encode(class_9129 buf, ItemAttributeData component) {
            StreamCodecUtils.ATTRIBUTE_CODEC.encode((Object)buf, component.baseStats);
            StreamCodecUtils.ATTRIBUTE_CODEC.encode((Object)buf, component.stats);
        }
    };
    private final Map<class_6880<class_1320>, Double> baseStats;
    private final Map<class_6880<class_1320>, Double> stats;
    private final Object2DoubleSortedMap<class_6880<class_1320>> totalStats;

    private ItemAttributeData(Map<class_6880<class_1320>, Double> baseStats, Map<class_6880<class_1320>, Double> stats) {
        this.baseStats = baseStats;
        this.stats = stats;
        Object2DoubleAVLTreeMap map = new Object2DoubleAVLTreeMap(RuneCraftoryAttributes.SORTED);
        map.putAll(this.baseStats);
        this.stats.forEach((attribute, value) -> map.put(attribute, map.getOrDefault(attribute, 0.0) + value));
        this.totalStats = Object2DoubleSortedMaps.unmodifiable((Object2DoubleSortedMap)map);
    }

    public ItemAttributeData base(Map<class_6880<class_1320>, Double> baseStats) {
        return new ItemAttributeData(baseStats, this.getStats());
    }

    public ItemAttributeData add(Map<class_6880<class_1320>, Double> stats) {
        HashMap<class_6880<class_1320>, Double> map = new HashMap<class_6880<class_1320>, Double>(this.stats);
        stats.forEach((attribute, value) -> map.put((class_6880<class_1320>)attribute, map.getOrDefault(attribute, 0.0) + value));
        return new ItemAttributeData(this.getBaseStats(), map);
    }

    public Map<class_6880<class_1320>, Double> getBaseStats() {
        return Map.copyOf(this.baseStats);
    }

    public Map<class_6880<class_1320>, Double> getStats() {
        return Map.copyOf(this.stats);
    }

    public Map<class_6880<class_1320>, Double> getTotalStats() {
        return this.totalStats;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ItemAttributeData) {
            ItemAttributeData other = (ItemAttributeData)object;
            return this.baseStats.equals(other.baseStats) && this.stats.equals(other.stats);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.baseStats, this.stats);
    }
}

