/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.MathsHelper;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinition;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.registry.TenshilibSyncableEntityDatas;
import io.github.flemmli97.tenshilib.common.utils.TypedResource;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_5134;

public abstract class ChargingMonster
extends BaseMonster {
    protected static final class_2960 CHARGING_STEP = RuneCraftory.modRes("charging_step");
    protected List<class_1309> hitEntity;
    private final Consumer<AnimationDefinition> chargingAnim = this.animatedActionConsumer();
    private boolean initAnim;
    public static final TypedResource<class_243> CHARGE_MOTION = new TypedResource(RuneCraftory.modRes("charge_motion"));

    public ChargingMonster(class_1299<? extends ChargingMonster> type, class_1937 level) {
        super(type, level);
    }

    protected Consumer<AnimationDefinition> animatedActionConsumer() {
        return anim -> {
            if (!this.method_37908().field_9236) {
                this.method_5996(class_5134.field_47761).method_6200(CHARGING_STEP);
                if (anim != null && this.isChargingAnim(anim.id())) {
                    this.method_5996(class_5134.field_47761).method_26835(new class_1322(CHARGING_STEP, 1.0, class_1322.class_1323.field_6328));
                }
                if (this.isChargingAnimation()) {
                    this.hitEntity = null;
                } else {
                    this.setChargeMotion(null);
                }
            }
        };
    }

    @Override
    protected void definedAdditinoalSyncedData(SyncedDataContainer.Builder<BaseMonster> builder) {
        super.definedAdditinoalSyncedData(builder);
        builder.define(CHARGE_MOTION, (SyncedEntityData)TenshilibSyncableEntityDatas.VEC_3.get(), null);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.initAnim) {
            this.getAnimationHandler().withChangeListener(anim -> {
                this.chargingAnim.accept((AnimationDefinition)anim);
                return false;
            });
            this.initAnim = true;
        }
    }

    @Override
    protected class_243 directionToLookAt() {
        if (this.fixedYaw()) {
            return this.getChargeMotion();
        }
        return super.directionToLookAt();
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, class_243 target, double grow) {
        if (!this.isChargingAnim(anim.getID())) {
            return super.calculateAttackAABB(anim, target, grow);
        }
        double width = this.method_17681();
        double speed = Math.max(width, this.method_18798().method_1033() - width);
        float yRot = 0.0f;
        if (this.getChargeMotion() != null) {
            yRot = MathsHelper.YRotFrom(this.getChargeMotion());
        }
        return new OrientedBoundingBox(OrientedBoundingBox.originAABB((class_1297)this).method_1014(0.2).method_1014(grow).method_1012(0.0, 0.0, speed), yRot, 0.0f, this.method_19538());
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (this.isChargingAnim(anim.getID())) {
            if (this.getChargeMotion() == null) {
                this.setChargeMotion(this.getChargeTo(anim.getAnimation()));
            }
            this.method_5942().method_6340();
            if (anim.isPast("attack_start") && !anim.isPast("attack_end")) {
                if (!this.handleChargeMovement(anim)) {
                    return;
                }
                if (this.hitEntity == null) {
                    this.hitEntity = new ArrayList<class_1309>();
                }
                this.mobAttack(anim, this.method_5968(), e -> {
                    if (!this.hitEntity.contains(e)) {
                        this.hitEntity.add((class_1309)e);
                        this.method_6121((class_1297)e);
                    }
                });
                this.doWhileCharge();
            }
        } else {
            super.handleAttack(anim);
        }
    }

    public void method_5697(class_1297 entity) {
        if (this.isChargingAnimation()) {
            return;
        }
        super.method_5697(entity);
    }

    protected abstract boolean isChargingAnim(String var1);

    private boolean isChargingAnimation() {
        AnimationState anim = this.getAnimationHandler().getAnimation();
        return anim != null && this.isChargingAnim(anim.getID());
    }

    public class_243 getChargeMotion() {
        return (class_243)this.getDataContainer().get(CHARGE_MOTION);
    }

    public class_243 getChargeTo(String anim) {
        return EntityUtils.getTargetDirection((class_1308)this, class_2183.class_2184.field_9853, true).method_1021(this.chargingSpeed());
    }

    public void setChargeMotion(class_243 chargeMotion) {
        this.getDataContainer().set(CHARGE_MOTION, (Object)chargeMotion);
    }

    public double chargingSpeed() {
        return 0.4;
    }

    public boolean handleChargeMovement(AnimationState anim) {
        class_243 charge = this.getChargeMotion();
        if (charge != null) {
            this.method_18800(charge.field_1352, this.method_18798().field_1351, charge.field_1350);
            return true;
        }
        return false;
    }

    public void doWhileCharge() {
    }

    protected boolean fixedYaw() {
        return this.isChargingAnimation();
    }

    @Override
    public boolean adjustRotFromRider(class_1309 rider) {
        return !this.isChargingAnimation();
    }
}

