/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities;

import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.attachment.player.XpLevelHolder;
import io.github.flemmli97.runecraftory.common.config.MobConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.misc.TreasureChestEntity;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4153;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_7477;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8103;
import org.jetbrains.annotations.Nullable;

public class GateEntity
extends class_1308
implements IBaseMob {
    private static final Map<ItemElement, class_5321<class_52>> LOOT_RES = new HashMap<ItemElement, class_5321<class_52>>();
    private static final class_2940<String> ELEMENT_TYPE = class_2945.method_12791(GateEntity.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Integer> ELEMENT = class_2945.method_12791(GateEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> MOB_LEVEL = class_2945.method_12791(GateEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2960 ATTRIBUTE_LEVEL_MOD = RuneCraftory.modRes("gate_level_modifier");
    public int rotate;
    public int clientRenderTick;
    private final List<class_1299<?>> spawnList = new ArrayList();
    private ItemElement type = ItemElement.NONE;
    private boolean initialSpawn = true;
    private final XpLevelHolder expPair = new XpLevelHolder();
    private boolean removeCauseEmptyList;
    private int maxNearby;
    private int spawnDelay;
    public final int renderRand = this.field_5974.method_43048(1000);

    public GateEntity(class_1299<? extends GateEntity> type, class_1937 level) {
        super(type, level);
        if (level.field_9236) {
            this.rotate = level.field_9229.method_43048(2) == 0 ? 1 : -1;
        }
        this.updateAttributes();
        this.method_5875(true);
        this.maxNearby = this.method_59922().method_43048(1 + MobConfig.maxNearby - MobConfig.minNearby) + MobConfig.minNearby;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26867(RuneCraftoryAttributes.DEFENCE.asHolder()).method_26867(RuneCraftoryAttributes.MAGIC_DEFENCE.asHolder()).method_26867(RuneCraftoryAttributes.WATER_RESISTANCE.asHolder()).method_26867(RuneCraftoryAttributes.EARTH_RESISTANCE.asHolder()).method_26867(RuneCraftoryAttributes.WIND_RESISTANCE.asHolder()).method_26867(RuneCraftoryAttributes.FIRE_RESISTANCE.asHolder()).method_26867(RuneCraftoryAttributes.DARK_RESISTANCE.asHolder()).method_26867(RuneCraftoryAttributes.LIGHT_RESISTANCE.asHolder()).method_26867(RuneCraftoryAttributes.LOVE_RESISTANCE.asHolder());
    }

    public static boolean gateSpawnRules(class_1299<? extends class_1308> type, class_1936 level, class_3730 spawnType, class_2338 pos, class_2680 state, class_5819 random) {
        class_2338 blockPos = pos.method_10074();
        return spawnType == class_3730.field_16469 || level.method_8320(blockPos).method_26170((class_1922)level, blockPos, type) || level.method_8615() - 5 > pos.method_10264() && state.method_26227().method_15767(class_3486.field_15517);
    }

    public static boolean canSpawnAt(class_1299<? extends GateEntity> type, class_5425 level, class_3730 reason, class_2338 pos, class_5819 random) {
        class_2680 state = level.method_8320(pos);
        return level.method_8407() != class_1267.field_5801 && DataPackHandler.INSTANCE.gateSpawnsManager().hasSpawns(level, pos, state) && level.method_8410().method_19494().method_19127(holder -> holder.method_40225(class_7477.field_39292), p -> true, pos, MobConfig.bellRadius, class_4153.class_4155.field_18489).isEmpty() && GateEntity.gateSpawnRules(type, (class_1936)level, reason, pos, state, random) && level.method_18467(GateEntity.class, new class_238(pos).method_1014(MobConfig.minDist)).size() < MobConfig.maxGroup;
    }

    public static class_5321<class_52> getGateLootLocation(ItemElement element) {
        class_5321 def = ((class_1299)RuneCraftoryEntities.GATE.get()).method_16351();
        return LOOT_RES.computeIfAbsent(element, e -> class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2960.method_60655((String)def.method_29177().method_12836(), (String)(def.method_29177().method_12832() + "_" + e.name().toLowerCase(Locale.ROOT)))));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ELEMENT_TYPE, (Object)"none");
        builder.method_56912(MOB_LEVEL, (Object)1);
        builder.method_56912(ELEMENT, (Object)0);
    }

    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
        if (this.method_37908().field_9236) {
            if (key.equals(MOB_LEVEL)) {
                this.updateStatsToLevel();
            }
            if (key.equals(ELEMENT)) {
                this.type = ItemElement.values()[(Integer)this.field_6011.method_12789(ELEMENT)];
            }
        }
    }

    private void updateAttributes() {
        this.method_5996(class_5134.field_23716).method_6192(MobConfig.gateHealth);
        this.method_5996(RuneCraftoryAttributes.DEFENCE.asHolder()).method_6192(MobConfig.gateDef);
        this.method_5996(RuneCraftoryAttributes.MAGIC_DEFENCE.asHolder()).method_6192(MobConfig.gateMDef);
        this.method_6033(this.method_6063());
    }

    public boolean method_5957(class_4538 level) {
        return level.method_8606((class_1297)this);
    }

    public ItemElement getElement() {
        return this.type;
    }

    public void method_5773() {
        if (Platform.INSTANCE.entityTickPre((class_1309)this)) {
            return;
        }
        if (!this.method_37908().field_9236) {
            if (this.removeCauseEmptyList) {
                this.method_31472();
                return;
            }
            this.method_5729(6, this.method_5851());
        } else {
            this.clientRenderTick += 10;
        }
        this.method_5670();
        if (this.field_6210 > 0) {
            double d0 = this.method_23317() + (this.field_6224 - this.method_23317()) / (double)this.field_6210;
            double d2 = this.method_23318() + (this.field_6245 - this.method_23318()) / (double)this.field_6210;
            double d4 = this.method_23321() + (this.field_6263 - this.method_23321()) / (double)this.field_6210;
            double d6 = class_3532.method_15338((double)(this.field_6284 - (double)this.method_36454()));
            this.method_36456((float)((double)this.method_36454() + d6 / (double)this.field_6210));
            this.method_36457((float)((double)this.method_36455() + (this.field_6221 - (double)this.method_36455()) / (double)this.field_6210));
            --this.field_6210;
            this.method_5814(d0, d2, d4);
            this.method_5710(this.method_36454(), this.method_36455());
        } else if (!this.method_6034()) {
            this.method_18799(this.method_18798().method_1021(0.98));
        }
        if (!this.method_37908().field_9236 && --this.spawnDelay <= 0 && this.method_37908().method_8407() != class_1267.field_5801) {
            int n = this.spawnDelay = MobConfig.minSpawnDelay >= MobConfig.maxSpawnDelay ? MobConfig.minSpawnDelay : this.method_59922().method_43051(MobConfig.minSpawnDelay, MobConfig.maxSpawnDelay);
            if (this.spawnMobs(1)) {
                this.spawnDelay = (int)((double)this.spawnDelay * 0.4);
            }
        }
    }

    private boolean spawnMobs(int count) {
        List nearby;
        class_3218 serverLevel;
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218) || (serverLevel = (class_3218)class_19372).method_8407() == class_1267.field_5801) {
            return false;
        }
        if (!this.spawnList.isEmpty() && (nearby = this.method_37908().method_8333((class_1297)this, this.method_5829().method_1014(18.0), entity -> entity.method_5864() == RuneCraftoryEntities.TREASURE_CHEST.get() || entity.method_5864() == RuneCraftoryEntities.MONSTER_BOX.get() || entity.method_5864() == RuneCraftoryEntities.GOBBLE_BOX.get() || this.spawnList.contains(entity.method_5864()))).size() <= this.maxNearby) {
            for (int amount = 0; amount < count; ++amount) {
                class_2680 state;
                boolean notSolid;
                class_1297 entity2;
                double x = this.method_23317() + (double)this.field_5974.method_43048(9) - 4.0;
                double y = this.method_23318() + (double)this.field_5974.method_43048(2) - 1.0;
                double z = this.method_23321() + (double)this.field_5974.method_43048(9) - 4.0;
                int levelRand = LevelCalc.randomizedLevel(this.field_5974, (Integer)this.field_6011.method_12789(MOB_LEVEL));
                class_1299<?> type = this.spawnList.get(this.field_5974.method_43048(this.spawnList.size()));
                if (this.initialSpawn) {
                    this.initialSpawn = false;
                    class_1299<?> chest = EntityUtils.trySpawnTreasureChest(this);
                    if (chest != null) {
                        type = chest;
                    }
                }
                if ((entity2 = type.method_5883(this.method_37908())) instanceof TreasureChestEntity) {
                    TreasureChestEntity chest = (TreasureChestEntity)entity2;
                    entity2.method_5641(x, y, z, this.method_37908().field_9229.method_43057() * 360.0f, 0.0f);
                    if (!this.method_37908().method_17892((class_1297)chest)) continue;
                    EntityUtils.tieredTreasureChest(this, chest);
                    this.method_37908().method_8649(entity2);
                    continue;
                }
                if (!(entity2 instanceof class_1308)) continue;
                class_1308 mob = (class_1308)entity2;
                class_2338 pos = class_2338.method_49637((double)x, (double)y, (double)z);
                while ((notSolid = !(state = this.method_37908().method_8320(pos.method_10074())).method_26169((class_1922)this.method_37908(), pos, entity2, class_2350.field_11036) && !state.method_26227().method_15767(class_3486.field_15517)) && pos.method_10268(x, y, z) < 16.0) {
                    pos = pos.method_10074();
                }
                if (notSolid) continue;
                if (mob instanceof BaseMonster) {
                    ((BaseMonster)mob).setXPLevel(levelRand);
                }
                entity2.method_5641(x, y, z, this.method_37908().field_9229.method_43057() * 360.0f, 0.0f);
                if (!Platform.INSTANCE.checkSpawnPosition(mob, serverLevel, class_3730.field_16469) || !this.method_37908().method_17892((class_1297)mob)) continue;
                mob.method_5943((class_5425)serverLevel, this.method_37908().method_8404(mob.method_24515()), class_3730.field_16469, null);
                class_1324 follow = mob.method_5996(class_5134.field_23717);
                mob.method_18408(this.method_24515(), (int)Math.max(18.0, follow != null ? follow.method_6194() * 0.75 : 0.0));
                this.method_37908().method_8649(entity2);
                mob.method_5990();
            }
            return true;
        }
        return false;
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("MobLevel", ((Integer)this.field_6011.method_12789(MOB_LEVEL)).intValue());
        compound.method_10566("Spawns", (class_2520)class_7923.field_41177.method_39673().listOf().encodeStart((DynamicOps)class_2509.field_11560, this.spawnList).getOrThrow());
        compound.method_10582("Element", this.type.toString());
        compound.method_10556("FirstSpawn", this.initialSpawn);
        compound.method_10569("MaxNearby", this.maxNearby);
        compound.method_10569("SpawnDelay", this.spawnDelay);
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10545("MobLevel")) {
            this.field_6011.method_12778(MOB_LEVEL, (Object)compound.method_10550("MobLevel"));
        }
        this.spawnList.clear();
        if (compound.method_10545("Spawns")) {
            this.spawnList.addAll((Collection)class_7923.field_41177.method_39673().listOf().parse((DynamicOps)class_2509.field_11560, (Object)compound.method_10580("Spawns")).getOrThrow());
        }
        if (compound.method_10545("Element")) {
            String el = compound.method_10558("Element");
            try {
                this.type = ItemElement.valueOf(el);
                this.field_6011.method_12778(ELEMENT_TYPE, (Object)this.type.getTranslation());
                this.field_6011.method_12778(ELEMENT, (Object)this.type.ordinal());
            }
            catch (IllegalArgumentException e) {
                RuneCraftory.LOGGER.error("Unable to set element type for gate entity {}", (Object)this);
            }
        }
        this.initialSpawn = compound.method_10577("FirstSpawn");
        this.maxNearby = compound.method_10550("MaxNearby");
        this.spawnDelay = compound.method_10550("SpawnDelay");
    }

    @Override
    public XpLevelHolder xpLevel() {
        this.expPair.setLevel((Integer)this.field_6011.method_12789(MOB_LEVEL), l -> 0);
        return this.expPair;
    }

    @Override
    public int friendPoints(UUID uuid) {
        return -1;
    }

    @Override
    public void setXPLevel(int lvl) {
        this.field_6011.method_12778(MOB_LEVEL, (Object)class_3532.method_15340((int)lvl, (int)1, (int)10000));
        this.updateStatsToLevel();
    }

    @Override
    public int baseXP() {
        return MobConfig.gateXp;
    }

    @Override
    public int baseMoney() {
        return MobConfig.gateMoney;
    }

    @Override
    public boolean applyFoodEffect(class_1799 stack) {
        return false;
    }

    @Override
    public void removeFoodEffect() {
    }

    protected class_5321<class_52> method_5991() {
        return GateEntity.getGateLootLocation(this.getElement());
    }

    public Iterable<class_1799> method_5661() {
        return class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    }

    public class_1799 method_6118(class_1304 slotIn) {
        return class_1799.field_8037;
    }

    public void method_5673(class_1304 slotIn, class_1799 stack) {
    }

    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData) {
        class_6880 biome = level.method_23753(this.method_24515());
        this.type = this.getType(level, (class_6880<class_1959>)biome);
        LevelCalc.GateLevelResult gateLevel = LevelCalc.levelFromPos(level.method_8410(), this.method_19538());
        this.field_6011.method_12778(MOB_LEVEL, (Object)gateLevel.level());
        this.field_6011.method_12778(ELEMENT_TYPE, (Object)this.type.getTranslation());
        this.field_6011.method_12778(ELEMENT, (Object)this.type.ordinal());
        this.spawnList.addAll(DataPackHandler.INSTANCE.gateSpawnsManager().pickRandomMobs(level.method_8410(), this, (class_6880<class_1959>)biome, this.field_5974, this.field_5974.method_43048(3) + 1, this.method_24515(), gateLevel.nearby()));
        this.method_5814(this.method_23317(), this.method_23318() + 1.0, this.method_23321());
        this.updateStatsToLevel();
        this.spawnMobs(Math.max(1, this.maxNearby - 2));
        this.spawnDelay = this.method_59922().method_43051(MobConfig.minSpawnDelay, MobConfig.maxSpawnDelay);
        if (this.spawnList.isEmpty() && reason != class_3730.field_16465 && reason != class_3730.field_16462) {
            this.removeCauseEmptyList = true;
        }
        return spawnData;
    }

    private void updateStatsToLevel() {
        this.method_5996(class_5134.field_23716).method_6200(ATTRIBUTE_LEVEL_MOD);
        this.method_5996(class_5134.field_23716).method_26837(new class_1322(ATTRIBUTE_LEVEL_MOD, (double)(this.xpLevel().getLevel() - 1) * MobConfig.gateHealthGain, class_1322.class_1323.field_6328));
        this.method_5996(RuneCraftoryAttributes.DEFENCE.asHolder()).method_6200(ATTRIBUTE_LEVEL_MOD);
        this.method_5996(RuneCraftoryAttributes.DEFENCE.asHolder()).method_26837(new class_1322(ATTRIBUTE_LEVEL_MOD, (double)(this.xpLevel().getLevel() - 1) * MobConfig.gateDefGain, class_1322.class_1323.field_6328));
        this.method_5996(RuneCraftoryAttributes.MAGIC_DEFENCE.asHolder()).method_6200(ATTRIBUTE_LEVEL_MOD);
        this.method_5996(RuneCraftoryAttributes.MAGIC_DEFENCE.asHolder()).method_26837(new class_1322(ATTRIBUTE_LEVEL_MOD, (double)(this.xpLevel().getLevel() - 1) * MobConfig.gateMDefGain, class_1322.class_1323.field_6328));
        this.method_6033(this.method_6063());
    }

    public class_1306 method_6068() {
        return class_1306.field_6183;
    }

    protected float method_6132(class_1282 source, float damageAmount) {
        float reduce = 0.0f;
        if (source.method_48789(RunecraftoryTags.DamageTypes.IS_MAGIC)) {
            if (!source.method_48789(RunecraftoryTags.DamageTypes.BYPASS_MAGIC)) {
                reduce = (float)this.method_45325(RuneCraftoryAttributes.MAGIC_DEFENCE.asHolder());
            }
        } else if (!source.method_48789(class_8103.field_42241)) {
            reduce = (float)this.method_45325(RuneCraftoryAttributes.DEFENCE.asHolder());
        }
        float min = reduce > damageAmount * 2.0f ? 0.0f : 0.5f;
        return super.method_6132(source, Math.max(min, damageAmount - reduce));
    }

    protected void method_6108() {
        if (this.field_6213 == 5 && !this.method_37908().field_9236 && this.method_6065() != null) {
            LevelCalc.addXP(this.method_6065(), this.baseXP(), this.baseMoney(), this.xpLevel().getLevel());
        }
        super.method_6108();
    }

    public void method_6025(float healAmount) {
    }

    public void method_6005(double strength, double x, double z) {
    }

    public boolean method_5757() {
        return false;
    }

    public void method_5697(class_1297 entity) {
        if (entity instanceof class_1657) {
            super.method_5697(entity);
        }
    }

    public boolean method_30948() {
        return true;
    }

    public boolean canBeCollidedWith(class_1297 other) {
        return other instanceof class_1657;
    }

    private ItemElement getType(class_5425 level, class_6880<class_1959> key) {
        ItemElement element = ItemElement.values()[this.method_59922().method_43048(ItemElement.values().length)];
        if (key.method_40220(RunecraftoryTags.Biomes.IS_PLAINS) && (double)this.method_59922().method_43057() < 0.5) {
            element = ItemElement.NONE;
        } else if (key.method_40220(class_6908.field_36517) && (double)this.method_59922().method_43057() < 0.5) {
            element = ItemElement.WIND;
        } else if (key.method_40220(RunecraftoryTags.Biomes.IS_HOT) && (double)this.method_59922().method_43057() < 0.5) {
            element = ItemElement.FIRE;
        } else if (key.method_40220(class_6908.field_36512) && (double)this.method_59922().method_43057() < 0.5) {
            element = ItemElement.WIND;
        } else if ((key.method_40220(RunecraftoryTags.Biomes.IS_AQUATIC) || key.method_40220(RunecraftoryTags.Biomes.IS_COLD_OVERWORLD)) && (double)this.method_59922().method_43057() < 0.5) {
            element = ItemElement.WATER;
        } else if (key.method_40220(RunecraftoryTags.Biomes.IS_SANDY) && (double)this.method_59922().method_43057() < 0.5) {
            element = ItemElement.EARTH;
        } else if (key.method_40220(RunecraftoryTags.Biomes.IS_MAGICAL)) {
            if ((double)this.method_59922().method_43057() < 0.4) {
                element = ItemElement.LIGHT;
            } else if ((double)this.method_59922().method_43057() < 0.2) {
                element = ItemElement.LOVE;
            }
        } else if (key.method_40220(RunecraftoryTags.Biomes.IS_SPOOKY) && (double)this.method_59922().method_43057() < 0.4) {
            element = ItemElement.DARK;
        }
        if (key.method_40220(class_6908.field_37394)) {
            if ((double)this.method_59922().method_43057() < 0.3) {
                element = ItemElement.DARK;
            } else if ((double)this.method_59922().method_43057() < 0.3) {
                element = ItemElement.LIGHT;
            }
        }
        return element;
    }

    public boolean method_5680(class_3222 player) {
        return !this.removeCauseEmptyList;
    }
}

