/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.MathsHelper;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinition;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.registry.TenshilibSyncableEntityDatas;
import io.github.flemmli97.tenshilib.common.utils.TypedResource;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import org.jetbrains.annotations.Nullable;

public abstract class LeapingMonster
extends BaseMonster {
    protected List<class_1309> hitEntity;
    private final Consumer<AnimationDefinition> chargingAnim = this.animatedActionConsumer();
    private boolean initAnim;
    public static final TypedResource<class_243> LEAP_MOTION = new TypedResource(RuneCraftory.modRes("leap_motion"));

    public LeapingMonster(class_1299<? extends LeapingMonster> type, class_1937 level) {
        super(type, level);
    }

    protected Consumer<AnimationDefinition> animatedActionConsumer() {
        return anim -> {
            if (!this.method_37908().field_9236) {
                if (this.isLeapingAnimation()) {
                    this.hitEntity = null;
                } else {
                    this.setLeapMotion(null);
                }
            }
        };
    }

    @Override
    protected void definedAdditinoalSyncedData(SyncedDataContainer.Builder<BaseMonster> builder) {
        super.definedAdditinoalSyncedData(builder);
        builder.define(LEAP_MOTION, (SyncedEntityData)TenshilibSyncableEntityDatas.VEC_3.get(), null);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.initAnim) {
            this.getAnimationHandler().withChangeListener(anim -> {
                this.chargingAnim.accept((AnimationDefinition)anim);
                return false;
            });
            this.initAnim = true;
        }
    }

    @Override
    protected class_243 directionToLookAt() {
        if (this.getAnimationHandler().hasAnimation() && this.isLeapingAnim(this.getAnimationHandler().getAnimation().getID())) {
            return this.getLeapMotion();
        }
        return super.directionToLookAt();
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (this.isLeapingAnim(anim.getID())) {
            this.method_5942().method_6340();
            if (anim.isAt("attack_start")) {
                class_243 vec32 = this.getLeapVec(this.tryGetTargetPosition(this.method_5968()));
                this.method_18800(vec32.field_1352, this.leapHeightMotion(), vec32.field_1350);
                this.setLeapMotion(this.method_18798());
            }
            if (anim.isPast("attack_start") && !anim.isPast("attack_end")) {
                if (this.hitEntity == null) {
                    this.hitEntity = new ArrayList<class_1309>();
                }
                this.mobAttack(anim, this.method_5968(), e -> {
                    if (!this.hitEntity.contains(e)) {
                        this.hitEntity.add((class_1309)e);
                        this.method_6121((class_1297)e);
                    }
                });
            }
        } else {
            super.handleAttack(anim);
        }
    }

    protected abstract boolean isLeapingAnim(String var1);

    public class_243 getLeapVec(@Nullable class_243 target) {
        if (target != null) {
            return new class_243(target.field_1352 - this.method_23317(), 0.0, target.field_1350 - this.method_23321()).method_1029();
        }
        return EntityUtils.horizontalLookAngle((class_1297)this);
    }

    public double leapHeightMotion() {
        return 0.1f;
    }

    public class_243 getLeapMotion() {
        return (class_243)this.getDataContainer().get(LEAP_MOTION);
    }

    public void setLeapMotion(class_243 chargeMotion) {
        this.getDataContainer().set(LEAP_MOTION, (Object)chargeMotion);
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, class_243 target, double grow) {
        if (!this.isLeapingAnim(anim.getID())) {
            return super.calculateAttackAABB(anim, target, grow);
        }
        double width = this.method_17681();
        double speed = Math.max(width, this.method_18798().method_1033() - width);
        float yRot = 0.0f;
        if (this.getLeapMotion() != null) {
            yRot = MathsHelper.YRotFrom(this.getLeapMotion());
        }
        return new OrientedBoundingBox(OrientedBoundingBox.originAABB((class_1297)this).method_1014(0.2).method_1014(grow).method_1012(0.0, 0.0, speed), yRot, 0.0f, this.method_19538());
    }

    @Override
    public boolean adjustRotFromRider(class_1309 rider) {
        return !this.isLeapingAnimation();
    }

    public void method_5697(class_1297 entity) {
        if (this.isLeapingAnimation()) {
            return;
        }
        super.method_5697(entity);
    }

    private boolean isLeapingAnimation() {
        AnimationState anim = this.getAnimationHandler().getAnimation();
        return anim != null && this.isLeapingAnim(anim.getID());
    }
}

