/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_11;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_2244;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4153;
import net.minecraft.class_4158;
import net.minecraft.class_4208;
import net.minecraft.class_4209;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class AcquirePOITask<E extends class_1308>
extends ExtendedBehaviour<E> {
    protected final class_4140<class_4208> poiMemory;
    protected final Predicate<class_6880<class_4158>> predicate;
    protected BiPredicate<E, class_2338> canAquire = (e, pos) -> true;
    protected Consumer<E> onAqcuire = e -> {};

    public AcquirePOITask(class_4140<class_4208> poiMemory, class_5321<class_4158> poi) {
        this(poiMemory, (class_6880<class_4158> h) -> h.method_40225(poi));
    }

    public AcquirePOITask(class_4140<class_4208> poiMemory, Predicate<class_6880<class_4158>> predicate) {
        this.poiMemory = poiMemory;
        this.predicate = predicate;
        this.cooldownFor(e -> 20);
        this.field_19291.put(poiMemory, class_4141.field_18457);
    }

    public static BiPredicate<NPCEntity, class_2338> bedPredicate() {
        return (entity, pos) -> {
            class_2680 blockState = entity.method_37908().method_8320(pos);
            return blockState.method_26164(class_3481.field_16443) && ((Boolean)blockState.method_11654((class_2769)class_2244.field_9968) == false || entity.method_6113());
        };
    }

    public static BiPredicate<NPCEntity, class_2338> withinRangeOf(Function<NPCEntity, class_4208> func) {
        return (entity, pos) -> {
            class_4208 gPos = (class_4208)func.apply((NPCEntity)entity);
            if (gPos == null) {
                return true;
            }
            if (entity.method_37908().method_27983() != gPos.comp_2207()) {
                return false;
            }
            return gPos.comp_2208().method_19771((class_2382)pos, 16.0);
        };
    }

    public AcquirePOITask<E> canAquire(BiPredicate<E, class_2338> canAquire) {
        this.canAquire = canAquire;
        return this;
    }

    public AcquirePOITask<E> onAqcuire(Consumer<E> onAqcuire) {
        this.onAqcuire = onAqcuire;
        return this;
    }

    protected List<Pair<class_4140<?>, class_4141>> getMemoryRequirements() {
        return List.of();
    }

    protected void start(E entity) {
        this.findAndTakePOI(entity, this.predicate);
    }

    private void findAndTakePOI(E entity, Predicate<class_6880<class_4158>> predicate) {
        class_3218 serverLevel = (class_3218)entity.method_37908();
        class_4153 poiManager = serverLevel.method_19494();
        Set<Pair<class_6880<class_4158>, class_2338>> set = poiManager.method_30957(predicate, p -> true, entity.method_24515(), 48, class_4153.class_4155.field_18487).limit(5L).filter(p -> this.canAquire.test(entity, (class_2338)p.getSecond())).collect(Collectors.toSet());
        if (set.isEmpty()) {
            return;
        }
        class_11 path = this.tryNavigateTo(entity, set);
        if (path != null && path.method_21655()) {
            class_2338 target = path.method_48();
            poiManager.method_19132(target).ifPresent(pos -> {
                poiManager.method_19126(predicate, (h, pos2) -> pos2.equals((Object)target), target, 1);
                class_4209.method_19778((class_3218)serverLevel, (class_2338)target);
                class_4208 poiPos = class_4208.method_19443((class_5321)serverLevel.method_27983(), (class_2338)target);
                BrainUtils.setMemory((class_1309)entity, this.poiMemory, (Object)poiPos);
                this.onAqcuire.accept(entity);
            });
        }
    }

    public class_11 tryNavigateTo(E mob, Set<Pair<class_6880<class_4158>, class_2338>> poiPositions) {
        if (poiPositions.isEmpty()) {
            return null;
        }
        HashSet<class_2338> set = new HashSet<class_2338>();
        int i = 1;
        for (Pair<class_6880<class_4158>, class_2338> pair : poiPositions) {
            i = Math.max(i, ((class_4158)((class_6880)pair.getFirst()).comp_349()).comp_817());
            set.add((class_2338)pair.getSecond());
        }
        return mob.method_5942().method_29934(set, i);
    }
}

