/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.ThrowItemAt;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc.NPCAttackActions;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc.SerializableBehaviour;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc.SetSpellAttack;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc.SetWeaponBasedAttack;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.DummyBehaviour;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3902;
import net.minecraft.class_4102;
import net.minecraft.class_4115;
import net.minecraft.class_4140;
import net.minecraft.class_4142;
import net.minecraft.class_44;
import net.minecraft.class_5658;
import net.minecraft.class_5659;
import net.minecraft.class_5699;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.CustomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.util.BrainUtils;

public class SerializableBehaviours {
    public static final SerializableBehaviour<class_3902> IDLE = new SerializableBehaviour<class_3902>(MapCodec.unit((Object)class_3902.field_17274), data -> List.of(new Idle().runFor(e -> 1)));
    public static final SerializableBehaviour<WalkToData> WALK_TO = new SerializableBehaviour<WalkToData>(WalkToData.CODEC, data -> List.of(new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(data.speed())).closeEnoughDist((e, t) -> data.closeEnough()), DummyBehaviour.opt(MonsterBehaviourUtils.moveTo())));
    public static final SerializableBehaviour<WalkAwayData> WALK_AWAY = new SerializableBehaviour<WalkAwayData>(WalkAwayData.CODEC, data -> List.of(new SetWalkTargetAwayFromTarget().speedMod((e, t) -> Float.valueOf(data.speed())).minDist(data.minDistance()).radius((double)data.radius()), DummyBehaviour.opt(MonsterBehaviourUtils.moveTo())));
    public static final SerializableBehaviour<KeepDistanceData> KEEP_DISTANCE = new SerializableBehaviour<KeepDistanceData>(KeepDistanceData.CODEC, data -> List.of(new SetWalkTargetWithinDist().speedMod((e, t) -> Float.valueOf(data.speed())).min((double)data.min()).max((double)data.max()), DummyBehaviour.opt(MonsterBehaviourUtils.moveTo())));
    public static final SerializableBehaviour<RandomWalkData> RANDOM_WALK = new SerializableBehaviour<RandomWalkData>(RandomWalkData.CODEC, data -> List.of(new SetRandomWalkTarget().speedModifier((e, t) -> Float.valueOf(data.speed())).setRadius((double)data.radius()), DummyBehaviour.opt(MonsterBehaviourUtils.moveTo())));
    public static final SerializableBehaviour<WalkToData> WALK_TO_FOLLOW = new SerializableBehaviour<WalkToData>(WalkToData.CODEC, data -> List.of(new CustomBehaviour(e -> {
        class_1657 target = e.followEntity();
        if (target != null) {
            BrainUtils.setMemory((class_1309)e, (class_4140)class_4140.field_18446, (Object)new class_4102((class_1297)target, true));
            BrainUtils.setMemory((class_1309)e, (class_4140)class_4140.field_18445, (Object)new class_4142((class_4115)new class_4102((class_1297)target, false), data.speed(), data.closeEnough()));
        }
    }), DummyBehaviour.opt(MonsterBehaviourUtils.moveTo())));
    public static final SerializableBehaviour<class_3902> LOOK_AT_FOLLOW = new SerializableBehaviour<class_3902>(MapCodec.unit((Object)class_3902.field_17274), data -> List.of(new CustomBehaviour(e -> {
        class_1657 target = e.followEntity();
        if (target != null) {
            BrainUtils.setForgettableMemory((class_1309)e, (class_4140)class_4140.field_18446, (Object)new class_4102((class_1297)target, true), (int)(40 + e.method_59922().method_43048(20)));
        }
    })));
    public static final SerializableBehaviour<class_3902> ATTACK_WITH_WEAPON = new SerializableBehaviour<class_3902>(MapCodec.unit((Object)class_3902.field_17274), data -> List.of(new CustomBehaviour(e -> {
        class_1309 target = BrainUtils.getTargetOfEntity((class_1309)e);
        if (target != null) {
            BrainUtils.setForgettableMemory((class_1309)e, (class_4140)class_4140.field_18446, (Object)new class_4102((class_1297)target, true), (int)(40 + e.method_59922().method_43048(20)));
        }
    }), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new SetWeaponBasedAttack(), new CustomBehaviour(entity -> {
        class_1309 target = BrainUtils.getTargetOfEntity((class_1309)entity);
        if (target == null || !entity.method_5985().method_6369((class_1297)target) || !entity.method_42150(target)) {
            return;
        }
        entity.method_6104(class_1268.field_5808);
        entity.method_6121((class_1297)target);
    })})));
    public static final SerializableBehaviour<SpellAttackData> ATTACK_WITH_SPELL = new SerializableBehaviour<SpellAttackData>(SpellAttackData.CODEC, new SerializableBehaviour.BehaviourSequenceFactory<SpellAttackData>(){

        @Override
        public List<ExtendedBehaviour<NPCEntity>> create(SpellAttackData data) {
            return List.of(new CustomBehaviour(e -> {
                class_1309 target = BrainUtils.getTargetOfEntity((class_1309)e);
                if (target != null) {
                    BrainUtils.setForgettableMemory((class_1309)e, (class_4140)class_4140.field_18446, (Object)new class_4102((class_1297)target, true), (int)(40 + e.method_59922().method_43048(20)));
                }
            }), new SetSpellAttack<NPCEntity>(data.spell(), entity -> data.amount().method_366(NPCAttackActions.createLootContext(entity))));
        }

        @Override
        public void addCondition(SpellAttackData data, Consumer<Predicate<NPCEntity>> predicate) {
            if (!data.ignoreSeal()) {
                predicate.accept(npc -> !EntityUtils.sealed((class_1309)npc));
            }
        }
    });
    public static final SerializableBehaviour<ItemThrowData> THROW_ITEM = new SerializableBehaviour<ItemThrowData>(ItemThrowData.CODEC, data -> List.of(new CustomBehaviour(e -> {
        class_1309 target;
        Object object = target = data.throwAtTarget() ? BrainUtils.getTargetOfEntity((class_1309)e) : e.followEntity();
        if (target != null) {
            BrainUtils.setForgettableMemory((class_1309)e, (class_4140)class_4140.field_18446, (Object)new class_4102((class_1297)target, true), (int)(40 + e.method_59922().method_43048(20)));
        }
    }), new ThrowItemAt(data.stacks())));

    public record ItemThrowData(List<class_1799> stacks, boolean throwAtTarget) {
        public static final MapCodec<ItemThrowData> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)CodecUtils.ITEM_STACK_CODEC.listOf().fieldOf("items").forGetter(ItemThrowData::stacks), (App)Codec.BOOL.fieldOf("throw_at_target").forGetter(ItemThrowData::throwAtTarget)).apply((Applicative)inst, ItemThrowData::new));
    }

    public record WalkToData(float speed, int closeEnough) {
        public static final MapCodec<WalkToData> CODEC = RecordCodecBuilder.mapCodec(data -> data.group((App)Codec.FLOAT.fieldOf("walk_speed").forGetter(WalkToData::speed), (App)class_5699.field_33441.fieldOf("close_enough").forGetter(WalkToData::closeEnough)).apply((Applicative)data, WalkToData::new));
    }

    public record RandomWalkData(float speed, int radius) {
        public static final MapCodec<RandomWalkData> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.FLOAT.fieldOf("walk_speed").forGetter(RandomWalkData::speed), (App)class_5699.field_33441.fieldOf("radius").forGetter(RandomWalkData::radius)).apply((Applicative)inst, RandomWalkData::new));
    }

    public record KeepDistanceData(float speed, float min, float max) {
        public static final MapCodec<KeepDistanceData> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.FLOAT.fieldOf("walk_speed").forGetter(KeepDistanceData::speed), (App)Codec.FLOAT.fieldOf("min").forGetter(KeepDistanceData::min), (App)Codec.FLOAT.fieldOf("max").forGetter(KeepDistanceData::max)).apply((Applicative)inst, KeepDistanceData::new));
    }

    public record WalkAwayData(float speed, float minDistance, int radius) {
        public static final MapCodec<WalkAwayData> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.FLOAT.fieldOf("walk_speed").forGetter(WalkAwayData::speed), (App)Codec.FLOAT.fieldOf("min_distance").forGetter(WalkAwayData::minDistance), (App)class_5699.field_33441.fieldOf("radius").forGetter(WalkAwayData::radius)).apply((Applicative)inst, WalkAwayData::new));
    }

    public record SpellAttackData(Spell spell, boolean ignoreSeal, class_5658 amount) {
        public static final MapCodec<SpellAttackData> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)RuneCraftorySpells.SPELLS.registry().method_39673().fieldOf("spell").forGetter(SpellAttackData::spell), (App)Codec.BOOL.fieldOf("ignore_seal").forGetter(SpellAttackData::ignoreSeal), (App)class_5659.field_45888.fieldOf("amount").forGetter(SpellAttackData::amount)).apply((Applicative)inst, SpellAttackData::new));

        public SpellAttackData(Spell spell) {
            this(spell, false, (class_5658)class_44.method_32448((float)1.0f));
        }
    }
}

