/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseDamageCloud;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryParticles;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_6880;

public class LightBallEntity
extends BaseDamageCloud {
    private Type lightType = Type.LONG;
    private class_243 spawnPos;
    private float angleOffset;
    private int firstDmg = -1;

    public LightBallEntity(class_1299<? extends LightBallEntity> type, class_1937 level) {
        super(type, level);
    }

    public LightBallEntity(class_1937 level, class_1309 thrower) {
        super((class_1299<? extends BaseDamageCloud>)((class_1299)RuneCraftoryEntities.LIGHT_BALL.get()), level, thrower);
        this.setRadius(0.8f);
    }

    public static void createFrontLights(class_1937 level, class_1309 thrower, float dmgMod) {
        if (level.field_9236) {
            return;
        }
        for (int i = 0; i < 2; ++i) {
            LightBallEntity ball = new LightBallEntity(level, thrower);
            ball.setDamageMultiplier(dmgMod);
            ball.lightType = Type.FRONT;
            ball.setAngleOffset(i == 0 ? -15.0f : 15.0f);
            level.method_8649((class_1297)ball);
        }
    }

    public static void createLights(class_1937 level, class_1309 thrower, Type type, float dmgMod, int amount) {
        if (level.field_9236) {
            return;
        }
        float angle = 360.0f / (float)amount;
        for (int i = 0; i < amount; ++i) {
            LightBallEntity ball = new LightBallEntity(level, thrower);
            ball.setDamageMultiplier(dmgMod);
            ball.lightType = type;
            ball.setAngleOffset(angle * (float)i);
            level.method_8649((class_1297)ball);
        }
    }

    public void setAngleOffset(float angleOffset) {
        this.angleOffset = angleOffset;
    }

    public int maxHitCount() {
        return this.lightType == Type.FRONT ? 5 : -1;
    }

    public int livingTickMax() {
        return switch (this.lightType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 4 -> 30;
            case 0 -> 140;
            case 1 -> 240;
            case 2, 3 -> 144000;
        };
    }

    public boolean canStartDamage() {
        return this.firstDmg == -1 || (this.livingTicks - this.firstDmg) % 5 == 0;
    }

    protected class_238 damageBoundingBox() {
        return this.method_5829().method_1009(0.25, 0.25, 0.25);
    }

    public void method_5773() {
        super.method_5773();
        class_243 motion = this.method_18798();
        double newX = this.method_23317() + motion.field_1352;
        double newY = this.method_23318() + motion.field_1351;
        double newZ = this.method_23321() + motion.field_1350;
        this.method_5814(newX, newY, newZ);
        if (this.spawnPos == null) {
            this.spawnPos = this.method_19538();
        }
        if (this.method_24921() == null) {
            this.method_31472();
        }
        if (this.method_37908().field_9236) {
            AdvancedParticleContainer.make((class_2394)((class_2394)RuneCraftoryParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(0.9647059f, 0.9882353f, 0.77254903f, 0.7f)).addData((AdvancedParticleData)new ScaleData(0.4f)).addData((AdvancedParticleData)new ParticleMetaData(1, false, 0.0f)).add(this.method_37908(), this.method_23317(), this.method_23318() + (double)this.method_17682() * 0.5, this.method_23321());
        } else if (this.method_24921() != null) {
            class_1297 owner = this.method_24921();
            class_243 ownerPos = owner.method_19538();
            class_243 pos = switch (this.lightType.ordinal()) {
                default -> throw new MatchException(null, null);
                case 3 -> {
                    class_243 look = EntityUtils.horizontalLookAngle(this.method_24921()).method_1021(1.2);
                    yield look.method_1024((float)Math.PI / 180 * this.angleOffset);
                }
                case 0, 1, 2 -> new class_243((double)owner.method_17681() + 0.5, 0.0, 0.0).method_1024((float)Math.PI / 180 * ((float)(13 * this.livingTicks) + this.angleOffset));
                case 4 -> new class_243((double)owner.method_17681() + (double)(this.livingTicks * this.livingTicks) * 0.01, 0.0, 0.0).method_1024((float)Math.PI / 180 * ((float)(13 * this.livingTicks) + this.angleOffset));
            };
            this.method_18800(ownerPos.field_1352 + pos.method_10216() - this.method_23317(), ownerPos.field_1351 + (double)this.method_24921().method_17682() * 0.5 - this.method_23323(0.5), ownerPos.field_1350 + pos.method_10215() - this.method_23321());
            this.field_6007 = true;
        }
    }

    protected boolean damageEntity(class_1309 target) {
        if (CombatUtils.damageWithFaintAndCrit(this.method_24921(), (class_1297)target, new DynamicDamage.Builder((class_1297)this, this.method_24921()).magic().hurtResistant(0).element(ItemElement.LIGHT), CombatUtils.getAttributeValue(this.method_24921(), (class_6880<class_1320>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier, null)) {
            if (this.lightType == Type.LONG || this.lightType == Type.EXPAND) {
                this.method_31472();
            }
            if (this.firstDmg == -1) {
                this.firstDmg = this.livingTicks;
            }
            return true;
        }
        return false;
    }

    protected void onMaxEntities() {
        this.method_31472();
    }

    @Override
    protected void method_5749(class_2487 compound) {
        super.method_5749(compound);
        try {
            this.lightType = Type.valueOf(compound.method_10558("LightType"));
        }
        catch (IllegalArgumentException e) {
            this.lightType = Type.LONG;
        }
        this.angleOffset = compound.method_10583("AngleOffset");
        if (compound.method_10545("SpawnX")) {
            this.spawnPos = new class_243(compound.method_10574("SpawnX"), compound.method_10574("SpawnY"), compound.method_10574("SpawnZ"));
        }
    }

    @Override
    protected void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10582("LightType", this.lightType.toString());
        compound.method_10548("AngleOffset", this.angleOffset);
        if (this.spawnPos != null) {
            compound.method_10549("SpawnX", this.spawnPos.field_1352);
            compound.method_10549("SpawnY", this.spawnPos.field_1351);
            compound.method_10549("SpawnZ", this.spawnPos.field_1350);
        }
    }

    public static enum Type {
        PIERCING_SHORT,
        PIERCING_LONG,
        LONG,
        FRONT,
        EXPAND;

    }
}

