/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseDamageCloud;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryParticles;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.tenshilib.common.entity.AdvancedProjectile;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_6880;
import org.joml.Vector3f;

public class StatusBallEntity
extends BaseDamageCloud {
    private static final class_2940<Integer> TYPE_DATA = class_2945.method_12791(StatusBallEntity.class, (class_2941)class_2943.field_13327);
    private Type type = Type.SLEEP;
    private int maxLivingTicks;

    public StatusBallEntity(class_1299<? extends StatusBallEntity> type, class_1937 level) {
        super(type, level);
    }

    public StatusBallEntity(class_1937 level, class_1309 shooter) {
        super((class_1299<? extends BaseDamageCloud>)((class_1299)RuneCraftoryEntities.STATUS_BALL.get()), level, shooter);
        this.method_5814(shooter.method_23317(), shooter.method_23318(), shooter.method_23321());
    }

    public int livingTickMax() {
        return this.maxLivingTicks;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(TYPE_DATA, (Object)0);
    }

    public void setType(Type type) {
        this.type = type;
        this.field_6011.method_12778(TYPE_DATA, (Object)this.type.ordinal());
        this.maxLivingTicks = this.type.maxLivingTicks;
    }

    public void setLivingTicksMax(int ticks) {
        this.maxLivingTicks = ticks;
    }

    public void method_5674(class_2940<?> key) {
        int id;
        super.method_5674(key);
        if (key == TYPE_DATA && (id = ((Integer)this.field_6011.method_12789(TYPE_DATA)).intValue()) >= 0 && id < Type.values().length) {
            this.type = Type.values()[id];
        }
    }

    public void shootAtPos(class_243 targetPos, float velocity, float inaccuracy) {
        class_243 dir = new class_243(targetPos.method_10216() - this.method_23317(), targetPos.method_10214() - this.method_23318(), targetPos.method_10215() - this.method_23321());
        this.shoot(dir.field_1352, dir.field_1351, dir.field_1350, velocity, inaccuracy);
    }

    public void shootFromRotation(class_1297 shooter, float pitch, float yaw, float pitchOffset, float velocity, float inaccuracy) {
        float f = -class_3532.method_15374((float)(yaw * ((float)Math.PI / 180))) * class_3532.method_15362((float)(pitch * ((float)Math.PI / 180)));
        float g = -class_3532.method_15374((float)((pitch + pitchOffset) * ((float)Math.PI / 180)));
        float h = class_3532.method_15362((float)(yaw * ((float)Math.PI / 180))) * class_3532.method_15362((float)(pitch * ((float)Math.PI / 180)));
        this.shoot(f, g, h, velocity, inaccuracy);
        class_243 vec3 = shooter.method_18798();
        this.method_18799(this.method_18798().method_1031(vec3.field_1352, shooter.method_24828() ? 0.0 : vec3.field_1351, vec3.field_1350));
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        class_243 vector3d = new class_243(x, y, z).method_1029().method_1031(this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy, this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy, this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy).method_1021((double)velocity);
        this.method_18799(vector3d);
        double f = Math.sqrt(AdvancedProjectile.horizontalMag((class_243)vector3d));
        this.method_36456((float)(class_3532.method_15349((double)vector3d.field_1352, (double)vector3d.field_1350) * 57.2957763671875));
        this.method_36457((float)(class_3532.method_15349((double)vector3d.field_1351, (double)f) * 57.2957763671875));
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().field_9236) {
            switch (this.type.ordinal()) {
                case 0: 
                case 1: 
                case 2: {
                    Vector3f color = this.type.particleColor;
                    AdvancedParticleContainer.make((class_2394)((class_2394)RuneCraftoryParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(color.x(), color.y(), color.z(), 0.6f)).addData((AdvancedParticleData)new MotionData(this.field_5974.method_43059() * 0.01, Math.abs(this.field_5974.method_43059() * 0.03), this.field_5974.method_43059() * 0.01)).addData((AdvancedParticleData)new ScaleData(0.4f)).addData((AdvancedParticleData)new ParticleMetaData(10, false, 0.0f)).add(this.method_37908(), this.method_23322(1.0), this.method_23323(this.method_59922().method_43058() * 0.5) + (double)this.method_17682() * 0.4, this.method_23325(1.0));
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    Vector3f color = this.type.particleColor;
                    AdvancedParticleContainer.make((class_2394)new class_2390(color, 1.0f)).addData((AdvancedParticleData)new ScaleData(0.2f)).addData((AdvancedParticleData)new ParticleMetaData(10, false, 0.0f)).add(this.method_37908(), this.method_23322(1.0), this.method_23323(this.method_59922().method_43058() * 0.5) + (double)this.method_17682() * 0.4, this.method_23325(1.0));
                }
            }
        }
        class_243 motion = this.method_18798();
        double newX = this.method_23317() + motion.field_1352;
        double newY = this.method_23318() + motion.field_1351;
        double newZ = this.method_23321() + motion.field_1350;
        this.method_5814(newX, newY, newZ);
    }

    protected boolean damageEntity(class_1309 target) {
        DynamicDamage.Builder builder = new DynamicDamage.Builder((class_1297)this, this.method_24921()).noKnockback();
        this.type.damageMod.accept(builder);
        if (CombatUtils.damageWithFaintAndCrit(this.method_24921(), (class_1297)target, builder, CombatUtils.getAttributeValue(this.method_24921(), (class_6880<class_1320>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier, null)) {
            this.method_31472();
            return true;
        }
        return false;
    }

    protected class_238 damageBoundingBox() {
        return this.method_5829().method_1009(0.3, 0.45, 0.3);
    }

    @Override
    protected void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("StatusType", this.type.ordinal());
        compound.method_10569("MaxTicks", this.maxLivingTicks);
    }

    @Override
    protected void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.type = Type.values()[compound.method_10550("StatusType")];
        this.maxLivingTicks = compound.method_10550("MaxTicks");
    }

    public static enum Type {
        SLEEP(b -> b.magic().element(ItemElement.EARTH).withChangedAttribute((class_6880<class_1320>)RuneCraftoryAttributes.SLEEP.asHolder(), 100.0), new Vector3f(0.8117647f, 0.050980393f, 0.14901961f), 80),
        MUSHROOM_POISON(b -> b.magic().withChangedAttribute((class_6880<class_1320>)RuneCraftoryAttributes.POISON.asHolder(), 50.0), new Vector3f(0.4392157f, 0.7882353f, 0.37254903f), 40),
        PARALYSIS(b -> b.magic().withChangedAttribute((class_6880<class_1320>)RuneCraftoryAttributes.PARALYSIS.asHolder(), 50.0), new Vector3f(0.76862746f, 0.7294118f, 0.13725491f), 40),
        RAFFLESIA_SLEEP(b -> b.hurtResistant(2).magic().withChangedAttribute((class_6880<class_1320>)RuneCraftoryAttributes.SLEEP.asHolder(), 10.0).withChangedAttribute((class_6880<class_1320>)RuneCraftoryAttributes.FATIGUE.asHolder(), 2.0).withChangedAttribute((class_6880<class_1320>)RuneCraftoryAttributes.COLD.asHolder(), 2.0), new Vector3f(0.8117647f, 0.050980393f, 0.14901961f), 30),
        RAFFLESIA_PARALYSIS(b -> b.hurtResistant(2).magic().withChangedAttribute((class_6880<class_1320>)RuneCraftoryAttributes.PARALYSIS.asHolder(), 7.0).withChangedAttribute((class_6880<class_1320>)RuneCraftoryAttributes.FATIGUE.asHolder(), 2.0).withChangedAttribute((class_6880<class_1320>)RuneCraftoryAttributes.COLD.asHolder(), 2.0), new Vector3f(0.8f, 0.74509805f, 0.22352941f), 30),
        RAFFLESIA_POISON(b -> b.hurtResistant(2).magic().withChangedAttribute((class_6880<class_1320>)RuneCraftoryAttributes.POISON.asHolder(), 7.0).withChangedAttribute((class_6880<class_1320>)RuneCraftoryAttributes.FATIGUE.asHolder(), 2.0).withChangedAttribute((class_6880<class_1320>)RuneCraftoryAttributes.COLD.asHolder(), 2.0), new Vector3f(0.72156864f, 0.21960784f, 0.81960785f), 30),
        RAFFLESIA_ALL(b -> b.hurtResistant(2).magic().withChangedAttribute((class_6880<class_1320>)RuneCraftoryAttributes.SLEEP.asHolder(), 5.0).withChangedAttribute((class_6880<class_1320>)RuneCraftoryAttributes.PARALYSIS.asHolder(), 5.0).withChangedAttribute((class_6880<class_1320>)RuneCraftoryAttributes.POISON.asHolder(), 5.0), new Vector3f(0.5294118f, 0.09019608f, 0.11372549f), 30);

        public final Consumer<DynamicDamage.Builder> damageMod;
        public final Vector3f particleColor;
        public final int maxLivingTicks;

        private Type(Consumer<DynamicDamage.Builder> damageMod, Vector3f particleColor, int maxLivingTicks) {
            this.damageMod = damageMod;
            this.particleColor = particleColor;
            this.maxLivingTicks = maxLivingTicks;
        }
    }
}

