/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.utils.ElementalAttackMob;
import io.github.flemmli97.runecraftory.common.entities.utils.HealingPredicateEntity;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.DarkBallSpell;
import io.github.flemmli97.runecraftory.common.spells.HealT2Spell;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_6025;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StrafeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;

public class Demon
extends BaseMonster
implements HealingPredicateEntity,
ElementalAttackMob {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String DARK = BUILDER.add("cast", AnimationsBuilder.definition((double)0.88).marker("attack", new double[]{0.52}));
    public static final String HEAL = BUILDER.add("heal", DARK);
    public static final String INTERACT = BUILDER.add("interact", DARK);
    public static final String STAB = BUILDER.add("stab", AnimationsBuilder.definition((double)0.68).marker("attack", new double[]{0.4}));
    public static final String STAB_LONG = BUILDER.add("stab_long", AnimationsBuilder.definition((double)0.8).marker("attack", new double[]{0.48}));
    public static final String SWIPE = BUILDER.add("swipe", AnimationsBuilder.definition((double)0.88).marker("attack", new double[]{0.44}));
    public static final String SLEEP = BUILDER.add("sleep", AnimationsBuilder.definition((double)0.0).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<Demon> animationHandler = new AnimationHandler((class_1297)this, ANIMS);
    private final Predicate<class_1309> healingPredicate = e -> {
        if (this.method_6139() == null) {
            class_6025 ownable;
            if (e instanceof class_6025 && (ownable = (class_6025)e).method_6139() != null) {
                return false;
            }
            return e instanceof class_1569 && e != this.method_5968();
        }
        if (e instanceof class_6025) {
            class_6025 ownable = (class_6025)e;
            if (this.method_6139().equals(ownable.method_6139())) {
                return true;
            }
        }
        return this.method_6139().equals(e.method_5667());
    };

    public Demon(class_1299<? extends Demon> type, class_1937 level) {
        super(type, level);
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{STAB}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(4).start(new String[]{STAB_LONG}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(5).start(new String[]{SWIPE}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(5).start(new String[]{DARK}).play(MonsterBehaviourUtils.cooldownedPlay()).end(3).start(new String[]{DARK}).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifFurtherThan(4.0)).end(5).start(new String[]{HEAL}).play(MonsterBehaviourUtils.cooldownedPlay()).end(2).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(4, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), MonsterBehaviourUtils.moveTo()}).add(2, new ExtendedBehaviour[]{new StrafeTarget().strafeDistance(12.0f)}).add(3, MonsterBehaviourUtils.ifCloserThan(10.0), new ExtendedBehaviour[]{new SetRandomWalkTarget(), MonsterBehaviourUtils.moveTo()}).build();
    }

    @Override
    public class_238 attackBB(AnimationState anim) {
        double width;
        double length = width = (double)(this.method_17681() * 1.0f);
        if (anim.is(new String[]{STAB})) {
            width = (double)this.method_17681() * 1.8;
            length = (double)this.method_17681() * 4.5;
        } else if (anim.is(new String[]{STAB_LONG})) {
            width = (double)this.method_17681() * 1.8;
            length = (double)this.method_17681() * 5.5;
        } else if (anim.is(new String[]{SWIPE})) {
            width = (double)this.method_17681() * 4.35;
            length = (double)this.method_17681() * 3.6;
        }
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{DARK})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((DarkBallSpell)RuneCraftorySpells.DARK_BALL.get()).use((class_1309)this);
            }
        } else if (anim.is(new String[]{HEAL})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((HealT2Spell)RuneCraftorySpells.CURE_ALL.get()).use((class_1309)this);
            }
        } else {
            super.handleAttack(anim);
        }
    }

    public AnimationHandler<Demon> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), command == 2 ? (Spell)RuneCraftorySpells.DARK_BALL.get() : null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(DARK);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(SWIPE);
            } else {
                this.getAnimationHandler().setAnimation(STAB);
            }
        }
    }

    @Override
    public ItemElement getAttackElement() {
        return ItemElement.DARK;
    }

    @Override
    public Predicate<class_1309> healeableEntities() {
        return this.healingPredicate;
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSleepAnimation() {
        return SLEEP;
    }
}

