/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ChargingMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.SetChargeTarget;
import io.github.flemmli97.runecraftory.common.entities.ai.control.FreeMoveControl;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.FloatingFlyNavigator;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.NoClipFlyEvaluator;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.DarkBallSpell;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetSetClampedFloatingMoveTarget;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinition;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import java.util.function.Consumer;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_13;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1408;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomHoverTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import org.jetbrains.annotations.Nullable;

public class Ghost
extends ChargingMonster {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String DARKBALL = BUILDER.add("darkball", AnimationsBuilder.definition((double)0.64).marker("attack", new double[]{0.28}));
    public static final String CHARGE = BUILDER.add("charge", AnimationsBuilder.definition((double)1.2).marker("attack_start", new double[]{0.36}));
    public static final String SWING = BUILDER.add("swing", AnimationsBuilder.definition((double)0.52).marker("attack", new double[]{0.24}));
    public static final String INTERACT = BUILDER.add("interact", SWING);
    public static final String VANISH = BUILDER.add("vanish", AnimationsBuilder.definition((double)5.0).marker("teleport", new double[]{2.5}));
    public static final String STILL = BUILDER.add("still", AnimationsBuilder.definition((double)0.0).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<Ghost> animationHandler = new AnimationHandler((class_1297)this, ANIMS);
    private boolean vanishNext;

    public Ghost(class_1299<? extends Ghost> type, class_1937 level) {
        super((class_1299<? extends ChargingMonster>)type, level);
        this.method_5875(true);
        this.field_5960 = true;
        this.field_6207 = new FreeMoveControl((class_1308)this);
    }

    @Override
    protected class_1408 method_5965(class_1937 level) {
        return new FloatingFlyNavigator(this, (class_1308)this, level){

            @Override
            protected class_13 method_6336(int maxDist) {
                this.field_6678 = new NoClipFlyEvaluator();
                return new class_13(this.field_6678, maxDist);
            }
        };
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23717).method_6192(32.0);
        this.method_5996(class_5134.field_23720).method_6192(0.31);
        this.method_5996(class_5134.field_23718).method_6192(1.0);
        super.applyAttributes();
    }

    @Override
    protected Consumer<AnimationDefinition> animatedActionConsumer() {
        return anim -> {
            super.animatedActionConsumer().accept((AnimationDefinition)anim);
            if (anim != null && anim.is(new String[]{VANISH})) {
                this.vanishNext = (double)this.method_59922().method_43057() < 0.6;
            }
        };
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{DARKBALL}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().minDist(3.0f)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(5).start(new String[]{SWING}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(5).start(new String[]{CHARGE}).play(MonsterBehaviourUtils.cooldownedPlay()).prepareOptional(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(8)), MonsterBehaviourUtils.moveTo(), new SetChargeTarget()}).end(4).start(MonsterBehaviourUtils.checkedAttack(VANISH)).play(MonsterBehaviourUtils.cooldownedPlay()).end(9).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(2, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(5)), MonsterBehaviourUtils.moveTo()}).add(4, MonsterBehaviourUtils.ifCloserThan(10.0), new ExtendedBehaviour[]{new SetSetClampedFloatingMoveTarget(Double.valueOf(2.0)), MonsterBehaviourUtils.moveTo()}).add(6, MonsterBehaviourUtils.withCondition(MonsterBehaviourUtils.ifCloserThan(9.0)), new ExtendedBehaviour[]{new Idle()}).build();
    }

    @Override
    protected ExtendedBehaviour<? extends BaseMonster> getWanderBehaviour() {
        return new SetRandomHoverTarget();
    }

    @Override
    protected boolean canFloatInWater() {
        return false;
    }

    public boolean method_6057(class_1297 entity) {
        return true;
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (this.getAnimationHandler().isCurrent(new String[]{VANISH})) {
            return false;
        }
        boolean ret = super.method_5643(source, amount);
        if (ret) {
            this.vanishNext = (double)this.method_59922().method_43057() < 0.4;
        }
        return ret;
    }

    @Override
    public void method_6091(class_243 vec) {
        class_1297 class_12972 = this.method_31483();
        if (class_12972 instanceof class_1309) {
            class_1309 entity = (class_1309)class_12972;
            this.field_5960 = entity.field_5960;
        } else {
            boolean bl = this.field_5960 = !this.playDeath();
            if (this.method_23318() < (double)(this.method_37908().method_31607() + 1)) {
                vec = new class_243(vec.field_1352, 0.006, vec.field_1350);
            }
        }
        this.handleFreeTravel(vec);
    }

    @Override
    public class_238 attackBB(AnimationState anim) {
        double width = (double)this.method_17681() * 2.9;
        double length = (double)this.method_17681() * 2.5;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public DynamicDamage.Builder damageSourceAttack() {
        DynamicDamage.Builder source = super.damageSourceAttack();
        if (this.getAnimationHandler().isCurrent(new String[]{CHARGE})) {
            source.knock(DynamicDamage.KnockBackType.BACK, 1.0f);
        }
        return source;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), command == 2 ? (Spell)RuneCraftorySpells.DARK_BALL.get() : null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(DARKBALL);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(CHARGE);
            } else {
                this.getAnimationHandler().setAnimation(SWING);
            }
        }
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{DARKBALL})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((DarkBallSpell)RuneCraftorySpells.DARK_BALL.get()).use((class_1309)this);
            }
        } else if (anim.is(new String[]{VANISH})) {
            this.method_5942().method_6340();
            if (anim.isAt("teleport")) {
                class_1309 target = this.method_5968();
                if (target == null) {
                    double rX = this.method_23317() + (this.field_5974.method_43058() - 0.5) * 16.0;
                    double rY = this.method_23318() + (this.field_5974.method_43058() - 0.5) * 4.0;
                    double rZ = this.method_23321() + (this.field_5974.method_43058() - 0.5) * 16.0;
                    this.teleport(rX, rY, rZ);
                } else {
                    this.teleportTowards((class_1297)target);
                }
            }
        } else {
            super.handleAttack(anim);
        }
    }

    public AnimationHandler<Ghost> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    protected boolean isChargingAnim(String anim) {
        return anim.equals(CHARGE);
    }

    @Override
    public boolean handleChargeMovement(AnimationState anim) {
        if (this.getChargeMotion() != null) {
            this.method_18800(this.getChargeMotion().field_1352 * (double)0.98f, this.method_18798().field_1351, this.getChargeMotion().field_1350 * (double)0.98f);
            return true;
        }
        return false;
    }

    @Override
    public class_243 getChargeTo(String animation) {
        return EntityUtils.getTargetDirection((class_1308)this, class_2183.class_2184.field_9853).method_1021(this.chargingSpeed());
    }

    @Override
    public double chargingSpeed() {
        return 0.5;
    }

    @Override
    public boolean allowAnimation(@Nullable String prev, String other) {
        if (other.equals(VANISH)) {
            return this.shouldVanishNext(prev);
        }
        return super.allowAnimation(prev, other);
    }

    public boolean shouldVanishNext(String prev) {
        class_1309 target = this.method_5968();
        if (target != null && target.method_5858((class_1297)this) > 140.0) {
            return true;
        }
        return this.field_5974.method_43057() < 0.2f || !prev.equals(VANISH) && this.vanishNext;
    }

    private void teleport(double x, double y, double z) {
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339(x, y, z);
        while (mutableBlockPos.method_10264() > this.method_37908().method_31607() && !this.method_37908().method_8320((class_2338)mutableBlockPos).method_51366()) {
            mutableBlockPos.method_10098(class_2350.field_11033);
        }
        class_2680 blockState = this.method_37908().method_8320((class_2338)mutableBlockPos);
        if (!blockState.method_51366()) {
            y = this.method_23318();
        }
        this.method_5859(x, y + 1.0, z);
    }

    private void teleportTowards(class_1297 entity) {
        class_243 look = EntityUtils.horizontalLookAngle(entity).method_1021(-1.5);
        class_243 behindEntity = entity.method_19538().method_1019(look);
        class_243 dir = new class_243(behindEntity.field_1352 - this.method_23317(), behindEntity.field_1351 - this.method_23318(), behindEntity.field_1350 - this.method_23321());
        if (dir.method_1027() < 100.0) {
            this.teleport(behindEntity.field_1352, behindEntity.field_1351, behindEntity.field_1350);
        } else {
            dir = dir.method_1029();
            double e = this.method_23317() + this.field_5974.method_43058() * 9.0 * dir.field_1352;
            double g = this.method_23321() + this.field_5974.method_43058() * 9.0 * dir.field_1350;
            this.teleport(e, entity.method_23318(), g);
        }
    }

    protected class_3414 method_5994() {
        return (class_3414)RuneCraftorySounds.ENTITY_GHOST_AMBIENT.get();
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSleepAnimation() {
        return STILL;
    }
}

