/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.misc.MobArrowEntity;
import io.github.flemmli97.runecraftory.common.entities.monster.Goblin;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinition;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1753;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_5819;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StayWithinDistanceOfAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StrafeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import org.joml.Vector3d;

public class GoblinArcher
extends Goblin {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder(Goblin.BUILDER, new String[]{SLEEP});
    public static final String BOW = BUILDER.add("bow", AnimationsBuilder.definition((double)0.8).marker("attack", new double[]{0.52}));
    public static final String TRIPLE = BUILDER.add("triple", BOW);
    public static final String KICK = BUILDER.add("kick", AnimationsBuilder.definition((double)0.56).marker("attack", new double[]{0.32}));
    public static final String INTERACT = BUILDER.add("interact", KICK);
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<GoblinArcher> animationHandler = new AnimationHandler((class_1297)this, ANIMS);

    public GoblinArcher(class_1299<? extends Goblin> type, class_1937 level) {
        super(type, level);
    }

    @Override
    protected void method_5964(class_5819 random, class_1266 difficulty) {
        this.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8102));
        this.method_5946(class_1304.field_6173, 0.0f);
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{KICK}).play(MonsterBehaviourUtils.requireInRangePlay()).condition(MonsterBehaviourUtils.inAABBRange(KICK)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(5).start(new String[]{BOW}).play(MonsterBehaviourUtils.cooldownedPlay()).condition(e -> e.method_6047().method_7909() instanceof class_1753).prepare(new ExtendedBehaviour[]{new StrafeTarget().strafeDistance(10.0f)}).end(7).start(new String[]{TRIPLE}).play(MonsterBehaviourUtils.cooldownedPlay()).condition(e -> e.method_6047().method_7909() instanceof class_1753).prepare(new ExtendedBehaviour[]{new StrafeTarget().strafeDistance(10.0f)}).end(4).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(2, new ExtendedBehaviour[]{new StayWithinDistanceOfAttackTarget().maxDistance(15.0f)}).add(3, new ExtendedBehaviour[]{new StrafeTarget()}).add(1, MonsterBehaviourUtils.ifCloserThan(10.0), new ExtendedBehaviour[]{new SetRandomWalkTarget(), MonsterBehaviourUtils.moveTo()}).add(2, MonsterBehaviourUtils.ifFurtherThan(7.0), new ExtendedBehaviour[]{new Idle()}).build();
    }

    @Override
    public void setupAttack(AnimationDefinition anim) {
        if (anim.is(new String[]{BOW, TRIPLE})) {
            this.method_6019(class_1268.field_5808);
        }
        super.setupAttack(anim);
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{BOW, TRIPLE})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                boolean withTarget;
                boolean bl = withTarget = this.method_5968() != null && this.method_5985().method_6369((class_1297)this.method_5968());
                if (anim.is(new String[]{BOW})) {
                    if (withTarget) {
                        this.shootArrow(this.method_5968());
                    } else {
                        this.shootArrowFromRotation((class_1309)this);
                    }
                } else if (withTarget) {
                    this.shootTripleArrow(this.method_5968());
                } else {
                    this.shootTripleArrowFromRotation((class_1309)this);
                }
                this.method_6021();
            }
        } else {
            super.handleAttack(anim);
        }
    }

    @Override
    public class_238 attackBB(AnimationState anim) {
        double width = (double)this.method_17681() * 1.3;
        double length = (double)this.method_17681() * 1.7;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    public AnimationHandler<GoblinArcher> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), command == 2 ? (Spell)RuneCraftorySpells.TRIPLE_ARROW.get() : null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(TRIPLE);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(BOW);
            } else {
                this.getAnimationHandler().setAnimation(KICK);
            }
        }
    }

    private void shootArrow(class_1309 target) {
        MobArrowEntity arrow = new MobArrowEntity(this.method_37908(), (class_1309)this, 0.8f);
        class_243 dir = new class_243(target.method_23317() - arrow.method_23317(), target.method_23323(0.33) - arrow.method_23318(), target.method_23321() - arrow.method_23321());
        double l = Math.sqrt(dir.field_1352 * dir.field_1352 + dir.field_1350 * dir.field_1350);
        dir = dir.method_1031(0.0, l * 0.2, 0.0);
        arrow.method_7485(dir.field_1352, dir.field_1351, dir.field_1350, 1.3f, 7 - this.method_37908().method_8407().method_5461() * 2);
        this.method_5783(class_3417.field_14633, 1.0f, 1.0f / (this.method_59922().method_43057() * 0.4f + 0.8f));
        this.method_37908().method_8649((class_1297)arrow);
    }

    private void shootArrowFromRotation(class_1309 shooter) {
        MobArrowEntity arrow = new MobArrowEntity(this.method_37908(), (class_1309)this, 0.8f);
        arrow.method_24919((class_1297)shooter, shooter.method_36455(), shooter.method_36454(), 0.0f, 1.3f, 7 - this.method_37908().method_8407().method_5461() * 2);
        this.method_5783(class_3417.field_14633, 1.0f, 1.0f / (this.method_59922().method_43057() * 0.4f + 0.8f));
        this.method_37908().method_8649((class_1297)arrow);
    }

    private void shootTripleArrow(class_1309 target) {
        MobArrowEntity arrow = new MobArrowEntity(this.method_37908(), (class_1309)this, 0.8f);
        class_243 dir = new class_243(target.method_23317() - arrow.method_23317(), target.method_23323(0.33) - arrow.method_23318(), target.method_23321() - arrow.method_23321());
        double l = Math.sqrt(dir.field_1352 * dir.field_1352 + dir.field_1350 * dir.field_1350);
        dir = dir.method_1031(0.0, l * 0.2, 0.0);
        arrow.method_7485(dir.field_1352, dir.field_1351, dir.field_1350, 1.3f, 7 - this.method_37908().method_8407().method_5461() * 2);
        this.method_37908().method_8649((class_1297)arrow);
        class_243 up = this.method_18864(1.0f);
        Vector3d dir3d = new Vector3d(dir.method_10216(), dir.method_10214(), dir.method_10215());
        for (float y = -15.0f; y <= 15.0f; y += 30.0f) {
            Vector3d newDir = dir3d.rotateAxis((double)(y * ((float)Math.PI / 180)), up.method_10216(), up.method_10214(), up.method_10215(), new Vector3d());
            MobArrowEntity arrowO = new MobArrowEntity(this.method_37908(), (class_1309)this, 0.8f);
            arrowO.method_7485(newDir.x(), newDir.y(), newDir.z(), 1.3f, 7 - this.method_37908().method_8407().method_5461() * 2);
            this.method_37908().method_8649((class_1297)arrowO);
        }
        this.method_5783(class_3417.field_14633, 1.0f, 1.0f / (this.method_59922().method_43057() * 0.4f + 0.8f));
    }

    private void shootTripleArrowFromRotation(class_1309 shooter) {
        for (int i = 0; i < 3; ++i) {
            MobArrowEntity arrow = new MobArrowEntity(this.method_37908(), (class_1309)this, 0.8f);
            arrow.method_24919((class_1297)shooter, shooter.method_36455(), shooter.method_36454() + (float)((i - 1) * 15), 0.0f, 1.3f, 7 - this.method_37908().method_8407().method_5461() * 2);
            this.method_5783(class_3417.field_14633, 1.0f, 1.0f / (this.method_59922().method_43057() * 0.4f + 0.8f));
            this.method_37908().method_8649((class_1297)arrow);
        }
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }
}

