/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.control.FreeMoveControl;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.FloatingFlyNavigator;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.PoisonNeedleSpell;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1408;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StayWithinDistanceOfAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomHoverTarget;
import org.jetbrains.annotations.Nullable;

public class Hornet
extends BaseMonster {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String ATTACK = BUILDER.add("attack", AnimationsBuilder.definition((double)0.68).marker("attack", new double[]{0.36}));
    public static final String INTERACT = BUILDER.add("interact", ATTACK);
    public static final String STILL = BUILDER.add("still", AnimationsBuilder.definition((double)0.0).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<Hornet> animationHandler = new AnimationHandler((class_1297)this, ANIMS);

    public Hornet(class_1299<? extends BaseMonster> type, class_1937 level) {
        super(type, level);
        this.field_6207 = new FreeMoveControl((class_1308)this);
        this.method_5875(true);
    }

    @Override
    protected class_1408 method_5965(class_1937 level) {
        return new FloatingFlyNavigator((class_1308)this, level);
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23717).method_6192(32.0);
        this.method_5996(class_5134.field_23720).method_6192(0.27);
        super.applyAttributes();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{ATTACK}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(3.0).max(12.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(1).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(4, new ExtendedBehaviour[]{new StayWithinDistanceOfAttackTarget().maxDistance(15.0f)}).add(2, MonsterBehaviourUtils.ifCloserThan(10.0), new ExtendedBehaviour[]{new SetRandomHoverTarget(), MonsterBehaviourUtils.moveTo()}).build();
    }

    @Override
    public void method_6091(class_243 vec) {
        this.handleFreeTravel(vec);
    }

    @Override
    public int animationCooldown(@Nullable String anim) {
        int diffAdd = this.difficultyCooldown();
        if (anim == null) {
            return this.method_59922().method_43048(20) + 30 + diffAdd;
        }
        return this.method_59922().method_43048(40) + 35 + diffAdd;
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{ATTACK})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((PoisonNeedleSpell)RuneCraftorySpells.POISON_NEEDLE.get()).use((class_1309)this);
            }
        }
    }

    public AnimationHandler<Hornet> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), (Spell)RuneCraftorySpells.POISON_NEEDLE.get())) {
                return;
            }
            this.getAnimationHandler().setAnimation(ATTACK);
        }
    }

    protected void method_5623(double dist, boolean groundLogic, class_2680 state, class_2338 pos) {
    }

    public int method_5970() {
        return 25;
    }

    protected class_3414 method_5994() {
        return (class_3414)RuneCraftorySounds.ENTITY_HORNET_BUZZ.get();
    }

    protected void method_5712(class_2338 pos, class_2680 blockIn) {
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return (class_3414)RuneCraftorySounds.ENTITY_HORNET_HURT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)RuneCraftorySounds.ENTITY_HORNET_DEATH.get();
    }

    public float method_6017() {
        return 1.0f + (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f;
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSleepAnimation() {
        return STILL;
    }
}

