/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import java.util.function.Consumer;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_3414;
import net.minecraft.class_5819;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;

public class Orc
extends BaseMonster {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String MELEE_1 = BUILDER.add("attack_1", AnimationsBuilder.definition((double)1.0).marker("attack", new double[]{0.72}));
    public static final String INTERACT = BUILDER.add("interact", MELEE_1);
    public static final String MELEE_2 = BUILDER.add("attack_2", AnimationsBuilder.definition((double)1.04).marker("attack", new double[]{0.56}));
    public static final String SLEEP = BUILDER.add("sleep", AnimationsBuilder.definition((double)0.0).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<Orc> animationHandler = new AnimationHandler((class_1297)this, ANIMS);

    public Orc(class_1299<? extends Orc> type, class_1937 level) {
        super(type, level);
    }

    @Override
    protected void method_5964(class_5819 random, class_1266 difficulty) {
        this.method_5673(class_1304.field_6173, new class_1799((class_1935)RuneCraftoryItems.ORC_MAZE.get()));
        this.method_5946(class_1304.field_6173, 0.0f);
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{MELEE_1}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(1).start(new String[]{MELEE_2}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(1).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(3, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), MonsterBehaviourUtils.moveTo()}).add(1, MonsterBehaviourUtils.ifCloserThan(7.0), new ExtendedBehaviour[]{new SetRandomWalkTarget(), MonsterBehaviourUtils.moveTo()}).add(2, MonsterBehaviourUtils.withCondition(MonsterBehaviourUtils.ifCloserThan(9.0)), new ExtendedBehaviour[]{new Idle()}).build();
    }

    @Override
    public class_238 attackBB(AnimationState anim) {
        double width = (double)this.method_17681() * 1.8;
        double length = (double)this.method_17681() * 2.1;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, this.vehicleDependentHeight() + 0.02, length);
    }

    @Override
    public void mobAttack(AnimationState anim, class_1309 target, Consumer<class_1309> cons) {
        super.mobAttack(anim, target, cons);
        if (this.method_6047().method_31574((class_1792)RuneCraftoryItems.ORC_MAZE.get())) {
            this.method_5783((class_3414)RuneCraftorySounds.ENTITY_ORC_BONK.get(), 1.0f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
        }
    }

    public AnimationHandler<? extends Orc> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), null)) {
                return;
            }
            if (this.field_5974.method_43048(2) == 0) {
                this.getAnimationHandler().setAnimation(MELEE_1);
            } else {
                this.getAnimationHandler().setAnimation(MELEE_2);
            }
        }
    }

    protected class_3414 method_5994() {
        return (class_3414)RuneCraftorySounds.ENTITY_ORC_AMBIENT.get();
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return (class_3414)RuneCraftorySounds.ENTITY_ORC_HURT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)RuneCraftorySounds.ENTITY_ORC_DEATH.get();
    }

    public float method_6017() {
        return 1.0f + (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f;
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSleepAnimation() {
        return SLEEP;
    }
}

