/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.WebShotSpell;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1408;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5134;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StrafeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.navigation.SmoothWallClimberNavigation;

public class Spider
extends BaseMonster {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String MELEE = BUILDER.add("attack", AnimationsBuilder.definition((double)0.6).marker("attack", new double[]{0.48}));
    public static final String INTERACT = BUILDER.add("interact", MELEE);
    public static final String WEBSHOT = BUILDER.add("webshot", AnimationsBuilder.definition((double)0.68).marker("attack", new double[]{0.36}));
    public static final String STILL = BUILDER.add("still", AnimationsBuilder.definition((double)0.0).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    public static final int CLIMB_MAX = 9;
    private static final class_2940<Boolean> CLIMBING_SYNC = class_2945.method_12791(Spider.class, (class_2941)class_2943.field_13323);
    private final AnimationHandler<Spider> animationHandler = new AnimationHandler((class_1297)this, ANIMS);
    public int climbingTicker = -1;

    public Spider(class_1299<? extends Spider> type, class_1937 level) {
        super(type, level);
    }

    @Override
    protected class_1408 method_5965(class_1937 level) {
        return new SmoothWallClimberNavigation((class_1308)this, level);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(CLIMBING_SYNC, (Object)false);
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23719).method_6192(0.27);
        super.applyAttributes();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{MELEE}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(4).start(new String[]{WEBSHOT}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new StrafeTarget().strafeDistance(8.0f)}).end(7).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(5, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), MonsterBehaviourUtils.moveTo()}).add(3, MonsterBehaviourUtils.ifCloserThan(10.0), new ExtendedBehaviour[]{new SetRandomWalkTarget(), MonsterBehaviourUtils.moveTo()}).add(3, MonsterBehaviourUtils.ifFurtherThan(7.0), new ExtendedBehaviour[]{new Idle()}).build();
    }

    @Override
    public void method_5773() {
        super.method_5670();
        if (!this.method_37908().field_9236) {
            this.setClimbing(this.field_5976);
        }
        this.climbingTicker = this.isClimbing() && this.method_5805() && !this.playDeath() ? Math.min(this.climbingTicker + 1, 9) : Math.max(this.climbingTicker - 1, -1);
    }

    public boolean isClimbing() {
        return (Boolean)this.field_6011.method_12789(CLIMBING_SYNC);
    }

    public void setClimbing(boolean climbing) {
        this.field_6011.method_12778(CLIMBING_SYNC, (Object)climbing);
    }

    public boolean method_6101() {
        return this.isClimbing();
    }

    public void method_5844(class_2680 state, class_243 motionMultiplier) {
        if (!state.method_27852(class_2246.field_10343)) {
            super.method_5844(state, motionMultiplier);
        }
    }

    @Override
    public class_238 attackBB(AnimationState anim) {
        double width = (double)this.method_17681() * 1.5;
        double length = (double)this.method_17681() * 1.7;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{WEBSHOT})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack") && (this.method_5968() != null && this.method_5985().method_6369((class_1297)this.method_5968()) || this.method_31483() instanceof class_1657)) {
                ((WebShotSpell)RuneCraftorySpells.WEB_SHOT.get()).use((class_1309)this);
            }
        } else {
            super.handleAttack(anim);
        }
    }

    public AnimationHandler<Spider> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), command == 1 ? (Spell)RuneCraftorySpells.WEB_SHOT.get() : null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(WEBSHOT);
            } else {
                this.getAnimationHandler().setAnimation(MELEE);
            }
        }
    }

    protected class_3414 method_5994() {
        return class_3417.field_15170;
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return class_3417.field_14657;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14579;
    }

    protected int method_23329(float distance, float damageMultiplier) {
        return (int)((double)(super.method_23329(distance, damageMultiplier) - 3) * 0.5);
    }

    public float method_6017() {
        return (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.3f;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(class_3417.field_14760, 0.15f, 1.0f);
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSleepAnimation() {
        return STILL;
    }
}

