/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.ElementBallBarrageSpell;
import io.github.flemmli97.runecraftory.common.spells.SlashSpell;
import io.github.flemmli97.runecraftory.common.spells.WaterLaserSpell;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.data.AnimationPlayHolder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.registry.TenshilibSyncableEntityDatas;
import io.github.flemmli97.tenshilib.common.utils.TypedResource;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_1259;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;

public class Chimera
extends BossMonster {
    public static final TypedResource<class_243> CHARGE_MOTION = new TypedResource(RuneCraftory.modRes("charge_motion"));
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String LEAP = BUILDER.add("leap", AnimationsBuilder.definition((double)1.68).marker("attack_start", new double[]{0.36}).marker("attack_end", new double[]{1.44}));
    public static final String FIRE_TAIL_BUBBLE = BUILDER.add("tail_beam", AnimationsBuilder.definition((double)1.48).marker("attack", new double[]{0.44}));
    public static final String WATER_TAIL_BUBBLE = BUILDER.add("water_tail_bubble", FIRE_TAIL_BUBBLE);
    public static final String WATER_TAIL_BEAM = BUILDER.add("water_tail_beam", FIRE_TAIL_BUBBLE);
    public static final String FIRE_BREATH = BUILDER.add("breath_attack", AnimationsBuilder.definition((double)1.24).marker("attack", new double[]{0.48}));
    public static final String BUBBLE_BEAM = BUILDER.add("bubble_beam", FIRE_BREATH);
    public static final String SLASH = BUILDER.add("claw_attack", AnimationsBuilder.definition((double)0.76).marker("attack", new double[]{0.48}));
    public static final String INTERACT = BUILDER.add("interact", SLASH);
    public static final String BITE = BUILDER.add("bite_attack", AnimationsBuilder.definition((double)1.04).marker("attack_1", new double[]{0.4}).marker("attack_2", new double[]{0.76}));
    public static final String SLEEP = BUILDER.add("sleep", AnimationsBuilder.definition((double)0.0).infinite());
    public static final String SPAWN = BUILDER.add("spawn", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.32}));
    public static final String ANGRY = BUILDER.add("angry", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.32}));
    public static final String DEFEAT = BUILDER.add("defeat", AnimationsBuilder.definition((double)DEATH_DURATION, (boolean)false).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private static final ImmutableMap<String, BiConsumer<AnimationState, Chimera>> ATTACK_HANDLER = Chimera.createAnimationHandler(b -> {
        BiConsumer<AnimationState, Chimera> summonFire = (anim, entity) -> {
            if (!anim.isPast("attack") && entity.method_5968() != null) {
                entity.setTargetPosition(entity.method_5968());
            }
            if (anim.isAt("attack")) {
                ((ElementBallBarrageSpell)RuneCraftorySpells.FIREBALL_BARRAGE.get()).use((class_1309)entity);
            }
        };
        b.put((Object)FIRE_TAIL_BUBBLE, summonFire);
        b.put((Object)FIRE_BREATH, summonFire);
        BiConsumer<AnimationState, Chimera> summonWater = (anim, entity) -> {
            if (!anim.isPast("attack") && entity.method_5968() != null) {
                entity.setTargetPosition(entity.method_5968());
            }
            if (anim.isAt("attack")) {
                ((ElementBallBarrageSpell)RuneCraftorySpells.BUBBLE_BEAM.get()).use((class_1309)entity);
            }
        };
        b.put((Object)BUBBLE_BEAM, summonWater);
        b.put((Object)WATER_TAIL_BUBBLE, summonWater);
        b.put((Object)WATER_TAIL_BEAM, (anim, entity) -> {
            if (!anim.isPast("attack") && entity.method_5968() != null) {
                entity.setTargetPosition(entity.method_5968());
            }
            if (anim.isAt("attack")) {
                ((WaterLaserSpell)RuneCraftorySpells.WATER_LASER.get()).use((class_1309)entity);
            }
        });
        b.put((Object)LEAP, (anim, entity) -> {
            if (anim.isPast("attack_start") && !anim.isPast("attack_end")) {
                class_243 dir;
                if (entity.hitEntity == null) {
                    entity.hitEntity = new ArrayList<class_1309>();
                }
                if (entity.getChargeMotion() == null) {
                    dir = EntityUtils.getTargetDirection((class_1308)entity, class_2183.class_2184.field_9853, true).method_1021(0.5);
                    entity.setChargeMotion(new class_243(dir.field_1352, 0.0, dir.field_1350));
                }
                dir = entity.getChargeMotion();
                entity.method_18800(dir.field_1352, entity.method_18798().field_1351, dir.field_1350);
                entity.mobAttack((AnimationState)anim, null, e -> {
                    if (!entity.hitEntity.contains(e) && CombatUtils.mobAttack((class_1309)entity, (class_1297)e, new DynamicDamage.Builder((class_1297)entity).hurtResistant(5).knock(DynamicDamage.KnockBackType.UP, 0.4f))) {
                        entity.chargeAttackSuccess = true;
                        entity.hitEntity.add((class_1309)e);
                    }
                });
            }
        });
        b.put((Object)SLASH, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((SlashSpell)RuneCraftorySpells.SLASH.get()).use((class_1309)entity);
            }
        });
        b.put((Object)BITE, (anim, entity) -> {
            if (anim.isAt("attack_1")) {
                entity.mobAttack((AnimationState)anim, entity.method_5968(), e -> CombatUtils.mobAttack((class_1309)entity, (class_1297)e, new DynamicDamage.Builder((class_1297)entity).hurtResistant(5).noKnockback()));
            } else if (anim.isAt("attack_2")) {
                entity.mobAttack((AnimationState)anim, entity.method_5968(), entity::method_6121);
            }
        });
        BiConsumer<AnimationState, Chimera> trigger = (anim, entity) -> {
            if (anim.isAt("sound")) {
                entity.method_5783((class_3414)RuneCraftorySounds.ENTITY_CHIMERA_ROAR.get(), 1.0f, 1.0f + (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f);
            }
        };
        b.put((Object)SPAWN, trigger);
        b.put((Object)ANGRY, trigger);
    });
    private final AnimationHandler<Chimera> animationHandler = new AnimationHandler((class_1297)this, ANIMS).withChangeListener(anim -> {
        if (!this.method_37908().field_9236) {
            if (anim == null) {
                this.setChargeMotion(null);
            } else if (anim.is(new String[]{LEAP})) {
                this.chargeAttackSuccess = false;
            }
            this.hitEntity = null;
            return false;
        }
        return false;
    });
    protected boolean chargeAttackSuccess;
    protected List<class_1309> hitEntity;

    public Chimera(class_1299<? extends Chimera> type, class_1937 level) {
        super((class_1299<? extends BossMonster>)type, level);
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(RuneCraftoryEntities.CHIMERA.getID(), this.method_5476(), class_1259.class_1260.field_5780, class_1259.class_1261.field_5795).setMusic((class_3414)RuneCraftorySounds.CHIMERA_FIGHT.get());
    }

    @Override
    protected void definedAdditinoalSyncedData(SyncedDataContainer.Builder<BaseMonster> builder) {
        super.definedAdditinoalSyncedData(builder);
        builder.define(CHARGE_MOTION, (SyncedEntityData)TenshilibSyncableEntityDatas.VEC_3.get(), null);
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23719).method_6192(0.31);
        this.method_5996(class_5134.field_47761).method_6192(((class_1320)class_5134.field_47761.comp_349()).method_6169() + 1.0);
        super.applyAttributes();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(MonsterBehaviourUtils.checkedAttack(AnimationPlayHolder.builder((String)LEAP).start(BITE, m -> m.chargeAttackSuccess).build())).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(12.0)).end(10).start(MonsterBehaviourUtils.checkedAttack(FIRE_TAIL_BUBBLE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(18.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().speedMod((e, t) -> Float.valueOf(1.1f)).min(4.0).max(10.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(8).start(MonsterBehaviourUtils.checkedAttack(FIRE_TAIL_BUBBLE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(18.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().speedMod((e, t) -> Float.valueOf(1.1f)).min(4.0).max(10.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(8).start(MonsterBehaviourUtils.checkedAttack(WATER_TAIL_BUBBLE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(18.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().speedMod((e, t) -> Float.valueOf(1.1f)).min(4.0).max(10.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(8).start(MonsterBehaviourUtils.checkedAttack(WATER_TAIL_BEAM)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(18.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().speedMod((e, t) -> Float.valueOf(1.1f)).min(4.0).max(10.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(8).start(MonsterBehaviourUtils.checkedAttack(BUBBLE_BEAM)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(18.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().speedMod((e, t) -> Float.valueOf(1.1f)).min(4.0).max(10.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(8).start(MonsterBehaviourUtils.checkedAttack(SLASH)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(10.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(10).start(MonsterBehaviourUtils.checkedAttack(SLASH)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(5.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(15).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(10, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.1f)), MonsterBehaviourUtils.moveTo()}).add(7, MonsterBehaviourUtils.ifCloserThan(12.0), new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().radius(4.0).speedMod((e, t) -> Float.valueOf(1.1f)), MonsterBehaviourUtils.moveTo()}).build();
    }

    @Override
    protected ExtendedBehaviour<? extends BaseMonster> getWanderBehaviour() {
        return new SetRandomWalkTarget().speedModifier(0.7f);
    }

    @Override
    public double sprintSpeedThreshold() {
        return 0.9;
    }

    public void method_5762(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new String[]{LEAP})) {
            return;
        }
        super.method_5762(x, y, z);
    }

    @Override
    protected class_243 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new String[]{LEAP})) {
            return this.getChargeMotion();
        }
        return super.directionToLookAt();
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, class_243 target, double grow) {
        class_243 dir;
        if (anim.is(new String[]{LEAP})) {
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((class_1297)this).method_1009(0.3, 0.1, 0.3 + this.method_18798().method_1021(0.3).method_1033()), this.method_36454(), 0.0f, this.method_19538());
        }
        if (!anim.is(new String[]{BITE})) {
            return super.calculateAttackAABB(anim, target, grow);
        }
        double reach = (double)this.method_17681() * 0.9;
        float offset = anim.isAt("attack_1") ? 45.0f : -5.0f;
        class_1309 class_13092 = this.method_5642();
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            dir = class_243.method_1030((float)player.method_36455(), (float)(player.method_36454() + offset));
        } else if (target != null) {
            reach = Math.min(reach, this.method_19538().method_1022(target));
            dir = target.method_1020(this.method_19538()).method_1029().method_1024(offset * ((float)Math.PI / 180));
        } else {
            dir = class_243.method_1030((float)this.method_36455(), (float)(this.method_36454() + offset));
        }
        class_243 attackPos = this.method_19538().method_1019(dir.method_1021(reach));
        return new OrientedBoundingBox(this.attackBB(anim).method_1009(grow, 0.0, grow), this.method_36454() + 45.0f, 0.0f, attackPos);
    }

    @Override
    public class_238 attackBB(AnimationState anim) {
        double width = (double)this.method_17681() * 1.6;
        double length = (double)this.method_17681() * 1.7;
        if (anim.is(new String[]{BITE})) {
            width = (double)this.method_17681() * 1.2;
            length = (double)this.method_17681() * 1.3;
        }
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimationState anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    public AnimationHandler<Chimera> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (command == 2) {
                if (this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), (Spell)RuneCraftorySpells.BUBBLE_BEAM.get())) {
                    this.getAnimationHandler().setAnimation(BUBBLE_BEAM);
                }
            } else if (command == 1) {
                if (this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), (Spell)RuneCraftorySpells.SLASH.get())) {
                    this.getAnimationHandler().setAnimation(SLASH);
                }
            } else if (this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), null)) {
                this.getAnimationHandler().setAnimation(LEAP);
            }
        }
    }

    @Override
    public double ridingSpeedModifier() {
        return 1.5;
    }

    protected class_3414 method_5994() {
        return (class_3414)RuneCraftorySounds.ENTITY_CHIMERA_AMBIENT.get();
    }

    public class_243 getChargeMotion() {
        return (class_243)this.getDataContainer().get(CHARGE_MOTION);
    }

    public void setChargeMotion(class_243 direction) {
        this.getDataContainer().set(CHARGE_MOTION, (Object)direction);
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSleepAnimation() {
        return SLEEP;
    }

    @Override
    public String getSpawnAnimation() {
        return SPAWN;
    }

    @Override
    public String getAngryAnimation() {
        return ANGRY;
    }

    @Override
    public String getDeathAnimation() {
        return DEFEAT;
    }
}

