/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.AppleRain;
import io.github.flemmli97.runecraftory.common.spells.AppleShield;
import io.github.flemmli97.runecraftory.common.spells.HealT1Spell;
import io.github.flemmli97.runecraftory.common.spells.RootSpikeTriple;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinition;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.class_11;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1408;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.navigation.SmoothGroundNavigation;
import org.jetbrains.annotations.Nullable;

public class DeadTree
extends BossMonster {
    private static final class_2940<Byte> SUMMON_ANIMATION = class_2945.method_12791(DeadTree.class, (class_2941)class_2943.field_13319);
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String ATTACK = BUILDER.add("attack", AnimationsBuilder.definition((double)1.16).marker("attack", new double[]{0.72, 0.92}));
    public static final String INTERACT = BUILDER.add("interact", ATTACK);
    public static final String FALLING_APPLES = BUILDER.add("falling_apples", AnimationsBuilder.definition((double)0.92).marker("attack", new double[]{0.6}).animationId("summon"));
    public static final String APPLE_SHIELD = BUILDER.add("apple_shield", FALLING_APPLES);
    public static final String SPIKE = BUILDER.add("spike", FALLING_APPLES);
    public static final String BIG_FALLING_APPLES = BUILDER.add("big_falling_apples", FALLING_APPLES);
    public static final String MORE_FALLING_APPLES = BUILDER.add("more_falling_apples", FALLING_APPLES);
    public static final String HEAL = BUILDER.add("heal", FALLING_APPLES);
    public static final String SPAWN = BUILDER.add("spawn", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.68}));
    public static final String ANGRY = BUILDER.add("angry", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.68}));
    public static final String DEFEAT = BUILDER.add("defeat", AnimationsBuilder.definition((double)DEATH_DURATION, (boolean)false).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private static final ImmutableMap<String, BiConsumer<AnimationState, DeadTree>> ATTACK_HANDLER = DeadTree.createAnimationHandler(b -> {
        b.put((Object)ATTACK, (anim, entity) -> {
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimationState)anim, entity.method_5968(), entity::method_6121);
            }
        });
        b.put((Object)FALLING_APPLES, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((AppleRain)RuneCraftorySpells.APPLE_RAIN.get()).use((class_1309)entity);
            }
        });
        b.put((Object)APPLE_SHIELD, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((AppleShield)RuneCraftorySpells.APPLE_SHIELD.get()).use((class_1309)entity);
            }
        });
        b.put((Object)BIG_FALLING_APPLES, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((AppleRain)RuneCraftorySpells.APPLE_RAIN_BIG.get()).use((class_1309)entity);
            }
        });
        b.put((Object)MORE_FALLING_APPLES, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((AppleRain)RuneCraftorySpells.APPLE_RAIN_MORE.get()).use((class_1309)entity);
            }
        });
        b.put((Object)SPIKE, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((RootSpikeTriple)RuneCraftorySpells.ROOT_SPIKE_TRIPLE.get()).use((class_1309)entity);
            }
        });
        b.put((Object)HEAL, (anim, entity) -> {
            if (anim.isAt("attack")) {
                float healAmount = entity.method_6063() * (entity.method_59922().method_43057() * 0.1f + 0.1f);
                entity.method_6025(healAmount);
                class_3218 serverLevel = (class_3218)entity.method_37908();
                serverLevel.method_14199((class_2394)class_2398.field_11201, entity.method_23317(), entity.method_23318() + (double)entity.method_17682() + 0.5, entity.method_23321(), 0, 0.0, 0.1, 0.0, 0.0);
                HealT1Spell.spawnHealParticles((class_1309)entity);
                HealT1Spell.spawnHealParticles((class_1309)entity);
                HealT1Spell.spawnHealParticles((class_1309)entity);
            }
        });
        BiConsumer<AnimationState, DeadTree> trigger = (anim, entity) -> {
            if (anim.isAt("sound")) {
                entity.method_5783((class_3414)RuneCraftorySounds.ENTITY_DEAD_TREE_ROAR.get(), 1.0f, 1.0f + (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f);
            }
        };
        b.put((Object)SPAWN, trigger);
        b.put((Object)ANGRY, trigger);
    });
    private final AnimationHandler<DeadTree> animationHandler = new AnimationHandler((class_1297)this, ANIMS).withChangeListener(anim -> {
        if (!this.method_37908().field_9236) {
            if (anim != null) {
                if (anim.is(new String[]{APPLE_SHIELD})) {
                    this.shieldCooldown = this.method_59922().method_43048(60) + 100;
                }
                if (anim.is(new String[]{HEAL})) {
                    this.healCooldown = this.method_59922().method_43048(80) + 100;
                }
            }
        } else if (anim != null && anim.animation().equals("summon")) {
            int rand = this.field_5974.method_43048(3) + 1;
            AnimationDefinition animNew = AnimationsBuilder.definition((double)anim.length(), (boolean)false).animationId(anim.animation() + "_" + rand).withTransitionTime(anim.startTransition(), anim.endTransition()).speed(anim.speed()).build(anim.id());
            this.getAnimationHandler().setAnimationDef(animNew);
            return true;
        }
        return false;
    });
    private int shieldCooldown;
    private int healCooldown;

    public DeadTree(class_1299<? extends DeadTree> type, class_1937 level) {
        super((class_1299<? extends BossMonster>)type, level);
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(RuneCraftoryEntities.DEAD_TREE.getID(), this.method_5476(), class_1259.class_1260.field_5785, class_1259.class_1261.field_5795).setMusic((class_3414)RuneCraftorySounds.DEAD_TREE_FIGHT.get());
    }

    @Override
    protected class_1408 method_5965(class_1937 level) {
        return new SmoothGroundNavigation((class_1308)this, level){

            @Nullable
            protected class_11 method_18416(Set<class_2338> targets, int regionOffset, boolean offsetUpward, int accuracy, float followRange) {
                if (!DeadTree.this.canMove()) {
                    return null;
                }
                return super.method_18416(targets, regionOffset, offsetUpward, accuracy, followRange);
            }
        };
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23719).method_6192(0.25);
        super.applyAttributes();
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(SUMMON_ANIMATION, (Object)0);
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(MonsterBehaviourUtils.checkedAttack(ATTACK)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(7.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(9).start(MonsterBehaviourUtils.checkedAttack(FALLING_APPLES)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> !m.isEnraged() && MonsterBehaviourUtils.ifCloserThan(16.0).test(m)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(5))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(9).start(MonsterBehaviourUtils.checkedAttack(APPLE_SHIELD)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> m.shieldCooldown <= 0).end(8).start(MonsterBehaviourUtils.checkedAttack(SPIKE)).play(MonsterBehaviourUtils.cooldownedPlay()).end(9).start(MonsterBehaviourUtils.checkedAttack(BIG_FALLING_APPLES)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(BossMonster::isEnraged).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(5))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(9).start(MonsterBehaviourUtils.checkedAttack(MORE_FALLING_APPLES)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.and(BossMonster::isEnraged, MonsterBehaviourUtils.ifCloserThan(16.0))).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(5))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(10).start(MonsterBehaviourUtils.checkedAttack(HEAL)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> m.healCooldown <= 0).end(6).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(1, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), MonsterBehaviourUtils.moveTo()}).build();
    }

    @Override
    public void method_5670() {
        super.method_5670();
        if (!this.method_37908().field_9236) {
            --this.shieldCooldown;
            --this.healCooldown;
        }
    }

    @Override
    public class_238 attackBB(AnimationState anim) {
        double width = (double)this.method_17681() * 2.1;
        double length = (double)this.method_17681() * 1.85;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public int animationCooldown(String anim) {
        int cooldown = super.animationCooldown(anim);
        if (anim != null && anim.equals(SPIKE)) {
            cooldown += 40;
        }
        return cooldown;
    }

    @Override
    public void handleAttack(AnimationState anim) {
        this.method_5942().method_6340();
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    public AnimationHandler<DeadTree> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (command == 2) {
                if (this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), (Spell)RuneCraftorySpells.ROOT_SPIKE_TRIPLE.get())) {
                    this.getAnimationHandler().setAnimation(SPIKE);
                }
            } else if (command == 1) {
                if (this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), (Spell)RuneCraftorySpells.APPLE_RAIN.get())) {
                    this.getAnimationHandler().setAnimation(FALLING_APPLES);
                }
            } else if (this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), null)) {
                this.getAnimationHandler().setAnimation(ATTACK);
            }
        }
    }

    public boolean canMove() {
        return this.isTamed() || this.isEnraged();
    }

    public void method_5762(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new String[]{ANGRY, DEFEAT})) {
            return;
        }
        if (!this.canMove()) {
            return;
        }
        super.method_5762(x, y, z);
    }

    @Override
    public double deathRayOffset() {
        return this.method_5751();
    }

    protected class_3414 method_6011(class_1282 source) {
        return (class_3414)RuneCraftorySounds.ENTITY_DEAD_TREE_HURT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)RuneCraftorySounds.ENTITY_DEAD_TREE_DEATH.get();
    }

    protected void method_5712(class_2338 pos, class_2680 blockIn) {
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSleepAnimation() {
        return DEFEAT;
    }

    @Override
    public String getSpawnAnimation() {
        return SPAWN;
    }

    @Override
    public String getAngryAnimation() {
        return ANGRY;
    }

    @Override
    public String getDeathAnimation() {
        return DEFEAT;
    }
}

