/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.control.FreeMoveControl;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.FloatingFlyNavigator;
import io.github.flemmli97.runecraftory.common.entities.utils.BoundEntityListHandler;
import io.github.flemmli97.runecraftory.common.entities.utils.BoundEntityListListener;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.network.S2CScreenShake;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.BigPlateSpell;
import io.github.flemmli97.runecraftory.common.spells.DarkBeamSpell;
import io.github.flemmli97.runecraftory.common.spells.DarkBulletsSpell;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.MathsHelper;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.registry.TenshilibSyncableEntityDatas;
import io.github.flemmli97.tenshilib.common.utils.TypedResource;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.function.BiConsumer;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1335;
import net.minecraft.class_1408;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StrafeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;

public class Handonetta
extends BossMonster
implements BoundEntityListListener {
    public static final TypedResource<class_243> MOVE_DIRECTION = new TypedResource(RuneCraftory.modRes("move_direction"));
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String SWIPE = BUILDER.add("swipe", AnimationsBuilder.definition((double)1.28).marker("attack", new double[]{0.64}));
    public static final String INTERACT = BUILDER.add("interact", SWIPE);
    public static final String FLICK = BUILDER.add("flick", AnimationsBuilder.definition((double)1.32).marker("attack", new double[]{0.64}));
    public static final String SHOOT = BUILDER.add("shoot", AnimationsBuilder.definition((double)1.52).marker("attack", new double[]{0.44}));
    public static final String LASER = BUILDER.add("laser", AnimationsBuilder.definition((double)1.24).marker("aim", new double[]{0.3}).marker("attack", new double[]{0.4}));
    public static final String PLATE = BUILDER.add("plate", AnimationsBuilder.definition((double)0.88).marker("attack", new double[]{0.56}));
    public static final String GRAB = BUILDER.add("grab", AnimationsBuilder.definition((double)1.2).marker("attack", new double[]{0.56}).marker("invis_start", new double[]{0.72}).marker("grab_done", new double[]{1.04}));
    public static final String GRAB_CAUGHT = BUILDER.add("grab_caught", AnimationsBuilder.definition((double)1.96).marker("attack", new double[]{0.12, 0.6, 1.04, 1.48}).marker("attack_end", new double[]{1.8}));
    public static final String PUNCH = BUILDER.add("punch", AnimationsBuilder.definition((double)1.2).marker("attack_start", new double[]{0.28}).marker("attack_end", new double[]{1.04}));
    public static final String SPAWN = BUILDER.add("spawn", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.6}));
    public static final String ANGRY = BUILDER.add("angry", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.6}));
    public static final String DEFEAT = BUILDER.add("defeat", AnimationsBuilder.definition((double)DEATH_DURATION, (boolean)false).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private static final ImmutableMap<String, BiConsumer<AnimationState, Handonetta>> ATTACK_HANDLER = Handonetta.createAnimationHandler(b -> {
        b.put((Object)SWIPE, (anim, entity) -> {
            class_1309 target = entity.method_5968();
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimationState)anim, target, entity::method_6121);
            }
        });
        b.put((Object)FLICK, (anim, entity) -> {
            class_1309 target = entity.method_5968();
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimationState)anim, target, entity::method_6121);
            }
        });
        b.put((Object)PUNCH, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (entity.getMoveDirection() == null) {
                entity.setMoveDirection(EntityUtils.getTargetDirection((class_1308)entity, class_2183.class_2184.field_9853).method_1021(0.75));
                entity.caughtEntities.clear();
            }
            entity.method_18799(entity.getMoveDirection());
            if (anim.isPast("attack_start") && !anim.isPast("attack_end")) {
                entity.mobAttack((AnimationState)anim, null, e -> {
                    if (!entity.caughtEntities.has((class_1309)e) && CombatUtils.mobAttack((class_1309)entity, (class_1297)e, new DynamicDamage.Builder((class_1297)entity).hurtResistant(8))) {
                        entity.caughtEntities.add((class_1309)e);
                        S2CScreenShake.sendAround((class_1297)entity, 32.0, 4, 2.0f);
                    }
                });
            }
        });
        b.put((Object)SHOOT, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((DarkBulletsSpell)RuneCraftorySpells.DARK_BULLETS.get()).use((class_1309)entity);
            }
        });
        b.put((Object)LASER, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (entity.method_5968() != null && !anim.isPast("aim")) {
                entity.setTargetPosition(entity.method_5968());
            }
            if (anim.isAt("attack")) {
                ((DarkBeamSpell)RuneCraftorySpells.DARK_BEAM.get()).use((class_1309)entity);
            }
        });
        b.put((Object)PLATE, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((BigPlateSpell)RuneCraftorySpells.PLATE.get()).use((class_1309)entity);
            }
        });
        b.put((Object)GRAB, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (entity.getMoveDirection() == null) {
                entity.setMoveDirection(EntityUtils.getTargetDirection((class_1308)entity, class_2183.class_2184.field_9853).method_1021(0.45));
            }
            entity.method_18799(entity.getMoveDirection());
            if (anim.isPast("grab_done")) {
                if (!entity.caughtEntities.isEmpty()) {
                    entity.getAnimationHandler().setAnimation(GRAB_CAUGHT);
                }
            } else if (anim.isPast("attack") && !anim.isPast("grab_done")) {
                entity.mobAttack((AnimationState)anim, null, e -> {
                    if (!entity.method_5864().method_20210(RunecraftoryTags.EntityTypes.HANDONETTA_GRAP_IGNORE) && !entity.caughtEntities.has((class_1309)e)) {
                        entity.catchEntity((class_1309)e);
                    }
                });
            }
        });
        b.put((Object)GRAB_CAUGHT, (anim, entity) -> {
            entity.method_5942().method_6340();
            entity.method_18799(entity.method_18798().method_1021(0.1));
            if (anim.isAt("attack")) {
                entity.caughtEntities.forEach(entity::method_6121);
                S2CScreenShake.sendAround((class_1297)entity, 24.0, 4, 1.0f);
            }
            if (anim.isPast("attack_end") && !entity.caughtEntities.isEmpty()) {
                Platform.INSTANCE.getEntityData((class_1309)entity).setInvis(0);
                entity.caughtEntities.clear();
            }
        });
        BiConsumer<AnimationState, Handonetta> trigger = (anim, entity) -> {
            if (anim.isAt("sound")) {
                entity.method_5783((class_3414)RuneCraftorySounds.ENTITY_HANDONETTA_ROAR.get(), 1.0f, 1.0f + (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f);
            }
        };
        b.put((Object)SPAWN, trigger);
        b.put((Object)ANGRY, trigger);
    });
    private final AnimationHandler<Handonetta> animationHandler = new AnimationHandler((class_1297)this, ANIMS).withChangeListener(anim -> {
        this.setMoveDirection(null);
        if (anim != null) {
            this.method_18799(this.method_18798().method_1021(0.1));
        }
        return false;
    });
    private final BoundEntityListHandler<Handonetta> caughtEntities = new BoundEntityListHandler<Handonetta>(this);

    public Handonetta(class_1299<? extends Handonetta> type, class_1937 level) {
        super((class_1299<? extends BossMonster>)type, level);
        this.method_5875(true);
        this.field_6207 = new HandonettaMoveController((class_1308)this);
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(RuneCraftoryEntities.HANDONETTA.getID(), this.method_5476(), class_1259.class_1260.field_5786, class_1259.class_1261.field_5795).setMusic((class_3414)RuneCraftorySounds.HANDONETTA_FIGHT.get());
    }

    @Override
    protected void definedAdditinoalSyncedData(SyncedDataContainer.Builder<BaseMonster> builder) {
        super.definedAdditinoalSyncedData(builder);
        builder.define(MOVE_DIRECTION, (SyncedEntityData)TenshilibSyncableEntityDatas.VEC_3.get(), null);
    }

    @Override
    protected class_1408 method_5965(class_1937 level) {
        return new FloatingFlyNavigator((class_1308)this, level);
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23719).method_6192(0.26);
        this.method_5996(class_5134.field_23717).method_6192(32.0);
        this.method_5996(class_5134.field_23720).method_6192(0.32);
        super.applyAttributes();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(MonsterBehaviourUtils.checkedAttack(SWIPE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(7.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(11).start(MonsterBehaviourUtils.checkedAttack(FLICK)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(7.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(11).start(MonsterBehaviourUtils.checkedAttack(PUNCH)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(20.0)).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(10).start(MonsterBehaviourUtils.checkedAttack(LASER)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(20.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(4.0).max(12.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(10).start(MonsterBehaviourUtils.checkedAttack(PLATE)).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(3.0).max(14.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(9).start(MonsterBehaviourUtils.checkedAttack(GRAB)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(16.0).and(BossMonster::isEnraged)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(7))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(8).start(MonsterBehaviourUtils.checkedAttack(SHOOT)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.and(BossMonster::isEnraged, MonsterBehaviourUtils.ifCloserThan(16.0))).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(3.0).max(11.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(8).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(1, new ExtendedBehaviour[]{new StrafeTarget().strafeDistance(12.0f)}).build();
    }

    @Override
    public void method_6091(class_243 vec) {
        this.handleFreeTravel(vec);
    }

    public void method_5697(class_1297 entityIn) {
        if (this.getAnimationHandler().isCurrent(new String[]{PUNCH, GRAB})) {
            return;
        }
        super.method_5697(entityIn);
    }

    public void method_5762(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new String[]{ANGRY, DEFEAT})) {
            return;
        }
        super.method_5762(x, y, z);
    }

    @Override
    public void method_5670() {
        super.method_5670();
        if (this.getAnimationHandler().isCurrent(new String[]{GRAB, GRAB_CAUGHT})) {
            boolean invis = this.getAnimationHandler().isCurrent(new String[]{GRAB}) ? this.getAnimationHandler().getAnimation().isPast("invis_start") : this.getAnimationHandler().isCurrent(new String[]{GRAB_CAUGHT});
            this.caughtEntities.forEach(entity -> {
                if (entity.method_5805()) {
                    entity.method_18799(class_243.field_1353);
                    if (entity instanceof class_3222) {
                        class_3222 player = (class_3222)entity;
                        player.method_24203(this.method_23317(), this.method_23323(0.5), this.method_23321());
                    } else {
                        entity.method_5814(this.method_23317(), this.method_23323(0.5), this.method_23321());
                    }
                    if (invis) {
                        Platform.INSTANCE.getEntityData((class_1309)entity).setInvis(10);
                    }
                    entity.field_6037 = true;
                }
            });
        }
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        class_1309 living;
        class_1297 class_12972;
        if (this.getAnimationHandler().isCurrent(new String[]{GRAB, GRAB_CAUGHT}) && (class_12972 = source.method_5529()) instanceof class_1309 && this.caughtEntities.has(living = (class_1309)class_12972)) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    @Override
    protected class_243 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new String[]{PUNCH, GRAB})) {
            return this.getMoveDirection();
        }
        return super.directionToLookAt();
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, class_243 target, double grow) {
        class_243 dir = this.getMoveDirection();
        if (dir == null) {
            dir = target != null ? target.method_1020(this.method_19538()) : this.method_5828(1.0f);
        }
        if (anim.is(new String[]{PUNCH})) {
            float[] rots = MathsHelper.YXRotFrom(dir);
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((class_1297)this).method_1009(grow + 0.2, grow, grow + 1.2), rots[0], rots[1], this.method_19538());
        }
        if (anim.is(new String[]{GRAB})) {
            float[] rots = MathsHelper.YXRotFrom(dir);
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((class_1297)this).method_1009(grow + 0.5, 0.0, grow + 1.0), rots[0], rots[1], this.method_19538());
        }
        return super.calculateAttackAABB(anim, target, grow).inflate(0.0, grow * 2.0, 0.0);
    }

    @Override
    public class_238 attackBB(AnimationState anim) {
        double width = (double)this.method_17681() * 2.2;
        double length = (double)this.method_17681() * 1.7;
        if (anim.is(new String[]{FLICK})) {
            width = (double)this.method_17681() * 1.6;
            length = (double)this.method_17681() * 1.8;
        }
        return new class_238(-width * 0.5, -0.5, 0.0, width * 0.5, (double)this.method_17682() + 0.5, length);
    }

    @Override
    public void handleAttack(AnimationState anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    @Override
    public DynamicDamage.Builder damageSourceAttack() {
        DynamicDamage.Builder builder = super.damageSourceAttack();
        if (this.getAnimationHandler().isCurrent(new String[]{SWIPE})) {
            builder.knock(DynamicDamage.KnockBackType.BACK, 1.2f);
        }
        if (this.getAnimationHandler().isCurrent(new String[]{FLICK})) {
            builder.knock(DynamicDamage.KnockBackType.UP, 0.9f);
        }
        return builder;
    }

    public AnimationHandler<Handonetta> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), command == 2 ? (Spell)RuneCraftorySpells.DARK_BULLETS.get() : null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(SHOOT);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(FLICK);
            } else {
                this.getAnimationHandler().setAnimation(SWIPE);
            }
        }
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        super.setEnraged(flag, load);
        if (flag && !load) {
            this.getAnimationHandler().setAnimation(ANGRY);
        }
    }

    protected void method_5623(double y, boolean onGround, class_2680 state, class_2338 pos) {
        super.method_5623(y, false, state, pos);
    }

    private void catchEntity(class_1309 entity) {
        this.caughtEntities.add(entity);
    }

    public class_243 getMoveDirection() {
        return (class_243)this.getDataContainer().get(MOVE_DIRECTION);
    }

    public void setMoveDirection(class_243 direction) {
        this.getDataContainer().set(MOVE_DIRECTION, (Object)direction);
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSpawnAnimation() {
        return SPAWN;
    }

    @Override
    public String getAngryAnimation() {
        return ANGRY;
    }

    @Override
    public String getDeathAnimation() {
        return DEFEAT;
    }

    @Override
    public BoundEntityListHandler<?> getList() {
        return this.caughtEntities;
    }

    static class HandonettaMoveController
    extends FreeMoveControl {
        public HandonettaMoveController(class_1308 mob) {
            super(mob);
        }

        @Override
        public void method_6240() {
            class_1335.class_1336 current = this.field_6374;
            super.method_6240();
            if (current == class_1335.class_1336.field_6376 && this.field_6371.method_5968() != null) {
                class_243 target = this.field_6371.method_5968().method_19538().method_1031(0.0, (double)this.field_6371.method_5968().method_17682(), 0.0);
                class_243 dist = this.field_6371.method_19538().method_1020(target);
                if (dist.method_10214() < 3.0) {
                    this.field_6371.method_5976(1.0f);
                } else {
                    this.field_6371.method_5976(-1.0f);
                }
                if (dist.method_37268() < 16.0) {
                    this.field_6371.method_6125(this.field_6371.method_6029() * 2.0f);
                    this.field_6371.method_5930(-1.0f);
                    this.field_6371.method_5938(this.field_6371.field_6212 * 0.5f);
                }
            }
        }
    }
}

