/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.misc.SlashResidueEntity;
import io.github.flemmli97.runecraftory.common.entities.utils.MultiPartContainer;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.network.S2CAttackDebug;
import io.github.flemmli97.runecraftory.common.network.S2CScreenShake;
import io.github.flemmli97.runecraftory.common.particles.SkelefangParticleData;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryParticles;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.BoneNeedleSpell;
import io.github.flemmli97.runecraftory.common.spells.EnergyOrbSpell;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.tenshilib.common.entity.MultiPartEntity;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.EntityFollowData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import io.github.flemmli97.tenshilib.common.utils.math.MathUtils;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_4048;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_8103;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import org.joml.Vector3f;

public class Skelefang
extends BossMonster {
    public static final byte HEAD_DROP = 70;
    public static final byte HEAD_THROW = 71;
    public static final byte NECK_DROP = 72;
    public static final byte NECK_THROW = 73;
    public static final byte FRONT = 74;
    public static final byte FRONT_RIBS = 75;
    public static final byte LEFT_LEG = 76;
    public static final byte RIGHT_LEG = 77;
    public static final byte BACK = 78;
    public static final byte BACK_RIBS = 79;
    public static final byte TAIL = 80;
    public static final byte TAIL_BASE = 81;
    public static final byte HIT = 82;
    public static final byte SHATTER = 83;
    public static final byte CHARGE_BEAM = 84;
    private static final class_2940<Integer> HEAD_BONES = class_2945.method_12791(Skelefang.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> TAIL_BONES = class_2945.method_12791(Skelefang.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> LEFT_LEG_BONES = class_2945.method_12791(Skelefang.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> RIGHT_LEG_BONES = class_2945.method_12791(Skelefang.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> BODY_BONES = class_2945.method_12791(Skelefang.class, (class_2941)class_2943.field_13327);
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String TAIL_SLAM = BUILDER.add("tail_slam", AnimationsBuilder.definition((double)2.0).marker("attack_1", new double[]{0.72}).marker("attack_2", new double[]{1.2}).marker("attack_3", new double[]{1.64}));
    public static final String INTERACT = BUILDER.add("interact", TAIL_SLAM);
    public static final String NEEDLE_THROW = BUILDER.add("needle_throw", AnimationsBuilder.definition((double)1.24).marker("attack", new double[]{0.88}));
    public static final String TAIL_SLAP = BUILDER.add("tail_slap", AnimationsBuilder.definition((double)0.92).marker("attack", new double[]{0.6}));
    public static final String SLASH = BUILDER.add("slash", AnimationsBuilder.definition((double)1.04).marker("attack", new double[]{0.68}));
    public static final String CHARGE = BUILDER.add("charge", AnimationsBuilder.definition((double)1.76).marker("attack_start", new double[]{0.4}));
    public static final String BEAM = BUILDER.add("beam", AnimationsBuilder.definition((double)13.0).marker("charge", new double[]{4.5}).marker("beam", new double[]{6.5}).marker("restore_start", new double[]{11.0}).marker("restore_end", new double[]{12.0}).marker("restore", new double[]{11.5}));
    public static final String DEATH = BUILDER.add("death", AnimationsBuilder.definition((double)10.0).infinite());
    public static final String SPAWN = BUILDER.add("spawn", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.24}));
    public static final String ANGRY = BUILDER.add("angry", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.24}));
    public static final String DEFEAT = BUILDER.add("defeat", AnimationsBuilder.definition((double)DEATH_DURATION, (boolean)false).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private static final ImmutableMap<String, BiConsumer<AnimationState, Skelefang>> ATTACK_HANDLER = Skelefang.createAnimationHandler(b -> {
        b.put((Object)TAIL_SLAM, (anim, entity) -> {
            block2: {
                block3: {
                    if (entity.remainingTailBones() <= 10 && !entity.isEnraged()) break block2;
                    if (anim.isAt("attack_1") || anim.isAt("attack_2")) break block3;
                    if (!anim.isAt("attack_3")) break block2;
                }
                entity.mobAttack((AnimationState)anim, entity.method_5968(), entity::method_6121);
                entity.method_37908().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), (class_3414)RuneCraftorySounds.ENTITY_SKELEFANG_SWEEP.get(), entity.method_5634(), 2.0f, 1.0f);
            }
        });
        b.put((Object)NEEDLE_THROW, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((BoneNeedleSpell)RuneCraftorySpells.BONE_NEEDLES.get()).use((class_1309)entity);
                if (entity.remainingHeadBones() > 10) {
                    entity.method_37908().method_8421((class_1297)entity, (byte)71);
                    entity.setHeadBones(10, false);
                } else if (entity.remainingHeadBones() > 0) {
                    entity.method_37908().method_8421((class_1297)entity, (byte)73);
                    entity.setHeadBones(0, false);
                }
            }
        });
        b.put((Object)TAIL_SLAP, (anim, entity) -> {
            if ((entity.remainingTailBones() > 10 || entity.isEnraged()) && anim.isAt("attack")) {
                entity.mobAttack((AnimationState)anim, entity.method_5968(), entity::method_6121);
            }
        });
        b.put((Object)SLASH, (anim, entity) -> {
            if (anim.isAt("attack")) {
                SlashResidueEntity slash;
                class_243 side;
                class_243 dir;
                entity.mobAttack((AnimationState)anim, entity.method_5968(), entity::method_6121);
                class_1309 patt0$temp = entity.method_5642();
                if (patt0$temp instanceof class_1657) {
                    class_1657 player = (class_1657)patt0$temp;
                    dir = class_243.method_1030((float)0.0f, (float)player.field_6283);
                    side = class_243.method_1030((float)0.0f, (float)(player.field_6283 + 90.0f));
                } else {
                    dir = class_243.method_1030((float)0.0f, (float)entity.field_6283);
                    side = class_243.method_1030((float)0.0f, (float)(entity.field_6283 + 90.0f));
                }
                dir = dir.method_1021((double)entity.method_17681() * 0.5 + 1.0);
                if (entity.remainingLeftLegBones() > 0) {
                    class_243 leftPos = entity.method_19538().method_1019(dir).method_1019(side.method_1021(-1.3));
                    slash = new SlashResidueEntity(entity.method_37908(), (class_1309)entity);
                    slash.setSize(2.0f);
                    slash.dummy();
                    slash.method_5814(leftPos.field_1352, leftPos.field_1351, leftPos.field_1350);
                    slash.method_36457(0.0f);
                    slash.method_36456(entity.field_6283);
                    entity.method_37908().method_8649((class_1297)slash);
                }
                if (entity.remainingRightLegBones() > 0) {
                    class_243 rightPos = entity.method_19538().method_1019(dir).method_1019(side.method_1021(1.3));
                    slash = new SlashResidueEntity(entity.method_37908(), (class_1309)entity);
                    slash.setSize(2.0f);
                    slash.dummy();
                    slash.method_5814(rightPos.field_1352, rightPos.field_1351, rightPos.field_1350);
                    slash.method_36457(0.0f);
                    slash.method_36456(entity.field_6283);
                    entity.method_37908().method_8649((class_1297)slash);
                }
            }
        });
        b.put((Object)CHARGE, (anim, entity) -> {
            if (entity.hitEntity == null) {
                entity.hitEntity = new ArrayList<class_1309>();
            }
            if (anim.isPast("attack_start")) {
                class_243 dir = entity.method_5968() != null ? entity.method_5968().method_19538().method_1020(entity.method_19538()) : class_243.method_1030((float)0.0f, (float)entity.method_36454());
                if ((dir = new class_243(dir.method_10216(), 0.0, dir.method_10215())).method_1027() < 0.5) {
                    entity.method_18800(0.0, entity.method_18798().field_1351, 0.0);
                } else {
                    dir = dir.method_1029().method_1021(entity.method_45325(class_5134.field_23719) * 1.3);
                    entity.method_18800(dir.method_10216(), entity.method_18798().field_1351, dir.method_10215());
                }
                if (entity.field_6012 % 5 == 0) {
                    entity.method_5783((class_3414)RuneCraftorySounds.ENTITY_GENERIC_HEAVY_CHARGE.get(), 1.0f, (entity.field_5974.method_43057() - entity.field_5974.method_43057()) * 0.2f + 1.0f);
                    S2CScreenShake.sendAround((class_1297)entity, 24.0, 10, 1.0f);
                }
                entity.mobAttack((AnimationState)anim, null, e -> {
                    if (!entity.hitEntity.contains(e) && CombatUtils.mobAttack((class_1309)entity, (class_1297)e, new DynamicDamage.Builder((class_1297)entity).hurtResistant(5).knock(DynamicDamage.KnockBackType.UP, 0.7f).withChangedAttribute((class_6880<class_1320>)RuneCraftoryAttributes.STUN.asHolder(), 70.0))) {
                        entity.hitEntity.add((class_1309)e);
                    }
                });
            }
        });
        b.put((Object)BEAM, (anim, entity) -> {
            if (anim.isAt("charge")) {
                entity.method_37908().method_8421((class_1297)entity, (byte)84);
            }
            if (anim.isAt("beam")) {
                ((EnergyOrbSpell)RuneCraftorySpells.ENERGY_ORB_SPELL.get()).use((class_1309)entity);
            }
            if (anim.isAt("restore")) {
                entity.restoreDragon();
            }
        });
        BiConsumer<AnimationState, Skelefang> trigger = (anim, entity) -> {
            if (anim.isAt(0.24)) {
                entity.playRandomizedSound((class_3414)RuneCraftorySounds.ENTITY_SKELEFANG_ROAR.get());
                S2CScreenShake.sendAround((class_1297)entity, 32.0, 40, 2.0f);
            }
        };
        b.put((Object)SPAWN, trigger);
        b.put((Object)ANGRY, trigger);
    });
    private final AnimationHandler<Skelefang> animationHandler = new AnimationHandler((class_1297)this, ANIMS).withChangeListener(anim -> {
        if (anim != null) {
            this.hitEntity = null;
        }
        if (!this.method_37908().field_9236 && anim == null) {
            boolean chain = !this.commanded;
            this.commanded = false;
            if (chain && this.getAnimationHandler().isCurrent(new String[]{NEEDLE_THROW})) {
                if (!this.isEnraged() || this.needleChain >= 2 || this.needleChain == 1 && (double)this.method_59922().method_43057() > 0.25) {
                    this.needleChain = 0;
                    return false;
                }
                this.getAnimationHandler().setAnimation(NEEDLE_THROW);
                ++this.needleChain;
                return true;
            }
        }
        return false;
    });
    protected List<class_1309> hitEntity;
    private int hurtResist;
    private boolean ignoreHurt;
    private boolean commanded;
    private int needleChain;
    private final MultiPartContainer head = new MultiPartContainer(() -> new MultiPartEntity((class_1299)RuneCraftoryEntities.MULTIPART.get(), (class_1309)this, 1.6f, 1.3f).updatePosition(new class_243(0.0, 2.15, 2.9)));
    private final MultiPartContainer back = new MultiPartContainer(() -> new MultiPartEntity((class_1299)RuneCraftoryEntities.MULTIPART.get(), (class_1309)this, 1.6f, 1.5f).updatePosition(new class_243(0.0, 1.0, -1.5)));
    private final MultiPartContainer rightLeg;
    private final MultiPartContainer leftLeg = new MultiPartContainer(() -> new MultiPartEntity((class_1299)RuneCraftoryEntities.MULTIPART.get(), (class_1309)this, 1.6f, 2.5f).updatePosition(new class_243(1.2, 0.0, 0.0)));

    public Skelefang(class_1299<? extends Skelefang> type, class_1937 level) {
        super((class_1299<? extends BossMonster>)type, level);
        this.rightLeg = new MultiPartContainer(() -> new MultiPartEntity((class_1299)RuneCraftoryEntities.MULTIPART.get(), (class_1309)this, 1.6f, 2.5f).updatePosition(new class_243(-1.2, 0.0, 0.0)));
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(RuneCraftoryEntities.SKELEFANG.getID(), this.method_5476(), class_1259.class_1260.field_5782, class_1259.class_1261.field_5795).setMusic((class_3414)RuneCraftorySounds.SKELEFANG_FIGHT.get());
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23719).method_6192(0.2);
        super.applyAttributes();
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(HEAD_BONES, (Object)20);
        builder.method_56912(TAIL_BONES, (Object)20);
        builder.method_56912(LEFT_LEG_BONES, (Object)20);
        builder.method_56912(RIGHT_LEG_BONES, (Object)20);
        builder.method_56912(BODY_BONES, (Object)20);
    }

    @Override
    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
        if (key.equals(BODY_BONES) && !this.hasBones()) {
            this.ignoreHurt = true;
        }
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(MonsterBehaviourUtils.checkedAttack(TAIL_SLAM)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> (m.isEnraged() || m.remainingTailBones() > 10) && MonsterBehaviourUtils.ifCloserThan(7.0).test(m)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(3))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(12).start(MonsterBehaviourUtils.checkedAttack(TAIL_SLAP)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> (m.isEnraged() || m.remainingTailBones() > 10) && MonsterBehaviourUtils.ifCloserThan(7.0).test(m)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(3))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(9).start(MonsterBehaviourUtils.checkedAttack(NEEDLE_THROW)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(20.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(13))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(10).start(MonsterBehaviourUtils.checkedAttack(SLASH)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> (m.remainingLeftLegBones() > 0 || m.remainingRightLegBones() > 0) && MonsterBehaviourUtils.ifCloserThan(7.0).test(m)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(2))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(8).start(MonsterBehaviourUtils.checkedAttack(CHARGE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(15.0)).end(11).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(1, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), MonsterBehaviourUtils.moveTo()}).build();
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("HeadBones", this.remainingHeadBones());
        compound.method_10569("TailBones", this.remainingTailBones());
        compound.method_10569("LeftLegBones", this.remainingLeftLegBones());
        compound.method_10569("RightLegBones", this.remainingRightLegBones());
        compound.method_10569("BodyBones", this.remainingBodyBones());
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.field_6011.method_12778(HEAD_BONES, (Object)compound.method_10550("HeadBones"));
        this.field_6011.method_12778(TAIL_BONES, (Object)compound.method_10550("TailBones"));
        this.field_6011.method_12778(LEFT_LEG_BONES, (Object)compound.method_10550("LeftLegBones"));
        this.field_6011.method_12778(RIGHT_LEG_BONES, (Object)compound.method_10550("RightLegBones"));
        this.field_6011.method_12778(BODY_BONES, (Object)compound.method_10550("BodyBones"));
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        super.setEnraged(flag, load);
        if (flag && !load) {
            this.getAnimationHandler().setAnimation(ANGRY);
        }
    }

    @Override
    protected boolean checkRage() {
        return false;
    }

    @Override
    protected void method_6074(class_1282 source, float damageAmount) {
        if (source.method_48789(class_8103.field_42242)) {
            super.method_6074(source, damageAmount);
            if (this.method_29504()) {
                this.method_37908().method_8421((class_1297)this, (byte)83);
            }
            return;
        }
        if (this.hurtResist > 0) {
            return;
        }
        this.hurtResist = 2;
        if (this.hasBones()) {
            if (damageAmount > 4.0f) {
                int amount;
                int boneDamage = 7;
                if (this.remainingTailBones() > 0) {
                    amount = Math.min(boneDamage, this.remainingTailBones());
                    boneDamage -= amount;
                    this.setTailBones(this.remainingTailBones() - amount);
                }
                if (this.remainingLeftLegBones() > 0) {
                    amount = Math.min(boneDamage, this.remainingLeftLegBones());
                    boneDamage -= amount;
                    this.setLeftLegBones(this.remainingLeftLegBones() - amount);
                }
                if (this.remainingRightLegBones() > 0) {
                    amount = Math.min(boneDamage, this.remainingRightLegBones());
                    boneDamage -= amount;
                    this.setRightLegBones(this.remainingRightLegBones() - amount);
                }
                if (this.remainingHeadBones() > 0) {
                    amount = Math.min(boneDamage, this.remainingHeadBones());
                    boneDamage -= amount;
                    this.setHeadBones(this.remainingHeadBones() - amount);
                }
                if (this.remainingBodyBones() > 0) {
                    amount = Math.min(boneDamage, this.remainingBodyBones());
                    this.setBodyBones(this.remainingBodyBones() - amount);
                }
            }
            if (this.method_29504()) {
                this.method_37908().method_8421((class_1297)this, (byte)83);
            } else {
                this.method_37908().method_8421((class_1297)this, (byte)82);
            }
            if (!this.hasBones()) {
                this.getAnimationHandler().setAnimation(BEAM);
            }
        } else {
            super.method_6074(source, damageAmount);
        }
    }

    public void setTailBones(int amount) {
        int pre = (Integer)this.field_6011.method_12789(TAIL_BONES);
        this.field_6011.method_12778(TAIL_BONES, (Object)Math.min(amount, 20));
        if (pre > 10 && amount <= 10) {
            this.method_37908().method_8421((class_1297)this, (byte)80);
        }
        if (amount <= 0) {
            this.method_37908().method_8421((class_1297)this, (byte)81);
        }
    }

    public void setLeftLegBones(int amount) {
        this.field_6011.method_12778(LEFT_LEG_BONES, (Object)Math.min(amount, 20));
        if (amount <= 0) {
            this.method_37908().method_8421((class_1297)this, (byte)76);
        }
    }

    public void setRightLegBones(int amount) {
        this.field_6011.method_12778(RIGHT_LEG_BONES, (Object)Math.min(amount, 20));
        if (amount <= 0) {
            this.method_37908().method_8421((class_1297)this, (byte)77);
        }
    }

    public void setHeadBones(int amount) {
        this.setHeadBones(amount, true);
    }

    public void setBodyBones(int amount) {
        int pre = (Integer)this.field_6011.method_12789(BODY_BONES);
        this.field_6011.method_12778(BODY_BONES, (Object)Math.min(amount, 20));
        if (pre > 15 && amount <= 15) {
            this.method_37908().method_8421((class_1297)this, (byte)79);
        }
        if (pre > 10 && amount <= 10) {
            this.method_37908().method_8421((class_1297)this, (byte)78);
        }
        if (pre > 5 && amount <= 5) {
            this.method_37908().method_8421((class_1297)this, (byte)75);
        }
        if (amount <= 0) {
            this.method_37908().method_8421((class_1297)this, (byte)74);
        }
    }

    private void setHeadBones(int amount, boolean withParticle) {
        int pre = (Integer)this.field_6011.method_12789(HEAD_BONES);
        this.field_6011.method_12778(HEAD_BONES, (Object)Math.min(amount, 20));
        if (withParticle) {
            if (pre > 10 && amount <= 10) {
                this.method_37908().method_8421((class_1297)this, (byte)70);
            }
            if (amount <= 0) {
                this.method_37908().method_8421((class_1297)this, (byte)72);
            }
        }
    }

    public void restoreDragon() {
        this.field_6011.method_12778(HEAD_BONES, (Object)20);
        this.field_6011.method_12778(TAIL_BONES, (Object)20);
        this.field_6011.method_12778(LEFT_LEG_BONES, (Object)20);
        this.field_6011.method_12778(RIGHT_LEG_BONES, (Object)20);
        this.field_6011.method_12778(BODY_BONES, (Object)20);
    }

    public boolean checkIgnoreHurtOverlay() {
        if (this.ignoreHurt) {
            this.ignoreHurt = false;
            return true;
        }
        return false;
    }

    public boolean hasBones() {
        return this.remainingHeadBones() > 0 || this.remainingTailBones() > 0 || this.remainingLeftLegBones() > 0 || this.remainingRightLegBones() > 0 || this.remainingBodyBones() > 0;
    }

    public int remainingHeadBones() {
        return (Integer)this.field_6011.method_12789(HEAD_BONES);
    }

    public int remainingTailBones() {
        return (Integer)this.field_6011.method_12789(TAIL_BONES);
    }

    public int remainingLeftLegBones() {
        return (Integer)this.field_6011.method_12789(LEFT_LEG_BONES);
    }

    public int remainingRightLegBones() {
        return (Integer)this.field_6011.method_12789(RIGHT_LEG_BONES);
    }

    public int remainingBodyBones() {
        return (Integer)this.field_6011.method_12789(BODY_BONES);
    }

    @Override
    public void method_5711(byte id) {
        switch (id) {
            case 70: {
                this.method_37908().method_8494((class_2394)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.HEAD, this.method_36455(), this.field_6241, 1.0f, 0.0f), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
                break;
            }
            case 71: {
                class_243 look = class_243.method_1030((float)0.0f, (float)this.field_6283);
                this.method_37908().method_8494((class_2394)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.HEAD, this.method_36455(), this.field_6241, -2.0f, 0.0f, 40, false), this.method_23317(), this.method_23318(), this.method_23321(), look.field_1352, look.field_1351, look.field_1350);
                break;
            }
            case 72: {
                this.method_37908().method_8494((class_2394)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.NECK, this.method_36455(), this.field_6241, 1.0f, this.field_5974.method_43048(2) - 1), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
                break;
            }
            case 73: {
                class_243 look = class_243.method_1030((float)0.0f, (float)this.field_6283);
                this.method_37908().method_8494((class_2394)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.NECK, this.method_36455(), this.field_6241, -2.0f, 0.0f, 40, false), this.method_23317(), this.method_23318(), this.method_23321(), look.field_1352, look.field_1351, look.field_1350);
                break;
            }
            case 74: {
                this.method_37908().method_8494((class_2394)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.FRONT, this.method_36455(), this.field_6283, this.field_5974.method_43048(2) - 1, this.field_5974.method_43048(2) - 1), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
                break;
            }
            case 75: {
                this.method_37908().method_8494((class_2394)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.FRONT_RIBS, this.method_36455(), this.field_6283, this.field_5974.method_43048(2) - 1, this.field_5974.method_43048(2) - 1), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
                break;
            }
            case 76: {
                this.method_37908().method_8494((class_2394)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.LEFT_LEG, this.method_36455(), this.field_6283, this.field_5974.method_43048(2) - 1, this.field_5974.method_43048(2) - 1), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
                break;
            }
            case 77: {
                this.method_37908().method_8494((class_2394)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.RIGHT_LEG, this.method_36455(), this.field_6283, this.field_5974.method_43048(2) - 1, this.field_5974.method_43048(2) - 1), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
                break;
            }
            case 78: {
                this.method_37908().method_8494((class_2394)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.BACK, this.method_36455(), this.field_6283, this.field_5974.method_43048(2) - 1, this.field_5974.method_43048(2) - 1), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
                break;
            }
            case 79: {
                this.method_37908().method_8494((class_2394)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.BACK_RIBS, this.method_36455(), this.field_6283, this.field_5974.method_43048(2) - 1, this.field_5974.method_43048(2) - 1), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
                break;
            }
            case 80: {
                this.method_37908().method_8494((class_2394)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.TAIL, this.method_36455(), this.field_6283, this.field_5974.method_43048(2) - 1, this.field_5974.method_43048(2) - 1), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
                break;
            }
            case 81: {
                this.method_37908().method_8494((class_2394)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.TAIL_BASE, this.method_36455(), this.field_6283, this.field_5974.method_43048(2) - 1, this.field_5974.method_43048(2) - 1), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
                break;
            }
            case 82: {
                int amount = this.field_5974.method_43048(6) + 12;
                for (int i = 0; i < amount; ++i) {
                    SkelefangParticleData.SkelefangBoneType type = (double)this.field_5974.method_43057() < 0.4 ? SkelefangParticleData.SkelefangBoneType.GENERIC : SkelefangParticleData.SkelefangBoneType.GENERIC2;
                    this.method_37908().method_8494((class_2394)new SkelefangParticleData(type, this.method_36455() + (float)this.field_5974.method_43048(40) - 20.0f, this.field_6241 + (float)this.field_5974.method_43048(360), this.field_5974.method_43048(2) - 1, this.field_5974.method_43048(2) - 1), this.method_23322(1.3), this.method_23323(0.5) + (double)this.method_17682() * 0.5, this.method_23325(1.3), this.field_5974.method_43059() * 0.11, this.field_5974.method_43059() * 0.11, this.field_5974.method_43059() * 0.11);
                }
                break;
            }
            case 83: {
                int amount = this.field_5974.method_43048(15) + 35;
                if (this.hasBones()) {
                    for (int i = 0; i < amount; ++i) {
                        SkelefangParticleData.SkelefangBoneType type = (double)this.field_5974.method_43057() < 0.4 ? SkelefangParticleData.SkelefangBoneType.GENERIC : SkelefangParticleData.SkelefangBoneType.GENERIC2;
                        this.method_37908().method_8494((class_2394)new SkelefangParticleData(type, this.method_36455() + (float)this.field_5974.method_43048(40) - 20.0f, this.field_6241 + (float)this.field_5974.method_43048(360), this.field_5974.method_43048(2) - 1, this.field_5974.method_43048(2) - 1), this.method_23322(1.3), this.method_23323(0.5) + (double)this.method_17682() * 0.5, this.method_23325(1.3), this.field_5974.method_43059() * 0.13, this.field_5974.method_43059() * 0.13, this.field_5974.method_43059() * 0.13);
                    }
                }
                if (this.remainingHeadBones() > 10) {
                    this.method_5711((byte)70);
                }
                if (this.remainingHeadBones() > 0) {
                    this.method_5711((byte)72);
                }
                if (this.remainingBodyBones() > 0) {
                    this.method_5711((byte)74);
                }
                if (this.remainingBodyBones() > 5) {
                    this.method_5711((byte)75);
                }
                if (this.remainingBodyBones() > 10) {
                    this.method_5711((byte)78);
                }
                if (this.remainingBodyBones() > 15) {
                    this.method_5711((byte)79);
                }
                if (this.remainingLeftLegBones() > 0) {
                    this.method_5711((byte)76);
                }
                if (this.remainingRightLegBones() > 0) {
                    this.method_5711((byte)77);
                }
                if (this.remainingTailBones() > 0) {
                    this.method_5711((byte)81);
                }
                if (this.remainingTailBones() <= 10) break;
                this.method_5711((byte)80);
                break;
            }
            case 84: {
                class_243 center = this.method_19538().method_1031(0.0, (double)this.method_17682() * 0.5, 0.0);
                ArrayList locations = new ArrayList();
                double speed = (this.method_17681() + 2.0f) / 40.0f;
                locations.addAll(MathUtils.rotatedVecs((Vector3f)MathUtils.NORMAL_X.method_1021((double)this.method_17681() * 1.5).method_46409(), (Vector3f)MathUtils.NORMAL_Z.method_46409(), (float)-180.0f, (float)180.0f, (float)10.0f));
                locations.addAll(MathUtils.rotatedVecs((Vector3f)MathUtils.NORMAL_X.method_1021((double)this.method_17681() * 1.5).method_46409(), (Vector3f)MathUtils.NORMAL_Y.method_46409(), (float)-180.0f, (float)180.0f, (float)10.0f));
                locations.addAll(MathUtils.rotatedVecs((Vector3f)MathUtils.NORMAL_Y.method_1021((double)this.method_17681() * 1.5).method_46409(), (Vector3f)MathUtils.NORMAL_X.method_46409(), (float)-180.0f, (float)180.0f, (float)10.0f));
                for (Vector3f vec : locations) {
                    class_243 pos = center.method_1031((double)vec.x(), (double)vec.y(), (double)vec.z());
                    class_243 dir = new class_243((double)(-vec.x()), (double)(-vec.y()), (double)(-vec.z())).method_1029().method_1021(speed);
                    AdvancedParticleContainer.make((class_2394)((class_2394)RuneCraftoryParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(0.8509804f, 0.972549f, 0.9882353f, 0.4f)).addData((AdvancedParticleData)new MotionData(dir)).addData((AdvancedParticleData)new EntityFollowData((class_1297)this, true)).addData((AdvancedParticleData)new ScaleData(0.3f)).addData((AdvancedParticleData)new ParticleMetaData(40, false, 0.0f)).add(this.method_37908(), pos.method_10216(), pos.method_10214(), pos.method_10215());
                }
                break;
            }
            default: {
                super.method_5711(id);
            }
        }
        if (this.field_6254 == 10 && this.checkIgnoreHurtOverlay()) {
            this.field_6254 = 0;
        }
    }

    @Override
    public void method_5670() {
        super.method_5670();
        if (!this.method_37908().field_9236) {
            --this.hurtResist;
            this.updateParts();
            if (!(this.method_29504() || this.hasBones() || this.getAnimationHandler().isCurrent(new String[]{BEAM}))) {
                this.getAnimationHandler().setAnimation(BEAM);
            }
            if (this.method_5805() && !this.getAnimationHandler().hasAnimation() && !this.isTamed() && (double)(this.method_6032() / this.method_6063()) < 0.5 && !this.isEnraged()) {
                this.setEnraged(true, false);
            }
        }
    }

    private void updateParts() {
        if (this.remainingTailBones() > 0) {
            this.back.tick();
        } else {
            this.back.removeEntity();
        }
        if (this.remainingHeadBones() > 10) {
            this.head.tick();
        } else {
            this.head.removeEntity();
        }
        if (this.remainingLeftLegBones() > 0) {
            this.leftLeg.tick();
        } else {
            this.leftLeg.removeEntity();
        }
        if (this.remainingRightLegBones() > 0) {
            this.rightLeg.tick();
        } else {
            this.rightLeg.removeEntity();
        }
    }

    @Override
    protected class_243 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new String[]{CHARGE})) {
            AnimationState anim = this.getAnimationHandler().getAnimation();
            if (!anim.isPast("attack_start")) {
                if (this.method_5968() == null) {
                    return null;
                }
                return this.method_5968().method_33571().method_1020(this.method_33571());
            }
            return this.method_18798();
        }
        return super.directionToLookAt();
    }

    @Override
    public int animationCooldown(String anim) {
        int diffAdd = this.difficultyCooldown();
        return (this.isEnraged() ? 25 + this.method_59922().method_43048(20) : 35 + this.method_59922().method_43048(30)) + diffAdd;
    }

    @Override
    public void handleAttack(AnimationState anim) {
        this.method_5942().method_6340();
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    @Override
    public void mobAttack(AnimationState anim, class_1309 target, Consumer<class_1309> cons) {
        if (anim.is(new String[]{CHARGE})) {
            double width = this.method_17681();
            double speed = Math.max(width, this.method_18798().method_1033() - width);
            OrientedBoundingBox obb = new OrientedBoundingBox(OrientedBoundingBox.originAABB((class_1297)this).method_1009(0.8, 0.0, 0.2).method_1012(0.0, 0.0, speed), this.method_36454(), 0.0f, this.method_19538());
            this.method_37908().method_8390(class_1309.class, obb.getEncompassingBox(), entity -> this.hitPred.test(entity) && obb.intersects(entity.method_5829())).forEach(cons);
            if (!this.method_37908().field_9236) {
                S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (class_1297)this);
            }
            return;
        }
        ArrayList<OrientedBoundingBox> obbs = new ArrayList<OrientedBoundingBox>();
        if (anim.is(new String[]{TAIL_SLAP})) {
            double range = this.method_17681() + 5.0f;
            obbs.add(new OrientedBoundingBox(new class_238(-range * 0.75, -0.02, 0.0, range * 0.75, 1.82, range), this.method_36454(), 0.0f, this.method_19538()));
        }
        if (anim.is(new String[]{TAIL_SLAM})) {
            float angle = this.field_6241 - 5.0f;
            class_1309 class_13092 = this.method_5642();
            if (class_13092 instanceof class_1657) {
                class_1657 player = (class_1657)class_13092;
                angle = player.field_6241;
            }
            if (anim.isAt("attack_3")) {
                angle += 20.0f;
            } else if (!anim.isAt("attack_2")) {
                angle -= 35.0f;
            }
            obbs.add(new OrientedBoundingBox(new class_238(-1.25, -0.02, 0.0, 1.25, 2.12, 7.0), angle, 0.0f, this.method_19538()));
        }
        if (anim.is(new String[]{SLASH})) {
            class_243 side;
            class_243 dir;
            double reach = 1.0;
            class_1309 class_13093 = this.method_5642();
            if (class_13093 instanceof class_1657) {
                class_1657 player = (class_1657)class_13093;
                dir = class_243.method_1030((float)0.0f, (float)player.field_6283);
                side = class_243.method_1030((float)0.0f, (float)(player.field_6283 + 90.0f));
            } else {
                dir = class_243.method_1030((float)0.0f, (float)this.field_6283);
                side = class_243.method_1030((float)0.0f, (float)(this.field_6283 + 90.0f));
            }
            dir = dir.method_1021((double)this.method_17681() * 0.5 + reach);
            double attackSize = 1.65;
            if (this.remainingLeftLegBones() > 0) {
                class_243 rightPos = this.method_19538().method_1019(dir).method_1019(side.method_1021(1.3));
                obbs.add(new OrientedBoundingBox(new class_238(-attackSize, -0.02, -attackSize, attackSize, 1.82, attackSize), this.method_36454(), 0.0f, rightPos));
            }
            if (this.remainingRightLegBones() > 0) {
                class_243 leftPos = this.method_19538().method_1019(dir).method_1019(side.method_1021(-1.3));
                obbs.add(new OrientedBoundingBox(new class_238(-attackSize, -0.02, -attackSize, attackSize, 1.82, attackSize), this.method_36454(), 0.0f, leftPos));
            }
        }
        HashSet targets = new HashSet();
        for (OrientedBoundingBox obb : obbs) {
            targets.addAll(this.method_37908().method_8390(class_1309.class, obb.getEncompassingBox(), entity -> this.hitPred.test(entity) && obb.intersects(entity.method_5829())));
            if (this.method_37908().field_9236) continue;
            S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (class_1297)this);
        }
        targets.forEach(cons);
    }

    @Override
    public DynamicDamage.Builder damageSourceAttack() {
        DynamicDamage.Builder builder = super.damageSourceAttack();
        if (this.getAnimationHandler().isCurrent(new String[]{TAIL_SLAP})) {
            builder.knock(DynamicDamage.KnockBackType.BACK, 1.0f);
        }
        return builder;
    }

    public AnimationHandler<Skelefang> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(CHARGE);
            } else {
                this.getAnimationHandler().setAnimation(TAIL_SLAP);
            }
            this.commanded = true;
        }
    }

    protected class_243 method_52533(class_1297 entity, class_4048 dimensions, float partialTick) {
        if (this.hasBones()) {
            return new class_243(0.0, 2.71875, 0.4375).method_1021((double)this.method_55693()).method_1024(-this.method_36454() * ((float)Math.PI / 180));
        }
        return super.method_52533(entity, dimensions, partialTick);
    }

    protected void method_5712(class_2338 pos, class_2680 blockIn) {
    }

    @Override
    public double deathRayOffset() {
        return (double)this.method_17682() * 0.3;
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getDeathAnimation() {
        return DEATH;
    }

    @Override
    public String getSpawnAnimation() {
        return SPAWN;
    }

    @Override
    public String getAngryAnimation() {
        return ANGRY;
    }

    @Override
    public String getSleepAnimation() {
        return DEATH;
    }
}

