/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.network.S2CScreenShake;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.BigLightningBoltSpell;
import io.github.flemmli97.runecraftory.common.spells.Laser5Spell;
import io.github.flemmli97.runecraftory.common.spells.LaserAOESpell;
import io.github.flemmli97.runecraftory.common.spells.WindBladeSpell;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.data.AnimationPlayHolder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.registry.TenshilibSyncableEntityDatas;
import io.github.flemmli97.tenshilib.common.utils.TypedResource;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StrafeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;

public class Thunderbolt
extends BossMonster {
    private static final float RANGE_THRESHOLD = 0.7f;
    private static final float FEINT_THRESHOLD = 0.35f;
    public static final TypedResource<class_243> CHARGE_MOTION = new TypedResource(RuneCraftory.modRes("charge_motion"));
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String BACK_KICK = BUILDER.add("back_kick", AnimationsBuilder.definition((double)0.84).marker("attack", new double[]{0.56}));
    public static final String BACK_KICK_HORN = BUILDER.add("back_kick_horn", BACK_KICK);
    public static final String LASER_X5 = BUILDER.add("laser_x5", AnimationsBuilder.definition((double)1.52).marker("attack", new double[]{1.32}));
    public static final String LASER_AOE = BUILDER.add("laser_aoe", LASER_X5);
    public static final String STOMP = BUILDER.add("stomp", AnimationsBuilder.definition((double)0.6).marker("attack", new double[]{0.44}));
    public static final String INTERACT = BUILDER.add("interact", STOMP);
    public static final String HORN_ATTACK = BUILDER.add("horn_attack", AnimationsBuilder.definition((double)0.56).marker("attack", new double[]{0.4}));
    public static final String CHARGE = BUILDER.add("charge", AnimationsBuilder.definition((double)1.68).marker("attack_start", new double[]{0.6}).marker("attack_end", new double[]{1.24}));
    public static final String CHARGE_2 = BUILDER.add("charge_2", CHARGE);
    public static final String CHARGE_3 = BUILDER.add("charge_3", CHARGE);
    public static final String LASER_KICK = BUILDER.add("laser_kick", AnimationsBuilder.definition((double)1.32).marker("attack", new double[]{0.4}));
    public static final String LASER_KICK_2 = BUILDER.add("laser_kick_2", LASER_KICK);
    public static final String LASER_KICK_3 = BUILDER.add("laser_kick_3", LASER_KICK);
    public static final String WIND_BLADE = BUILDER.add("wind_blade", AnimationsBuilder.definition((double)0.8).marker("attack", new double[]{0.44}));
    public static final String FEINT = BUILDER.add("feint", AnimationsBuilder.definition((double)7.52).marker("neigh", new double[]{6.2}));
    public static final String SPAWN = BUILDER.add("spawn", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.44}));
    public static final String ANGRY = BUILDER.add("angry", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.44}));
    public static final String DEFEAT = BUILDER.add("defeat", AnimationsBuilder.definition((double)DEATH_DURATION, (boolean)false).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private static final ImmutableMap<String, BiConsumer<AnimationState, Thunderbolt>> ATTACK_HANDLER = Thunderbolt.createAnimationHandler(b -> {
        BiConsumer<AnimationState, Thunderbolt> kick = (anim, entity) -> {
            class_1309 target = entity.method_5968();
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimationState)anim, target, e -> {
                    if (entity.method_6121((class_1297)e)) {
                        e.method_18800(0.0, 0.05, 0.0);
                        e.field_6007 = true;
                        e.method_6005((double)0.8f, entity.method_23317() - e.method_23317(), entity.method_23321() - e.method_23321());
                    }
                });
            }
        };
        b.put((Object)BACK_KICK, kick);
        b.put((Object)BACK_KICK_HORN, kick);
        b.put((Object)HORN_ATTACK, (anim, entity) -> {
            class_1309 target = entity.method_5968();
            if (anim.isAt("attack")) {
                AtomicBoolean bool = new AtomicBoolean(false);
                entity.mobAttack((AnimationState)anim, target, e -> {
                    if (entity.method_6121((class_1297)e)) {
                        if (!bool.get()) {
                            bool.set(true);
                        }
                        e.method_18800(0.0, 0.65, 0.0);
                        e.field_6007 = true;
                    }
                });
                if (bool.get() && !entity.method_5782()) {
                    entity.hornAttackSuccess = true;
                }
            }
        });
        b.put((Object)STOMP, (anim, entity) -> {
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimationState)anim, entity.method_5968(), entity::method_6121);
            }
        });
        b.put((Object)WIND_BLADE, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((WindBladeSpell)RuneCraftorySpells.DOUBLE_SONIC.get()).use((class_1309)entity);
            }
        });
        b.put((Object)LASER_X5, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Laser5Spell)RuneCraftorySpells.LASER5.get()).use((class_1309)entity);
            }
        });
        b.put((Object)LASER_AOE, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((LaserAOESpell)RuneCraftorySpells.LASER_AOE.get()).use((class_1309)entity);
            }
        });
        BiConsumer<AnimationState, Thunderbolt> bigLaser = (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((BigLightningBoltSpell)RuneCraftorySpells.BIG_LIGHTNING.get()).use((class_1309)entity);
            }
        };
        b.put((Object)LASER_KICK, bigLaser);
        b.put((Object)LASER_KICK_2, bigLaser);
        b.put((Object)LASER_KICK_3, bigLaser);
        BiConsumer<AnimationState, Thunderbolt> charge = (anim, entity) -> {
            if (entity.getChargeMotion() == null) {
                entity.setChargeMotion(EntityUtils.getTargetDirection((class_1308)entity, class_2183.class_2184.field_9853, true).method_1021(3.0));
            }
            if (anim.isAt("attack_start")) {
                class_243 dir = entity.getChargeMotion();
                entity.method_18800(dir.method_10216(), 0.25, dir.method_10215());
            }
            if (anim.isPast("attack_start") && !anim.isPast("attack_end") && !entity.chargeAttackSuccess) {
                entity.mobAttack((AnimationState)anim, null, e -> {
                    if (entity.method_6121((class_1297)e)) {
                        entity.chargeAttackSuccess = true;
                        entity.method_18800(0.0, entity.method_18798().field_1351, 0.0);
                    }
                });
            }
        };
        b.put((Object)CHARGE, charge);
        b.put((Object)CHARGE_2, charge);
        b.put((Object)CHARGE_3, charge);
        b.put((Object)FEINT, (anim, entity) -> {
            if (anim.isAt("neigh")) {
                entity.method_5783((class_3414)RuneCraftorySounds.ENTITY_THUNDERBOLT_NEIGH.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 1.0f);
            }
        });
        BiConsumer<AnimationState, Thunderbolt> trigger = (anim, entity) -> {
            if (anim.isAt("sound")) {
                entity.method_5783((class_3414)RuneCraftorySounds.ENTITY_THUNDERBOLT_NEIGH.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 1.0f);
            }
        };
        b.put((Object)SPAWN, trigger);
        b.put((Object)ANGRY, trigger);
    });
    private final AnimationHandler<Thunderbolt> animationHandler = new AnimationHandler((class_1297)this, ANIMS).withChangeListener(anim -> {
        if (!this.method_37908().field_9236) {
            this.setChargeMotion(null);
            if (anim != null) {
                if (anim.is(new String[]{CHARGE, CHARGE_2, CHARGE_3})) {
                    this.chargeAttackSuccess = false;
                }
                if (anim.is(new String[]{HORN_ATTACK})) {
                    this.hornAttackSuccess = false;
                }
            }
        }
        return false;
    });
    protected boolean feintedDeath;
    protected boolean hornAttackSuccess;
    protected boolean chargeAttackSuccess;

    public Thunderbolt(class_1299<? extends BossMonster> type, class_1937 level) {
        super(type, level);
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(RuneCraftoryEntities.THUNDERBOLT.getID(), this.method_5476(), class_1259.class_1260.field_5780, class_1259.class_1261.field_5795).setMusic((class_3414)RuneCraftorySounds.THUNDERBOLT_FIGHT.get());
    }

    @Override
    protected void definedAdditinoalSyncedData(SyncedDataContainer.Builder<BaseMonster> builder) {
        super.definedAdditinoalSyncedData(builder);
        builder.define(CHARGE_MOTION, (SyncedEntityData)TenshilibSyncableEntityDatas.VEC_3.get(), null);
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23719).method_6192(0.34);
        this.method_5996(class_5134.field_47761).method_6192(((class_1320)class_5134.field_47761.comp_349()).method_6169() + 1.0);
        super.applyAttributes();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(MonsterBehaviourUtils.checkedAttack(BACK_KICK)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> !m.feintedDeath && MonsterBehaviourUtils.ifCloserThan(5.0).test(m)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.2f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(10).start(MonsterBehaviourUtils.checkedAttack(STOMP)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> !m.feintedDeath && MonsterBehaviourUtils.ifCloserThan(5.0).test(m)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.2f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(11).start(MonsterBehaviourUtils.checkedAttack(AnimationPlayHolder.builder((String)HORN_ATTACK).start(BACK_KICK, m -> m.hornAttackSuccess).build())).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> !m.feintedDeath && MonsterBehaviourUtils.ifCloserThan(5.0).test(m)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.2f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(9).start(MonsterBehaviourUtils.checkedAttack(LASER_X5)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> !m.isEnraged() && !m.feintedDeath && MonsterBehaviourUtils.ifCloserThan(16.0).test(m)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(8)).speedMod((e, t) -> Float.valueOf(1.2f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(10).start(MonsterBehaviourUtils.checkedAttack(AnimationPlayHolder.builder((String)CHARGE).start(CHARGE_2, m -> !m.chargeAttackSuccess).build())).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> !m.feintedDeath && MonsterBehaviourUtils.ifCloserThan(16.0).test(m)).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(9).start(MonsterBehaviourUtils.checkedAttack(LASER_AOE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> m.isEnraged() && !m.feintedDeath && MonsterBehaviourUtils.ifCloserThan(16.0).test(m)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(8)).speedMod((e, t) -> Float.valueOf(1.2f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(8).start(MonsterBehaviourUtils.checkedAttack(AnimationPlayHolder.builder((String)LASER_KICK).start(LASER_KICK_2).build())).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> m.isEnraged() && !m.feintedDeath && MonsterBehaviourUtils.ifCloserThan(12.0).test(m)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(8)).speedMod((e, t) -> Float.valueOf(1.2f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement(50, 80)}).end(8).start(MonsterBehaviourUtils.checkedAttack(WIND_BLADE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> m.isEnraged() && !m.feintedDeath && MonsterBehaviourUtils.ifCloserThan(24.0).test(m)).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(7).start(MonsterBehaviourUtils.checkedAttack(WIND_BLADE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> m.isEnraged() && !m.feintedDeath && m.method_5968() != null && m.method_5968().method_23318() - m.method_23318() > 4.0 && MonsterBehaviourUtils.ifCloserThan(24.0).test(m)).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(10).start(MonsterBehaviourUtils.checkedAttack(LASER_AOE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.and(Thunderbolt::afterFeint, MonsterBehaviourUtils.ifCloserThan(16.0))).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(8)).speedMod((e, t) -> Float.valueOf(1.2f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(7).start(MonsterBehaviourUtils.checkedAttack(AnimationPlayHolder.builder((String)CHARGE).start(CHARGE_2, m -> !m.chargeAttackSuccess).chain(CHARGE_3).build())).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.and(Thunderbolt::afterFeint, MonsterBehaviourUtils.ifCloserThan(16.0))).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(11).start(MonsterBehaviourUtils.checkedAttack(AnimationPlayHolder.builder((String)LASER_KICK).start(LASER_KICK_2).chain(LASER_KICK_3).build())).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.and(Thunderbolt::afterFeint, MonsterBehaviourUtils.ifCloserThan(16.0))).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(8)).speedMod((e, t) -> Float.valueOf(1.2f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement(50, 80)}).end(12).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(7, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.1f)), MonsterBehaviourUtils.moveTo()}).add(10, new ExtendedBehaviour[]{new StrafeTarget().strafeDistance(8.0f)}).build();
    }

    @Override
    protected ExtendedBehaviour<? extends BaseMonster> getWanderBehaviour() {
        return new SetRandomWalkTarget().speedModifier(0.7f);
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("Feint", this.feintedDeath);
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.feintedDeath = compound.method_10577("Feint");
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        if (flag && !load) {
            if (!this.isEnraged()) {
                this.getAnimationHandler().setAnimation(ANGRY);
                this.method_5942().method_6340();
            } else {
                this.getAnimationHandler().setAnimation(FEINT);
                this.method_5942().method_6340();
                this.feintDeath();
                this.bossInfo.method_5408(0.0f);
            }
        }
        super.setEnraged(flag, load);
    }

    @Override
    protected void updateBossBar() {
        if (!this.feintedDeath || this.getAnimationHandler().isCurrent(new String[]{FEINT})) {
            this.bossInfo.method_5408((this.method_6032() - this.method_6063() * 0.35f) / (this.method_6063() * 0.65f));
        } else {
            this.bossInfo.method_5408(this.method_6032() / this.method_6063());
        }
    }

    @Override
    protected boolean checkRage() {
        if (this.method_6032() / this.method_6063() < 0.35f) {
            return !this.feintedDeath;
        }
        if (this.method_6032() / this.method_6063() < 0.7f) {
            return !this.isEnraged();
        }
        return false;
    }

    @Override
    protected void fullyHeal() {
        super.fullyHeal();
        this.feintedDeath = false;
    }

    private boolean afterFeint() {
        return !this.isTamed() && this.isEnraged() && this.feintedDeath;
    }

    @Override
    public void method_5670() {
        super.method_5670();
        if (this.getAnimationHandler().isCurrent(new String[]{FEINT}) && !this.isTamed()) {
            class_243 delta = this.method_18798();
            int tick = (int)this.getAnimationHandler().getAnimation().getTick(1.0f);
            this.method_18800(0.0, delta.field_1351, 0.0);
            if (tick < 50) {
                if (tick % 10 == 0) {
                    ++this.deathRays;
                    S2CScreenShake.sendAround((class_1297)this, 24.0, 4, 1.0f);
                    this.method_37908().method_55116((class_1297)this, (class_3414)class_3417.field_15152.comp_349(), this.method_5634(), 2.0f, 0.8f);
                }
            } else if (tick < 65) {
                if (tick % 5 == 0) {
                    ++this.deathRays;
                    S2CScreenShake.sendAround((class_1297)this, 24.0, 4, 1.0f);
                    this.method_37908().method_55116((class_1297)this, (class_3414)class_3417.field_15152.comp_349(), this.method_5634(), 2.0f, 0.8f);
                }
            } else if (tick > 100) {
                this.deathRays = 0;
            }
        }
    }

    @Override
    public double sprintSpeedThreshold() {
        return 0.9;
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        return !this.getAnimationHandler().isCurrent(new String[]{FEINT}) && super.method_5643(source, amount);
    }

    @Override
    protected boolean method_6062() {
        return super.method_6062() || this.getAnimationHandler().isCurrent(new String[]{FEINT});
    }

    @Override
    public double ridingSpeedModifier() {
        return 1.5;
    }

    protected void feintDeath() {
        this.feintedDeath = true;
        this.getAnimationHandler().setAnimation(FEINT);
        STAT_INCREASE.forEach(att -> {
            class_1324 inst = this.method_5996((class_6880)att.get());
            inst.method_6200(STAT_INCREASE_ID);
            inst.method_26837(new class_1322(STAT_INCREASE_ID, 0.33, class_1322.class_1323.field_6331));
        });
    }

    public boolean method_5805() {
        return super.method_5805() && (this.getAnimationHandler() == null || !this.getAnimationHandler().isCurrent(new String[]{FEINT, DEFEAT}));
    }

    public void method_5762(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new String[]{FEINT, DEFEAT})) {
            return;
        }
        super.method_5762(x, y, z);
    }

    @Override
    protected class_243 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new String[]{CHARGE, CHARGE_2, CHARGE_3})) {
            return this.getChargeMotion();
        }
        return super.directionToLookAt();
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, class_243 target, double grow) {
        if (anim.is(new String[]{STOMP})) {
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((class_1297)this).method_1009(1.7, -0.4, 1.7), this.method_36454(), 0.0f, this.method_19538());
        }
        if (anim.is(new String[]{CHARGE, CHARGE_2, CHARGE_3})) {
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((class_1297)this).method_1014(grow + 1.0), this.method_36454(), 0.0f, this.method_19538());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public class_238 attackBB(AnimationState anim) {
        double width = (double)this.method_17681() * 1.6;
        double length = (double)this.method_17681() * 1.5;
        if (anim.is(new String[]{HORN_ATTACK})) {
            width = (double)this.method_17681() * 1.3;
            length = (double)this.method_17681() * 1.8;
        }
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public int animationCooldown(String anim) {
        int cooldown = super.animationCooldown(anim);
        if (anim != null && this.feintedDeath && (anim.equals(LASER_KICK) || anim.equals(LASER_AOE) || anim.equals(CHARGE))) {
            cooldown += 40;
        }
        return cooldown;
    }

    @Override
    public void handleAttack(AnimationState anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    public AnimationHandler<Thunderbolt> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), command == 2 ? (Spell)RuneCraftorySpells.LASER5.get() : null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(LASER_X5);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(STOMP);
            } else {
                this.getAnimationHandler().setAnimation(HORN_ATTACK);
            }
        }
    }

    @Override
    public boolean allowAnimation(String prev, String other) {
        if (this.feintedDeath) {
            return true;
        }
        return super.allowAnimation(prev, other);
    }

    @Override
    public double deathRayOffset() {
        return (double)this.method_17682() * 0.25;
    }

    protected class_3414 method_5994() {
        return (class_3414)RuneCraftorySounds.ENTITY_THUNDERBOLT_AMBIENT.get();
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return (class_3414)RuneCraftorySounds.ENTITY_THUNDERBOLT_HURT.get();
    }

    public float method_6017() {
        return 1.0f + (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        if (!state.method_51176()) {
            class_2680 blockstate = this.method_37908().method_8320(pos.method_10084());
            class_2498 soundtype = Platform.INSTANCE.getSoundType(state, this.method_37908(), pos, (class_1297)this);
            if (blockstate.method_27852(class_2246.field_10477)) {
                soundtype = Platform.INSTANCE.getSoundType(blockstate, this.method_37908(), pos, (class_1297)this);
            }
            this.method_5783((class_3414)RuneCraftorySounds.ENTITY_THUNDERBOLT_GALLOP.get(), soundtype.method_10597() * 0.15f, soundtype.method_10599());
        }
    }

    public class_243 getChargeMotion() {
        return (class_243)this.getDataContainer().get(CHARGE_MOTION);
    }

    public void setChargeMotion(class_243 direction) {
        this.getDataContainer().set(CHARGE_MOTION, (Object)direction);
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSpawnAnimation() {
        return SPAWN;
    }

    @Override
    public String getDeathAnimation() {
        return DEFEAT;
    }
}

